/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.LineSet;
import com.intellij.openapi.util.Key;
import com.intellij.reference.SoftReference;
import com.intellij.util.text.ImmutableCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrozenDocument
implements DocumentEx {
    private final ImmutableCharSequence myText;
    @Nullable
    private volatile SoftReference<LineSet> myLineSet;
    private final long myStamp;
    private volatile SoftReference<String> myTextString;

    /*
     * WARNING - void declaration
     */
    FrozenDocument(@NotNull ImmutableCharSequence text2, @Nullable LineSet lineSet, long stamp, @Nullable String string2) {
        void textString;
        if (text2 == null) {
            FrozenDocument.$$$reportNull$$$0(0);
        }
        this.myText = text2;
        this.myLineSet = lineSet == null ? null : new SoftReference<LineSet>(lineSet);
        this.myStamp = stamp;
        this.myTextString = textString == null ? null : new SoftReference<void>(textString);
    }

    @NotNull
    private LineSet getLineSet() {
        LineSet lineSet = SoftReference.dereference(this.myLineSet);
        if (lineSet == null) {
            lineSet = LineSet.createLineSet(this.myText);
            this.myLineSet = new SoftReference<LineSet>(lineSet);
        }
        LineSet lineSet2 = lineSet;
        if (lineSet2 == null) {
            FrozenDocument.$$$reportNull$$$0(1);
        }
        return lineSet2;
    }

    public FrozenDocument applyEvent(DocumentEvent event, int newStamp) {
        int offset2 = event.getOffset();
        int oldEnd = offset2 + event.getOldLength();
        ImmutableCharSequence newText = this.myText.delete(offset2, oldEnd).insert(offset2, event.getNewFragment());
        LineSet newLineSet = this.getLineSet().update(this.myText, offset2, oldEnd, event.getNewFragment(), event.isWholeTextReplaced());
        return new FrozenDocument(newText, newLineSet, newStamp, null);
    }

    @Override
    public void setModificationStamp(long modificationStamp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            FrozenDocument.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String getText() {
        String s = SoftReference.dereference(this.myTextString);
        if (s == null) {
            s = this.myText.toString();
            this.myTextString = new SoftReference<String>(s);
        }
        String string2 = s;
        if (string2 == null) {
            FrozenDocument.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @Override
    @NotNull
    public CharSequence getCharsSequence() {
        ImmutableCharSequence immutableCharSequence = this.myText;
        if (immutableCharSequence == null) {
            FrozenDocument.$$$reportNull$$$0(11);
        }
        return immutableCharSequence;
    }

    @Override
    @NotNull
    public CharSequence getImmutableCharSequence() {
        ImmutableCharSequence immutableCharSequence = this.myText;
        if (immutableCharSequence == null) {
            FrozenDocument.$$$reportNull$$$0(12);
        }
        return immutableCharSequence;
    }

    @Override
    public int getLineCount() {
        return this.getLineSet().getLineCount();
    }

    @Override
    public int getLineNumber(int offset2) {
        return this.getLineSet().findLineIndex(offset2);
    }

    @Override
    public int getLineStartOffset(int line) {
        if (line == 0) {
            return 0;
        }
        return this.getLineSet().getLineStart(line);
    }

    @Override
    public int getLineEndOffset(int line) {
        if (this.getTextLength() == 0 && line == 0) {
            return 0;
        }
        int result2 = this.getLineSet().getLineEnd(line) - this.getLineSeparatorLength(line);
        assert (result2 >= 0);
        return result2;
    }

    @Override
    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            FrozenDocument.$$$reportNull$$$0(14);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public long getModificationStamp() {
        return this.myStamp;
    }

    @Override
    public void setReadOnly(boolean isReadOnly) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setText(@NotNull CharSequence text2) {
        if (text2 == null) {
            FrozenDocument.$$$reportNull$$$0(16);
        }
        throw new UnsupportedOperationException();
    }

    public int getLineSeparatorLength(int line) {
        return this.getLineSet().getSeparatorLength(line);
    }

    @Override
    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            FrozenDocument.$$$reportNull$$$0(17);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        if (key == null) {
            FrozenDocument.$$$reportNull$$$0(18);
        }
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/FrozenDocument";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeMarker";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/FrozenDocument";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineSet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineIterator";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharsSequence";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmutableCharSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "replaceText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeRangeMarker";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerRangeMarker";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processRangeMarkers";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processRangeMarkersOverlappingWith";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "insertString";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "replaceString";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeGuardedBlock";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeEditReadOnlyListener";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

