/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.LoggingContext;
import org.jetbrains.kotlin.backend.common.overrides.FakeOverrideBuilder;
import org.jetbrains.kotlin.backend.common.overrides.FakeOverrideClassFilter;
import org.jetbrains.kotlin.backend.common.overrides.FileLocalAwareLinker;
import org.jetbrains.kotlin.backend.common.serialization.CurrentModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.DeserializationStrategy;
import org.jetbrains.kotlin.backend.common.serialization.IrFileDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializerWithBuiltIns;
import org.jetbrains.kotlin.backend.common.serialization.LegacyDescriptorUtilsKt;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.backend.common.serialization.proto.Actual;
import org.jetbrains.kotlin.backend.common.serialization.proto.IdSignature;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrConstructorCall;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrDeclaration;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrExpression;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrFile;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrStatement;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrType;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.impl.EmptyPackageFragmentDescriptor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.TranslationPluginContext;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.impl.IrFileImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrModuleFragmentImpl;
import org.jetbrains.kotlin.ir.descriptors.IrAbstractFunctionFactory;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorExpressionImpl;
import org.jetbrains.kotlin.ir.linkage.IrDeserializer;
import org.jetbrains.kotlin.ir.symbols.IrBindableSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingClassSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingConstructorSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingEnumEntrySymbolImpl;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingPropertySymbolImpl;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingSimpleFunctionSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingSymbolKt;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbolKt;
import org.jetbrains.kotlin.ir.symbols.impl.IrAnonymousInitializerSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrFileSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrLocalDelegatedPropertySymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrValueParameterSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrVariableSymbolImpl;
import org.jetbrains.kotlin.ir.types.impl.IrErrorTypeImpl;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.NaiveSourceBasedFileEntryImpl;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.library.IrLibrary;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.protobuf.CodedInputStream;
import org.jetbrains.kotlin.protobuf.ExtensionRegistryLite;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u00012\u00020\u0002:\u0002mnB5\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\u0002\u0010\rJ\u001e\u00106\u001a\u00020\u00152\u0006\u00107\u001a\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00150%H\u0014J\"\u0010:\u001a\u00020\u00152\u0006\u0010;\u001a\u00020\u00042\b\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010>\u001a\u00020?H$J\b\u0010@\u001a\u00020AH\u0002J\u0018\u0010B\u001a\u0002082\u0006\u0010;\u001a\u00020\u00042\b\u0010C\u001a\u0004\u0018\u00010DJ\u0018\u0010E\u001a\u0002082\u0006\u0010;\u001a\u00020\u00042\b\u0010C\u001a\u0004\u0018\u00010DJ\u0018\u0010F\u001a\u0002082\u0006\u0010;\u001a\u00020\u00042\b\u0010C\u001a\u0004\u0018\u00010DJ\"\u0010F\u001a\u0002082\u0006\u0010;\u001a\u00020\u00042\b\u0010C\u001a\u0004\u0018\u00010D2\b\b\u0002\u0010G\u001a\u00020?J\u0018\u0010H\u001a\u0002082\u0006\u0010;\u001a\u00020\u00042\b\u0010C\u001a\u0004\u0018\u00010DJ\b\u0010I\u001a\u00020AH\u0002J\u0012\u0010J\u001a\u0004\u0018\u00010K2\u0006\u0010L\u001a\u00020\u0011H\u0002J\u0012\u0010M\u001a\u0004\u0018\u00010N2\u0006\u0010L\u001a\u00020\u0011H\u0016J\u0018\u0010O\u001a\u00020\u00112\u0006\u0010P\u001a\u00020\u00102\u0006\u0010Q\u001a\u00020\u0011H\u0002J\u0010\u0010R\u001a\u00020\u00152\u0006\u0010S\u001a\u00020\u0010H\u0014J \u0010T\u001a\u00020A2\b\u00107\u001a\u0004\u0018\u0001082\f\u0010U\u001a\b\u0012\u0004\u0012\u00020&0%H\u0016J\u0010\u0010V\u001a\u00020W2\u0006\u0010;\u001a\u00020\u0004H$J\u0018\u0010X\u001a\u00020\u00152\u0006\u0010;\u001a\u00020\u00042\u0006\u0010Y\u001a\u00020\u0015H\u0002J\u0010\u0010Z\u001a\u00020W2\u0006\u0010L\u001a\u00020\u0011H\u0014J\b\u0010[\u001a\u00020AH\u0016J\u0018\u0010\\\u001a\u00020\u00112\u0006\u0010]\u001a\u00020^2\u0006\u0010P\u001a\u00020\u0010H\u0002J \u0010_\u001a\u00020\u00112\u0006\u0010`\u001a\u00020\u00102\u0006\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020dH\u0016J\u0010\u0010e\u001a\u00020\u00152\u0006\u0010;\u001a\u00020\u0004H\u0014J\u0010\u0010f\u001a\u00020^2\u0006\u0010a\u001a\u00020bH\u0002J\u001a\u0010g\u001a\u0004\u0018\u00010h2\u0006\u0010i\u001a\u00020N2\u0006\u0010S\u001a\u00020\u0010H\u0016J\u001a\u0010j\u001a\u0004\u0018\u00010k2\u0006\u0010i\u001a\u00020N2\u0006\u0010S\u001a\u00020\u0010H\u0016J\u0012\u0010l\u001a\u0004\u0018\u00010N2\u0006\u0010L\u001a\u00020\u0011H\u0002R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00020\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0012\u0010\u001e\u001a\u00020\u001fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00150#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001a\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00150\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\u0004\u0018\u00010.X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0018\u00101\u001a\u000202*\u0002038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u0006o"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "Lorg/jetbrains/kotlin/ir/linkage/IrDeserializer;", "Lorg/jetbrains/kotlin/backend/common/overrides/FileLocalAwareLinker;", "currentModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "logger", "Lorg/jetbrains/kotlin/backend/common/LoggingContext;", "builtIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "exportedDependencies", "", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/backend/common/LoggingContext;Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;Lorg/jetbrains/kotlin/ir/util/SymbolTable;Ljava/util/List;)V", "actualSymbols", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getBuiltIns", "()Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "deserializersForModules", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "getDeserializersForModules", "()Ljava/util/Map;", "expectSymbols", "expectUniqIdToActualUniqId", "fakeOverrideBuilder", "Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideBuilder;", "getFakeOverrideBuilder", "()Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideBuilder;", "functionalInterfaceFactory", "Lorg/jetbrains/kotlin/ir/descriptors/IrAbstractFunctionFactory;", "getFunctionalInterfaceFactory", "()Lorg/jetbrains/kotlin/ir/descriptors/IrAbstractFunctionFactory;", "haveSeen", "", "linkerExtensions", "", "Lorg/jetbrains/kotlin/ir/linkage/IrDeserializer$IrLinkerExtension;", "getLogger", "()Lorg/jetbrains/kotlin/backend/common/LoggingContext;", "modulesWithReachableTopLevels", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "topLevelActualUniqItToDeserializer", "translationPluginContext", "Lorg/jetbrains/kotlin/ir/builders/TranslationPluginContext;", "getTranslationPluginContext", "()Lorg/jetbrains/kotlin/ir/builders/TranslationPluginContext;", "codedInputStream", "Lorg/jetbrains/kotlin/protobuf/CodedInputStream;", "", "getCodedInputStream", "([B)Lorg/jetbrains/kotlin/protobuf/CodedInputStream;", "createCurrentModuleDeserializer", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "dependencies", "createModuleDeserializer", "moduleDescriptor", "klib", "Lorg/jetbrains/kotlin/library/IrLibrary;", "strategy", "Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "deserializeAllReachableTopLevels", "", "deserializeFullModule", "kotlinLibrary", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "deserializeHeadersWithInlineBodies", "deserializeIrModuleHeader", "deserializationStrategy", "deserializeOnlyHeaderModule", "finalizeExpectActualLinker", "findDeserializedDeclarationForSymbol", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "symbol", "getDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "handleExpectActualMapping", "idSig", "rawSymbol", "handleNoModuleDeserializerFound", "idSignature", "init", "extensions", "isBuiltInModule", "", "maybeWrapWithBuiltInAndInit", "moduleDeserializer", "platformSpecificSymbol", "postProcess", "referenceDeserializedSymbol", "symbolKind", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "resolveBySignatureInModule", "signature", "kind", "Lorg/jetbrains/kotlin/ir/linkage/IrDeserializer$TopLevelSymbolKind;", "moduleName", "Lorg/jetbrains/kotlin/name/Name;", "resolveModuleDeserializer", "topLevelKindToSymbolKind", "tryReferencingPropertyByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "parent", "tryReferencingSimpleFunctionByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "tryResolveCustomDeclaration", "BasicIrModuleDeserializer", "IrDeserializerForFile", "ir.serialization.common"})
public abstract class KotlinIrLinker
implements FileLocalAwareLinker,
IrDeserializer {
    @Nullable
    private final ModuleDescriptor currentModule;
    @NotNull
    private final LoggingContext logger;
    @NotNull
    private final IrBuiltIns builtIns;
    @NotNull
    private final SymbolTable symbolTable;
    @NotNull
    private final List<ModuleDescriptor> exportedDependencies;
    @NotNull
    private final Map<org.jetbrains.kotlin.ir.util.IdSignature, org.jetbrains.kotlin.ir.util.IdSignature> expectUniqIdToActualUniqId;
    @NotNull
    private final Map<org.jetbrains.kotlin.ir.util.IdSignature, IrModuleDeserializer> topLevelActualUniqItToDeserializer;
    @NotNull
    private final Map<org.jetbrains.kotlin.ir.util.IdSignature, IrSymbol> expectSymbols;
    @NotNull
    private final Map<org.jetbrains.kotlin.ir.util.IdSignature, IrSymbol> actualSymbols;
    @NotNull
    private final Set<IrModuleDeserializer> modulesWithReachableTopLevels;
    @NotNull
    private final Map<ModuleDescriptor, IrModuleDeserializer> deserializersForModules;
    @NotNull
    private final Set<IrSymbol> haveSeen;
    private Collection<? extends IrDeserializer.IrLinkerExtension> linkerExtensions;

    public KotlinIrLinker(@Nullable ModuleDescriptor currentModule, @NotNull LoggingContext logger, @NotNull IrBuiltIns builtIns, @NotNull SymbolTable symbolTable, @NotNull List<? extends ModuleDescriptor> exportedDependencies) {
        Intrinsics.checkNotNullParameter(logger, "logger");
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(exportedDependencies, "exportedDependencies");
        this.currentModule = currentModule;
        this.logger = logger;
        this.builtIns = builtIns;
        this.symbolTable = symbolTable;
        this.exportedDependencies = exportedDependencies;
        boolean bl = false;
        this.expectUniqIdToActualUniqId = new LinkedHashMap();
        bl = false;
        this.topLevelActualUniqItToDeserializer = new LinkedHashMap();
        bl = false;
        this.expectSymbols = new LinkedHashMap();
        bl = false;
        this.actualSymbols = new LinkedHashMap();
        bl = false;
        this.modulesWithReachableTopLevels = new LinkedHashSet();
        bl = false;
        this.deserializersForModules = new LinkedHashMap();
        bl = false;
        this.haveSeen = new LinkedHashSet();
    }

    @NotNull
    public final LoggingContext getLogger() {
        return this.logger;
    }

    @NotNull
    public final IrBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    @NotNull
    public final SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    @NotNull
    protected final Map<ModuleDescriptor, IrModuleDeserializer> getDeserializersForModules() {
        return this.deserializersForModules;
    }

    @NotNull
    public abstract FakeOverrideBuilder getFakeOverrideBuilder();

    @Nullable
    public abstract TranslationPluginContext getTranslationPluginContext();

    private final CodedInputStream getCodedInputStream(byte[] $this$codedInputStream) {
        CodedInputStream codedInputStream = CodedInputStream.newInstance($this$codedInputStream);
        codedInputStream.setRecursionLimit(65535);
        Intrinsics.checkNotNullExpressionValue(codedInputStream, "codedInputStream");
        return codedInputStream;
    }

    @NotNull
    protected IrModuleDeserializer handleNoModuleDeserializerFound(@NotNull org.jetbrains.kotlin.ir.util.IdSignature idSignature) {
        Intrinsics.checkNotNullParameter(idSignature, "idSignature");
        String string2 = "Deserializer for declaration " + idSignature + " is not found";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string2.toString());
    }

    @NotNull
    protected IrModuleDeserializer resolveModuleDeserializer(@NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        IrModuleDeserializer irModuleDeserializer = this.deserializersForModules.get(moduleDescriptor);
        if (irModuleDeserializer == null) {
            String string2 = Intrinsics.stringPlus("No module deserializer found for ", moduleDescriptor);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return irModuleDeserializer;
    }

    @NotNull
    protected abstract IrModuleDeserializer createModuleDeserializer(@NotNull ModuleDescriptor var1, @Nullable IrLibrary var2, @NotNull DeserializationStrategy var3);

    @NotNull
    protected abstract IrAbstractFunctionFactory getFunctionalInterfaceFactory();

    protected abstract boolean isBuiltInModule(@NotNull ModuleDescriptor var1);

    private final IrSymbol handleExpectActualMapping(org.jetbrains.kotlin.ir.util.IdSignature idSig, IrSymbol rawSymbol) {
        IrSymbol referencingSymbol;
        IrSymbol irSymbol;
        Object object;
        boolean bl;
        if (this.expectUniqIdToActualUniqId.keySet().contains(idSig)) {
            org.jetbrains.kotlin.ir.util.IdSignature idSignature = idSig;
            bl = false;
            boolean bl2 = false;
            org.jetbrains.kotlin.ir.util.IdSignature $this$handleExpectActualMapping_u24lambda_u2d122 = idSignature;
            boolean bl3 = false;
            boolean bl4 = $this$handleExpectActualMapping_u24lambda_u2d122.test(IdSignature.Flags.IS_EXPECT);
            bl = false;
            bl2 = false;
            if (_Assertions.ENABLED && !bl4) {
                boolean $this$handleExpectActualMapping_u24lambda_u2d122 = false;
                String $this$handleExpectActualMapping_u24lambda_u2d122 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)$this$handleExpectActualMapping_u24lambda_u2d122));
            }
            object = IrDelegatingSymbolKt.wrapInDelegatedSymbol(rawSymbol);
            bl = false;
            bl2 = false;
            Object it = object;
            boolean bl5 = false;
            Map<org.jetbrains.kotlin.ir.util.IdSignature, IrSymbol> map = this.expectSymbols;
            boolean bl6 = false;
            map.put(idSig, (IrSymbol)it);
            irSymbol = (IrSymbol)object;
        } else {
            irSymbol = referencingSymbol = rawSymbol;
        }
        if (this.expectUniqIdToActualUniqId.values().contains(idSig)) {
            object = this.actualSymbols;
            bl = false;
            object.put((org.jetbrains.kotlin.ir.util.IdSignature)idSig, (IrSymbol)rawSymbol);
        }
        return referencingSymbol;
    }

    private final IrSymbol referenceDeserializedSymbol(BinarySymbolData.SymbolKind symbolKind, org.jetbrains.kotlin.ir.util.IdSignature idSig) {
        IrBindableSymbol irBindableSymbol;
        SymbolTable symbolTable = this.symbolTable;
        boolean bl = false;
        boolean bl2 = false;
        SymbolTable $this$referenceDeserializedSymbol_u24lambda_u2d2 = symbolTable;
        boolean bl3 = false;
        BinarySymbolData.SymbolKind symbolKind2 = symbolKind;
        int n = WhenMappings.$EnumSwitchMapping$0[symbolKind2.ordinal()];
        switch (n) {
            case 1: {
                irBindableSymbol = new IrAnonymousInitializerSymbolImpl(null, 1, null);
                break;
            }
            case 2: {
                irBindableSymbol = $this$referenceDeserializedSymbol_u24lambda_u2d2.referenceClassFromLinker(idSig);
                break;
            }
            case 3: {
                irBindableSymbol = $this$referenceDeserializedSymbol_u24lambda_u2d2.referenceConstructorFromLinker(idSig);
                break;
            }
            case 4: {
                irBindableSymbol = $this$referenceDeserializedSymbol_u24lambda_u2d2.referenceTypeParameterFromLinker(idSig);
                break;
            }
            case 5: {
                irBindableSymbol = $this$referenceDeserializedSymbol_u24lambda_u2d2.referenceEnumEntryFromLinker(idSig);
                break;
            }
            case 6: {
                irBindableSymbol = $this$referenceDeserializedSymbol_u24lambda_u2d2.referenceFieldFromLinker(idSig);
                break;
            }
            case 7: {
                irBindableSymbol = $this$referenceDeserializedSymbol_u24lambda_u2d2.referenceFieldFromLinker(idSig);
                break;
            }
            case 8: {
                irBindableSymbol = $this$referenceDeserializedSymbol_u24lambda_u2d2.referenceSimpleFunctionFromLinker(idSig);
                break;
            }
            case 9: {
                irBindableSymbol = $this$referenceDeserializedSymbol_u24lambda_u2d2.referenceTypeAliasFromLinker(idSig);
                break;
            }
            case 10: {
                irBindableSymbol = $this$referenceDeserializedSymbol_u24lambda_u2d2.referencePropertyFromLinker(idSig);
                break;
            }
            case 11: {
                irBindableSymbol = new IrVariableSymbolImpl(null, 1, null);
                break;
            }
            case 12: {
                irBindableSymbol = new IrValueParameterSymbolImpl(null, 1, null);
                break;
            }
            case 13: {
                irBindableSymbol = new IrValueParameterSymbolImpl(null, 1, null);
                break;
            }
            case 14: {
                irBindableSymbol = new IrLocalDelegatedPropertySymbolImpl(null, 1, null);
                break;
            }
            default: {
                String string2 = "Unexpected classifier symbol kind: " + (Object)((Object)symbolKind) + " for signature " + idSig;
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        }
        return irBindableSymbol;
    }

    private final void deserializeAllReachableTopLevels() {
        while (true) {
            Collection collection = this.modulesWithReachableTopLevels;
            boolean bl = false;
            if (!(!collection.isEmpty())) break;
            IrModuleDeserializer moduleDeserializer = (IrModuleDeserializer)CollectionsKt.first((Iterable)this.modulesWithReachableTopLevels);
            this.modulesWithReachableTopLevels.remove(moduleDeserializer);
            moduleDeserializer.deserializeReachableDeclarations();
        }
    }

    private final DeclarationDescriptor findDeserializedDeclarationForSymbol(IrSymbol symbol2) {
        boolean bl = IrSymbolKt.isPublicApi(symbol2) || DescriptorUtilsKt.getModule(symbol2.getDescriptor()) == this.currentModule || this.platformSpecificSymbol(symbol2);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        if (this.haveSeen.contains(symbol2)) {
            return null;
        }
        this.haveSeen.add(symbol2);
        DeclarationDescriptor descriptor2 = symbol2.getDescriptor();
        IrModuleDeserializer moduleDeserializer = this.resolveModuleDeserializer(DescriptorUtilsKt.getModule(descriptor2));
        moduleDeserializer.declareIrSymbol(symbol2);
        this.deserializeAllReachableTopLevels();
        if (!symbol2.isBound()) {
            return null;
        }
        return descriptor2;
    }

    protected boolean platformSpecificSymbol(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        return false;
    }

    private final org.jetbrains.kotlin.ir.declarations.IrDeclaration tryResolveCustomDeclaration(IrSymbol symbol2) {
        Collection<? extends IrDeserializer.IrLinkerExtension> collection;
        if (!symbol2.getHasDescriptor()) {
            return null;
        }
        DeclarationDescriptor descriptor2 = symbol2.getDescriptor();
        if (descriptor2 instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)descriptor2).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            return null;
        }
        TranslationPluginContext translationPluginContext = this.getTranslationPluginContext();
        if (translationPluginContext == null) {
            collection = null;
        } else {
            org.jetbrains.kotlin.ir.declarations.IrDeclaration irDeclaration2;
            Collection<? extends IrDeserializer.IrLinkerExtension> collection2;
            block9: {
                org.jetbrains.kotlin.ir.declarations.IrDeclaration irDeclaration3;
                TranslationPluginContext translationPluginContext2 = translationPluginContext;
                boolean bl = false;
                boolean bl2 = false;
                TranslationPluginContext ctx = translationPluginContext2;
                boolean bl3 = false;
                collection2 = this.linkerExtensions;
                if (collection2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("linkerExtensions");
                    throw null;
                }
                Iterable $this$firstNotNullResult$iv = collection2;
                boolean $i$f$firstNotNullResult = false;
                for (Object element$iv : $this$firstNotNullResult$iv) {
                    IrDeserializer.IrLinkerExtension it = (IrDeserializer.IrLinkerExtension)element$iv;
                    boolean bl4 = false;
                    org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv = it.resolveSymbol(symbol2, ctx);
                    if (result$iv == null) continue;
                    irDeclaration3 = result$iv;
                    break block9;
                }
                irDeclaration3 = irDeclaration2 = null;
            }
            if (irDeclaration2 == null) {
                collection = null;
            } else {
                collection2 = irDeclaration2;
                boolean bl = false;
                boolean bl5 = false;
                Collection<? extends IrDeserializer.IrLinkerExtension> it = collection2;
                boolean bl6 = false;
                boolean bl7 = Intrinsics.areEqual(symbol2.getOwner(), it);
                boolean bl8 = false;
                boolean bl9 = false;
                bl9 = false;
                boolean bl10 = false;
                if (!bl7) {
                    boolean bl11 = false;
                    String string2 = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string2.toString());
                }
                collection = collection2;
            }
        }
        return collection;
    }

    @Override
    @Nullable
    public org.jetbrains.kotlin.ir.declarations.IrDeclaration getDeclaration(@NotNull IrSymbol symbol2) {
        org.jetbrains.kotlin.ir.declarations.IrDeclaration irDeclaration2;
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        if (!IrSymbolKt.isPublicApi(symbol2)) {
            DeclarationDescriptor descriptor2 = symbol2.getDescriptor();
            if (!this.platformSpecificSymbol(symbol2) && DescriptorUtilsKt.getModule(descriptor2) != this.currentModule) {
                return null;
            }
        }
        if (!symbol2.isBound() && (declarationDescriptor = this.findDeserializedDeclarationForSymbol(symbol2)) == null && (irDeclaration2 = this.tryResolveCustomDeclaration(symbol2)) == null) {
            return null;
        }
        if (!symbol2.isBound() && (LegacyDescriptorUtilsKt.isExpectMember(symbol2.getDescriptor()) || Intrinsics.areEqual((declarationDescriptor = symbol2.getDescriptor().getContainingDeclaration()) == null ? null : Boolean.valueOf(LegacyDescriptorUtilsKt.isExpectMember(declarationDescriptor)), true))) {
            return null;
        }
        if (!symbol2.isBound()) {
            return null;
        }
        return (org.jetbrains.kotlin.ir.declarations.IrDeclaration)symbol2.getOwner();
    }

    @Override
    @Nullable
    public IrSimpleFunctionSymbol tryReferencingSimpleFunctionByLocalSignature(@NotNull org.jetbrains.kotlin.ir.declarations.IrDeclaration parent2, @NotNull org.jetbrains.kotlin.ir.util.IdSignature idSignature) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        Intrinsics.checkNotNullParameter(parent2, "parent");
        Intrinsics.checkNotNullParameter(idSignature, "idSignature");
        if (idSignature.isPublic()) {
            return null;
        }
        Object object = this.deserializersForModules.get(IrUtilsKt.getFile(parent2).getPackageFragmentDescriptor().getContainingDeclaration());
        IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = irSimpleFunctionSymbol = object == null ? null : ((IrModuleDeserializer)object).referenceSimpleFunctionByLocalSignature(IrUtilsKt.getFile(parent2), idSignature);
        if (irSimpleFunctionSymbol == null) {
            object = Intrinsics.stringPlus("No module deserializer for ", RenderIrElementKt.render(parent2));
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        return irSimpleFunctionSymbol;
    }

    @Override
    @Nullable
    public IrPropertySymbol tryReferencingPropertyByLocalSignature(@NotNull org.jetbrains.kotlin.ir.declarations.IrDeclaration parent2, @NotNull org.jetbrains.kotlin.ir.util.IdSignature idSignature) {
        IrPropertySymbol irPropertySymbol;
        Intrinsics.checkNotNullParameter(parent2, "parent");
        Intrinsics.checkNotNullParameter(idSignature, "idSignature");
        if (idSignature.isPublic()) {
            return null;
        }
        Object object = this.deserializersForModules.get(IrUtilsKt.getFile(parent2).getPackageFragmentDescriptor().getContainingDeclaration());
        IrPropertySymbol irPropertySymbol2 = irPropertySymbol = object == null ? null : ((IrModuleDeserializer)object).referencePropertyByLocalSignature(IrUtilsKt.getFile(parent2), idSignature);
        if (irPropertySymbol == null) {
            object = Intrinsics.stringPlus("No module deserializer for ", RenderIrElementKt.render(parent2));
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        return irPropertySymbol;
    }

    @NotNull
    protected IrModuleDeserializer createCurrentModuleDeserializer(@NotNull IrModuleFragment moduleFragment, @NotNull Collection<? extends IrModuleDeserializer> dependencies2) {
        Intrinsics.checkNotNullParameter(moduleFragment, "moduleFragment");
        Intrinsics.checkNotNullParameter(dependencies2, "dependencies");
        return new CurrentModuleDeserializer(moduleFragment, dependencies2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init(@Nullable IrModuleFragment moduleFragment, @NotNull Collection<? extends IrDeserializer.IrLinkerExtension> extensions) {
        Intrinsics.checkNotNullParameter(extensions, "extensions");
        this.linkerExtensions = extensions;
        if (moduleFragment != null) {
            ModuleDescriptor $this$mapTo$iv$iv;
            Iterable $this$map$iv = moduleFragment.getDescriptor().getAllDependencyModules();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv = iterator2.next();
                ModuleDescriptor moduleDescriptor = (ModuleDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                IrModuleDeserializer irModuleDeserializer = this.getDeserializersForModules().get(it);
                if (irModuleDeserializer == null) {
                    String string2 = Intrinsics.stringPlus("No deserializer found for ", it);
                    boolean bl2 = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                IrModuleDeserializer irModuleDeserializer2 = irModuleDeserializer;
                collection.add(irModuleDeserializer2);
            }
            List currentModuleDependencies = (List)destination$iv$iv;
            IrModuleDeserializer currentModuleDeserializer = this.createCurrentModuleDeserializer(moduleFragment, currentModuleDependencies);
            Map<ModuleDescriptor, IrModuleDeserializer> map = this.deserializersForModules;
            $this$mapTo$iv$iv = moduleFragment.getDescriptor();
            destination$iv$iv = this.maybeWrapWithBuiltInAndInit(moduleFragment.getDescriptor(), currentModuleDeserializer);
            $i$f$mapTo = false;
            map.put($this$mapTo$iv$iv, (IrModuleDeserializer)destination$iv$iv);
        }
        Iterable $this$forEach$iv = this.deserializersForModules.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrModuleDeserializer it = (IrModuleDeserializer)element$iv;
            boolean bl = false;
            it.init();
        }
    }

    @Override
    public void postProcess() {
        this.finalizeExpectActualLinker();
        this.getFakeOverrideBuilder().provideFakeOverrides();
        this.haveSeen.clear();
    }

    private final BinarySymbolData.SymbolKind topLevelKindToSymbolKind(IrDeserializer.TopLevelSymbolKind kind) {
        BinarySymbolData.SymbolKind symbolKind;
        IrDeserializer.TopLevelSymbolKind topLevelSymbolKind = kind;
        int n = WhenMappings.$EnumSwitchMapping$1[topLevelSymbolKind.ordinal()];
        switch (n) {
            case 1: {
                symbolKind = BinarySymbolData.SymbolKind.CLASS_SYMBOL;
                break;
            }
            case 2: {
                symbolKind = BinarySymbolData.SymbolKind.PROPERTY_SYMBOL;
                break;
            }
            case 3: {
                symbolKind = BinarySymbolData.SymbolKind.FUNCTION_SYMBOL;
                break;
            }
            case 4: {
                symbolKind = BinarySymbolData.SymbolKind.TYPEALIAS_SYMBOL;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return symbolKind;
    }

    @Override
    @NotNull
    public IrSymbol resolveBySignatureInModule(@NotNull org.jetbrains.kotlin.ir.util.IdSignature signature2, @NotNull IrDeserializer.TopLevelSymbolKind kind, @NotNull Name moduleName) {
        IrModuleDeserializer irModuleDeserializer;
        Object v0;
        block4: {
            Intrinsics.checkNotNullParameter(signature2, "signature");
            Intrinsics.checkNotNullParameter((Object)kind, "kind");
            Intrinsics.checkNotNullParameter(moduleName, "moduleName");
            Iterable iterable = this.deserializersForModules.entrySet();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Map.Entry it = (Map.Entry)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual(((ModuleDescriptor)it.getKey()).getName(), moduleName)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        Object object = v0;
        IrModuleDeserializer irModuleDeserializer2 = irModuleDeserializer = object == null ? null : (IrModuleDeserializer)object.getValue();
        if (irModuleDeserializer == null) {
            object = "No module for name '" + moduleName + "' found";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        IrModuleDeserializer moduleDeserializer = irModuleDeserializer;
        boolean bl = Intrinsics.areEqual(signature2, signature2.topLevelSignature());
        boolean bl4 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string2 = "Signature '" + signature2 + "' has to be top level";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        if (!moduleDeserializer.contains(signature2)) {
            String string3 = "No signature " + signature2 + " in module " + moduleName;
            bl4 = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        IrSymbol irSymbol = moduleDeserializer.deserializeIrSymbol(signature2, this.topLevelKindToSymbolKind(kind));
        bl4 = false;
        boolean bl6 = false;
        IrSymbol it = irSymbol;
        boolean bl7 = false;
        this.deserializeAllReachableTopLevels();
        return irSymbol;
    }

    /*
     * WARNING - void declaration
     */
    private final void finalizeExpectActualLinker() {
        IrSymbol actualSymbol;
        IrSymbol expectSymbol;
        void $this$filterTo$iv$iv;
        Map<org.jetbrains.kotlin.ir.util.IdSignature, org.jetbrains.kotlin.ir.util.IdSignature> $this$filter$iv = this.expectUniqIdToActualUniqId;
        boolean $i$f$filter = false;
        Map<org.jetbrains.kotlin.ir.util.IdSignature, org.jetbrains.kotlin.ir.util.IdSignature> map = $this$filter$iv;
        Map<org.jetbrains.kotlin.ir.util.IdSignature, org.jetbrains.kotlin.ir.util.IdSignature> destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var6_8 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = var6_8.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            if (!(this.topLevelActualUniqItToDeserializer.get(it.getValue()) != null)) continue;
            destination$iv$iv.put((org.jetbrains.kotlin.ir.util.IdSignature)element$iv$iv.getKey(), (org.jetbrains.kotlin.ir.util.IdSignature)element$iv$iv.getValue());
        }
        Map<org.jetbrains.kotlin.ir.util.IdSignature, org.jetbrains.kotlin.ir.util.IdSignature> $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        map = $this$forEach$iv;
        boolean bl3 = false;
        Iterator<Map.Entry<Object, Object>> iterator3 = map.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry entry;
            Map.Entry it = entry = iterator3.next();
            boolean bl4 = false;
            expectSymbol = this.expectSymbols.get(it.getKey());
            actualSymbol = this.actualSymbols.get(it.getValue());
            if (expectSymbol == null || actualSymbol != null && actualSymbol.isBound()) continue;
            IrModuleDeserializer irModuleDeserializer = this.topLevelActualUniqItToDeserializer.get(it.getValue());
            Intrinsics.checkNotNull(irModuleDeserializer);
            irModuleDeserializer.addModuleReachableTopLevel((org.jetbrains.kotlin.ir.util.IdSignature)it.getValue());
            this.deserializeAllReachableTopLevels();
        }
        $this$forEach$iv = this.expectUniqIdToActualUniqId;
        $i$f$forEach = false;
        map = $this$forEach$iv;
        bl3 = false;
        iterator3 = map.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry<Object, Object> entry;
            Map.Entry<Object, Object> it = entry = iterator3.next();
            boolean bl5 = false;
            expectSymbol = this.expectSymbols.get(it.getKey());
            actualSymbol = this.actualSymbols.get(it.getValue());
            if (expectSymbol == null || actualSymbol == null) continue;
            IrSymbol irSymbol = expectSymbol;
            if (irSymbol instanceof IrDelegatingClassSymbolImpl) {
                ((IrDelegatingClassSymbolImpl)expectSymbol).setDelegate((IrBindableSymbol)((IrClassSymbol)actualSymbol));
                continue;
            }
            if (irSymbol instanceof IrDelegatingEnumEntrySymbolImpl) {
                ((IrDelegatingEnumEntrySymbolImpl)expectSymbol).setDelegate((IrBindableSymbol)((IrEnumEntrySymbol)actualSymbol));
                continue;
            }
            if (irSymbol instanceof IrDelegatingSimpleFunctionSymbolImpl) {
                ((IrDelegatingSimpleFunctionSymbolImpl)expectSymbol).setDelegate((IrBindableSymbol)((IrSimpleFunctionSymbol)actualSymbol));
                continue;
            }
            if (irSymbol instanceof IrDelegatingConstructorSymbolImpl) {
                ((IrDelegatingConstructorSymbolImpl)expectSymbol).setDelegate((IrBindableSymbol)((IrConstructorSymbol)actualSymbol));
                continue;
            }
            if (irSymbol instanceof IrDelegatingPropertySymbolImpl) {
                ((IrDelegatingPropertySymbolImpl)expectSymbol).setDelegate((IrBindableSymbol)((IrPropertySymbol)actualSymbol));
                continue;
            }
            String string2 = Intrinsics.stringPlus("Unexpected expect symbol kind during actualization: ", expectSymbol);
            boolean bl2 = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
    }

    @NotNull
    public final IrModuleFragment deserializeIrModuleHeader(@NotNull ModuleDescriptor moduleDescriptor, @Nullable KotlinLibrary kotlinLibrary, @NotNull DeserializationStrategy deserializationStrategy) {
        IrModuleDeserializer irModuleDeserializer;
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)deserializationStrategy, "deserializationStrategy");
        Map<ModuleDescriptor, IrModuleDeserializer> $this$getOrPut$iv = this.deserializersForModules;
        boolean $i$f$getOrPut = false;
        IrModuleDeserializer value$iv = $this$getOrPut$iv.get(moduleDescriptor);
        if (value$iv == null) {
            boolean bl = false;
            IrModuleDeserializer answer$iv = this.maybeWrapWithBuiltInAndInit(moduleDescriptor, this.createModuleDeserializer(moduleDescriptor, kotlinLibrary, deserializationStrategy));
            $this$getOrPut$iv.put(moduleDescriptor, answer$iv);
            irModuleDeserializer = answer$iv;
        } else {
            irModuleDeserializer = value$iv;
        }
        IrModuleDeserializer deserializerForModule = irModuleDeserializer;
        return deserializerForModule.getModuleFragment();
    }

    public static /* synthetic */ IrModuleFragment deserializeIrModuleHeader$default(KotlinIrLinker kotlinIrLinker, ModuleDescriptor moduleDescriptor, KotlinLibrary kotlinLibrary, DeserializationStrategy deserializationStrategy, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: deserializeIrModuleHeader");
        }
        if ((n & 4) != 0) {
            deserializationStrategy = DeserializationStrategy.ONLY_REFERENCED;
        }
        return kotlinIrLinker.deserializeIrModuleHeader(moduleDescriptor, kotlinLibrary, deserializationStrategy);
    }

    private final IrModuleDeserializer maybeWrapWithBuiltInAndInit(ModuleDescriptor moduleDescriptor, IrModuleDeserializer moduleDeserializer) {
        return this.isBuiltInModule(moduleDescriptor) ? (IrModuleDeserializer)new IrModuleDeserializerWithBuiltIns(this.builtIns, this.getFunctionalInterfaceFactory(), moduleDeserializer) : moduleDeserializer;
    }

    @NotNull
    public final IrModuleFragment deserializeIrModuleHeader(@NotNull ModuleDescriptor moduleDescriptor, @Nullable KotlinLibrary kotlinLibrary) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        DeserializationStrategy deserializationStrategy = this.exportedDependencies.contains(moduleDescriptor) ? DeserializationStrategy.ALL : DeserializationStrategy.EXPLICITLY_EXPORTED;
        return this.deserializeIrModuleHeader(moduleDescriptor, kotlinLibrary, deserializationStrategy);
    }

    @NotNull
    public final IrModuleFragment deserializeFullModule(@NotNull ModuleDescriptor moduleDescriptor, @Nullable KotlinLibrary kotlinLibrary) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        return this.deserializeIrModuleHeader(moduleDescriptor, kotlinLibrary, DeserializationStrategy.ALL);
    }

    @NotNull
    public final IrModuleFragment deserializeOnlyHeaderModule(@NotNull ModuleDescriptor moduleDescriptor, @Nullable KotlinLibrary kotlinLibrary) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        return this.deserializeIrModuleHeader(moduleDescriptor, kotlinLibrary, DeserializationStrategy.ONLY_DECLARATION_HEADERS);
    }

    @NotNull
    public final IrModuleFragment deserializeHeadersWithInlineBodies(@NotNull ModuleDescriptor moduleDescriptor, @Nullable KotlinLibrary kotlinLibrary) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        return this.deserializeIrModuleHeader(moduleDescriptor, kotlinLibrary, DeserializationStrategy.WITH_INLINE_BODIES);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00a6\u0004\u0018\u00002\u00020\u0001:\u0001;B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001fH\u0016J\u0011\u0010%\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u001fH\u0096\u0002J(\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00012\u0006\u0010,\u001a\u00020\tH\u0002J\u0018\u0010-\u001a\u00020.2\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020#H\u0016J\b\u00102\u001a\u00020#H\u0002J\u0010\u00103\u001a\u00020#2\u0006\u00104\u001a\u00020\u0001H\u0016J\u0018\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\r2\u0006\u00108\u001a\u00020\u001fH\u0016J\u0018\u00109\u001a\u00020:2\u0006\u00107\u001a\u00020\r2\u0006\u00108\u001a\u00020\u001fH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u00060\u000eR\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u00138VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0018\u001a\n0\u0019R\u00060\u0000R\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u001f\u0012\b\u0012\u00060\u000eR\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker$BasicIrModuleDeserializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "klib", "Lorg/jetbrains/kotlin/library/IrLibrary;", "strategy", "Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "containsErrorCode", "", "(Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/library/IrLibrary;Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;Z)V", "fileToDeserializerMap", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker$IrDeserializerForFile;", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "getKlib", "()Lorg/jetbrains/kotlin/library/IrLibrary;", "moduleDependencies", "", "getModuleDependencies", "()Ljava/util/List;", "moduleDependencies$delegate", "Lkotlin/Lazy;", "moduleDeserializationState", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker$BasicIrModuleDeserializer$ModuleDeserializationState;", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "getModuleFragment", "()Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "moduleReversedFileIndex", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "getStrategy", "()Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "addModuleReachableTopLevel", "", "idSig", "contains", "deserializeIrFile", "fileProto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrFile;", "fileIndex", "", "moduleDeserializer", "allowErrorNodes", "deserializeIrSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "symbolKind", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "deserializeReachableDeclarations", "enqueueModule", "init", "delegate", "referencePropertyByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "file", "idSignature", "referenceSimpleFunctionByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "ModuleDeserializationState", "ir.serialization.common"})
    public abstract class BasicIrModuleDeserializer
    extends IrModuleDeserializer {
        @NotNull
        private final IrLibrary klib;
        @NotNull
        private final DeserializationStrategy strategy;
        private final boolean containsErrorCode;
        @NotNull
        private final Map<org.jetbrains.kotlin.ir.declarations.IrFile, IrDeserializerForFile> fileToDeserializerMap;
        @NotNull
        private final ModuleDeserializationState moduleDeserializationState;
        @NotNull
        private final Map<org.jetbrains.kotlin.ir.util.IdSignature, IrDeserializerForFile> moduleReversedFileIndex;
        @NotNull
        private final Lazy moduleDependencies$delegate;
        @NotNull
        private final IrModuleFragment moduleFragment;

        public BasicIrModuleDeserializer(@NotNull ModuleDescriptor moduleDescriptor, @NotNull IrLibrary klib, DeserializationStrategy strategy, boolean containsErrorCode) {
            Intrinsics.checkNotNullParameter(KotlinIrLinker.this, "this$0");
            Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
            Intrinsics.checkNotNullParameter(klib, "klib");
            Intrinsics.checkNotNullParameter((Object)strategy, "strategy");
            super(moduleDescriptor);
            this.klib = klib;
            this.strategy = strategy;
            this.containsErrorCode = containsErrorCode;
            boolean bl = false;
            this.fileToDeserializerMap = new LinkedHashMap();
            this.moduleDeserializationState = new ModuleDeserializationState();
            bl = false;
            this.moduleReversedFileIndex = new LinkedHashMap();
            this.moduleDependencies$delegate = LazyKt.lazy((Function0)new Function0<List<? extends IrModuleDeserializer>>(moduleDescriptor, KotlinIrLinker.this){
                final /* synthetic */ ModuleDescriptor $moduleDescriptor;
                final /* synthetic */ KotlinIrLinker this$0;
                {
                    this.$moduleDescriptor = $moduleDescriptor;
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<IrModuleDeserializer> invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    ModuleDescriptor it;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    Iterable iterable = this.$moduleDescriptor.getAllDependencyModules();
                    Object object = this.$moduleDescriptor;
                    boolean $i$f$filter = false;
                    void var4_4 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (ModuleDescriptor)element$iv$iv;
                        boolean bl = false;
                        if (!(!Intrinsics.areEqual(it, object))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    object = this.this$0;
                    boolean $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        it = (ModuleDescriptor)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        IrModuleDeserializer irModuleDeserializer = ((KotlinIrLinker)object).resolveModuleDeserializer(it);
                        collection.add(irModuleDeserializer);
                    }
                    return (List)destination$iv$iv;
                }
            });
            this.moduleFragment = new IrModuleFragmentImpl(moduleDescriptor, KotlinIrLinker.this.getBuiltIns(), CollectionsKt.emptyList());
        }

        public /* synthetic */ BasicIrModuleDeserializer(ModuleDescriptor moduleDescriptor, IrLibrary irLibrary, DeserializationStrategy deserializationStrategy, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                bl = false;
            }
            this(moduleDescriptor, irLibrary, deserializationStrategy, bl);
        }

        @Override
        @NotNull
        public IrLibrary getKlib() {
            return this.klib;
        }

        @Override
        @NotNull
        public DeserializationStrategy getStrategy() {
            return this.strategy;
        }

        @NotNull
        public List<IrModuleDeserializer> getModuleDependencies() {
            Lazy lazy = this.moduleDependencies$delegate;
            boolean bl = false;
            return (List)lazy.getValue();
        }

        @Override
        public void init(@NotNull IrModuleDeserializer delegate) {
            Intrinsics.checkNotNullParameter(delegate, "delegate");
            int fileCount = this.getKlib().fileCount();
            ArrayList<org.jetbrains.kotlin.ir.declarations.IrFile> files2 = new ArrayList<org.jetbrains.kotlin.ir.declarations.IrFile>(fileCount);
            int n = 0;
            if (n < fileCount) {
                do {
                    int i = n++;
                    CodedInputStream fileStream = KotlinIrLinker.this.getCodedInputStream(this.getKlib().file(i));
                    IrFile irFile = IrFile.parseFrom(fileStream, ExtensionRegistryLite.newInstance());
                    Intrinsics.checkNotNullExpressionValue(irFile, "parseFrom(fileStream, newInstance())");
                    files2.add(this.deserializeIrFile(irFile, i, delegate, this.containsErrorCode));
                } while (n < fileCount);
            }
            this.getModuleFragment().getFiles().addAll((Collection<org.jetbrains.kotlin.ir.declarations.IrFile>)files2);
            Iterable $this$forEach$iv = this.fileToDeserializerMap.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrDeserializerForFile it = (IrDeserializerForFile)element$iv;
                boolean bl = false;
                it.deserializeExpectActualMapping();
            }
        }

        @Override
        @NotNull
        public IrSimpleFunctionSymbol referenceSimpleFunctionByLocalSignature(@NotNull org.jetbrains.kotlin.ir.declarations.IrFile file2, @NotNull org.jetbrains.kotlin.ir.util.IdSignature idSignature) {
            Intrinsics.checkNotNullParameter(file2, "file");
            Intrinsics.checkNotNullParameter(idSignature, "idSignature");
            IrDeserializerForFile irDeserializerForFile = this.fileToDeserializerMap.get(file2);
            if (irDeserializerForFile == null) {
                String string2 = "No deserializer for file " + file2 + " in module " + this.getModuleDescriptor().getName();
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            return irDeserializerForFile.referenceSimpleFunctionByLocalSignature(idSignature);
        }

        @Override
        @NotNull
        public IrPropertySymbol referencePropertyByLocalSignature(@NotNull org.jetbrains.kotlin.ir.declarations.IrFile file2, @NotNull org.jetbrains.kotlin.ir.util.IdSignature idSignature) {
            Intrinsics.checkNotNullParameter(file2, "file");
            Intrinsics.checkNotNullParameter(idSignature, "idSignature");
            IrDeserializerForFile irDeserializerForFile = this.fileToDeserializerMap.get(file2);
            if (irDeserializerForFile == null) {
                String string2 = "No deserializer for file " + file2 + " in module " + this.getModuleDescriptor().getName();
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            return irDeserializerForFile.referencePropertyByLocalSignature(idSignature);
        }

        @Override
        public boolean contains(@NotNull org.jetbrains.kotlin.ir.util.IdSignature idSig) {
            Intrinsics.checkNotNullParameter(idSig, "idSig");
            Map<org.jetbrains.kotlin.ir.util.IdSignature, IrDeserializerForFile> map = this.moduleReversedFileIndex;
            boolean bl = false;
            Map<org.jetbrains.kotlin.ir.util.IdSignature, IrDeserializerForFile> map2 = map;
            boolean bl2 = false;
            return map2.containsKey(idSig);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrSymbol deserializeIrSymbol(@NotNull org.jetbrains.kotlin.ir.util.IdSignature idSig, @NotNull BinarySymbolData.SymbolKind symbolKind) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter(idSig, "idSig");
            Intrinsics.checkNotNullParameter((Object)symbolKind, "symbolKind");
            boolean bl = idSig.isPublic();
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            org.jetbrains.kotlin.ir.util.IdSignature topLevelSignature = idSig.topLevelSignature();
            IrDeserializerForFile irDeserializerForFile = this.moduleReversedFileIndex.get(topLevelSignature);
            if (irDeserializerForFile == null) {
                String string3 = "No file for " + topLevelSignature + " (@ " + idSig + ") in module " + this.getModuleDescriptor();
                boolean bl5 = false;
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            IrDeserializerForFile fileDeserializer = irDeserializerForFile;
            IrDeserializerForFile.FileDeserializationState fileDeserializationState = fileDeserializer.getFileLocalDeserializationState();
            fileDeserializationState.addIdSignature(topLevelSignature);
            this.moduleDeserializationState.enqueueFile(fileDeserializer);
            Map<org.jetbrains.kotlin.ir.util.IdSignature, IrSymbol> map = fileDeserializationState.getDeserializedSymbols();
            KotlinIrLinker kotlinIrLinker = KotlinIrLinker.this;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(idSig);
            if (value$iv == null) {
                boolean bl6 = false;
                IrSymbol symbol2 = kotlinIrLinker.referenceDeserializedSymbol(symbolKind, idSig);
                IrSymbol answer$iv = kotlinIrLinker.handleExpectActualMapping(idSig, symbol2);
                $this$getOrPut$iv.put(idSig, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (IrSymbol)object;
        }

        @Override
        @NotNull
        public IrModuleFragment getModuleFragment() {
            return this.moduleFragment;
        }

        /*
         * WARNING - void declaration
         */
        private final org.jetbrains.kotlin.ir.declarations.IrFile deserializeIrFile(IrFile fileProto, int fileIndex, IrModuleDeserializer moduleDeserializer, boolean allowErrorNodes) {
            void $this$mapTo$iv$iv;
            String fileName = fileProto.getFileEntry().getName();
            Intrinsics.checkNotNullExpressionValue(fileName, "fileName");
            List<Integer> list2 = fileProto.getFileEntry().getLineStartOffsetsList();
            Intrinsics.checkNotNullExpressionValue(list2, "fileProto.fileEntry.lineStartOffsetsList");
            NaiveSourceBasedFileEntryImpl fileEntry = new NaiveSourceBasedFileEntryImpl(fileName, CollectionsKt.toIntArray((Collection<Integer>)list2));
            List<IrConstructorCall> list3 = fileProto.getAnnotationList();
            Object object = fileProto.getActualsList();
            Intrinsics.checkNotNullExpressionValue(object, "fileProto.actualsList");
            object = new IrDeserializerForFile(list3, (List<Actual>)object, fileIndex, !this.getStrategy().getNeedBodies(), this.getStrategy().getInlineBodies(), moduleDeserializer, allowErrorNodes);
            boolean bl = false;
            boolean bl2 = false;
            Object $this$deserializeIrFile_u24lambda_u2d3 = object;
            boolean $i$a$-apply-KotlinIrLinker$BasicIrModuleDeserializer$deserializeIrFile$fileDeserializer$232 = false;
            List<Long> list4 = fileProto.getExplicitlyExportedToCompilerList();
            Intrinsics.checkNotNullExpressionValue(list4, "fileProto.explicitlyExportedToCompilerList");
            Iterable $this$forEach$iv32422 = list4;
            boolean $i$f$forEach = false;
            for (Object t : $this$forEach$iv32422) {
                Long it = (Long)t;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                long symbolData = ((IrDeserializerForFile)$this$deserializeIrFile_u24lambda_u2d3).parseSymbolData-9x8F8T0(it);
                org.jetbrains.kotlin.ir.util.IdSignature sig = ((IrDeserializerForFile)$this$deserializeIrFile_u24lambda_u2d3).deserializeIdSignature(BinarySymbolData.getSignatureId-impl(symbolData));
                boolean bl4 = !sig.isPackageSignature();
                boolean bl5 = false;
                boolean bl6 = false;
                if (_Assertions.ENABLED && !bl4) {
                    boolean bl7 = false;
                    String string2 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                ((IrDeserializerForFile)$this$deserializeIrFile_u24lambda_u2d3).getFileLocalDeserializationState().addIdSignature(sig.topLevelSignature());
            }
            Object fileDeserializer = object;
            List<Integer> list5 = fileProto.getFqNameList();
            Intrinsics.checkNotNullExpressionValue(list5, "fileProto.fqNameList");
            FqName fqName2 = new FqName(((IrFileDeserializer)fileDeserializer).deserializeFqName(list5));
            EmptyPackageFragmentDescriptor packageFragmentDescriptor = new EmptyPackageFragmentDescriptor(this.getModuleDescriptor(), fqName2);
            IrFileSymbolImpl symbol2 = new IrFileSymbolImpl(packageFragmentDescriptor);
            IrFileImpl file2 = new IrFileImpl(fileEntry, symbol2, fqName2);
            ((IrDeserializerForFile)fileDeserializer).setFile(file2);
            Map<org.jetbrains.kotlin.ir.declarations.IrFile, IrDeserializerForFile> $i$a$-apply-KotlinIrLinker$BasicIrModuleDeserializer$deserializeIrFile$fileDeserializer$232 = this.fileToDeserializerMap;
            boolean $this$forEach$iv32422 = false;
            $i$a$-apply-KotlinIrLinker$BasicIrModuleDeserializer$deserializeIrFile$fileDeserializer$232.put(file2, (IrDeserializerForFile)fileDeserializer);
            List<Integer> $this$forEach$iv32422 = fileProto.getDeclarationIdList();
            Intrinsics.checkNotNullExpressionValue($this$forEach$iv32422, "fileProto.declarationIdList");
            Iterable $this$map$iv = $this$forEach$iv32422;
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Integer n = (Integer)item$iv$iv;
                Collection collection2 = collection;
                boolean bl8 = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                Pair<org.jetbrains.kotlin.ir.util.IdSignature, void> pair = TuplesKt.to(((IrDeserializerForFile)fileDeserializer).deserializeIdSignature(it.intValue()), it);
                collection2.add(pair);
            }
            List fileSignatureIndex = (List)collection;
            Iterable $this$forEach$iv = fileSignatureIndex;
            $i$f$forEach = false;
            for (Object t : $this$forEach$iv) {
                void $this$getOrPut$iv;
                Pair it = (Pair)t;
                boolean bl9 = false;
                Map<org.jetbrains.kotlin.ir.util.IdSignature, IrDeserializerForFile> item$iv$iv = this.moduleReversedFileIndex;
                Object key$iv = it.getFirst();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv != null) continue;
                boolean bl10 = false;
                Object answer$iv = fileDeserializer;
                $this$getOrPut$iv.put(key$iv, answer$iv);
            }
            ((IrDeserializerForFile)fileDeserializer).setReversedSignatureIndex(MapsKt.toMap(fileSignatureIndex));
            if (this.getStrategy().getTheWholeWorld()) {
                for (Pair id : fileSignatureIndex) {
                    this.moduleDeserializationState.addIdSignature((org.jetbrains.kotlin.ir.util.IdSignature)id.getFirst());
                }
                this.moduleDeserializationState.enqueueFile((IrDeserializerForFile)fileDeserializer);
            } else if (this.getStrategy().getExplicitlyExported()) {
                this.moduleDeserializationState.enqueueFile((IrDeserializerForFile)fileDeserializer);
            }
            return file2;
        }

        @Override
        public void deserializeReachableDeclarations() {
            this.moduleDeserializationState.processPendingDeclarations();
        }

        private final void enqueueModule() {
            KotlinIrLinker.this.modulesWithReachableTopLevels.add(this);
        }

        @Override
        public void addModuleReachableTopLevel(@NotNull org.jetbrains.kotlin.ir.util.IdSignature idSig) {
            Intrinsics.checkNotNullParameter(idSig, "idSig");
            this.moduleDeserializationState.addIdSignature(idSig);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u00020\b2\n\u0010\f\u001a\u00060\u0005R\u00020\u0006J\u0006\u0010\r\u001a\u00020\bR\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u00060\u0005R\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker$BasicIrModuleDeserializer$ModuleDeserializationState;", "", "(Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker$BasicIrModuleDeserializer;)V", "filesWithPendingTopLevels", "", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker$IrDeserializerForFile;", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "addIdSignature", "", "key", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "enqueueFile", "fileDeserializer", "processPendingDeclarations", "ir.serialization.common"})
        private final class ModuleDeserializationState {
            @NotNull
            private final Set<IrDeserializerForFile> filesWithPendingTopLevels;

            public ModuleDeserializationState() {
                Intrinsics.checkNotNullParameter(BasicIrModuleDeserializer.this, "this$0");
                boolean bl = false;
                this.filesWithPendingTopLevels = new LinkedHashSet();
            }

            public final void enqueueFile(@NotNull IrDeserializerForFile fileDeserializer) {
                Intrinsics.checkNotNullParameter(fileDeserializer, "fileDeserializer");
                this.filesWithPendingTopLevels.add(fileDeserializer);
                BasicIrModuleDeserializer.this.enqueueModule();
            }

            public final void addIdSignature(@NotNull org.jetbrains.kotlin.ir.util.IdSignature key) {
                Intrinsics.checkNotNullParameter(key, "key");
                IrDeserializerForFile irDeserializerForFile = (IrDeserializerForFile)BasicIrModuleDeserializer.this.moduleReversedFileIndex.get(key);
                if (irDeserializerForFile == null) {
                    String string2 = Intrinsics.stringPlus("No file found for key ", key);
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                IrDeserializerForFile fileDeserializer = irDeserializerForFile;
                fileDeserializer.getFileLocalDeserializationState().addIdSignature(key);
                this.enqueueFile(fileDeserializer);
            }

            public final void processPendingDeclarations() {
                while (true) {
                    Collection collection = this.filesWithPendingTopLevels;
                    boolean bl = false;
                    if (!(!collection.isEmpty())) break;
                    IrDeserializerForFile pendingDeserializer = (IrDeserializerForFile)CollectionsKt.first((Iterable)this.filesWithPendingTopLevels);
                    pendingDeserializer.deserializeFileImplicitDataIfFirstUse();
                    pendingDeserializer.deserializeAllFileReachableTopLevel();
                    this.filesWithPendingTopLevels.remove(pendingDeserializer);
                }
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001:\u0001lBK\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u0002012\u0006\u00102\u001a\u00020)J\u0006\u00103\u001a\u00020/J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\bH\u0016J\u0006\u00107\u001a\u00020/J\u0010\u00108\u001a\u00020)2\u0006\u00106\u001a\u00020\bH\u0016J\u0018\u00109\u001a\u00020:2\u0006\u00102\u001a\u00020)2\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010=\u001a\u00020:2\u0006\u0010>\u001a\u00020?H\u0016J\u0018\u0010@\u001a\u00020:2\u0006\u0010A\u001a\u00020)2\u0006\u0010;\u001a\u00020<H\u0002J\u001c\u0010B\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020)0C2\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010D\u001a\u00020\"2\u0006\u00106\u001a\u00020\bH\u0016J\u001e\u0010E\u001a\u00020 2\u0006\u0010F\u001a\u00020\b2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020 0HH\u0016J\u0010\u0010I\u001a\u00020J2\u0006\u00106\u001a\u00020\bH\u0016J\u0010\u0010K\u001a\u00020L2\u0006\u00106\u001a\u00020\bH\u0016J\u0010\u0010M\u001a\u00020\r2\u0006\u00102\u001a\u00020)H\u0002J\u0012\u0010N\u001a\u0004\u0018\u00010\r2\u0006\u0010A\u001a\u00020)H\u0002J\u0010\u0010O\u001a\u00020P2\u0006\u00106\u001a\u00020\bH\u0002J\u0010\u0010Q\u001a\u00020R2\u0006\u00106\u001a\u00020\bH\u0002J\u0010\u0010S\u001a\u00020T2\u0006\u00106\u001a\u00020\bH\u0002J\u0010\u0010U\u001a\u00020L2\u0006\u00106\u001a\u00020\bH\u0002J\u0010\u0010V\u001a\u00020W2\u0006\u00102\u001a\u00020)H\u0002J\u0010\u0010X\u001a\u00020Y2\u0006\u00106\u001a\u00020\bH\u0002J\u001e\u0010Z\u001a\u00020[2\u0006\u0010>\u001a\u00020?\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\\\u0010]J\u0010\u0010^\u001a\u00020_2\u0006\u00106\u001a\u00020\bH\u0002J\u0010\u0010`\u001a\u00020_2\u0006\u00106\u001a\u00020\bH\u0002J\u0010\u0010a\u001a\u00020_2\u0006\u00106\u001a\u00020\bH\u0002J\u0010\u0010b\u001a\u00020_2\u0006\u00106\u001a\u00020\bH\u0002J\u0018\u0010c\u001a\u00020/2\u0006\u0010d\u001a\u00020:2\u0006\u0010e\u001a\u00020)H\u0016J\u0018\u0010f\u001a\u00020/2\u0006\u0010d\u001a\u00020:2\u0006\u0010e\u001a\u00020)H\u0002J\u000e\u0010g\u001a\u00020h2\u0006\u0010A\u001a\u00020)J\u000e\u0010i\u001a\u00020j2\u0006\u0010A\u001a\u00020)J\u0010\u0010k\u001a\u00020\b2\u0006\u00102\u001a\u00020)H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0019\u001a\n0\u001aR\u00060\u0000R\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\"0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R&\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\b0(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006m"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker$IrDeserializerForFile;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileDeserializer;", "annotations", "", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrConstructorCall;", "actuals", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/Actual;", "fileIndex", "", "onlyHeaders", "", "inlineBodies", "moduleDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "allowErrorNodes", "(Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;Ljava/util/List;Ljava/util/List;IZZLorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;Z)V", "deserializeInlineFunctions", "getDeserializeInlineFunctions", "()Z", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "setFile", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "fileLocalDeserializationState", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker$IrDeserializerForFile$FileDeserializationState;", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "getFileLocalDeserializationState", "()Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker$IrDeserializerForFile$FileDeserializationState;", "fileLoops", "", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "irTypeCache", "Lorg/jetbrains/kotlin/ir/types/IrType;", "platformFakeOverrideClassFilter", "Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideClassFilter;", "getPlatformFakeOverrideClassFilter", "()Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideClassFilter;", "reversedSignatureIndex", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "getReversedSignatureIndex", "()Ljava/util/Map;", "setReversedSignatureIndex", "(Ljava/util/Map;)V", "deserializeAllFileReachableTopLevel", "", "deserializeDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "idSig", "deserializeExpectActualMapping", "deserializeExpressionBody", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "index", "deserializeFileImplicitDataIfFirstUse", "deserializeIdSignature", "deserializeIrLocalSymbolData", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "symbolKind", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "deserializeIrSymbol", "code", "", "deserializeIrSymbolData", "idSignature", "deserializeIrSymbolToDeclare", "Lkotlin/Pair;", "deserializeIrType", "deserializeLoopHeader", "loopIndex", "loopBuilder", "Lkotlin/Function0;", "deserializeStatementBody", "Lorg/jetbrains/kotlin/ir/IrElement;", "deserializeString", "", "findModuleDeserializer", "getModuleForTopLevelId", "loadExpressionBodyProto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrExpression;", "loadSignatureProto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IdSignature;", "loadStatementBodyProto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrStatement;", "loadStringProto", "loadTopLevelDeclarationProto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrDeclaration;", "loadTypeProto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrType;", "parseSymbolData", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData;", "parseSymbolData-9x8F8T0", "(J)J", "readBody", "Lorg/jetbrains/kotlin/protobuf/CodedInputStream;", "readDeclaration", "readSignature", "readType", "referenceIrSymbol", "symbol", "signature", "referenceIrSymbolData", "referencePropertyByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "referenceSimpleFunctionByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "resolveSignatureIndex", "FileDeserializationState", "ir.serialization.common"})
    public final class IrDeserializerForFile
    extends IrFileDeserializer {
        @Nullable
        private List<IrConstructorCall> annotations;
        @NotNull
        private final List<Actual> actuals;
        private final int fileIndex;
        @NotNull
        private final IrModuleDeserializer moduleDeserializer;
        @NotNull
        private Map<Integer, IrLoop> fileLoops;
        public org.jetbrains.kotlin.ir.declarations.IrFile file;
        @NotNull
        private final Map<Integer, org.jetbrains.kotlin.ir.types.IrType> irTypeCache;
        private final boolean deserializeInlineFunctions;
        @NotNull
        private final FakeOverrideClassFilter platformFakeOverrideClassFilter;
        @NotNull
        private Map<org.jetbrains.kotlin.ir.util.IdSignature, Integer> reversedSignatureIndex;
        @NotNull
        private final FileDeserializationState fileLocalDeserializationState;

        public IrDeserializerForFile(@NotNull List<IrConstructorCall> annotations2, List<Actual> actuals, int fileIndex, boolean onlyHeaders, @NotNull boolean inlineBodies, IrModuleDeserializer moduleDeserializer, boolean allowErrorNodes) {
            Intrinsics.checkNotNullParameter(KotlinIrLinker.this, "this$0");
            Intrinsics.checkNotNullParameter(actuals, "actuals");
            Intrinsics.checkNotNullParameter(moduleDeserializer, "moduleDeserializer");
            super(KotlinIrLinker.this.getLogger(), KotlinIrLinker.this.getBuiltIns(), KotlinIrLinker.this.getSymbolTable(), !onlyHeaders, KotlinIrLinker.this.getFakeOverrideBuilder(), allowErrorNodes);
            this.annotations = annotations2;
            this.actuals = actuals;
            this.fileIndex = fileIndex;
            this.moduleDeserializer = moduleDeserializer;
            boolean bl = false;
            this.fileLoops = new LinkedHashMap();
            bl = false;
            this.irTypeCache = new LinkedHashMap();
            this.deserializeInlineFunctions = inlineBodies;
            this.platformFakeOverrideClassFilter = KotlinIrLinker.this.getFakeOverrideBuilder().getPlatformSpecificClassFilter();
            this.reversedSignatureIndex = MapsKt.emptyMap();
            this.fileLocalDeserializationState = new FileDeserializationState();
        }

        @NotNull
        public final org.jetbrains.kotlin.ir.declarations.IrFile getFile() {
            org.jetbrains.kotlin.ir.declarations.IrFile irFile = this.file;
            if (irFile != null) {
                return irFile;
            }
            Intrinsics.throwUninitializedPropertyAccessException("file");
            throw null;
        }

        public final void setFile(@NotNull org.jetbrains.kotlin.ir.declarations.IrFile irFile) {
            Intrinsics.checkNotNullParameter(irFile, "<set-?>");
            this.file = irFile;
        }

        @Override
        public boolean getDeserializeInlineFunctions() {
            return this.deserializeInlineFunctions;
        }

        @Override
        @NotNull
        public FakeOverrideClassFilter getPlatformFakeOverrideClassFilter() {
            return this.platformFakeOverrideClassFilter;
        }

        @NotNull
        public final Map<org.jetbrains.kotlin.ir.util.IdSignature, Integer> getReversedSignatureIndex() {
            return this.reversedSignatureIndex;
        }

        public final void setReversedSignatureIndex(@NotNull Map<org.jetbrains.kotlin.ir.util.IdSignature, Integer> map) {
            Intrinsics.checkNotNullParameter(map, "<set-?>");
            this.reversedSignatureIndex = map;
        }

        @NotNull
        public final FileDeserializationState getFileLocalDeserializationState() {
            return this.fileLocalDeserializationState;
        }

        @NotNull
        public final org.jetbrains.kotlin.ir.declarations.IrDeclaration deserializeDeclaration(@NotNull org.jetbrains.kotlin.ir.util.IdSignature idSig) {
            Intrinsics.checkNotNullParameter(idSig, "idSig");
            return this.deserializeDeclaration(this.loadTopLevelDeclarationProto(idSig), this.getFile());
        }

        /*
         * WARNING - void declaration
         */
        public final void deserializeExpectActualMapping() {
            void $this$forEach$iv;
            Iterable iterable = this.actuals;
            KotlinIrLinker kotlinIrLinker = KotlinIrLinker.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Actual it = (Actual)element$iv;
                boolean bl = false;
                long expectSymbol = this.parseSymbolData-9x8F8T0(it.getExpectSymbol());
                long actualSymbol = this.parseSymbolData-9x8F8T0(it.getActualSymbol());
                org.jetbrains.kotlin.ir.util.IdSignature expect = this.deserializeIdSignature(BinarySymbolData.getSignatureId-impl(expectSymbol));
                org.jetbrains.kotlin.ir.util.IdSignature actual = this.deserializeIdSignature(BinarySymbolData.getSignatureId-impl(actualSymbol));
                boolean bl2 = kotlinIrLinker.expectUniqIdToActualUniqId.get(expect) == null;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl4 = false;
                    String string2 = "Expect signature " + expect + " is already actualized by " + kotlinIrLinker.expectUniqIdToActualUniqId.get(expect) + ", while we try to record " + actual;
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                Object object = kotlinIrLinker.expectUniqIdToActualUniqId;
                bl3 = false;
                object.put(expect, actual);
                object = this.getModuleForTopLevelId(actual);
                if (object == null) continue;
                Object object2 = object;
                boolean bl5 = false;
                boolean bl6 = false;
                Object md = object2;
                boolean bl7 = false;
                Map map = kotlinIrLinker.topLevelActualUniqItToDeserializer;
                boolean bl8 = false;
                map.put(actual, md);
            }
        }

        private final int resolveSignatureIndex(org.jetbrains.kotlin.ir.util.IdSignature idSig) {
            Integer n = this.reversedSignatureIndex.get(idSig);
            if (n == null) {
                String string2 = Intrinsics.stringPlus("Not found Idx for ", idSig);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            return n;
        }

        private final CodedInputStream readDeclaration(int index2) {
            return KotlinIrLinker.this.getCodedInputStream(this.moduleDeserializer.getKlib().irDeclaration(index2, this.fileIndex));
        }

        private final IrDeclaration loadTopLevelDeclarationProto(org.jetbrains.kotlin.ir.util.IdSignature idSig) {
            int idSigIndex = this.resolveSignatureIndex(idSig);
            IrDeclaration irDeclaration2 = IrDeclaration.parseFrom(this.readDeclaration(idSigIndex), ExtensionRegistryLite.newInstance());
            Intrinsics.checkNotNullExpressionValue(irDeclaration2, "parseFrom(readDeclaration(idSigIndex), newInstance())");
            return irDeclaration2;
        }

        private final CodedInputStream readType(int index2) {
            return KotlinIrLinker.this.getCodedInputStream(this.moduleDeserializer.getKlib().type(index2, this.fileIndex));
        }

        private final IrType loadTypeProto(int index2) {
            IrType irType = IrType.parseFrom(this.readType(index2), ExtensionRegistryLite.newInstance());
            Intrinsics.checkNotNullExpressionValue(irType, "parseFrom(readType(index), newInstance())");
            return irType;
        }

        private final CodedInputStream readSignature(int index2) {
            return KotlinIrLinker.this.getCodedInputStream(this.moduleDeserializer.getKlib().signature(index2, this.fileIndex));
        }

        private final IdSignature loadSignatureProto(int index2) {
            IdSignature idSignature = IdSignature.parseFrom(this.readSignature(index2), ExtensionRegistryLite.newInstance());
            Intrinsics.checkNotNullExpressionValue(idSignature, "parseFrom(readSignature(index), newInstance())");
            return idSignature;
        }

        private final CodedInputStream readBody(int index2) {
            return KotlinIrLinker.this.getCodedInputStream(this.moduleDeserializer.getKlib().body(index2, this.fileIndex));
        }

        private final IrStatement loadStatementBodyProto(int index2) {
            IrStatement irStatement = IrStatement.parseFrom(this.readBody(index2), ExtensionRegistryLite.newInstance());
            Intrinsics.checkNotNullExpressionValue(irStatement, "parseFrom(readBody(index), newInstance())");
            return irStatement;
        }

        private final IrExpression loadExpressionBodyProto(int index2) {
            IrExpression irExpression = IrExpression.parseFrom(this.readBody(index2), ExtensionRegistryLite.newInstance());
            Intrinsics.checkNotNullExpressionValue(irExpression, "parseFrom(readBody(index), newInstance())");
            return irExpression;
        }

        private final String loadStringProto(int index2) {
            byte[] byArray = this.moduleDeserializer.getKlib().string(index2, this.fileIndex);
            boolean bl = false;
            return new String(byArray, Charsets.UTF_8);
        }

        private final IrModuleDeserializer getModuleForTopLevelId(org.jetbrains.kotlin.ir.util.IdSignature idSignature) {
            Object v0;
            block2: {
                if (this.moduleDeserializer.contains(idSignature)) {
                    return this.moduleDeserializer;
                }
                Iterable $this$firstOrNull$iv = this.moduleDeserializer.getModuleDependencies();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    IrModuleDeserializer it = (IrModuleDeserializer)element$iv;
                    boolean bl = false;
                    if (!it.contains(idSignature)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            return v0;
        }

        private final IrModuleDeserializer findModuleDeserializer(org.jetbrains.kotlin.ir.util.IdSignature idSig) {
            Object v0;
            block3: {
                boolean bl = idSig.isPublic();
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string2 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                org.jetbrains.kotlin.ir.util.IdSignature topLevelSig = idSig.topLevelSignature();
                if (this.moduleDeserializer.contains(topLevelSig)) {
                    return this.moduleDeserializer;
                }
                Iterable $this$firstOrNull$iv = this.moduleDeserializer.getModuleDependencies();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    IrModuleDeserializer it = (IrModuleDeserializer)element$iv;
                    boolean bl5 = false;
                    if (!it.contains(topLevelSig)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            IrModuleDeserializer irModuleDeserializer = v0;
            return irModuleDeserializer == null ? KotlinIrLinker.this.handleNoModuleDeserializerFound(idSig) : irModuleDeserializer;
        }

        private final void referenceIrSymbolData(IrSymbol symbol2, org.jetbrains.kotlin.ir.util.IdSignature signature2) {
            boolean bl = signature2.isLocal();
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            this.fileLocalDeserializationState.getDeserializedSymbols().putIfAbsent(signature2, symbol2);
        }

        /*
         * WARNING - void declaration
         */
        private final IrSymbol deserializeIrLocalSymbolData(org.jetbrains.kotlin.ir.util.IdSignature idSig, BinarySymbolData.SymbolKind symbolKind) {
            Object object;
            void $this$getOrPut$iv;
            boolean bl = idSig.isLocal();
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            if (idSig.getHasTopLevel()) {
                this.fileLocalDeserializationState.addIdSignature(idSig.topLevelSignature());
            }
            Map<org.jetbrains.kotlin.ir.util.IdSignature, IrSymbol> map = this.fileLocalDeserializationState.getDeserializedSymbols();
            KotlinIrLinker kotlinIrLinker = KotlinIrLinker.this;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(idSig);
            if (value$iv == null) {
                boolean bl5 = false;
                IrSymbol answer$iv = kotlinIrLinker.referenceDeserializedSymbol(symbolKind, idSig);
                $this$getOrPut$iv.put(idSig, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (IrSymbol)object;
        }

        @NotNull
        public final IrSimpleFunctionSymbol referenceSimpleFunctionByLocalSignature(@NotNull org.jetbrains.kotlin.ir.util.IdSignature idSignature) {
            Intrinsics.checkNotNullParameter(idSignature, "idSignature");
            return (IrSimpleFunctionSymbol)this.deserializeIrSymbolData(idSignature, BinarySymbolData.SymbolKind.FUNCTION_SYMBOL);
        }

        @NotNull
        public final IrPropertySymbol referencePropertyByLocalSignature(@NotNull org.jetbrains.kotlin.ir.util.IdSignature idSignature) {
            Intrinsics.checkNotNullParameter(idSignature, "idSignature");
            return (IrPropertySymbol)this.deserializeIrSymbolData(idSignature, BinarySymbolData.SymbolKind.PROPERTY_SYMBOL);
        }

        private final IrSymbol deserializeIrSymbolData(org.jetbrains.kotlin.ir.util.IdSignature idSignature, BinarySymbolData.SymbolKind symbolKind) {
            if (idSignature.isLocal()) {
                return this.deserializeIrLocalSymbolData(idSignature, symbolKind);
            }
            IrSymbol irSymbol = this.findModuleDeserializer(idSignature).deserializeIrSymbol(idSignature, symbolKind);
            KotlinIrLinker kotlinIrLinker = KotlinIrLinker.this;
            boolean bl = false;
            boolean bl2 = false;
            IrSymbol it = irSymbol;
            boolean bl3 = false;
            kotlinIrLinker.haveSeen.add(it);
            return irSymbol;
        }

        @Override
        @NotNull
        public Pair<IrSymbol, org.jetbrains.kotlin.ir.util.IdSignature> deserializeIrSymbolToDeclare(long code) {
            long symbolData = this.parseSymbolData-9x8F8T0(code);
            org.jetbrains.kotlin.ir.util.IdSignature signature2 = this.deserializeIdSignature(BinarySymbolData.getSignatureId-impl(symbolData));
            return new Pair<IrSymbol, org.jetbrains.kotlin.ir.util.IdSignature>(this.deserializeIrSymbolData(signature2, BinarySymbolData.getKind-impl(symbolData)), signature2);
        }

        public final long parseSymbolData-9x8F8T0(long code) {
            return BinarySymbolData.Companion.decode-9x8F8T0(code);
        }

        @Override
        @NotNull
        public IrSymbol deserializeIrSymbol(long code) {
            long symbolData = this.parseSymbolData-9x8F8T0(code);
            org.jetbrains.kotlin.ir.util.IdSignature signature2 = this.deserializeIdSignature(BinarySymbolData.getSignatureId-impl(symbolData));
            return this.deserializeIrSymbolData(signature2, BinarySymbolData.getKind-impl(symbolData));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public org.jetbrains.kotlin.ir.types.IrType deserializeIrType(int index2) {
            Object object;
            void $this$getOrPut$iv;
            Map<Integer, org.jetbrains.kotlin.ir.types.IrType> map = this.irTypeCache;
            Integer key$iv = index2;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                IrType typeData = this.loadTypeProto(index2);
                org.jetbrains.kotlin.ir.types.IrType answer$iv = this.deserializeIrTypeData(typeData);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (org.jetbrains.kotlin.ir.types.IrType)object;
        }

        @Override
        @NotNull
        public org.jetbrains.kotlin.ir.util.IdSignature deserializeIdSignature(int index2) {
            IdSignature sigData = this.loadSignatureProto(index2);
            return this.deserializeSignatureData(sigData);
        }

        @Override
        @NotNull
        public String deserializeString(int index2) {
            return this.loadStringProto(index2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrLoop deserializeLoopHeader(int loopIndex, @NotNull Function0<? extends IrLoop> loopBuilder) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter(loopBuilder, "loopBuilder");
            Map<Integer, IrLoop> map = this.fileLoops;
            Integer key$iv = loopIndex;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                IrLoop answer$iv = loopBuilder.invoke();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (IrLoop)object;
        }

        @Override
        @NotNull
        public org.jetbrains.kotlin.ir.expressions.IrExpression deserializeExpressionBody(int index2) {
            org.jetbrains.kotlin.ir.expressions.IrExpression irExpression;
            if (this.getDeserializeBodies()) {
                IrExpression bodyData = this.loadExpressionBodyProto(index2);
                irExpression = this.deserializeExpression(bodyData);
            } else {
                IrErrorTypeImpl errorType = new IrErrorTypeImpl(null, CollectionsKt.emptyList(), Variance.INVARIANT);
                irExpression = new IrErrorExpressionImpl(-1, -1, errorType, "Expression body is not deserialized yet");
            }
            return irExpression;
        }

        @Override
        @NotNull
        public IrElement deserializeStatementBody(int index2) {
            IrElement irElement;
            if (this.getDeserializeBodies()) {
                IrStatement bodyData = this.loadStatementBodyProto(index2);
                irElement = this.deserializeStatement(bodyData);
            } else {
                IrErrorTypeImpl errorType = new IrErrorTypeImpl(null, CollectionsKt.emptyList(), Variance.INVARIANT);
                irElement = this.getIrFactory().createBlockBody(-1, -1, CollectionsKt.listOf(new IrErrorExpressionImpl(-1, -1, errorType, "Statement body is not deserialized yet")));
            }
            return irElement;
        }

        @Override
        public void referenceIrSymbol(@NotNull IrSymbol symbol2, @NotNull org.jetbrains.kotlin.ir.util.IdSignature signature2) {
            Intrinsics.checkNotNullParameter(symbol2, "symbol");
            Intrinsics.checkNotNullParameter(signature2, "signature");
            this.referenceIrSymbolData(symbol2, signature2);
        }

        public final void deserializeFileImplicitDataIfFirstUse() {
            List<IrConstructorCall> list2 = this.annotations;
            if (list2 != null) {
                List<IrConstructorCall> list3 = list2;
                boolean bl = false;
                boolean bl2 = false;
                List<IrConstructorCall> it = list3;
                boolean bl3 = false;
                org.jetbrains.kotlin.ir.declarations.IrFile irFile = this.getFile();
                irFile.setAnnotations(CollectionsKt.plus((Collection)irFile.getAnnotations(), (Iterable)this.deserializeAnnotations(it)));
                this.annotations = null;
            }
        }

        public final void deserializeAllFileReachableTopLevel() {
            this.fileLocalDeserializationState.processPendingDeclarations();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u0006\u0010\u000f\u001a\u00020\rR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00050\nj\b\u0012\u0004\u0012\u00020\u0005`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker$IrDeserializerForFile$FileDeserializationState;", "", "(Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker$IrDeserializerForFile;)V", "deserializedSymbols", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getDeserializedSymbols", "()Ljava/util/Map;", "reachableTopLevels", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "addIdSignature", "", "key", "processPendingDeclarations", "ir.serialization.common"})
        public final class FileDeserializationState {
            @NotNull
            private final LinkedHashSet<org.jetbrains.kotlin.ir.util.IdSignature> reachableTopLevels;
            @NotNull
            private final Map<org.jetbrains.kotlin.ir.util.IdSignature, IrSymbol> deserializedSymbols;

            public FileDeserializationState() {
                Intrinsics.checkNotNullParameter(IrDeserializerForFile.this, "this$0");
                this.reachableTopLevels = new LinkedHashSet();
                boolean bl = false;
                this.deserializedSymbols = new LinkedHashMap();
            }

            @NotNull
            public final Map<org.jetbrains.kotlin.ir.util.IdSignature, IrSymbol> getDeserializedSymbols() {
                return this.deserializedSymbols;
            }

            public final void addIdSignature(@NotNull org.jetbrains.kotlin.ir.util.IdSignature key) {
                Intrinsics.checkNotNullParameter(key, "key");
                this.reachableTopLevels.add(key);
            }

            public final void processPendingDeclarations() {
                while (true) {
                    Collection collection = this.reachableTopLevels;
                    boolean bl = false;
                    if (!(!collection.isEmpty())) break;
                    org.jetbrains.kotlin.ir.util.IdSignature reachableKey = (org.jetbrains.kotlin.ir.util.IdSignature)CollectionsKt.first((Iterable)this.reachableTopLevels);
                    IrSymbol existedSymbol = this.deserializedSymbols.get(reachableKey);
                    if (existedSymbol == null || !existedSymbol.isBound()) {
                        org.jetbrains.kotlin.ir.declarations.IrDeclaration declaration2 = IrDeserializerForFile.this.deserializeDeclaration(reachableKey);
                        IrDeserializerForFile.this.getFile().getDeclarations().add(declaration2);
                    }
                    this.reachableTopLevels.remove(reachableKey);
                }
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[BinarySymbolData.SymbolKind.values().length];
            nArray[BinarySymbolData.SymbolKind.ANONYMOUS_INIT_SYMBOL.ordinal()] = 1;
            nArray[BinarySymbolData.SymbolKind.CLASS_SYMBOL.ordinal()] = 2;
            nArray[BinarySymbolData.SymbolKind.CONSTRUCTOR_SYMBOL.ordinal()] = 3;
            nArray[BinarySymbolData.SymbolKind.TYPE_PARAMETER_SYMBOL.ordinal()] = 4;
            nArray[BinarySymbolData.SymbolKind.ENUM_ENTRY_SYMBOL.ordinal()] = 5;
            nArray[BinarySymbolData.SymbolKind.STANDALONE_FIELD_SYMBOL.ordinal()] = 6;
            nArray[BinarySymbolData.SymbolKind.FIELD_SYMBOL.ordinal()] = 7;
            nArray[BinarySymbolData.SymbolKind.FUNCTION_SYMBOL.ordinal()] = 8;
            nArray[BinarySymbolData.SymbolKind.TYPEALIAS_SYMBOL.ordinal()] = 9;
            nArray[BinarySymbolData.SymbolKind.PROPERTY_SYMBOL.ordinal()] = 10;
            nArray[BinarySymbolData.SymbolKind.VARIABLE_SYMBOL.ordinal()] = 11;
            nArray[BinarySymbolData.SymbolKind.VALUE_PARAMETER_SYMBOL.ordinal()] = 12;
            nArray[BinarySymbolData.SymbolKind.RECEIVER_PARAMETER_SYMBOL.ordinal()] = 13;
            nArray[BinarySymbolData.SymbolKind.LOCAL_DELEGATED_PROPERTY_SYMBOL.ordinal()] = 14;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IrDeserializer.TopLevelSymbolKind.values().length];
            nArray[IrDeserializer.TopLevelSymbolKind.CLASS_SYMBOL.ordinal()] = 1;
            nArray[IrDeserializer.TopLevelSymbolKind.PROPERTY_SYMBOL.ordinal()] = 2;
            nArray[IrDeserializer.TopLevelSymbolKind.FUNCTION_SYMBOL.ordinal()] = 3;
            nArray[IrDeserializer.TopLevelSymbolKind.TYPEALIAS_SYMBOL.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

