/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.SingleAbstractMethodLowering;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\u0014\u0010\u001a\u001a\u00020\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00020\u0006*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0018\u0010\f\u001a\u00020\u0006*\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmSingleAbstractMethodLowering;", "Lorg/jetbrains/kotlin/backend/common/lower/SingleAbstractMethodLowering;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "inInlineFunctionScope", "", "getInInlineFunctionScope", "()Z", "isKotlinFunInterface", "Lorg/jetbrains/kotlin/ir/types/IrType;", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Z", "needEqualsHashCodeMethods", "getNeedEqualsHashCodeMethods", "getSuperTypeForWrapper", "typeOperand", "getWrappedFunctionType", "klass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getWrapperVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "scopes", "", "Lorg/jetbrains/kotlin/backend/common/ScopeWithIr;", "setConstructorSourceRange", "", "Lorg/jetbrains/kotlin/ir/builders/declarations/IrFunctionBuilder;", "createFor", "Lorg/jetbrains/kotlin/ir/IrElement;", "backend.jvm"})
final class JvmSingleAbstractMethodLowering
extends SingleAbstractMethodLowering {
    public JvmSingleAbstractMethodLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        super(context2);
    }

    @Override
    public boolean getInInlineFunctionScope() {
        boolean bl;
        block6: {
            Iterable $this$any$iv = this.getAllScopes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    IrFunction irFunction2;
                    ScopeWithIr scope2 = (ScopeWithIr)element$iv;
                    boolean bl3 = false;
                    IrElement $this$safeAs$iv = scope2.getIrElement();
                    boolean $i$f$safeAs = false;
                    IrElement irElement = $this$safeAs$iv;
                    if (!(irElement instanceof IrFunction)) {
                        irElement = null;
                    }
                    if ((irFunction2 = (IrFunction)irElement) == null) {
                        bl2 = false;
                    } else {
                        boolean bl4;
                        IrFunction irFunction3 = irFunction2;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        IrFunction it = irFunction3;
                        boolean bl7 = false;
                        bl2 = bl4 = it.isInline() || Intrinsics.areEqual(it.getOrigin(), IrDeclarationOrigin.LOCAL_FUNCTION_FOR_LAMBDA.INSTANCE);
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public DescriptorVisibility getWrapperVisibility(@NotNull IrTypeOperatorCall expression2, @NotNull List<? extends ScopeWithIr> scopes) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(scopes, "scopes");
        DescriptorVisibility descriptorVisibility = this.getInInlineFunctionScope() ? DescriptorVisibilities.PUBLIC : JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "if (inInlineFunctionScope) DescriptorVisibilities.PUBLIC else JavaDescriptorVisibilities.PACKAGE_VISIBILITY");
        return descriptorVisibility;
    }

    @Override
    @NotNull
    public IrType getSuperTypeForWrapper(@NotNull IrType typeOperand) {
        Intrinsics.checkNotNullParameter(typeOperand, "typeOperand");
        return IrUtilsKt.rawType(IrUtilsKt.getErasedUpperBound(typeOperand), (JvmBackendContext)this.getContext());
    }

    @Override
    @NotNull
    protected IrType getWrappedFunctionType(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        return IrUtilsKt.rawType(klass, (JvmBackendContext)this.getContext());
    }

    @Override
    protected void setConstructorSourceRange(@NotNull IrFunctionBuilder $this$setConstructorSourceRange, @NotNull IrElement createFor) {
        Intrinsics.checkNotNullParameter($this$setConstructorSourceRange, "<this>");
        Intrinsics.checkNotNullParameter(createFor, "createFor");
        $this$setConstructorSourceRange.setStartOffset(-1);
        $this$setConstructorSourceRange.setEndOffset(-1);
    }

    private final boolean isKotlinFunInterface(IrType $this$isKotlinFunInterface) {
        IrClass irClass2 = IrTypesKt.getClass($this$isKotlinFunInterface);
        return !Intrinsics.areEqual(irClass2 == null ? null : irClass2.getOrigin(), IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE);
    }

    @Override
    public boolean getNeedEqualsHashCodeMethods(@NotNull IrType $this$needEqualsHashCodeMethods) {
        Intrinsics.checkNotNullParameter($this$needEqualsHashCodeMethods, "<this>");
        return this.isKotlinFunInterface($this$needEqualsHashCodeMethods);
    }
}

