/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.builder.FirResolvedQualifierBuilder;
import org.jetbrains.kotlin.fir.references.impl.FirSimpleNamedReference;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.transformers.FirImportResolveTransformerKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PackageOrClass;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\rJ\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/FirQualifiedNameResolver;", "", "components", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "(Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;)V", "qualifierPartsToDrop", "", "qualifierStack", "", "Lorg/jetbrains/kotlin/fir/FirQualifiedNameResolver$NameWithTypeArguments;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "initProcessingQualifiedAccess", "", "callee", "Lorg/jetbrains/kotlin/fir/references/impl/FirSimpleNamedReference;", "typeArguments", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;", "isPotentialQualifierPartPosition", "", "replacedQualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "qualifiedAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccess;", "reset", "tryResolveAsQualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "NameWithTypeArguments", "resolve"})
public final class FirQualifiedNameResolver {
    @NotNull
    private final BodyResolveComponents components;
    @NotNull
    private final FirSession session;
    @NotNull
    private List<NameWithTypeArguments> qualifierStack;
    private int qualifierPartsToDrop;

    public FirQualifiedNameResolver(@NotNull BodyResolveComponents components2) {
        Intrinsics.checkNotNullParameter(components2, "components");
        this.components = components2;
        this.session = this.components.getSession();
        boolean bl = false;
        this.qualifierStack = new ArrayList();
    }

    public final void reset() {
        this.qualifierStack.clear();
        this.qualifierPartsToDrop = 0;
    }

    public final boolean isPotentialQualifierPartPosition() {
        return this.qualifierStack.size() > 1;
    }

    public final void initProcessingQualifiedAccess(@NotNull FirSimpleNamedReference callee, @NotNull List<? extends FirTypeProjection> typeArguments2) {
        Intrinsics.checkNotNullParameter(callee, "callee");
        Intrinsics.checkNotNullParameter(typeArguments2, "typeArguments");
        if (callee.getName().isSpecial()) {
            this.qualifierStack.clear();
        } else {
            this.qualifierStack.add(new NameWithTypeArguments(callee.getName(), CollectionsKt.toList((Iterable)typeArguments2)));
        }
    }

    @Nullable
    public final FirStatement replacedQualifier(@NotNull FirQualifiedAccess qualifiedAccess) {
        FirStatement firStatement;
        Intrinsics.checkNotNullParameter(qualifiedAccess, "qualifiedAccess");
        if (this.qualifierPartsToDrop > 0) {
            Object object = this;
            int n = ((FirQualifiedNameResolver)object).qualifierPartsToDrop;
            ((FirQualifiedNameResolver)object).qualifierPartsToDrop = n + -1;
            object = qualifiedAccess.getExplicitReceiver();
            firStatement = object == null ? (FirStatement)qualifiedAccess : (FirStatement)object;
        } else {
            firStatement = null;
        }
        return firStatement;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FirResolvedQualifier tryResolveAsQualifier(@Nullable FirSourceElement source) {
        Iterable it;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        if (this.qualifierStack.isEmpty()) {
            return null;
        }
        FirSymbolProvider symbolProvider2 = MainSessionComponentsKt.getFirSymbolProvider(this.session);
        List qualifierParts = null;
        Iterable $this$map$iv = CollectionsKt.asReversedMutable(this.qualifierStack);
        boolean $i$f$map2 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            NameWithTypeArguments nameWithTypeArguments = (NameWithTypeArguments)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            String string2 = ((NameWithTypeArguments)((Object)it)).getName().asString();
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        qualifierParts = collection;
        PackageOrClass resolved = null;
        do {
            Object $i$f$map2 = FqName.fromSegments(qualifierParts);
            Intrinsics.checkNotNullExpressionValue($i$f$map2, "fromSegments(qualifierParts)");
            resolved = FirImportResolveTransformerKt.resolveToPackageOrClass(symbolProvider2, (FqName)$i$f$map2);
            if (resolved == null) {
                qualifierParts = CollectionsKt.dropLast(qualifierParts, 1);
            }
            if (resolved != null) break;
            $i$f$map2 = qualifierParts;
            boolean bl = false;
        } while (!$i$f$map2.isEmpty());
        if (resolved != null) {
            void $this$resultType$iv;
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            this.qualifierPartsToDrop = qualifierParts.size() - 1;
            boolean $i$f$buildResolvedQualifier = false;
            boolean bl = false;
            FirResolvedQualifierBuilder firResolvedQualifierBuilder = new FirResolvedQualifierBuilder();
            boolean bl2 = false;
            $i$f$mapTo = false;
            FirResolvedQualifierBuilder $this$tryResolveAsQualifier_u24lambda_u2d2 = firResolvedQualifierBuilder;
            boolean $i$a$-buildResolvedQualifier-FirQualifiedNameResolver$tryResolveAsQualifier$22 = false;
            $this$tryResolveAsQualifier_u24lambda_u2d2.setSource(source);
            $this$tryResolveAsQualifier_u24lambda_u2d2.setPackageFqName(resolved.getPackageFqName());
            $this$tryResolveAsQualifier_u24lambda_u2d2.setRelativeClassFqName(resolved.getRelativeClassFqName());
            $this$tryResolveAsQualifier_u24lambda_u2d2.setSymbol(resolved.getClassSymbol());
            it = CollectionsKt.take((Iterable)this.qualifierStack, qualifierParts.size());
            List<FirTypeProjection> bl3 = $this$tryResolveAsQualifier_u24lambda_u2d2.getTypeArguments();
            boolean $i$f$flatMap = false;
            void var14_30 = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                NameWithTypeArguments it2 = (NameWithTypeArguments)element$iv$iv;
                boolean bl4 = false;
                Iterable list$iv$iv = it2.getTypeArguments();
                CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
            }
            List list2 = (List)destination$iv$iv2;
            bl3.addAll(list2);
            FirResolvedQualifier firResolvedQualifier = firResolvedQualifierBuilder.build();
            boolean bl5 = false;
            bl2 = false;
            FirResolvedQualifier $this$tryResolveAsQualifier_u24lambda_u2d3 = firResolvedQualifier;
            boolean bl6 = false;
            FirExpression $i$a$-buildResolvedQualifier-FirQualifiedNameResolver$tryResolveAsQualifier$22 = $this$tryResolveAsQualifier_u24lambda_u2d3;
            FirTypeRef type$iv = ResolveUtilsKt.typeForQualifier(this.components, $this$tryResolveAsQualifier_u24lambda_u2d3);
            boolean $i$f$setResultType = false;
            $this$resultType$iv.replaceTypeRef(type$iv);
            return firResolvedQualifier;
        }
        return null;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/FirQualifiedNameResolver$NameWithTypeArguments;", "", "name", "Lorg/jetbrains/kotlin/name/Name;", "typeArguments", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;", "(Lorg/jetbrains/kotlin/name/Name;Ljava/util/List;)V", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "getTypeArguments", "()Ljava/util/List;", "resolve"})
    private static final class NameWithTypeArguments {
        @NotNull
        private final Name name;
        @NotNull
        private final List<FirTypeProjection> typeArguments;

        public NameWithTypeArguments(@NotNull Name name, @NotNull List<? extends FirTypeProjection> typeArguments2) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(typeArguments2, "typeArguments");
            this.name = name;
            this.typeArguments = typeArguments2;
        }

        @NotNull
        public final Name getName() {
            return this.name;
        }

        @NotNull
        public final List<FirTypeProjection> getTypeArguments() {
            return this.typeArguments;
        }
    }
}

