/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.java.deserialization;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.caches.FirCache;
import org.jetbrains.kotlin.fir.caches.FirCachesFactory;
import org.jetbrains.kotlin.fir.caches.FirCachesFactoryKt;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.deserialization.ClassDeserializationKt;
import org.jetbrains.kotlin.fir.deserialization.FirConstDeserializer;
import org.jetbrains.kotlin.fir.deserialization.FirDeserializationContext;
import org.jetbrains.kotlin.fir.deserialization.FirMemberDeserializer;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.java.JavaSymbolProvider;
import org.jetbrains.kotlin.fir.java.deserialization.AnnotationsLoader;
import org.jetbrains.kotlin.fir.java.deserialization.JvmBinaryAnnotationDeserializer;
import org.jetbrains.kotlin.fir.java.deserialization.KnownNameInPackageCache;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderInternals;
import org.jetbrains.kotlin.fir.scopes.KotlinScopeProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.load.java.JavaClassFinder;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinderKt;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.PackagePartProvider;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolver;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.deserialization.IncompatibleVersionErrorData;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001TB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010-\u001a\u00020\u001bH\u0002J,\u0010.\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0006\u0012\u0004\u0018\u0001000/2\u0006\u00101\u001a\u00020\u00152\n\b\u0002\u00102\u001a\u0004\u0018\u00010\u0017H\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\u00162\u0006\u00101\u001a\u00020\u0015H\u0002J\u0012\u00104\u001a\u0004\u0018\u00010\"2\u0006\u00101\u001a\u00020\u0015H\u0002J\u001e\u00105\u001a\u0004\u0018\u00010\u00162\u0006\u00101\u001a\u00020\u00152\n\b\u0002\u00102\u001a\u0004\u0018\u00010\u0017H\u0002J\u0016\u00106\u001a\b\u0012\u0002\b\u0003\u0018\u0001072\u0006\u00101\u001a\u00020\u0015H\u0016J\u0012\u00108\u001a\u0004\u0018\u00010\u001b2\u0006\u00109\u001a\u00020\u001bH\u0016J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001d0;2\u0006\u0010-\u001a\u00020\u001bH\u0002J*\u0010<\u001a\u00020=2\u0010\u0010>\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030@0?2\u0006\u0010-\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020BH\u0017J&\u0010C\u001a\u00020=2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020D0?2\u0006\u0010-\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020BH\u0017J&\u0010E\u001a\u00020=2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020F0?2\u0006\u0010-\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020BH\u0017J\u0012\u0010G\u001a\u0004\u0018\u00010\"2\u0006\u00101\u001a\u00020\u0015H\u0002J\u001e\u0010H\u001a\b\u0012\u0004\u0012\u00020D0\u001c2\u0006\u0010I\u001a\u00020\u001d2\u0006\u0010A\u001a\u00020BH\u0002J\u001e\u0010J\u001a\b\u0012\u0004\u0012\u00020F0\u001c2\u0006\u0010I\u001a\u00020\u001d2\u0006\u0010A\u001a\u00020BH\u0002J \u0010K\u001a\u00020=2\u0006\u0010L\u001a\u00020&2\b\u0010M\u001a\u0004\u0018\u00010N2\u0006\u0010O\u001a\u00020\u0016J\u0016\u0010P\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010-\u001a\u00020\u001bH\u0002J\u001a\u0010Q\u001a\u0010\u0012\u0004\u0012\u00020R\u0012\u0004\u0012\u00020S\u0018\u00010/*\u00020&H\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u0018\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u001a\u001a\u001c\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R$\u0010!\u001a\u0018\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\"\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010#\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$*\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0018\u0010)\u001a\u00020**\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010+\u00a8\u0006U"}, d2={"Lorg/jetbrains/kotlin/fir/java/deserialization/KotlinDeserializedJvmSymbolsProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "project", "Lcom/intellij/openapi/project/Project;", "packagePartProvider", "Lorg/jetbrains/kotlin/load/kotlin/PackagePartProvider;", "javaSymbolProvider", "Lorg/jetbrains/kotlin/fir/java/JavaSymbolProvider;", "kotlinClassFinder", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder;", "javaClassFinder", "Lorg/jetbrains/kotlin/load/java/JavaClassFinder;", "kotlinScopeProvider", "Lorg/jetbrains/kotlin/fir/scopes/KotlinScopeProvider;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/load/kotlin/PackagePartProvider;Lorg/jetbrains/kotlin/fir/java/JavaSymbolProvider;Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder;Lorg/jetbrains/kotlin/load/java/JavaClassFinder;Lorg/jetbrains/kotlin/fir/scopes/KotlinScopeProvider;)V", "annotationsLoader", "Lorg/jetbrains/kotlin/fir/java/deserialization/AnnotationsLoader;", "classCache", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationContext;", "knownNameInPackageCache", "Lorg/jetbrains/kotlin/fir/java/deserialization/KnownNameInPackageCache;", "packagePartsCache", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/fir/java/deserialization/KotlinDeserializedJvmSymbolsProvider$PackagePartsCacheData;", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "typeAliasCache", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeAliasSymbol;", "incompatibility", "Lorg/jetbrains/kotlin/serialization/deserialization/IncompatibleVersionErrorData;", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "getIncompatibility", "(Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;)Lorg/jetbrains/kotlin/serialization/deserialization/IncompatibleVersionErrorData;", "isPreReleaseInvisible", "", "(Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;)Z", "computePackagePartsInfos", "packageFqName", "findAndDeserializeClass", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder$Result$KotlinClass;", "classId", "parentContext", "findAndDeserializeClassViaParent", "findAndDeserializeTypeAlias", "getClass", "getClassLikeSymbolByFqName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getPackage", "fqName", "getPackageParts", "", "getTopLevelCallableSymbolsTo", "", "destination", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getTopLevelFunctionSymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getTopLevelPropertySymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getTypeAlias", "loadFunctionsByName", "part", "loadPropertiesByName", "postCompute", "kotlinJvmBinaryClass", "byteContent", "", "symbol", "tryComputePackagePartInfos", "readClassDataFrom", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmNameResolver;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "PackagePartsCacheData", "java"})
public final class KotlinDeserializedJvmSymbolsProvider
extends FirSymbolProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final PackagePartProvider packagePartProvider;
    @NotNull
    private final JavaSymbolProvider javaSymbolProvider;
    @NotNull
    private final KotlinClassFinder kotlinClassFinder;
    @NotNull
    private final JavaClassFinder javaClassFinder;
    @NotNull
    private final KotlinScopeProvider kotlinScopeProvider;
    @NotNull
    private final AnnotationsLoader annotationsLoader;
    @NotNull
    private final FirCache typeAliasCache;
    @NotNull
    private final FirCache packagePartsCache;
    @NotNull
    private final FirCache<ClassId, FirRegularClassSymbol, FirDeserializationContext> classCache;
    @NotNull
    private final KnownNameInPackageCache knownNameInPackageCache;

    public KotlinDeserializedJvmSymbolsProvider(@NotNull FirSession session2, @NotNull Project project, @NotNull PackagePartProvider packagePartProvider, @NotNull JavaSymbolProvider javaSymbolProvider, @NotNull KotlinClassFinder kotlinClassFinder, @NotNull JavaClassFinder javaClassFinder, @NotNull KotlinScopeProvider kotlinScopeProvider2) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(packagePartProvider, "packagePartProvider");
        Intrinsics.checkNotNullParameter(javaSymbolProvider, "javaSymbolProvider");
        Intrinsics.checkNotNullParameter(kotlinClassFinder, "kotlinClassFinder");
        Intrinsics.checkNotNullParameter(javaClassFinder, "javaClassFinder");
        Intrinsics.checkNotNullParameter(kotlinScopeProvider2, "kotlinScopeProvider");
        super(session2);
        this.project = project;
        this.packagePartProvider = packagePartProvider;
        this.javaSymbolProvider = javaSymbolProvider;
        this.kotlinClassFinder = kotlinClassFinder;
        this.javaClassFinder = javaClassFinder;
        this.kotlinScopeProvider = kotlinScopeProvider2;
        this.annotationsLoader = new AnnotationsLoader(session2);
        FirCachesFactory $this$createCache$iv = FirCachesFactoryKt.getFirCachesFactory(session2);
        boolean $i$f$createCache = false;
        this.typeAliasCache = $this$createCache$iv.createCache(new Function2(this){
            final /* synthetic */ KotlinDeserializedJvmSymbolsProvider $receiver$inlined;
            {
                this.$receiver$inlined = kotlinDeserializedJvmSymbolsProvider;
                super(2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object invoke(@NotNull Object key, @Nullable Void $noName_1) {
                Intrinsics.checkNotNullParameter(key, "key");
                ClassId p0 = (ClassId)key;
                boolean bl = false;
                return KotlinDeserializedJvmSymbolsProvider.access$findAndDeserializeTypeAlias(this.$receiver$inlined, p0);
            }
        });
        $this$createCache$iv = FirCachesFactoryKt.getFirCachesFactory(session2);
        $i$f$createCache = false;
        this.packagePartsCache = $this$createCache$iv.createCache(new Function2(this){
            final /* synthetic */ KotlinDeserializedJvmSymbolsProvider $receiver$inlined;
            {
                this.$receiver$inlined = kotlinDeserializedJvmSymbolsProvider;
                super(2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object invoke(@NotNull Object key, @Nullable Void $noName_1) {
                Intrinsics.checkNotNullParameter(key, "key");
                FqName p0 = (FqName)key;
                boolean bl = false;
                return KotlinDeserializedJvmSymbolsProvider.access$tryComputePackagePartInfos(this.$receiver$inlined, p0);
            }
        });
        this.classCache = FirCachesFactoryKt.getFirCachesFactory(session2).createCacheWithPostCompute((Function2)new Function2<ClassId, FirDeserializationContext, Pair<? extends FirRegularClassSymbol, ? extends KotlinClassFinder.Result.KotlinClass>>(this){
            final /* synthetic */ KotlinDeserializedJvmSymbolsProvider this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Pair<FirRegularClassSymbol, KotlinClassFinder.Result.KotlinClass> invoke(@NotNull ClassId classId, @Nullable FirDeserializationContext context2) {
                Intrinsics.checkNotNullParameter(classId, "classId");
                return KotlinDeserializedJvmSymbolsProvider.access$findAndDeserializeClass(this.this$0, classId, context2);
            }
        }, (Function3)new Function3<ClassId, FirRegularClassSymbol, KotlinClassFinder.Result.KotlinClass, Unit>(this){
            final /* synthetic */ KotlinDeserializedJvmSymbolsProvider this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(@NotNull ClassId $noName_0, @Nullable FirRegularClassSymbol symbol2, @Nullable KotlinClassFinder.Result.KotlinClass result2) {
                Intrinsics.checkNotNullParameter($noName_0, "$noName_0");
                if (result2 != null && symbol2 != null) {
                    this.this$0.postCompute(result2.getKotlinJvmBinaryClass(), result2.getByteContent(), symbol2);
                }
            }
        });
        this.knownNameInPackageCache = new KnownNameInPackageCache(session2, this.javaClassFinder);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PackagePartsCacheData> computePackagePartsInfos(FqName packageFqName) {
        void $this$mapNotNullTo$iv$iv;
        String string2 = packageFqName.asString();
        Intrinsics.checkNotNullExpressionValue(string2, "packageFqName.asString()");
        Iterable $this$mapNotNull$iv = this.packagePartProvider.findPackageParts(string2);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PackagePartsCacheData packagePartsCacheData;
            block10: {
                String[] stringArray;
                Object object;
                KotlinClassHeader header;
                KotlinJvmBinaryClass facadeBinaryClass;
                byte[] byteContent;
                KotlinJvmBinaryClass kotlinJvmBinaryClass2;
                block14: {
                    String[] it2;
                    block12: {
                        block13: {
                            KotlinJvmBinaryClass kotlinJvmBinaryClass3;
                            FqName facadeFqName;
                            FqName fqName2;
                            String[] facadeName;
                            boolean bl;
                            String[] stringArray2;
                            Object object2;
                            KotlinClassFinder.Result.KotlinClass kotlinClass;
                            Object object3;
                            block11: {
                                ClassId classId;
                                block9: {
                                    Object element$iv$iv$iv;
                                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                                    boolean bl2 = false;
                                    String partName = (String)element$iv$iv;
                                    boolean bl3 = false;
                                    object3 = ClassId.topLevel(JvmClassName.byInternalName(partName).getFqNameForTopLevelClassMaybeWithDollars());
                                    Intrinsics.checkNotNullExpressionValue(object3, "topLevel(JvmClassName.byInternalName(partName).fqNameForTopLevelClassMaybeWithDollars)");
                                    classId = object3;
                                    if (!this.knownNameInPackageCache.hasNoTopLevelClassOf(classId)) break block9;
                                    packagePartsCacheData = null;
                                    break block10;
                                }
                                KotlinClassFinder.Result result2 = this.kotlinClassFinder.findKotlinClassOrContent(classId);
                                KotlinClassFinder.Result.KotlinClass kotlinClass2 = kotlinClass = result2 instanceof KotlinClassFinder.Result.KotlinClass ? (KotlinClassFinder.Result.KotlinClass)result2 : null;
                                if (kotlinClass != null) break block11;
                                packagePartsCacheData = null;
                                break block10;
                            }
                            object3 = kotlinClass;
                            kotlinJvmBinaryClass2 = ((KotlinClassFinder.Result.KotlinClass)object3).component1();
                            byteContent = ((KotlinClassFinder.Result.KotlinClass)object3).component2();
                            String[] stringArray3 = kotlinJvmBinaryClass2.getClassHeader().getMultifileClassName();
                            if (stringArray3 == null) {
                                object2 = null;
                            } else {
                                stringArray2 = stringArray3;
                                boolean bl4 = false;
                                bl = false;
                                it2 = stringArray2;
                                boolean bl5 = false;
                                CharSequence charSequence = (CharSequence)it2;
                                boolean bl6 = false;
                                object2 = charSequence.length() > 0 ? stringArray2 : null;
                            }
                            stringArray2 = facadeName = object2;
                            if (stringArray2 == null) {
                                fqName2 = null;
                            } else {
                                String[] stringArray4 = stringArray2;
                                bl = false;
                                boolean it2 = false;
                                String[] it3 = stringArray4;
                                boolean bl7 = false;
                                fqName2 = JvmClassName.byInternalName((String)it3).getFqNameForTopLevelClassMaybeWithDollars();
                            }
                            FqName fqName3 = facadeFqName = fqName2;
                            if (fqName3 == null) {
                                kotlinJvmBinaryClass3 = null;
                            } else {
                                FqName fqName4 = fqName3;
                                boolean it2 = false;
                                boolean bl8 = false;
                                FqName it4 = fqName4;
                                boolean bl9 = false;
                                ClassId classId = ClassId.topLevel(it4);
                                Intrinsics.checkNotNullExpressionValue(classId, "topLevel(it)");
                                kotlinJvmBinaryClass3 = KotlinClassFinderKt.findKotlinClass(this.kotlinClassFinder, classId);
                            }
                            facadeBinaryClass = kotlinJvmBinaryClass3;
                            header = kotlinJvmBinaryClass2.getClassHeader();
                            it2 = header.getData();
                            if (it2 != null) break block12;
                            object = header.getIncompatibleData();
                            if (object != null) break block13;
                            packagePartsCacheData = null;
                            break block10;
                        }
                        stringArray = object;
                        break block14;
                    }
                    stringArray = it2;
                }
                String[] data = stringArray;
                object = header.getStrings();
                if (object == null) {
                    packagePartsCacheData = null;
                } else {
                    KotlinJvmBinaryClass kotlinJvmBinaryClass4;
                    String[] strings2 = object;
                    object = JvmProtoBufUtil.readPackageDataFrom(data, strings2);
                    JvmNameResolver nameResolver2 = (JvmNameResolver)((Pair)object).component1();
                    ProtoBuf.Package packageProto = (ProtoBuf.Package)((Pair)object).component2();
                    JvmPackagePartSource source = new JvmPackagePartSource(kotlinJvmBinaryClass2, packageProto, nameResolver2, this.getIncompatibility(kotlinJvmBinaryClass2), this.isPreReleaseInvisible(kotlinJvmBinaryClass2), null, 32, null);
                    packagePartsCacheData = new PackagePartsCacheData(packageProto, FirDeserializationContext.Companion.createForPackage(packageFqName, packageProto, nameResolver2, this.getSession(), new JvmBinaryAnnotationDeserializer(this.getSession(), kotlinJvmBinaryClass2, byteContent), new FirConstDeserializer(this.getSession(), (kotlinJvmBinaryClass4 = facadeBinaryClass) == null ? kotlinJvmBinaryClass2 : kotlinJvmBinaryClass4), source));
                }
            }
            if (packagePartsCacheData == null) continue;
            PackagePartsCacheData packagePartsCacheData2 = packagePartsCacheData;
            boolean bl = false;
            boolean bl10 = false;
            PackagePartsCacheData it$iv$iv = packagePartsCacheData2;
            boolean bl11 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final IncompatibleVersionErrorData<JvmMetadataVersion> getIncompatibility(KotlinJvmBinaryClass $this$incompatibility) {
        if ($this$incompatibility.getClassHeader().getMetadataVersion().isCompatible()) {
            return null;
        }
        return new IncompatibleVersionErrorData<JvmMetadataVersion>($this$incompatibility.getClassHeader().getMetadataVersion(), JvmMetadataVersion.INSTANCE, $this$incompatibility.getLocation(), $this$incompatibility.getClassId());
    }

    private final boolean isPreReleaseInvisible(KotlinJvmBinaryClass $this$isPreReleaseInvisible) {
        return $this$isPreReleaseInvisible.getClassHeader().isPreRelease();
    }

    @Override
    @Nullable
    public FirClassLikeSymbol<?> getClassLikeSymbolByFqName(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        FirRegularClassSymbol firRegularClassSymbol = KotlinDeserializedJvmSymbolsProvider.getClass$default(this, classId, null, 2, null);
        return firRegularClassSymbol == null ? (FirClassLikeSymbol)this.getTypeAlias(classId) : (FirClassLikeSymbol)firRegularClassSymbol;
    }

    private final FirTypeAliasSymbol getTypeAlias(ClassId classId) {
        FqName fqName2 = classId.getRelativeClassName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "classId.relativeClassName");
        if (!FqNamesUtilKt.isOneSegmentFQN(fqName2)) {
            return null;
        }
        FirCache $this$getValue$iv = this.typeAliasCache;
        boolean $i$f$getValue = false;
        return (FirTypeAliasSymbol)$this$getValue$iv.getValue(classId, null);
    }

    /*
     * WARNING - void declaration
     */
    private final FirTypeAliasSymbol findAndDeserializeTypeAlias(ClassId classId) {
        FirTypeAliasSymbol firTypeAliasSymbol;
        block4: {
            FqName fqName2 = classId.getPackageFqName();
            Intrinsics.checkNotNullExpressionValue(fqName2, "classId.packageFqName");
            Iterable $this$firstNotNullResult$iv = this.getPackageParts(fqName2);
            boolean $i$f$firstNotNullResult = false;
            for (Object element$iv : $this$firstNotNullResult$iv) {
                FirTypeAliasSymbol result$iv;
                FirTypeAliasSymbol firTypeAliasSymbol2;
                PackagePartsCacheData part = (PackagePartsCacheData)element$iv;
                boolean bl = false;
                List<Integer> ids = part.getTypeAliasNameIndex().get(classId.getShortClassName());
                if (ids == null || ids.isEmpty()) {
                    firTypeAliasSymbol2 = null;
                } else {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = ids;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        int n = ((Number)item$iv$iv).intValue();
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        ProtoBuf.TypeAlias typeAlias = part.getProto().getTypeAlias((int)it);
                        collection.add(typeAlias);
                    }
                    ProtoBuf.TypeAlias aliasProto = (ProtoBuf.TypeAlias)CollectionsKt.single((List)destination$iv$iv);
                    FirMemberDeserializer firMemberDeserializer = part.getContext().getMemberDeserializer();
                    Intrinsics.checkNotNullExpressionValue(aliasProto, "aliasProto");
                    firTypeAliasSymbol2 = firMemberDeserializer.loadTypeAlias(aliasProto).getSymbol();
                }
                if ((result$iv = firTypeAliasSymbol2) == null) continue;
                firTypeAliasSymbol = result$iv;
                break block4;
            }
            firTypeAliasSymbol = null;
        }
        return firTypeAliasSymbol;
    }

    private final Pair<JvmNameResolver, ProtoBuf.Class> readClassDataFrom(KotlinJvmBinaryClass $this$readClassDataFrom) {
        String[] stringArray = $this$readClassDataFrom.getClassHeader().getData();
        if (stringArray == null) {
            return null;
        }
        String[] data = stringArray;
        String[] stringArray2 = $this$readClassDataFrom.getClassHeader().getStrings();
        if (stringArray2 == null) {
            return null;
        }
        String[] strings2 = stringArray2;
        return JvmProtoBufUtil.readClassDataFrom(data, strings2);
    }

    private final FirRegularClassSymbol findAndDeserializeClassViaParent(ClassId classId) {
        ClassId classId2 = classId.getOuterClassId();
        if (classId2 == null) {
            return null;
        }
        Object object = classId2;
        Object outerClassId = object;
        if ((object = KotlinDeserializedJvmSymbolsProvider.getClass$default(this, (ClassId)outerClassId, null, 2, null)) == null) {
            return null;
        }
        return this.classCache.getValueIfComputed(classId);
    }

    private final FirRegularClassSymbol getClass(ClassId classId, FirDeserializationContext parentContext) {
        return this.classCache.getValue(classId, parentContext);
    }

    static /* synthetic */ FirRegularClassSymbol getClass$default(KotlinDeserializedJvmSymbolsProvider kotlinDeserializedJvmSymbolsProvider, ClassId classId, FirDeserializationContext firDeserializationContext, int n, Object object) {
        if ((n & 2) != 0) {
            firDeserializationContext = null;
        }
        return kotlinDeserializedJvmSymbolsProvider.getClass(classId, firDeserializationContext);
    }

    private final Pair<FirRegularClassSymbol, KotlinClassFinder.Result.KotlinClass> findAndDeserializeClass(ClassId classId, FirDeserializationContext parentContext) {
        KotlinClassFinder.Result result2;
        if (this.knownNameInPackageCache.hasNoTopLevelClassOf(classId)) {
            return TuplesKt.to(null, null);
        }
        try {
            result2 = this.kotlinClassFinder.findKotlinClassOrContent(classId);
        }
        catch (ProcessCanceledException e) {
            return TuplesKt.to(null, null);
        }
        KotlinClassFinder.Result result3 = result2;
        Object object = result3;
        if (!(object instanceof KotlinClassFinder.Result.KotlinClass)) {
            if (object instanceof KotlinClassFinder.Result.ClassFileContent) {
                return TuplesKt.to(this.javaSymbolProvider.getFirJavaClass(classId, (KotlinClassFinder.Result.ClassFileContent)result3), null);
            }
            if (object == null) {
                return TuplesKt.to(this.findAndDeserializeClassViaParent(classId), null);
            }
            throw new NoWhenBranchMatchedException();
        }
        KotlinClassFinder.Result.KotlinClass kotlinClass = (KotlinClassFinder.Result.KotlinClass)result3;
        if (kotlinClass.getKotlinJvmBinaryClass().getClassHeader().getKind() != KotlinClassHeader.Kind.CLASS) {
            return TuplesKt.to(null, null);
        }
        Pair<JvmNameResolver, ProtoBuf.Class> pair = this.readClassDataFrom(kotlinClass.getKotlinJvmBinaryClass());
        if (pair == null) {
            return TuplesKt.to(null, null);
        }
        object = pair;
        JvmNameResolver nameResolver2 = (JvmNameResolver)((Pair)object).component1();
        ProtoBuf.Class classProto = (ProtoBuf.Class)((Pair)object).component2();
        if (parentContext == null && Flags.CLASS_KIND.get(classProto.getFlags()) == ProtoBuf.Class.Kind.COMPANION_OBJECT) {
            return TuplesKt.to(this.findAndDeserializeClassViaParent(classId), null);
        }
        FirRegularClassSymbol symbol2 = new FirRegularClassSymbol(classId);
        ClassDeserializationKt.deserializeClassToSymbol(classId, classProto, symbol2, nameResolver2, this.getSession(), new JvmBinaryAnnotationDeserializer(this.getSession(), kotlinClass.getKotlinJvmBinaryClass(), kotlinClass.getByteContent()), this.kotlinScopeProvider, parentContext, new KotlinJvmBinarySourceElement(kotlinClass.getKotlinJvmBinaryClass(), null, false, null, 14, null), (Function2<? super ClassId, ? super FirDeserializationContext, FirRegularClassSymbol>)new Function2<ClassId, FirDeserializationContext, FirRegularClassSymbol>(this){

            @Nullable
            public final FirRegularClassSymbol invoke(@NotNull ClassId p0, @Nullable FirDeserializationContext p1) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return KotlinDeserializedJvmSymbolsProvider.access$getClass((KotlinDeserializedJvmSymbolsProvider)this.receiver, p0, p1);
            }

            @NotNull
            public final String getSignature() {
                return "getClass(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationContext;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;";
            }

            @NotNull
            public final String getName() {
                return "getClass";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(KotlinDeserializedJvmSymbolsProvider.class);
            }
        });
        return TuplesKt.to(symbol2, kotlinClass);
    }

    public final void postCompute(@NotNull KotlinJvmBinaryClass kotlinJvmBinaryClass2, @Nullable byte[] byteContent, @NotNull FirRegularClassSymbol symbol2) {
        Intrinsics.checkNotNullParameter(kotlinJvmBinaryClass2, "kotlinJvmBinaryClass");
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        boolean bl = false;
        List annotations2 = new ArrayList();
        kotlinJvmBinaryClass2.loadClassAnnotations(new KotlinJvmBinaryClass.AnnotationVisitor(this, annotations2){
            final /* synthetic */ KotlinDeserializedJvmSymbolsProvider this$0;
            final /* synthetic */ List<FirAnnotationCall> $annotations;
            {
                this.this$0 = $receiver;
                this.$annotations = $annotations;
            }

            @Nullable
            public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull ClassId classId, @NotNull SourceElement source) {
                Intrinsics.checkNotNullParameter(classId, "classId");
                Intrinsics.checkNotNullParameter(source, "source");
                return KotlinDeserializedJvmSymbolsProvider.access$getAnnotationsLoader$p(this.this$0).loadAnnotationIfNotSpecial$java(classId, this.$annotations);
            }

            public void visitEnd() {
            }
        }, byteContent);
        Collection collection = TypeIntrinsics.asMutableList(((FirRegularClass)symbol2.getFir()).getAnnotations());
        boolean bl2 = false;
        CollectionsKt.addAll(collection, annotations2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirNamedFunctionSymbol> loadFunctionsByName(PackagePartsCacheData part, Name name) {
        void $this$mapTo$iv$iv;
        List<Integer> list2 = part.getTopLevelFunctionNameIndex().get(name);
        if (list2 == null) {
            return CollectionsKt.emptyList();
        }
        List<Integer> functionIds = list2;
        Iterable $this$map$iv = functionIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FirMemberDeserializer firMemberDeserializer = part.getContext().getMemberDeserializer();
            ProtoBuf.Function function2 = part.getProto().getFunction((int)it);
            Intrinsics.checkNotNullExpressionValue(function2, "part.proto.getFunction(it)");
            FirNamedFunctionSymbol firNamedFunctionSymbol = FirMemberDeserializer.loadFunction$default(firMemberDeserializer, function2, null, 2, null).getSymbol();
            collection.add(firNamedFunctionSymbol);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirPropertySymbol> loadPropertiesByName(PackagePartsCacheData part, Name name) {
        void $this$mapTo$iv$iv;
        List<Integer> list2 = part.getTopLevelPropertyNameIndex().get(name);
        if (list2 == null) {
            return CollectionsKt.emptyList();
        }
        List<Integer> propertyIds = list2;
        Iterable $this$map$iv = propertyIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FirMemberDeserializer firMemberDeserializer = part.getContext().getMemberDeserializer();
            ProtoBuf.Property property2 = part.getProto().getProperty((int)it);
            Intrinsics.checkNotNullExpressionValue(property2, "part.proto.getProperty(it)");
            FirPropertySymbol firPropertySymbol = FirMemberDeserializer.loadProperty$default(firMemberDeserializer, property2, null, 2, null).getSymbol();
            collection.add(firPropertySymbol);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelCallableSymbolsTo(@NotNull List<FirCallableSymbol<?>> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name, "name");
        Iterable $this$flatMapTo$iv = this.getPackageParts(packageFqName);
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            PackagePartsCacheData part = (PackagePartsCacheData)element$iv;
            boolean bl = false;
            Iterable list$iv = CollectionsKt.plus((Collection)this.loadFunctionsByName(part, name), (Iterable)this.loadPropertiesByName(part, name));
            CollectionsKt.addAll((Collection)destination, list$iv);
        }
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelFunctionSymbolsTo(@NotNull List<FirNamedFunctionSymbol> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name, "name");
        Iterable $this$flatMapTo$iv = this.getPackageParts(packageFqName);
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            PackagePartsCacheData part = (PackagePartsCacheData)element$iv;
            boolean bl = false;
            Iterable list$iv = this.loadFunctionsByName(part, name);
            CollectionsKt.addAll((Collection)destination, list$iv);
        }
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelPropertySymbolsTo(@NotNull List<FirPropertySymbol> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name, "name");
        Iterable $this$flatMapTo$iv = this.getPackageParts(packageFqName);
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            PackagePartsCacheData part = (PackagePartsCacheData)element$iv;
            boolean bl = false;
            Iterable list$iv = this.loadPropertiesByName(part, name);
            CollectionsKt.addAll((Collection)destination, list$iv);
        }
    }

    private final Collection<PackagePartsCacheData> getPackageParts(FqName packageFqName) {
        FirCache $this$getValue$iv = this.packagePartsCache;
        boolean $i$f$getValue = false;
        return (Collection)$this$getValue$iv.getValue(packageFqName, null);
    }

    private final List<PackagePartsCacheData> tryComputePackagePartInfos(FqName packageFqName) {
        List<PackagePartsCacheData> list2;
        try {
            list2 = this.computePackagePartsInfos(packageFqName);
        }
        catch (ProcessCanceledException e) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Override
    @Nullable
    public FqName getPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return null;
    }

    public static final /* synthetic */ FirRegularClassSymbol access$getClass(KotlinDeserializedJvmSymbolsProvider $this, ClassId classId, FirDeserializationContext parentContext) {
        return $this.getClass(classId, parentContext);
    }

    public static final /* synthetic */ AnnotationsLoader access$getAnnotationsLoader$p(KotlinDeserializedJvmSymbolsProvider $this) {
        return $this.annotationsLoader;
    }

    public static final /* synthetic */ FirTypeAliasSymbol access$findAndDeserializeTypeAlias(KotlinDeserializedJvmSymbolsProvider $this, ClassId classId) {
        return $this.findAndDeserializeTypeAlias(classId);
    }

    public static final /* synthetic */ List access$tryComputePackagePartInfos(KotlinDeserializedJvmSymbolsProvider $this, FqName packageFqName) {
        return $this.tryComputePackagePartInfos(packageFqName);
    }

    public static final /* synthetic */ Pair access$findAndDeserializeClass(KotlinDeserializedJvmSymbolsProvider $this, ClassId classId, FirDeserializationContext parentContext) {
        return $this.findAndDeserializeClass(classId, parentContext);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR-\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R-\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0013\u001a\u0004\b\u0015\u0010\u0011R-\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0013\u001a\u0004\b\u0018\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/java/deserialization/KotlinDeserializedJvmSymbolsProvider$PackagePartsCacheData;", "", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Package;", "context", "Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationContext;", "(Lorg/jetbrains/kotlin/metadata/ProtoBuf$Package;Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationContext;)V", "getContext", "()Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationContext;", "getProto", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$Package;", "topLevelFunctionNameIndex", "", "Lorg/jetbrains/kotlin/name/Name;", "", "", "getTopLevelFunctionNameIndex", "()Ljava/util/Map;", "topLevelFunctionNameIndex$delegate", "Lkotlin/Lazy;", "topLevelPropertyNameIndex", "getTopLevelPropertyNameIndex", "topLevelPropertyNameIndex$delegate", "typeAliasNameIndex", "getTypeAliasNameIndex", "typeAliasNameIndex$delegate", "java"})
    private static final class PackagePartsCacheData {
        @NotNull
        private final ProtoBuf.Package proto;
        @NotNull
        private final FirDeserializationContext context;
        @NotNull
        private final Lazy topLevelFunctionNameIndex$delegate;
        @NotNull
        private final Lazy topLevelPropertyNameIndex$delegate;
        @NotNull
        private final Lazy typeAliasNameIndex$delegate;

        public PackagePartsCacheData(@NotNull ProtoBuf.Package proto, @NotNull FirDeserializationContext context2) {
            Intrinsics.checkNotNullParameter(proto, "proto");
            Intrinsics.checkNotNullParameter(context2, "context");
            this.proto = proto;
            this.context = context2;
            this.topLevelFunctionNameIndex$delegate = LazyKt.lazy((Function0)new Function0<Map<Name, ? extends List<? extends Integer>>>(this){
                final /* synthetic */ PackagePartsCacheData this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Map<Name, List<Integer>> invoke() {
                    void $this$groupByTo$iv$iv;
                    void $this$groupBy$iv;
                    Iterable<Object> iterable = this.this$0.getProto().getFunctionList();
                    Intrinsics.checkNotNullExpressionValue(iterable, "proto.functionList");
                    iterable = CollectionsKt.withIndex((Iterable)iterable);
                    PackagePartsCacheData packagePartsCacheData = this.this$0;
                    boolean $i$f$groupBy = false;
                    void var4_4 = $this$groupBy$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$groupByTo = false;
                    for (T element$iv$iv : $this$groupByTo$iv$iv) {
                        void $dstr$index;
                        Object object;
                        IndexedValue it = (IndexedValue)element$iv$iv;
                        boolean bl = false;
                        Name key$iv$iv = NameResolverUtilKt.getName(packagePartsCacheData.getContext().getNameResolver(), ((ProtoBuf.Function)it.getValue()).getName());
                        Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                        boolean $i$f$getOrPut = false;
                        V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl2 = false;
                            List answer$iv$iv$iv = new ArrayList<E>();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object;
                        it = (IndexedValue)element$iv$iv;
                        List list2 = list$iv$iv;
                        boolean bl3 = false;
                        int index2 = $dstr$index.component1();
                        Integer n = index2;
                        list2.add(n);
                    }
                    return destination$iv$iv;
                }
            });
            this.topLevelPropertyNameIndex$delegate = LazyKt.lazy((Function0)new Function0<Map<Name, ? extends List<? extends Integer>>>(this){
                final /* synthetic */ PackagePartsCacheData this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Map<Name, List<Integer>> invoke() {
                    void $this$groupByTo$iv$iv;
                    void $this$groupBy$iv;
                    Iterable<Object> iterable = this.this$0.getProto().getPropertyList();
                    Intrinsics.checkNotNullExpressionValue(iterable, "proto.propertyList");
                    iterable = CollectionsKt.withIndex((Iterable)iterable);
                    PackagePartsCacheData packagePartsCacheData = this.this$0;
                    boolean $i$f$groupBy = false;
                    void var4_4 = $this$groupBy$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$groupByTo = false;
                    for (T element$iv$iv : $this$groupByTo$iv$iv) {
                        void $dstr$index;
                        Object object;
                        IndexedValue it = (IndexedValue)element$iv$iv;
                        boolean bl = false;
                        Name key$iv$iv = NameResolverUtilKt.getName(packagePartsCacheData.getContext().getNameResolver(), ((ProtoBuf.Property)it.getValue()).getName());
                        Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                        boolean $i$f$getOrPut = false;
                        V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl2 = false;
                            List answer$iv$iv$iv = new ArrayList<E>();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object;
                        it = (IndexedValue)element$iv$iv;
                        List list2 = list$iv$iv;
                        boolean bl3 = false;
                        int index2 = $dstr$index.component1();
                        Integer n = index2;
                        list2.add(n);
                    }
                    return destination$iv$iv;
                }
            });
            this.typeAliasNameIndex$delegate = LazyKt.lazy((Function0)new Function0<Map<Name, ? extends List<? extends Integer>>>(this){
                final /* synthetic */ PackagePartsCacheData this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Map<Name, List<Integer>> invoke() {
                    void $this$groupByTo$iv$iv;
                    void $this$groupBy$iv;
                    Iterable<Object> iterable = this.this$0.getProto().getTypeAliasList();
                    Intrinsics.checkNotNullExpressionValue(iterable, "proto.typeAliasList");
                    iterable = CollectionsKt.withIndex((Iterable)iterable);
                    PackagePartsCacheData packagePartsCacheData = this.this$0;
                    boolean $i$f$groupBy = false;
                    void var4_4 = $this$groupBy$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$groupByTo = false;
                    for (T element$iv$iv : $this$groupByTo$iv$iv) {
                        void $dstr$index;
                        Object object;
                        IndexedValue it = (IndexedValue)element$iv$iv;
                        boolean bl = false;
                        Name key$iv$iv = NameResolverUtilKt.getName(packagePartsCacheData.getContext().getNameResolver(), ((ProtoBuf.TypeAlias)it.getValue()).getName());
                        Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                        boolean $i$f$getOrPut = false;
                        V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl2 = false;
                            List answer$iv$iv$iv = new ArrayList<E>();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object;
                        it = (IndexedValue)element$iv$iv;
                        List list2 = list$iv$iv;
                        boolean bl3 = false;
                        int index2 = $dstr$index.component1();
                        Integer n = index2;
                        list2.add(n);
                    }
                    return destination$iv$iv;
                }
            });
        }

        @NotNull
        public final ProtoBuf.Package getProto() {
            return this.proto;
        }

        @NotNull
        public final FirDeserializationContext getContext() {
            return this.context;
        }

        @NotNull
        public final Map<Name, List<Integer>> getTopLevelFunctionNameIndex() {
            Lazy lazy = this.topLevelFunctionNameIndex$delegate;
            boolean bl = false;
            return (Map)lazy.getValue();
        }

        @NotNull
        public final Map<Name, List<Integer>> getTopLevelPropertyNameIndex() {
            Lazy lazy = this.topLevelPropertyNameIndex$delegate;
            boolean bl = false;
            return (Map)lazy.getValue();
        }

        @NotNull
        public final Map<Name, List<Integer>> getTypeAliasNameIndex() {
            Lazy lazy = this.typeAliasNameIndex$delegate;
            boolean bl = false;
            return (Map)lazy.getValue();
        }
    }
}

