/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.AbstractFirStatusResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.PhaseUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.StatusComputationSession;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.visitors.CompositeTransformResult;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u001c\u0010\r\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\n0\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\bH\u0002J \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\f\u0010\u001e\u001a\u00020\u0013*\u00020\bH\u0014J\f\u0010\u001f\u001a\u00020\u0013*\u00020\bH\u0014R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirDesignatedStatusResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/AbstractFirStatusResolveTransformer;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "designation", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "targetClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "statusComputationSession", "Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;", "designationMapForLocalClasses", "", "scopeForLocalClass", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Ljava/util/Iterator;Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;Ljava/util/Map;Lorg/jetbrains/kotlin/fir/scopes/FirScope;)V", "classLocated", "", "currentElement", "shouldSkipClass", "declaration", "transformRegularClass", "Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "data", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;", "needResolveMembers", "needResolveNestedClassifiers", "resolve"})
final class FirDesignatedStatusResolveTransformer
extends AbstractFirStatusResolveTransformer {
    @NotNull
    private final Iterator<FirDeclaration> designation;
    @NotNull
    private final FirClass<?> targetClass;
    @Nullable
    private FirDeclaration currentElement;
    private boolean classLocated;

    public FirDesignatedStatusResolveTransformer(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull Iterator<? extends FirDeclaration> designation2, @NotNull FirClass<?> targetClass, @NotNull StatusComputationSession statusComputationSession, @NotNull Map<FirClass<?>, ? extends FirClass<?>> designationMapForLocalClasses, @Nullable FirScope scopeForLocalClass) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Intrinsics.checkNotNullParameter(designation2, "designation");
        Intrinsics.checkNotNullParameter(targetClass, "targetClass");
        Intrinsics.checkNotNullParameter(statusComputationSession, "statusComputationSession");
        Intrinsics.checkNotNullParameter(designationMapForLocalClasses, "designationMapForLocalClasses");
        super(session2, scopeSession, statusComputationSession, designationMapForLocalClasses, scopeForLocalClass);
        this.designation = designation2;
        this.targetClass = targetClass;
    }

    private final boolean shouldSkipClass(FirDeclaration declaration2) {
        boolean result2;
        if (this.classLocated) {
            return !Intrinsics.areEqual(declaration2, this.targetClass);
        }
        if (this.currentElement == null && this.designation.hasNext()) {
            this.currentElement = this.designation.next();
        }
        if (result2 = Intrinsics.areEqual(this.currentElement, declaration2)) {
            if (Intrinsics.areEqual(this.currentElement, this.targetClass)) {
                this.classLocated = true;
            }
            this.currentElement = null;
        }
        return false;
    }

    @Override
    protected boolean needResolveMembers(@NotNull FirDeclaration $this$needResolveMembers) {
        Intrinsics.checkNotNullParameter($this$needResolveMembers, "<this>");
        return this.classLocated;
    }

    @Override
    protected boolean needResolveNestedClassifiers(@NotNull FirDeclaration $this$needResolveNestedClassifiers) {
        Intrinsics.checkNotNullParameter($this$needResolveNestedClassifiers, "<this>");
        return !this.classLocated;
    }

    @Override
    @NotNull
    public CompositeTransformResult<FirStatement> transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable FirResolvedDeclarationStatus data) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        if (this.shouldSkipClass(regularClass)) {
            FirElement $this$compose$iv = regularClass;
            boolean $i$f$compose = false;
            return CompositeTransformResult.Companion.single($this$compose$iv);
        }
        PhaseUtilsKt.ensureResolved(regularClass.getSymbol(), FirResolvePhase.TYPES, this.getSession());
        boolean classLocated = this.classLocated;
        if (classLocated) {
            boolean $i$f$compose = Intrinsics.areEqual(regularClass, this.targetClass);
            bl2 = false;
            bl = false;
            if (_Assertions.ENABLED && !$i$f$compose) {
                boolean bl3 = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            StatusComputationSession.StatusComputationStatus computationStatus = this.getStatusComputationSession().startComputing(regularClass);
            this.forceResolveStatusesOfSupertypes(regularClass);
            if (computationStatus != StatusComputationSession.StatusComputationStatus.Computed) {
                this.updateResolvePhaseOfMembers(regularClass);
                regularClass.transformStatus(this, this.getStatusResolver().resolveStatus(regularClass, this.getContainingClass(), false));
            }
        }
        CompositeTransformResult<FirStatement> compositeTransformResult = this.transformClass((FirClass)regularClass, data);
        bl2 = false;
        bl = false;
        CompositeTransformResult<FirStatement> it = compositeTransformResult;
        boolean bl4 = false;
        if (classLocated) {
            this.getStatusComputationSession().endComputing(regularClass);
        }
        return compositeTransformResult;
    }
}

