/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.utils.InlineUtils;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0006\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\n\u001a\u00020\u0006\u001a\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0010"}, d2={"transitiveStaticRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "getTransitiveStaticRef", "(Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;)Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "getCallerQualifier", "invocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "getCallerQualifierImpl", "getSimpleIdent", "", "call", "getSimpleName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "hasCallerQualifier", "", "isCallInvocation", "js.translator"})
public final class InvocationUtilsKt {
    @Nullable
    public static final JsName getSimpleName(@NotNull JsInvocation call2) {
        Intrinsics.checkNotNullParameter(call2, "call");
        JsExpression jsExpression = call2.getQualifier();
        Intrinsics.checkNotNullExpressionValue(jsExpression, "call.qualifier");
        JsExpression qualifier = jsExpression;
        jsExpression = qualifier instanceof JsNameRef ? (JsNameRef)qualifier : null;
        return jsExpression == null ? null : ((JsNameRef)jsExpression).getName();
    }

    @Nullable
    public static final String getSimpleIdent(@NotNull JsInvocation call2) {
        Intrinsics.checkNotNullParameter(call2, "call");
        JsExpression qualifier = call2.getQualifier();
        while (qualifier != null) {
            JsExpression jsExpression = qualifier;
            if (jsExpression instanceof JsInvocation) {
                JsExpression callableQualifier = qualifier;
                qualifier = ((JsInvocation)callableQualifier).getQualifier();
                if (!InvocationUtilsKt.isCallInvocation((JsInvocation)callableQualifier)) continue;
                JsExpression jsExpression2 = qualifier;
                JsNameRef jsNameRef = jsExpression2 instanceof JsNameRef ? (JsNameRef)jsExpression2 : null;
                qualifier = jsNameRef == null ? null : jsNameRef.getQualifier();
                continue;
            }
            if (!(jsExpression instanceof HasName)) break;
            JsName jsName = ((HasName)((Object)qualifier)).getName();
            return jsName == null ? null : jsName.getIdent();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isCallInvocation(@NotNull JsInvocation invocation) {
        Intrinsics.checkNotNullParameter(invocation, "invocation");
        JsExpression jsExpression = invocation.getQualifier();
        JsNameRef qualifier = jsExpression instanceof JsNameRef ? (JsNameRef)jsExpression : null;
        Object object = invocation.getArguments();
        Intrinsics.checkNotNullExpressionValue(object, "invocation.arguments");
        List<JsExpression> arguments2 = object;
        object = InlineUtils.getName(qualifier);
        if ((object == null ? null : MetadataProperties.getDescriptor((JsName)object)) != null) {
            return false;
        }
        object = qualifier;
        if (!Intrinsics.areEqual(object == null ? null : ((JsNameRef)object).getIdent(), "call")) return false;
        object = arguments2;
        boolean bl = false;
        if (object.isEmpty()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        if (qualifier.getQualifier() == null) return false;
        return true;
    }

    public static final boolean hasCallerQualifier(@NotNull JsInvocation invocation) {
        Intrinsics.checkNotNullParameter(invocation, "invocation");
        return InvocationUtilsKt.getCallerQualifierImpl(invocation) != null;
    }

    @NotNull
    public static final JsExpression getCallerQualifier(@NotNull JsInvocation invocation) {
        Intrinsics.checkNotNullParameter(invocation, "invocation");
        JsExpression jsExpression = InvocationUtilsKt.getCallerQualifierImpl(invocation);
        if (jsExpression == null) {
            throw new AssertionError((Object)"must check hasQualifier() before calling getQualifier");
        }
        return jsExpression;
    }

    private static final JsExpression getCallerQualifierImpl(JsInvocation invocation) {
        JsExpression jsExpression = invocation.getQualifier();
        JsNameRef jsNameRef = jsExpression instanceof JsNameRef ? (JsNameRef)jsExpression : null;
        return jsNameRef == null ? null : jsNameRef.getQualifier();
    }

    @NotNull
    public static final JsExpression getTransitiveStaticRef(@NotNull JsExpression $this$transitiveStaticRef) {
        Intrinsics.checkNotNullParameter($this$transitiveStaticRef, "<this>");
        JsExpression qualifier = $this$transitiveStaticRef;
        while (true) {
            JsExpression jsExpression;
            JsExpression jsExpression2;
            JsNode jsNode;
            JsName jsName;
            JsExpression jsExpression3;
            if ((jsExpression3 = qualifier) instanceof JsNameRef) {
                jsName = ((JsNameRef)qualifier).getName();
                jsNode = jsName == null ? null : MetadataProperties.getStaticRef(jsName);
                JsExpression jsExpression4 = jsExpression2 = jsNode instanceof JsExpression ? (JsExpression)jsNode : null;
                if (jsExpression2 == null) break;
                jsExpression = jsExpression2;
            } else {
                if (!(jsExpression3 instanceof JsInvocation)) break;
                jsName = InvocationUtilsKt.getSimpleName((JsInvocation)qualifier);
                jsNode = jsName == null ? null : MetadataProperties.getStaticRef(jsName);
                JsExpression jsExpression5 = jsExpression2 = jsNode instanceof JsExpression ? (JsExpression)jsNode : null;
                if (jsExpression2 == null) break;
                jsExpression = jsExpression2;
            }
            qualifier = jsExpression;
        }
        return qualifier;
    }
}

