/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.JsEqualsHashcodeToStringGenerator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtClassOrObject;

public class JsInlineClassGenerator
extends JsEqualsHashcodeToStringGenerator {
    protected JsInlineClassGenerator(KtClassOrObject klass, TranslationContext context2) {
        super(klass, context2);
    }

    @Override
    public void generate() {
        this.generateUnboxFunction();
        super.generate();
    }

    private void generateUnboxFunction() {
        PropertyDescriptor boxee = this.getPrimaryConstructorProperties().get(0);
        JsFunction unboxFunction = this.context.createRootScopedFunction("unbox");
        JsExpression prototypeRef = JsAstUtils.prototypeOf(this.context.getInnerReference(this.getClassDescriptor()));
        JsNameRef functionRef = new JsNameRef("unbox", prototypeRef);
        unboxFunction.getBody().getStatements().add(new JsReturn(JsAstUtils.pureFqn(this.context.getNameForDescriptor(boxee), (JsExpression)new JsThisRef())));
        this.context.addDeclarationStatement(JsAstUtils.assignment(functionRef, unboxFunction).makeStmt());
    }
}

