/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.resolve.calls.NewCommonSuperTypeCalculator;
import org.jetbrains.kotlin.resolve.calls.inference.components.ResultTypeResolver;
import org.jetbrains.kotlin.resolve.calls.inference.components.TrivialConstraintTypeInferenceOracle;
import org.jetbrains.kotlin.resolve.calls.inference.components.TypeVariableDirectionCalculator;
import org.jetbrains.kotlin.resolve.calls.inference.components.VariableFixationFinderKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.Constraint;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintKind;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintPositionAndErrorsKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintStorageKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.types.AbstractTypeApproximator;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;
import org.jetbrains.kotlin.types.model.TypeArgumentListMarker;
import org.jetbrains.kotlin.types.model.TypeArgumentMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeSubstitutorMarker;
import org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContext;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;
import org.jetbrains.kotlin.types.model.TypeVariableTypeConstructorMarker;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u00002\u00020\u0001:\u0001*B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018J\"\u0010\u0019\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u001a\u001a\u00020\u0011*\u00020\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0002J\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u0011*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u0011*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u001e\u001a\u00020\f*\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0011H\u0002J\u001c\u0010 \u001a\u00020\f*\u00020\u00132\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J&\u0010\"\u001a\u0004\u0018\u00010\u0011*\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J \u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e*\u00020\u00132\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001c\u0010$\u001a\u0004\u0018\u00010\u0011*\u00020\u00132\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J*\u0010!\u001a\u0004\u0018\u00010\u0011*\u00020\u00132\b\u0010%\u001a\u0004\u0018\u00010\u00112\b\u0010&\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e*\u00020\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0002J\u001e\u0010(\u001a\u0004\u0018\u00010\u0011*\u00020\u00132\u0006\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u0011H\u0002J\f\u0010)\u001a\u00020\u0011*\u00020\u0011H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/ResultTypeResolver;", "", "typeApproximator", "Lorg/jetbrains/kotlin/types/AbstractTypeApproximator;", "trivialConstraintTypeInferenceOracle", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/TrivialConstraintTypeInferenceOracle;", "(Lorg/jetbrains/kotlin/types/AbstractTypeApproximator;Lorg/jetbrains/kotlin/resolve/calls/inference/components/TrivialConstraintTypeInferenceOracle;)V", "getTrivialConstraintTypeInferenceOracle", "()Lorg/jetbrains/kotlin/resolve/calls/inference/components/TrivialConstraintTypeInferenceOracle;", "getTypeApproximator", "()Lorg/jetbrains/kotlin/types/AbstractTypeApproximator;", "checkSingleLowerNullabilityConstraint", "", "constraints", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/Constraint;", "findResultIfThereIsEqualsConstraint", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "c", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ResultTypeResolver$Context;", "variableWithConstraints", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "findResultType", "direction", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDirectionCalculator$ResolveDirection;", "findResultTypeOrNull", "computeCommonSuperType", "types", "findSubType", "findSuperType", "isProperTypeForFixation", "type", "isSuitableType", "resultType", "makeFlexibleIfNecessary", "prepareLowerConstraints", "representativeFromEqualityConstraints", "firstCandidate", "secondCandidate", "sinkIntegerLiteralTypes", "specialResultForIntersectionType", "toPublicType", "Context", "resolution.common"})
public final class ResultTypeResolver {
    @NotNull
    private final AbstractTypeApproximator typeApproximator;
    @NotNull
    private final TrivialConstraintTypeInferenceOracle trivialConstraintTypeInferenceOracle;

    public ResultTypeResolver(@NotNull AbstractTypeApproximator typeApproximator, @NotNull TrivialConstraintTypeInferenceOracle trivialConstraintTypeInferenceOracle) {
        Intrinsics.checkNotNullParameter(typeApproximator, "typeApproximator");
        Intrinsics.checkNotNullParameter(trivialConstraintTypeInferenceOracle, "trivialConstraintTypeInferenceOracle");
        this.typeApproximator = typeApproximator;
        this.trivialConstraintTypeInferenceOracle = trivialConstraintTypeInferenceOracle;
    }

    @NotNull
    public final AbstractTypeApproximator getTypeApproximator() {
        return this.typeApproximator;
    }

    @NotNull
    public final TrivialConstraintTypeInferenceOracle getTrivialConstraintTypeInferenceOracle() {
        return this.trivialConstraintTypeInferenceOracle;
    }

    @NotNull
    public final KotlinTypeMarker findResultType(@NotNull Context c, @NotNull VariableWithConstraints variableWithConstraints, @NotNull TypeVariableDirectionCalculator.ResolveDirection direction) {
        Intrinsics.checkNotNullParameter(c, "c");
        Intrinsics.checkNotNullParameter(variableWithConstraints, "variableWithConstraints");
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        Object object = this.findResultTypeOrNull(c, variableWithConstraints, direction);
        if (object != null) {
            KotlinTypeMarker kotlinTypeMarker = object;
            boolean bl = false;
            boolean bl2 = false;
            KotlinTypeMarker it = kotlinTypeMarker;
            boolean bl3 = false;
            return it;
        }
        object = this;
        boolean bl = false;
        boolean bl4 = false;
        ResultTypeResolver $this$findResultType_u24lambda_u2d1 = (ResultTypeResolver)object;
        boolean bl5 = false;
        return direction == TypeVariableDirectionCalculator.ResolveDirection.TO_SUBTYPE ? c.nothingType() : c.nullableAnyType();
    }

    private final KotlinTypeMarker findResultTypeOrNull(Context c, VariableWithConstraints variableWithConstraints, TypeVariableDirectionCalculator.ResolveDirection direction) {
        KotlinTypeMarker kotlinTypeMarker = this.findResultIfThereIsEqualsConstraint(c, variableWithConstraints);
        if (kotlinTypeMarker != null) {
            KotlinTypeMarker kotlinTypeMarker2 = kotlinTypeMarker;
            boolean bl = false;
            boolean bl2 = false;
            KotlinTypeMarker it = kotlinTypeMarker2;
            boolean bl3 = false;
            return it;
        }
        KotlinTypeMarker subType = this.findSubType(c, variableWithConstraints);
        KotlinTypeMarker superType = this.makeFlexibleIfNecessary(this.findSuperType(c, variableWithConstraints), c, variableWithConstraints.getConstraints());
        return direction == TypeVariableDirectionCalculator.ResolveDirection.TO_SUBTYPE || direction == TypeVariableDirectionCalculator.ResolveDirection.UNKNOWN ? this.resultType(c, subType, superType, variableWithConstraints) : this.resultType(c, superType, subType, variableWithConstraints);
    }

    private final KotlinTypeMarker makeFlexibleIfNecessary(KotlinTypeMarker $this$makeFlexibleIfNecessary, Context c, List<Constraint> constraints) {
        KotlinTypeMarker kotlinTypeMarker;
        boolean bl = false;
        boolean bl2 = false;
        Context $this$makeFlexibleIfNecessary_u24lambda_u2d4 = c;
        boolean bl3 = false;
        KotlinTypeMarker type2 = $this$makeFlexibleIfNecessary;
        if (type2 instanceof SimpleTypeMarker) {
            boolean bl4;
            block5: {
                Iterable $this$any$iv = constraints;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl4 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Constraint it = (Constraint)element$iv;
                        boolean bl5 = false;
                        if (!($this$makeFlexibleIfNecessary_u24lambda_u2d4.isTypeVariable($this$makeFlexibleIfNecessary_u24lambda_u2d4.typeConstructor(it.getType())) && $this$makeFlexibleIfNecessary_u24lambda_u2d4.hasFlexibleNullability(it.getType()))) continue;
                        bl4 = true;
                        break block5;
                    }
                    bl4 = false;
                }
            }
            kotlinTypeMarker = bl4 ? $this$makeFlexibleIfNecessary_u24lambda_u2d4.createFlexibleType($this$makeFlexibleIfNecessary_u24lambda_u2d4.makeSimpleTypeDefinitelyNotNullOrNotNull((SimpleTypeMarker)type2), $this$makeFlexibleIfNecessary_u24lambda_u2d4.withNullability((SimpleTypeMarker)type2, true)) : type2;
        } else {
            kotlinTypeMarker = type2;
        }
        return kotlinTypeMarker;
    }

    private final KotlinTypeMarker resultType(Context $this$resultType, KotlinTypeMarker firstCandidate, KotlinTypeMarker secondCandidate, VariableWithConstraints variableWithConstraints) {
        if (firstCandidate == null || secondCandidate == null) {
            KotlinTypeMarker kotlinTypeMarker = firstCandidate;
            return kotlinTypeMarker == null ? secondCandidate : kotlinTypeMarker;
        }
        KotlinTypeMarker kotlinTypeMarker = this.specialResultForIntersectionType($this$resultType, firstCandidate, secondCandidate);
        if (kotlinTypeMarker != null) {
            KotlinTypeMarker kotlinTypeMarker2 = kotlinTypeMarker;
            boolean bl = false;
            boolean bl2 = false;
            KotlinTypeMarker intersectionWithAlternative = kotlinTypeMarker2;
            boolean bl3 = false;
            return intersectionWithAlternative;
        }
        if (this.isSuitableType($this$resultType, firstCandidate, variableWithConstraints)) {
            return firstCandidate;
        }
        return this.isSuitableType($this$resultType, secondCandidate, variableWithConstraints) ? secondCandidate : firstCandidate;
    }

    private final KotlinTypeMarker specialResultForIntersectionType(Context $this$specialResultForIntersectionType, KotlinTypeMarker firstCandidate, KotlinTypeMarker secondCandidate) {
        if ($this$specialResultForIntersectionType.isIntersection($this$specialResultForIntersectionType.typeConstructor(firstCandidate)) && !AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, $this$specialResultForIntersectionType, this.toPublicType(firstCandidate), this.toPublicType(secondCandidate), false, 8, null)) {
            return $this$specialResultForIntersectionType.createTypeWithAlternativeForIntersectionResult(firstCandidate, secondCandidate);
        }
        return null;
    }

    private final KotlinTypeMarker toPublicType(KotlinTypeMarker $this$toPublicType) {
        KotlinTypeMarker kotlinTypeMarker = this.typeApproximator.approximateToSuperType($this$toPublicType, TypeApproximatorConfiguration.PublicDeclaration.INSTANCE);
        return kotlinTypeMarker == null ? $this$toPublicType : kotlinTypeMarker;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isSuitableType(Context $this$isSuitableType, KotlinTypeMarker resultType, VariableWithConstraints variableWithConstraints) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = variableWithConstraints.getConstraints();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Constraint it = (Constraint)element$iv$iv;
            boolean bl = false;
            if (!this.isProperTypeForFixation($this$isSuitableType, it.getType())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredConstraints = (List)destination$iv$iv;
        for (Constraint constraint : filteredConstraints) {
            if (ConstraintStorageKt.checkConstraint($this$isSuitableType, constraint.getType(), constraint.getKind(), resultType)) continue;
            return false;
        }
        if (!this.trivialConstraintTypeInferenceOracle.isSuitableResultedType(resultType)) {
            if ($this$isSuitableType.isNullableType(resultType) && this.checkSingleLowerNullabilityConstraint(filteredConstraints)) {
                return false;
            }
            if ($this$isSuitableType.isReified(variableWithConstraints.getTypeVariable())) {
                return false;
            }
        }
        return true;
    }

    private final boolean checkSingleLowerNullabilityConstraint(List<Constraint> constraints) {
        boolean bl;
        Object v0;
        block2: {
            Iterable $this$singleOrNull$iv = constraints;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                Constraint it = (Constraint)element$iv;
                boolean bl2 = false;
                if (!it.getKind().isLower()) continue;
                if (found$iv) {
                    v0 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        Constraint constraint = v0;
        return constraint == null ? false : (bl = constraint.isNullabilityConstraint());
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinTypeMarker findSubType(Context $this$findSubType, VariableWithConstraints variableWithConstraints) {
        List<KotlinTypeMarker> lowerConstraintTypes = this.prepareLowerConstraints($this$findSubType, variableWithConstraints.getConstraints());
        Collection collection = lowerConstraintTypes;
        boolean bl = false;
        if (!collection.isEmpty()) {
            KotlinTypeMarker kotlinTypeMarker;
            List<KotlinTypeMarker> types2 = this.sinkIntegerLiteralTypes($this$findSubType, lowerConstraintTypes);
            KotlinTypeMarker commonSuperType = this.computeCommonSuperType($this$findSubType, types2);
            if ($this$findSubType.contains(commonSuperType, findSubType.1.INSTANCE)) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = types2;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    KotlinTypeMarker lowerType = (KotlinTypeMarker)element$iv$iv;
                    boolean bl2 = false;
                    if (!(!$this$findSubType.contains(lowerType, findSubType.typesWithoutStubs.1.1.INSTANCE))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List typesWithoutStubs2 = (List)destination$iv$iv;
                Collection collection2 = typesWithoutStubs2;
                boolean bl3 = false;
                if (!collection2.isEmpty()) {
                    commonSuperType = this.computeCommonSuperType($this$findSubType, typesWithoutStubs2);
                } else {
                    return null;
                }
            }
            return (kotlinTypeMarker = this.typeApproximator.approximateToSuperType(commonSuperType, TypeApproximatorConfiguration.InternalTypesApproximation.INSTANCE)) == null ? commonSuperType : kotlinTypeMarker;
        }
        return null;
    }

    private final KotlinTypeMarker computeCommonSuperType(Context $this$computeCommonSuperType, List<? extends KotlinTypeMarker> types2) {
        NewCommonSuperTypeCalculator newCommonSuperTypeCalculator = NewCommonSuperTypeCalculator.INSTANCE;
        boolean bl = false;
        boolean bl2 = false;
        NewCommonSuperTypeCalculator $this$computeCommonSuperType_u24lambda_u2d9 = newCommonSuperTypeCalculator;
        boolean bl3 = false;
        return $this$computeCommonSuperType_u24lambda_u2d9.commonSuperType($this$computeCommonSuperType, types2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<KotlinTypeMarker> prepareLowerConstraints(Context $this$prepareLowerConstraints, List<Constraint> constraints) {
        void $this$mapTo$iv$iv;
        boolean atLeastOneProper = false;
        boolean atLeastOneNonProper = false;
        boolean bl = false;
        List lowerConstraintTypes = new ArrayList();
        for (Constraint constraint : constraints) {
            if (constraint.getKind() != ConstraintKind.LOWER) continue;
            KotlinTypeMarker type2 = constraint.getType();
            lowerConstraintTypes.add(type2);
            if (this.isProperTypeForFixation($this$prepareLowerConstraints, type2)) {
                atLeastOneProper = true;
                continue;
            }
            atLeastOneNonProper = true;
        }
        if (!atLeastOneProper) {
            return CollectionsKt.emptyList();
        }
        if (!atLeastOneNonProper) {
            return lowerConstraintTypes;
        }
        TypeSubstitutorMarker notFixedToStubTypesSubstitutor = $this$prepareLowerConstraints.buildNotFixedVariablesToStubTypesSubstitutor();
        Iterable $this$map$iv = lowerConstraintTypes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinTypeMarker kotlinTypeMarker = (KotlinTypeMarker)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            void var17_19 = this.isProperTypeForFixation($this$prepareLowerConstraints, (KotlinTypeMarker)it) ? it : $this$prepareLowerConstraints.safeSubstitute(notFixedToStubTypesSubstitutor, (KotlinTypeMarker)it);
            collection.add(var17_19);
        }
        return (List)destination$iv$iv;
    }

    private final List<KotlinTypeMarker> sinkIntegerLiteralTypes(Context $this$sinkIntegerLiteralTypes, List<? extends KotlinTypeMarker> types2) {
        Iterable $this$sortedBy$iv = types2;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        return CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator<T>($this$sinkIntegerLiteralTypes){
            final /* synthetic */ Context $this_sinkIntegerLiteralTypes$inlined;
            {
                this.$this_sinkIntegerLiteralTypes$inlined = context2;
            }

            public final int compare(T a, T b) {
                boolean bl = false;
                KotlinTypeMarker type2 = (KotlinTypeMarker)a;
                boolean bl2 = false;
                boolean containsILT2 = this.$this_sinkIntegerLiteralTypes$inlined.contains(type2, (Function1<? super KotlinTypeMarker, Boolean>)new Function1<KotlinTypeMarker, Boolean>(this.$this_sinkIntegerLiteralTypes$inlined){
                    final /* synthetic */ Context $this_sinkIntegerLiteralTypes;
                    {
                        this.$this_sinkIntegerLiteralTypes = $receiver;
                        super(1);
                    }

                    public final boolean invoke(@NotNull KotlinTypeMarker it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        SimpleTypeMarker simpleTypeMarker = this.$this_sinkIntegerLiteralTypes.asSimpleType(it);
                        return simpleTypeMarker == null ? false : this.$this_sinkIntegerLiteralTypes.isIntegerLiteralType(simpleTypeMarker);
                    }
                });
                int n = containsILT2 ? 1 : 0;
                type2 = (KotlinTypeMarker)b;
                Comparable comparable = Integer.valueOf(n);
                bl2 = false;
                containsILT2 = this.$this_sinkIntegerLiteralTypes$inlined.contains(type2, (Function1<? super KotlinTypeMarker, Boolean>)new /* invalid duplicate definition of identical inner class */);
                Integer n2 = containsILT2 ? 1 : 0;
                return ComparisonsKt.compareValues(comparable, (Comparable)n2);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinTypeMarker findSuperType(Context $this$findSuperType, VariableWithConstraints variableWithConstraints) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = variableWithConstraints.getConstraints();
        boolean $i$f$filter2 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Constraint it = (Constraint)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getKind() == ConstraintKind.UPPER && this.isProperTypeForFixation($this$findSuperType, it.getType()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List upperConstraints = (List)destination$iv$iv;
        $this$filter$iv = upperConstraints;
        $i$f$filter2 = false;
        if (!$this$filter$iv.isEmpty()) {
            KotlinTypeMarker kotlinTypeMarker;
            boolean isThereUnwantedIntersectedTypes;
            boolean bl;
            Iterable $this$any$iv;
            KotlinTypeMarker kotlinTypeMarker2;
            Collection<KotlinTypeMarker> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable $i$f$filter2 = upperConstraints;
            Context context2 = $this$findSuperType;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Constraint bl2 = (Constraint)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                kotlinTypeMarker2 = it.getType();
                collection.add(kotlinTypeMarker2);
            }
            collection = (List)destination$iv$iv2;
            KotlinTypeMarker intersectionUpperType = context2.intersectTypes((List<? extends KotlinTypeMarker>)collection);
            boolean resultIsActuallyIntersection = $this$findSuperType.isIntersection($this$findSuperType.typeConstructor(intersectionUpperType));
            if (resultIsActuallyIntersection) {
                boolean areThereIntersectionFinalClasses;
                int intersectionClasses;
                block15: {
                    boolean bl4;
                    KotlinTypeMarker it22;
                    int n;
                    Collection<KotlinTypeMarker> intersectionSupertypes = $this$findSuperType.supertypes($this$findSuperType.typeConstructor(intersectionUpperType));
                    Iterable $this$count$iv = intersectionSupertypes;
                    boolean $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n = 0;
                    } else {
                        int count$iv = 0;
                        for (Object element$iv : $this$count$iv) {
                            it22 = (KotlinTypeMarker)element$iv;
                            boolean bl5 = false;
                            if (!($this$findSuperType.isClassTypeConstructor($this$findSuperType.typeConstructor(it22)) && !$this$findSuperType.isInterface($this$findSuperType.typeConstructor(it22)))) continue;
                            int it22 = ++count$iv;
                            bl5 = false;
                            if (it22 >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n = count$iv;
                    }
                    intersectionClasses = n;
                    $this$any$iv = intersectionSupertypes;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl4 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it22 = (KotlinTypeMarker)element$iv;
                            boolean bl6 = false;
                            if (!$this$findSuperType.isCommonFinalClassConstructor($this$findSuperType.typeConstructor(it22))) continue;
                            bl4 = true;
                            break block15;
                        }
                        bl4 = areThereIntersectionFinalClasses = false;
                    }
                }
                bl = intersectionClasses > 1 || areThereIntersectionFinalClasses;
            } else {
                bl = isThereUnwantedIntersectedTypes = false;
            }
            if (isThereUnwantedIntersectedTypes) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                void $this$filterNotTo$iv$iv;
                Iterable $this$filterNot$iv;
                Iterable intersectionClasses = upperConstraints;
                context2 = $this$findSuperType;
                boolean $i$f$filterNot = false;
                $this$any$iv = $this$filterNot$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    Constraint it = (Constraint)element$iv$iv;
                    boolean bl7 = false;
                    if (ConstraintPositionAndErrorsKt.isExpectedTypePosition(it)) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                collection = (List)destination$iv$iv3;
                $this$filterNot$iv = collection;
                boolean $i$f$map2 = false;
                $this$filterNotTo$iv$iv = $this$map$iv2;
                destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    Constraint it = (Constraint)item$iv$iv;
                    collection = destination$iv$iv3;
                    boolean bl8 = false;
                    kotlinTypeMarker2 = it.getType();
                    collection.add(kotlinTypeMarker2);
                }
                collection = (List)destination$iv$iv3;
                kotlinTypeMarker = context2.intersectTypes((List<? extends KotlinTypeMarker>)collection);
            } else {
                kotlinTypeMarker = intersectionUpperType;
            }
            KotlinTypeMarker upperType = kotlinTypeMarker;
            KotlinTypeMarker kotlinTypeMarker3 = this.typeApproximator.approximateToSubType(upperType, TypeApproximatorConfiguration.InternalTypesApproximation.INSTANCE);
            return kotlinTypeMarker3 == null ? upperType : kotlinTypeMarker3;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isProperTypeForFixation(Context $this$isProperTypeForFixation, KotlinTypeMarker type2) {
        KotlinTypeMarker it;
        TypeSystemInferenceExtensionContext $this$isProperTypeForFixation$iv = $this$isProperTypeForFixation;
        boolean $i$f$isProperTypeForFixation = false;
        KotlinTypeMarker it2 = type2;
        boolean bl = false;
        if (!$this$isProperTypeForFixation.isProperType(it2)) return false;
        Iterable $this$all$iv$iv = VariableFixationFinderKt.extractProjectionsForAllCapturedTypes($this$isProperTypeForFixation$iv, type2);
        boolean $i$f$all = false;
        if ($this$all$iv$iv instanceof Collection && ((Collection)$this$all$iv$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv$iv = iterator2.next();
            it = (KotlinTypeMarker)element$iv$iv;
            $i$a$-isProperTypeForFixation-ResultTypeResolver$isProperTypeForFixation$1 = false;
        } while ($this$isProperTypeForFixation.isProperType(it));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinTypeMarker findResultIfThereIsEqualsConstraint(Context c, VariableWithConstraints variableWithConstraints) {
        void $this$filterTo$iv$iv;
        boolean bl = false;
        boolean bl2 = false;
        Context $this$findResultIfThereIsEqualsConstraint_u24lambda_u2d20 = c;
        boolean bl3 = false;
        Iterable $this$filter$iv = variableWithConstraints.getConstraints();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Constraint it = (Constraint)element$iv$iv;
            boolean bl4 = false;
            if (!(it.getKind() == ConstraintKind.EQUALITY && this.isProperTypeForFixation(c, it.getType()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List properEqualityConstraints = (List)destination$iv$iv;
        return this.representativeFromEqualityConstraints(c, properEqualityConstraints);
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinTypeMarker representativeFromEqualityConstraints(Context $this$representativeFromEqualityConstraints, List<Constraint> constraints) {
        KotlinTypeMarker kotlinTypeMarker;
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        if (constraints.isEmpty()) {
            return null;
        }
        Iterable $this$map$iv = constraints;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Constraint constraint = (Constraint)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            KotlinTypeMarker kotlinTypeMarker2 = it.getType();
            collection.add(kotlinTypeMarker2);
        }
        List constraintTypes = (List)destination$iv$iv;
        Iterable $this$filter$iv = constraintTypes;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KotlinTypeMarker it = (KotlinTypeMarker)element$iv$iv;
            boolean bl = false;
            if (!(!$this$representativeFromEqualityConstraints.isIntegerLiteralTypeConstructor($this$representativeFromEqualityConstraints.typeConstructor(it)))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List nonLiteralTypes = (List)destination$iv$iv2;
        KotlinTypeMarker kotlinTypeMarker3 = $this$representativeFromEqualityConstraints.singleBestRepresentative(nonLiteralTypes);
        return kotlinTypeMarker3 == null ? ((kotlinTypeMarker = $this$representativeFromEqualityConstraints.singleBestRepresentative(constraintTypes)) == null ? (KotlinTypeMarker)CollectionsKt.first(constraintTypes) : kotlinTypeMarker) : kotlinTypeMarker3;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH&\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/ResultTypeResolver$Context;", "Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContext;", "buildNotFixedVariablesToStubTypesSubstitutor", "Lorg/jetbrains/kotlin/types/model/TypeSubstitutorMarker;", "isProperType", "", "type", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "isReified", "variable", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "resolution.common"})
    public static interface Context
    extends TypeSystemInferenceExtensionContext {
        public boolean isProperType(@NotNull KotlinTypeMarker var1);

        @NotNull
        public TypeSubstitutorMarker buildNotFixedVariablesToStubTypesSubstitutor();

        public boolean isReified(@NotNull TypeVariableMarker var1);

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            public static boolean identicalArguments(@NotNull Context this_, @NotNull SimpleTypeMarker a, @NotNull SimpleTypeMarker b) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(a, "a");
                Intrinsics.checkNotNullParameter(b, "b");
                return TypeSystemInferenceExtensionContext.DefaultImpls.identicalArguments(this_, a, b);
            }

            public static boolean anySuperTypeConstructor(@NotNull Context this_, @NotNull KotlinTypeMarker receiver, @NotNull Function1<? super TypeConstructorMarker, Boolean> predicate) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                Intrinsics.checkNotNullParameter(predicate, "predicate");
                return TypeSystemInferenceExtensionContext.DefaultImpls.anySuperTypeConstructor(this_, receiver, predicate);
            }

            @NotNull
            public static Set<TypeVariableTypeConstructorMarker> extractTypeVariables(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.extractTypeVariables(this_, receiver);
            }

            public static boolean hasFlexibleNullability(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.hasFlexibleNullability(this_, receiver);
            }

            public static boolean isCapturedDynamic(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isCapturedDynamic(this_, receiver);
            }

            public static boolean isCapturedType(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isCapturedType(this_, receiver);
            }

            public static boolean isDefinitelyNotNullType(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isDefinitelyNotNullType(this_, receiver);
            }

            public static boolean isDynamic(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isDynamic(this_, receiver);
            }

            public static boolean isFlexible(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isFlexible(this_, receiver);
            }

            public static boolean isFlexibleNothing(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isFlexibleNothing(this_, receiver);
            }

            public static boolean isMarkedNullable(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isMarkedNullable(this_, receiver);
            }

            public static boolean isNothing(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isNothing(this_, receiver);
            }

            public static boolean isNullableAny(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isNullableAny(this_, receiver);
            }

            public static boolean isNullableNothing(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isNullableNothing(this_, receiver);
            }

            public static boolean isSimpleType(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isSimpleType(this_, receiver);
            }

            @NotNull
            public static SimpleTypeMarker lowerBoundIfFlexible(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.lowerBoundIfFlexible(this_, receiver);
            }

            @NotNull
            public static TypeConstructorMarker typeConstructor(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.typeConstructor(this_, receiver);
            }

            public static int typeDepth(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.typeDepth(this_, receiver);
            }

            @NotNull
            public static SimpleTypeMarker upperBoundIfFlexible(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.upperBoundIfFlexible(this_, receiver);
            }

            @Nullable
            public static List<SimpleTypeMarker> fastCorrespondingSupertypes(@NotNull Context this_, @NotNull SimpleTypeMarker receiver, @NotNull TypeConstructorMarker constructor2) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                Intrinsics.checkNotNullParameter(constructor2, "constructor");
                return TypeSystemInferenceExtensionContext.DefaultImpls.fastCorrespondingSupertypes(this_, receiver, constructor2);
            }

            @Nullable
            public static TypeArgumentMarker getArgumentOrNull(@NotNull Context this_, @NotNull SimpleTypeMarker receiver, int index2) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.getArgumentOrNull(this_, receiver, index2);
            }

            public static boolean isClassType(@NotNull Context this_, @NotNull SimpleTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isClassType(this_, receiver);
            }

            public static boolean isIntegerLiteralType(@NotNull Context this_, @NotNull SimpleTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isIntegerLiteralType(this_, receiver);
            }

            @NotNull
            public static TypeArgumentMarker get(@NotNull Context this_, @NotNull TypeArgumentListMarker receiver, int index2) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.get(this_, receiver, index2);
            }

            @NotNull
            public static Iterator<TypeArgumentMarker> iterator(@NotNull Context this_, @NotNull TypeArgumentListMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.iterator(this_, receiver);
            }

            public static int size(@NotNull Context this_, @NotNull TypeArgumentListMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.size(this_, receiver);
            }
        }
    }
}

