/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.Substitutable;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclarationStub;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.ModulePath;
import org.jetbrains.kotlin.resolve.ModuleStructureOracle;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectedActualResolver;
import org.jetbrains.kotlin.resolve.source.PsiSourceFile;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 E2\u00020\u0001:\u0002DEB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J@\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0016\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001b0\u001dj\u0002`\u001fH\u0002J:\u0010 \u001a\u00020\r2\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020#\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170$0\"2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0017H\u0002J(\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020)H\u0002JH\u0010*\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-2\u0016\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001b0\u001dj\u0002`\u001fH\u0002J@\u0010.\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010/\u001a\u0002002\u0016\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001b0\u001dj\u0002`\u001fH\u0002J(\u00101\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010,\u001a\u00020-H\u0002J&\u00102\u001a\b\u0012\u0002\b\u0003\u0018\u0001032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010:\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u0017H\u0002J\u0010\u0010;\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u0017H\u0002J\u0012\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010\u0010\u001a\u00020\u0017H\u0002J&\u0010>\u001a\u00020\u001b*\u00020\u00172\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020#\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170$0\"H\u0002J\f\u0010?\u001a\u00020\u001b*\u00020#H\u0002J\f\u0010@\u001a\u00020\u001b*\u00020\u0017H\u0002J\"\u0010A\u001a\u00020\r*\u00020-2\u0006\u0010&\u001a\u00020\u00172\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00170CH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006F"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExpectedActualDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "moduleStructureOracle", "Lorg/jetbrains/kotlin/resolve/ModuleStructureOracle;", "argumentExtractors", "", "Lorg/jetbrains/kotlin/resolve/checkers/ExpectedActualDeclarationChecker$ActualAnnotationArgumentExtractor;", "(Lorg/jetbrains/kotlin/resolve/ModuleStructureOracle;Ljava/lang/Iterable;)V", "getArgumentExtractors", "()Ljava/lang/Iterable;", "getModuleStructureOracle", "()Lorg/jetbrains/kotlin/resolve/ModuleStructureOracle;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkActualDeclarationHasExpected", "reportOn", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkActual", "", "moduleVisibilityFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "Lorg/jetbrains/kotlin/resolve/multiplatform/ModuleFilter;", "checkAmbiguousExpects", "compatibility", "", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectedActualResolver$Compatibility;", "", "checkAnnotationConstructors", "expected", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "actual", "Lcom/intellij/psi/PsiElement;", "checkExpectedDeclarationHasAtLeastOneActual", "module", "expectActualTracker", "Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;", "checkExpectedDeclarationHasAtMostOneActual", "path", "Lorg/jetbrains/kotlin/resolve/ModulePath;", "checkExpectedDeclarationHasProperActuals", "getActualAnnotationParameterValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "actualParameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "isUnderlyingPropertyOfInlineClass", "requireActualModifier", "sourceFile", "Ljava/io/File;", "hasNoActualWithDiagnostic", "isCompatibleOrWeakCompatible", "isExplicitActualDeclaration", "reportExpectActual", "actualMembers", "Lkotlin/sequences/Sequence;", "ActualAnnotationArgumentExtractor", "Companion", "frontend"})
public final class ExpectedActualDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModuleStructureOracle moduleStructureOracle;
    @NotNull
    private final Iterable<ActualAnnotationArgumentExtractor> argumentExtractors;
    @NotNull
    private static final FqName OPTIONAL_EXPECTATION_FQ_NAME = new FqName("kotlin.OptionalExpectation");

    public ExpectedActualDeclarationChecker(@NotNull ModuleStructureOracle moduleStructureOracle, @NotNull Iterable<? extends ActualAnnotationArgumentExtractor> argumentExtractors) {
        Intrinsics.checkNotNullParameter(moduleStructureOracle, "moduleStructureOracle");
        Intrinsics.checkNotNullParameter(argumentExtractors, "argumentExtractors");
        this.moduleStructureOracle = moduleStructureOracle;
        this.argumentExtractors = argumentExtractors;
    }

    @NotNull
    public final ModuleStructureOracle getModuleStructureOracle() {
        return this.moduleStructureOracle;
    }

    @NotNull
    public final Iterable<ActualAnnotationArgumentExtractor> getArgumentExtractors() {
        return this.argumentExtractors;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiPlatformProjects)) {
            return;
        }
        if (context2.getLanguageVersionSettings().getFlag(AnalysisFlags.INSTANCE.getExpectActualLinker()).booleanValue()) {
            return;
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return;
        }
        if (!(declaration2 instanceof KtNamedDeclaration)) {
            return;
        }
        if (!(descriptor2 instanceof MemberDescriptor) || DescriptorUtils.isEnumEntry(descriptor2)) {
            return;
        }
        if (((MemberDescriptor)descriptor2).isExpect()) {
            this.checkExpectedDeclarationHasProperActuals((KtNamedDeclaration)declaration2, (MemberDescriptor)descriptor2, context2.getTrace(), context2.getExpectActualTracker());
        } else {
            void $this$flatMapTo$iv$iv;
            boolean checkActual = context2.getLanguageVersionSettings().getFlag(AnalysisFlags.INSTANCE.getMultiPlatformDoNotCheckActual()) == false;
            Iterable $this$flatMap$iv = this.moduleStructureOracle.findAllDependsOnPaths(DescriptorUtilsKt.getModule(descriptor2));
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ModulePath it = (ModulePath)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getNodes();
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            HashSet<ModuleDescriptor> allImplementedModules = CollectionsKt.toHashSet((List)destination$iv$iv);
            this.checkActualDeclarationHasExpected((KtNamedDeclaration)declaration2, (MemberDescriptor)descriptor2, context2.getTrace(), checkActual, (Function1<? super ModuleDescriptor, Boolean>)new Function1<ModuleDescriptor, Boolean>(allImplementedModules){
                final /* synthetic */ HashSet<ModuleDescriptor> $allImplementedModules;
                {
                    this.$allImplementedModules = $allImplementedModules;
                    super(1);
                }

                public final boolean invoke(@NotNull ModuleDescriptor it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return this.$allImplementedModules.contains(it);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkExpectedDeclarationHasProperActuals(KtNamedDeclaration reportOn, MemberDescriptor descriptor2, BindingTrace trace, ExpectActualTracker expectActualTracker) {
        void $this$mapValuesTo$iv$iv22;
        void $this$mapValues$iv;
        Object answer$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        List<ModulePath> allActualizationPaths = this.moduleStructureOracle.findAllReversedDependsOnPaths(DescriptorUtilsKt.getModule(descriptor2));
        Object $this$groupBy$iv = allActualizationPaths;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ModulePath it = (ModulePath)element$iv$iv;
            boolean bl = false;
            key$iv$iv = CollectionsKt.last(it.getNodes());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues22 = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv22.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$flatMapTo$iv$iv;
            void it;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            answer$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map2 = map;
            boolean bl3 = false;
            Iterable $this$flatMap$iv = (Iterable)it.getValue();
            boolean $i$f$flatMap = false;
            Iterable iterable2 = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ModulePath it2 = (ModulePath)element$iv$iv;
                boolean bl4 = false;
                Iterable list$iv$iv = it2.getNodes();
                CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
            }
            Set set = CollectionsKt.toSet((List)destination$iv$iv2);
            map2.put(k2, set);
        }
        Map leafModuleToVisibleModules = destination$iv$iv;
        Object $i$f$mapValues22 = leafModuleToVisibleModules;
        boolean $this$mapValuesTo$iv$iv22 = false;
        Iterator<Object> iterator2 = $i$f$mapValues22.entrySet().iterator();
        while (iterator2.hasNext()) {
            destination$iv$iv = $i$f$mapValues22 = iterator2.next();
            boolean bl = false;
            ModuleDescriptor leafModule = (ModuleDescriptor)destination$iv$iv.getKey();
            Object object = $i$f$mapValues22;
            boolean bl5 = false;
            Set modulesVisibleFromLeaf = (Set)object.getValue();
            this.checkExpectedDeclarationHasAtLeastOneActual(reportOn, descriptor2, trace, leafModule, expectActualTracker, (Function1<? super ModuleDescriptor, Boolean>)new Function1<ModuleDescriptor, Boolean>((Set<? extends ModuleDescriptor>)modulesVisibleFromLeaf){
                final /* synthetic */ Set<ModuleDescriptor> $modulesVisibleFromLeaf;
                {
                    this.$modulesVisibleFromLeaf = $modulesVisibleFromLeaf;
                    super(1);
                }

                public final boolean invoke(@NotNull ModuleDescriptor it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return this.$modulesVisibleFromLeaf.contains(it);
                }
            });
        }
        for (ModulePath path2 : allActualizationPaths) {
            Set modulesOnThisPath = CollectionsKt.toSet((Iterable)path2.getNodes());
            this.checkExpectedDeclarationHasAtMostOneActual(reportOn, descriptor2, trace, path2, (Function1<? super ModuleDescriptor, Boolean>)new Function1<ModuleDescriptor, Boolean>(modulesOnThisPath){
                final /* synthetic */ Set<ModuleDescriptor> $modulesOnThisPath;
                {
                    this.$modulesOnThisPath = $modulesOnThisPath;
                    super(1);
                }

                public final boolean invoke(@NotNull ModuleDescriptor it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return this.$modulesOnThisPath.contains(it);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkExpectedDeclarationHasAtMostOneActual(KtNamedDeclaration reportOn, MemberDescriptor descriptor2, BindingTrace trace, ModulePath path2, Function1<? super ModuleDescriptor, Boolean> moduleVisibilityFilter) {
        Iterable $this$filterKeys$iv;
        void $this$fold$iv;
        Iterable $this$ifEmpty$iv;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Collection $this$mapNotNull$iv;
        Iterable iterable = path2.getNodes();
        boolean $i$f$mapNotNull = false;
        void var9_9 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
            Map<ExpectedActualResolver.Compatibility, List<MemberDescriptor>> map;
            element$iv$iv = element$iv$iv$iv;
            boolean bl = false;
            ModuleDescriptor it = (ModuleDescriptor)element$iv$iv;
            boolean bl2 = false;
            if (ExpectedActualResolver.INSTANCE.findActualForExpected(descriptor2, it, moduleVisibilityFilter) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Map<ExpectedActualResolver.Compatibility, List<MemberDescriptor>> it$iv$iv = map;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$ifEmpty = false;
        if ($this$ifEmpty$iv.isEmpty()) {
            boolean bl = false;
            return;
        }
        $this$ifEmpty$iv = $this$ifEmpty$iv;
        Map initial$iv = new LinkedHashMap();
        boolean $i$f$fold = false;
        Object accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void partialMap;
            Map $i$f$forEach2 = (Map)element$iv;
            LinkedHashMap resultMap = accumulator$iv;
            boolean bl = false;
            element$iv$iv = resultMap;
            boolean bl6 = false;
            boolean bl7 = false;
            Object $this$checkExpectedDeclarationHasAtMostOneActual_u24lambda_u2d7_u24lambda_u2d6 = element$iv$iv;
            boolean bl8 = false;
            ((HashMap)$this$checkExpectedDeclarationHasAtMostOneActual_u24lambda_u2d7_u24lambda_u2d6).putAll(partialMap);
            accumulator$iv = element$iv$iv;
        }
        LinkedHashMap compatibility = accumulator$iv;
        initial$iv = compatibility;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        Iterator $i$f$mapNotNullTo22 = $this$filterKeys$iv;
        boolean element$iv = false;
        for (Map.Entry entry$iv : $i$f$mapNotNullTo22.entrySet()) {
            ExpectedActualResolver.Compatibility it = (ExpectedActualResolver.Compatibility)entry$iv.getKey();
            boolean bl = false;
            if (!this.isCompatibleOrWeakCompatible(it)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        List atLeastWeaklyCompatibleActuals = CollectionsKt.distinct(CollectionsKt.flatten(((Map)result$iv).values()));
        if (atLeastWeaklyCompatibleActuals.size() > 1) {
            void $this$sortedBy$iv;
            Collection<ModuleDescriptor> collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            $this$filterKeys$iv = atLeastWeaklyCompatibleActuals;
            MemberDescriptor memberDescriptor = descriptor2;
            PsiElement psiElement = reportOn;
            DiagnosticFactory2<KtNamedDeclaration, DeclarationDescriptor, Collection<ModuleDescriptor>> diagnosticFactory2 = Errors.AMBIGUOUS_ACTUALS;
            BindingTrace bindingTrace = trace;
            boolean $i$f$map = false;
            result$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
                MemberDescriptor it = (MemberDescriptor)((Object)item$iv$iv);
                collection = destination$iv$iv2;
                boolean bl = false;
                ModuleDescriptor moduleDescriptor = DescriptorUtilsKt.getModule(it);
                collection.add(moduleDescriptor);
            }
            collection = (List)destination$iv$iv2;
            $this$map$iv = collection;
            boolean $i$f$sortedBy = false;
            boolean bl = false;
            bindingTrace.report(diagnosticFactory2.on((KtNamedDeclaration)psiElement, memberDescriptor, CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    ModuleDescriptor it = (ModuleDescriptor)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it.getName().asString());
                    it = (ModuleDescriptor)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string2 = it.getName().asString();
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)string2));
                }
            })));
        }
    }

    private final void checkExpectedDeclarationHasAtLeastOneActual(KtNamedDeclaration reportOn, MemberDescriptor descriptor2, BindingTrace trace, ModuleDescriptor module2, ExpectActualTracker expectActualTracker, Function1<? super ModuleDescriptor, Boolean> moduleVisibilityFilter) {
        Map<ExpectedActualResolver.Compatibility, List<MemberDescriptor>> compatibility;
        block11: {
            boolean bl;
            boolean bl2;
            block9: {
                block10: {
                    if (!(descriptor2.getContainingDeclaration() instanceof PackageFragmentDescriptor)) {
                        return;
                    }
                    Map<ExpectedActualResolver.Compatibility, List<MemberDescriptor>> map = ExpectedActualResolver.INSTANCE.findActualForExpected(descriptor2, module2, moduleVisibilityFilter);
                    if (map == null) {
                        return;
                    }
                    compatibility = map;
                    if (Companion.allStrongIncompatibilities(compatibility) && Companion.isOptionalAnnotationClass(descriptor2)) {
                        return;
                    }
                    if (Companion.allStrongIncompatibilities(compatibility)) break block10;
                    map = compatibility;
                    ExpectedActualResolver.Compatibility.Compatible compatible = ExpectedActualResolver.Compatibility.Compatible.INSTANCE;
                    bl2 = false;
                    Map<ExpectedActualResolver.Compatibility, List<MemberDescriptor>> map2 = map;
                    boolean bl3 = false;
                    if (map2.containsKey(compatible) || !this.hasNoActualWithDiagnostic(descriptor2, compatibility)) break block11;
                }
                Iterable $this$all$iv = compatibility.keySet();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        ExpectedActualResolver.Compatibility it = (ExpectedActualResolver.Compatibility)element$iv;
                        boolean bl4 = false;
                        if (it instanceof ExpectedActualResolver.Compatibility.Incompatible) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            }
            boolean $this$all$iv = bl;
            boolean bl5 = false;
            bl2 = false;
            if (_Assertions.ENABLED && !$this$all$iv) {
                boolean bl6 = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            Map<ExpectedActualResolver.Compatibility, List<MemberDescriptor>> incompatibility = compatibility;
            trace.report(Errors.NO_ACTUAL_FOR_EXPECT.on((KtNamedDeclaration)((PsiElement)reportOn), descriptor2, module2, incompatibility));
            return;
        }
        Sequence actualMembers2 = SequencesKt.flatMap(SequencesKt.filter(MapsKt.asSequence(compatibility), checkExpectedDeclarationHasAtLeastOneActual.actualMembers.1.INSTANCE), checkExpectedDeclarationHasAtLeastOneActual.actualMembers.2.INSTANCE);
        this.reportExpectActual(expectActualTracker, descriptor2, actualMembers2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasNoActualWithDiagnostic(MemberDescriptor $this$hasNoActualWithDiagnostic, Map<ExpectedActualResolver.Compatibility, ? extends List<? extends MemberDescriptor>> compatibility) {
        boolean bl;
        block4: {
            void destination$iv;
            void $this$flatMapTo$iv;
            Iterable iterable = compatibility.values();
            boolean bl2 = false;
            Collection collection = new HashSet();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                List it = (List)element$iv;
                boolean bl3 = false;
                Iterable list$iv = it;
                CollectionsKt.addAll(destination$iv, list$iv);
            }
            Iterable $this$all$iv = (Iterable)destination$iv;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    MemberDescriptor actual = (MemberDescriptor)element$iv;
                    boolean bl4 = false;
                    Map expectedOnes = ExpectedActualResolver.findExpectedForActual$default(ExpectedActualResolver.INSTANCE, actual, DescriptorUtilsKt.getModule($this$hasNoActualWithDiagnostic), null, 4, null);
                    if (expectedOnes != null && expectedOnes.keySet().contains(ExpectedActualResolver.Compatibility.Compatible.INSTANCE)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final void reportExpectActual(ExpectActualTracker $this$reportExpectActual, MemberDescriptor expected, Sequence<? extends MemberDescriptor> actualMembers2) {
        if ($this$reportExpectActual instanceof ExpectActualTracker.DoNothing) {
            return;
        }
        Object object = this.sourceFile(expected);
        if (object == null) {
            return;
        }
        File expectedFile = object;
        object = actualMembers2.iterator();
        while (object.hasNext()) {
            MemberDescriptor actual = (MemberDescriptor)object.next();
            File file2 = this.sourceFile(actual);
            if (file2 == null) continue;
            File actualFile = file2;
            $this$reportExpectActual.report(expectedFile, actualFile);
        }
    }

    private final File sourceFile(MemberDescriptor descriptor2) {
        File file2;
        PsiSourceFile psiSourceFile;
        SourceFile $this$safeAs$iv = descriptor2.getSource().getContainingFile();
        boolean $i$f$safeAs = false;
        SourceFile sourceFile = $this$safeAs$iv;
        if (!(sourceFile instanceof PsiSourceFile)) {
            sourceFile = null;
        }
        if ((psiSourceFile = (PsiSourceFile)sourceFile) == null) {
            file2 = null;
        } else {
            PsiSourceFile psiSourceFile2 = psiSourceFile;
            boolean bl = false;
            boolean bl2 = false;
            PsiSourceFile $this$sourceFile_u24lambda_u2d14 = psiSourceFile2;
            boolean bl3 = false;
            file2 = VfsUtilCore.virtualToIoFile($this$sourceFile_u24lambda_u2d14.getPsiFile().getVirtualFile());
        }
        return file2;
    }

    private final void checkActualDeclarationHasExpected(KtNamedDeclaration reportOn, MemberDescriptor descriptor2, BindingTrace trace, boolean checkActual, Function1<? super ModuleDescriptor, Boolean> moduleVisibilityFilter) {
        ExpectedActualResolver.Compatibility singleIncompatibility;
        boolean bl;
        boolean hasActualModifier;
        Map<ExpectedActualResolver.Compatibility, List<MemberDescriptor>> map = ExpectedActualResolver.INSTANCE.findExpectedForActual(descriptor2, DescriptorUtilsKt.getModule(descriptor2), moduleVisibilityFilter);
        if (map == null) {
            return;
        }
        Map<ExpectedActualResolver.Compatibility, List<MemberDescriptor>> compatibility = map;
        this.checkAmbiguousExpects(compatibility, trace, reportOn, descriptor2);
        boolean bl2 = hasActualModifier = descriptor2.isActual() && PsiUtilsKt.hasActualModifier(reportOn);
        if (!hasActualModifier) {
            if (Companion.allStrongIncompatibilities(compatibility)) {
                return;
            }
            Map<ExpectedActualResolver.Compatibility, List<MemberDescriptor>> map2 = compatibility;
            ExpectedActualResolver.Compatibility.Compatible compatible = ExpectedActualResolver.Compatibility.Compatible.INSTANCE;
            bl = false;
            Map<ExpectedActualResolver.Compatibility, List<MemberDescriptor>> map3 = map2;
            boolean bl3 = false;
            if (map3.containsKey(compatible)) {
                if (checkActual && this.requireActualModifier(descriptor2)) {
                    trace.report(Errors.ACTUAL_MISSING.on((KtNamedDeclaration)((PsiElement)reportOn)));
                }
                return;
            }
        }
        if ((singleIncompatibility = (ExpectedActualResolver.Compatibility)CollectionsKt.firstOrNull((Iterable)compatibility.keySet())) instanceof ExpectedActualResolver.Compatibility.Incompatible.ClassScopes) {
            ClassifierDescriptor $this$filterNotTo$iv$iv;
            boolean bl4 = descriptor2 instanceof ClassDescriptor || descriptor2 instanceof TypeAliasDescriptor;
            bl = false;
            if (_Assertions.ENABLED && !bl4) {
                boolean $i$a$-assert-ExpectedActualDeclarationChecker$checkActualDeclarationHasExpected$22 = false;
                String $i$a$-assert-ExpectedActualDeclarationChecker$checkActualDeclarationHasExpected$22 = Intrinsics.stringPlus("Incompatible.ClassScopes is only possible for a class or a typealias: ", descriptor2);
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-ExpectedActualDeclarationChecker$checkActualDeclarationHasExpected$22));
            }
            Iterable $this$filterNot$iv = ((ExpectedActualResolver.Compatibility.Incompatible.ClassScopes)singleIncompatibility).getUnfulfilled();
            boolean $i$f$filterNot2 = false;
            Iterable iterable = $this$filterNot$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo2 = false;
            Iterator iterator2 = $this$filterNotTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                Pair p0 = (Pair)element$iv$iv;
                boolean bl5 = false;
                if (ExpectedActualDeclarationChecker.checkActualDeclarationHasExpected$hasSingleActualSuspect(this, p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List nonTrivialUnfulfilled = (List)destination$iv$iv;
            $this$filterNot$iv = nonTrivialUnfulfilled;
            $i$f$filterNot2 = false;
            if (!$this$filterNot$iv.isEmpty()) {
                Object $i$f$filterNotTo2 = descriptor2 instanceof TypeAliasDescriptor ? (TypeAliasDescriptor)descriptor2 : null;
                Object object = destination$iv$iv = $i$f$filterNotTo2 == null ? null : $i$f$filterNotTo2.getExpandedType();
                $this$filterNotTo$iv$iv = destination$iv$iv == null ? null : (($i$f$filterNotTo2 = ((KotlinType)destination$iv$iv).getConstructor()) == null ? null : $i$f$filterNotTo2.getDeclarationDescriptor());
                ClassDescriptor $i$f$filterNot2 = $this$filterNotTo$iv$iv instanceof ClassDescriptor ? (ClassDescriptor)$this$filterNotTo$iv$iv : null;
                ClassDescriptor classDescriptor = $i$f$filterNot2 == null ? (ClassDescriptor)descriptor2 : $i$f$filterNot2;
                trace.report(Errors.NO_ACTUAL_CLASS_MEMBER_FOR_EXPECTED_CLASS.on((KtNamedDeclaration)((PsiElement)reportOn), classDescriptor, nonTrivialUnfulfilled));
            }
        } else {
            Map<ExpectedActualResolver.Compatibility, List<MemberDescriptor>> nonTrivialUnfulfilled = compatibility;
            ExpectedActualResolver.Compatibility.Compatible classDescriptor = ExpectedActualResolver.Compatibility.Compatible.INSTANCE;
            boolean $i$f$filterNot2 = false;
            Map<ExpectedActualResolver.Compatibility, List<MemberDescriptor>> $this$filterNotTo$iv$iv = nonTrivialUnfulfilled;
            boolean destination$iv$iv = false;
            if (!$this$filterNotTo$iv$iv.containsKey(classDescriptor)) {
                boolean bl6;
                boolean $i$f$all;
                block20: {
                    Iterable $this$all$iv = compatibility.keySet();
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl6 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            ExpectedActualResolver.Compatibility it = (ExpectedActualResolver.Compatibility)element$iv;
                            boolean bl7 = false;
                            if (it instanceof ExpectedActualResolver.Compatibility.Incompatible) continue;
                            bl6 = false;
                            break block20;
                        }
                        bl6 = true;
                    }
                }
                boolean $this$all$iv = bl6;
                $i$f$all = false;
                $i$f$filterNot2 = false;
                if (_Assertions.ENABLED && !$this$all$iv) {
                    boolean bl8 = false;
                    String string2 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                Map<ExpectedActualResolver.Compatibility, List<MemberDescriptor>> incompatibility = compatibility;
                trace.report(Errors.ACTUAL_WITHOUT_EXPECT.on((KtNamedDeclaration)((PsiElement)reportOn), descriptor2, incompatibility));
            } else {
                List<MemberDescriptor> $i$f$all = compatibility.get(ExpectedActualResolver.Compatibility.Compatible.INSTANCE);
                Intrinsics.checkNotNull($i$f$all);
                MemberDescriptor expected = CollectionsKt.first($i$f$all);
                if (expected instanceof ClassDescriptor && ((ClassDescriptor)expected).getKind() == ClassKind.ANNOTATION_CLASS) {
                    Object object;
                    Collection<ClassConstructorDescriptor> collection;
                    Collection<TypeAliasConstructorDescriptor> collection2;
                    Collection<TypeAliasConstructorDescriptor> collection3 = collection2 = descriptor2 instanceof ClassDescriptor ? (ClassDescriptor)descriptor2 : null;
                    ClassConstructorDescriptor classConstructorDescriptor = collection2 == null ? null : ($i$f$filterNot2 = (collection = collection2.getConstructors()) == null ? null : (ClassConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)collection));
                    if ($i$f$filterNot2 == null) {
                        Substitutable<ClassifierDescriptorWithTypeParameters> substitutable = descriptor2 instanceof TypeAliasDescriptor ? (TypeAliasDescriptor)descriptor2 : null;
                        Collection<TypeAliasConstructorDescriptor> collection4 = collection2 = substitutable == null ? null : substitutable.getConstructors();
                        object = collection2 == null ? null : ((substitutable = (TypeAliasConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)collection2)) == null ? null : substitutable.getUnderlyingConstructorDescriptor());
                    } else {
                        object = $i$f$filterNot2;
                    }
                    ClassConstructorDescriptor actualConstructor = object;
                    collection2 = ((ClassDescriptor)expected).getConstructors();
                    Intrinsics.checkNotNullExpressionValue(collection2, "expected.constructors");
                    ClassConstructorDescriptor expectedConstructor = (ClassConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)collection2);
                    if (expectedConstructor != null && actualConstructor != null) {
                        this.checkAnnotationConstructors(expectedConstructor, actualConstructor, trace, reportOn);
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAmbiguousExpects(Map<ExpectedActualResolver.Compatibility, ? extends List<? extends MemberDescriptor>> compatibility, BindingTrace trace, KtNamedDeclaration reportOn, MemberDescriptor descriptor2) {
        void $this$sortedBy$iv;
        Sequence sequence2 = SequencesKt.map(SequencesKt.flattenSequenceOfIterable(SequencesKt.map(SequencesKt.filter(MapsKt.asSequence(compatibility), (Function1)new Function1<Map.Entry<? extends ExpectedActualResolver.Compatibility, ? extends List<? extends MemberDescriptor>>, Boolean>(this){
            final /* synthetic */ ExpectedActualDeclarationChecker this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final boolean invoke(@NotNull Map.Entry<? extends ExpectedActualResolver.Compatibility, ? extends List<? extends MemberDescriptor>> $dstr$compatibility$_u24__u24) {
                Intrinsics.checkNotNullParameter($dstr$compatibility$_u24__u24, "$dstr$compatibility$_u24__u24");
                Map.Entry<? extends ExpectedActualResolver.Compatibility, ? extends List<? extends MemberDescriptor>> entry = $dstr$compatibility$_u24__u24;
                boolean bl = false;
                ExpectedActualResolver.Compatibility compatibility = entry.getKey();
                return ExpectedActualDeclarationChecker.access$isCompatibleOrWeakCompatible(this.this$0, compatibility);
            }
        }), checkAmbiguousExpects.filesWithAtLeastWeaklyCompatibleExpects.2.INSTANCE)), checkAmbiguousExpects.filesWithAtLeastWeaklyCompatibleExpects.3.INSTANCE);
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        List filesWithAtLeastWeaklyCompatibleExpects2 = SequencesKt.toList(SequencesKt.sortedWith($this$sortedBy$iv, new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                ModuleDescriptor it = (ModuleDescriptor)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getName().asString());
                it = (ModuleDescriptor)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string2 = it.getName().asString();
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)string2));
            }
        }));
        if (filesWithAtLeastWeaklyCompatibleExpects2.size() > 1) {
            trace.report(Errors.AMBIGUOUS_EXPECTS.on((KtNamedDeclaration)((PsiElement)reportOn), descriptor2, filesWithAtLeastWeaklyCompatibleExpects2));
        }
    }

    private final boolean isCompatibleOrWeakCompatible(ExpectedActualResolver.Compatibility $this$isCompatibleOrWeakCompatible) {
        return $this$isCompatibleOrWeakCompatible instanceof ExpectedActualResolver.Compatibility.Compatible || $this$isCompatibleOrWeakCompatible instanceof ExpectedActualResolver.Compatibility.Incompatible && ((ExpectedActualResolver.Compatibility.Incompatible)$this$isCompatibleOrWeakCompatible).getKind() == ExpectedActualResolver.Compatibility.IncompatibilityKind.WEAK;
    }

    private final boolean requireActualModifier(MemberDescriptor descriptor2) {
        return !DescriptorUtilsKt.isAnnotationConstructor(descriptor2) && !DescriptorUtilsKt.isPrimaryConstructorOfInlineClass(descriptor2) && !this.isUnderlyingPropertyOfInlineClass(descriptor2);
    }

    private final boolean isUnderlyingPropertyOfInlineClass(MemberDescriptor descriptor2) {
        return descriptor2 instanceof PropertyDescriptor && InlineClassesUtilsKt.isUnderlyingPropertyOfInlineClass((VariableDescriptor)((Object)descriptor2));
    }

    private final boolean isExplicitActualDeclaration(MemberDescriptor $this$isExplicitActualDeclaration) {
        MemberDescriptor memberDescriptor = $this$isExplicitActualDeclaration;
        return memberDescriptor instanceof ConstructorDescriptor ? DescriptorToSourceUtils.getSourceFromDescriptor($this$isExplicitActualDeclaration) instanceof KtConstructor : (memberDescriptor instanceof CallableMemberDescriptor ? ((CallableMemberDescriptor)$this$isExplicitActualDeclaration).getKind() == CallableMemberDescriptor.Kind.DECLARATION : true);
    }

    private final void checkAnnotationConstructors(ConstructorDescriptor expected, ConstructorDescriptor actual, BindingTrace trace, PsiElement reportOn) {
        for (ValueParameterDescriptor expectedParameterDescriptor : expected.getValueParameters()) {
            PsiElement psiElement;
            KtExpression ktExpression;
            ConstantValue constantValue;
            KtParameter $i$f$first2;
            Object element$iv2;
            block6: {
                List<ValueParameterDescriptor> list2 = actual.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list2, "actual.valueParameters");
                Iterable $this$first$iv = list2;
                boolean $i$f$first2 = false;
                for (Object element$iv2 : $this$first$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getName(), expectedParameterDescriptor.getName())) continue;
                    break block6;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            ValueParameterDescriptor actualParameterDescriptor = (ValueParameterDescriptor)element$iv2;
            if (!expectedParameterDescriptor.declaresDefaultValue() || !actualParameterDescriptor.declaresDefaultValue()) continue;
            Intrinsics.checkNotNullExpressionValue(expectedParameterDescriptor, "expectedParameterDescriptor");
            Object object = DescriptorToSourceUtils.descriptorToDeclaration(expectedParameterDescriptor);
            KtParameter ktParameter = $i$f$first2 = object instanceof KtParameter ? (KtParameter)object : null;
            if ($i$f$first2 == null) continue;
            KtParameter expectedParameter = $i$f$first2;
            object = (CompileTimeConstant)trace.getBindingContext().get(BindingContext.COMPILE_TIME_VALUE, expectedParameter.getDefaultValue());
            if (object == null) {
                constantValue = null;
            } else {
                element$iv2 = expectedParameterDescriptor.getType();
                Intrinsics.checkNotNullExpressionValue(element$iv2, "expectedParameterDescriptor.type");
                constantValue = object.toConstantValue((KotlinType)element$iv2);
            }
            ConstantValue expectedValue = constantValue;
            Intrinsics.checkNotNullExpressionValue(actualParameterDescriptor, "actualParameterDescriptor");
            element$iv2 = trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue(element$iv2, "trace.bindingContext");
            Object object2 = element$iv2;
            element$iv2 = expectedParameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue(element$iv2, "expectedParameterDescriptor.type");
            ConstantValue<?> actualValue = this.getActualAnnotationParameterValue(actualParameterDescriptor, (BindingContext)object2, (KotlinType)element$iv2);
            if (Intrinsics.areEqual(expectedValue, actualValue)) continue;
            PsiElement ktParameter2 = DescriptorToSourceUtils.descriptorToDeclaration(actualParameterDescriptor);
            KtNamedDeclarationStub ktNamedDeclarationStub = ktParameter2 instanceof KtParameter ? (KtParameter)ktParameter2 : null;
            KtExpression ktExpression2 = ktExpression = ktNamedDeclarationStub == null ? null : ((KtParameter)ktNamedDeclarationStub).getDefaultValue();
            if (ktExpression == null) {
                PsiElement psiElement2;
                KtNamedDeclarationStub ktNamedDeclarationStub2 = ktNamedDeclarationStub = reportOn instanceof KtTypeAlias ? (KtTypeAlias)reportOn : null;
                psiElement = ktNamedDeclarationStub == null ? reportOn : ((psiElement2 = ((KtTypeParameterListOwnerStub)ktNamedDeclarationStub).getNameIdentifier()) == null ? reportOn : psiElement2);
            } else {
                psiElement = ktExpression;
            }
            PsiElement psiElement3 = psiElement;
            Intrinsics.checkNotNullExpressionValue(psiElement3, "(ktParameter as? KtParameter)?.defaultValue ?: (reportOn as? KtTypeAlias)?.nameIdentifier ?: reportOn");
            PsiElement target = psiElement3;
            trace.report(Errors.ACTUAL_ANNOTATION_CONFLICTING_DEFAULT_ARGUMENT_VALUE.on(target, actualParameterDescriptor));
        }
    }

    private final ConstantValue<?> getActualAnnotationParameterValue(ValueParameterDescriptor actualParameter, BindingContext bindingContext, KotlinType expectedType2) {
        PsiElement declaration2 = DescriptorToSourceUtils.descriptorToDeclaration(actualParameter);
        if (declaration2 instanceof KtParameter) {
            CompileTimeConstant compileTimeConstant = (CompileTimeConstant)bindingContext.get(BindingContext.COMPILE_TIME_VALUE, ((KtParameter)declaration2).getDefaultValue());
            return compileTimeConstant == null ? null : compileTimeConstant.toConstantValue(expectedType2);
        }
        for (ActualAnnotationArgumentExtractor extractor : this.argumentExtractors) {
            ConstantValue<?> constantValue = extractor.extractDefaultValue(actualParameter, expectedType2);
            if (constantValue == null) continue;
            ConstantValue<?> constantValue2 = constantValue;
            boolean bl = false;
            boolean bl2 = false;
            ConstantValue<?> it = constantValue2;
            boolean bl3 = false;
            return it;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkActualDeclarationHasExpected$hasSingleActualSuspect(ExpectedActualDeclarationChecker this$0, Pair<? extends MemberDescriptor, ? extends Map<ExpectedActualResolver.Compatibility.Incompatible, ? extends Collection<? extends MemberDescriptor>>> expectedWithIncompatibility) {
        Pair<? extends MemberDescriptor, ? extends Map<ExpectedActualResolver.Compatibility.Incompatible, ? extends Collection<? extends MemberDescriptor>>> pair = expectedWithIncompatibility;
        MemberDescriptor expectedMember = pair.component1();
        Map<ExpectedActualResolver.Compatibility.Incompatible, ? extends Collection<? extends MemberDescriptor>> incompatibility = pair.component2();
        Collection collection = (Collection)CollectionsKt.singleOrNull((Iterable)incompatibility.values());
        if (collection == null) {
            return false;
        }
        MemberDescriptor memberDescriptor = (MemberDescriptor)CollectionsKt.singleOrNull(collection);
        MemberDescriptor actualMember = memberDescriptor;
        if (actualMember == null) return false;
        if (!this$0.isExplicitActualDeclaration(actualMember)) return false;
        if (Companion.allStrongIncompatibilities(incompatibility)) return false;
        Object object = ExpectedActualResolver.findExpectedForActual$default(ExpectedActualResolver.INSTANCE, actualMember, DescriptorUtilsKt.getModule(expectedMember), null, 4, null);
        Collection collection2 = collection = object == null ? null : object.values();
        if (!Intrinsics.areEqual(collection == null ? null : ((object = (List)CollectionsKt.singleOrNull(collection)) == null ? null : (MemberDescriptor)CollectionsKt.singleOrNull(object)), expectedMember)) return false;
        return true;
    }

    @JvmStatic
    public static final boolean isOptionalAnnotationClass(@NotNull DeclarationDescriptor descriptor2) {
        return Companion.isOptionalAnnotationClass(descriptor2);
    }

    @JvmStatic
    public static final boolean shouldGenerateExpectClass(@NotNull ClassDescriptor descriptor2) {
        return Companion.shouldGenerateExpectClass(descriptor2);
    }

    public static final /* synthetic */ boolean access$isCompatibleOrWeakCompatible(ExpectedActualDeclarationChecker $this, ExpectedActualResolver.Compatibility $receiver) {
        return $this.isCompatibleOrWeakCompatible($receiver);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001e\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExpectedActualDeclarationChecker$ActualAnnotationArgumentExtractor;", "", "extractDefaultValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "frontend"})
    public static interface ActualAnnotationArgumentExtractor {
        @Nullable
        public ConstantValue<?> extractDefaultValue(@NotNull ValueParameterDescriptor var1, @NotNull KotlinType var2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0007J\u001e\u0010\r\u001a\u00020\b*\u0016\u0012\u0006\b\u0001\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000eJ\u0082\u0001\u0010\u0012\u001a*\u0012\u0004\u0012\u0002H\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160\u00150\u0013j\u0014\u0012\u0004\u0012\u0002H\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160\u0015`\u0017\"\u0004\b\u0000\u0010\u0014\"\u0004\b\u0001\u0010\u0016**\u0012\u0004\u0012\u0002H\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160\u00150\u0013j\u0014\u0012\u0004\u0012\u0002H\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160\u0015`\u00172\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u0002H\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160\u00150\u000eH\u0002J\u0012\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0015*\u00020\u001aH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExpectedActualDeclarationChecker$Companion;", "", "()V", "OPTIONAL_EXPECTATION_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getOPTIONAL_EXPECTATION_FQ_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "isOptionalAnnotationClass", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "shouldGenerateExpectClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "allStrongIncompatibilities", "", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectedActualResolver$Compatibility;", "", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "merge", "Ljava/util/LinkedHashMap;", "K", "", "V", "Lkotlin/collections/LinkedHashMap;", "other", "unwrapModuleInfo", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FqName getOPTIONAL_EXPECTATION_FQ_NAME() {
            return OPTIONAL_EXPECTATION_FQ_NAME;
        }

        @JvmStatic
        public final boolean isOptionalAnnotationClass(@NotNull DeclarationDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            return descriptor2 instanceof ClassDescriptor && ((ClassDescriptor)descriptor2).getKind() == ClassKind.ANNOTATION_CLASS && ((ClassDescriptor)descriptor2).isExpect() && descriptor2.getAnnotations().hasAnnotation(this.getOPTIONAL_EXPECTATION_FQ_NAME());
        }

        @JvmStatic
        public final boolean shouldGenerateExpectClass(@NotNull ClassDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            boolean bl = descriptor2.isExpect();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = Intrinsics.stringPlus("Not an expected class: ", descriptor2);
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            if (this.isOptionalAnnotationClass(descriptor2)) {
                ExpectedActualResolver expectedActualResolver = ExpectedActualResolver.INSTANCE;
                bl2 = false;
                boolean bl4 = false;
                ExpectedActualResolver $this$shouldGenerateExpectClass_u24lambda_u2d1 = expectedActualResolver;
                boolean bl5 = false;
                return $this$shouldGenerateExpectClass_u24lambda_u2d1.findCompatibleActualForExpected(descriptor2, DescriptorUtilsKt.getModule(descriptor2)).isEmpty();
            }
            return false;
        }

        public final boolean allStrongIncompatibilities(@NotNull Map<? extends ExpectedActualResolver.Compatibility, ? extends Collection<? extends MemberDescriptor>> $this$allStrongIncompatibilities) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter($this$allStrongIncompatibilities, "<this>");
                Iterable $this$all$iv = $this$allStrongIncompatibilities.keySet();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        ExpectedActualResolver.Compatibility it = (ExpectedActualResolver.Compatibility)element$iv;
                        boolean bl2 = false;
                        if (it instanceof ExpectedActualResolver.Compatibility.Incompatible && ((ExpectedActualResolver.Compatibility.Incompatible)it).getKind() == ExpectedActualResolver.Compatibility.IncompatibilityKind.STRONG) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

