/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.WFCException;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.in.XmlScanner;
import com.fasterxml.aalto.util.XmlConsts;
import java.io.IOException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public abstract class InputBootstrapper
implements XmlConsts {
    public static final String ERR_XMLDECL_KW_VERSION = "; expected keyword 'version'";
    public static final String ERR_XMLDECL_KW_ENCODING = "; expected keyword 'encoding'";
    public static final String ERR_XMLDECL_KW_STANDALONE = "; expected keyword 'standalone'";
    public static final String ERR_XMLDECL_END_MARKER = "; expected \"?>\" end marker";
    public static final String ERR_XMLDECL_EXP_SPACE = "; expected a white space";
    public static final String ERR_XMLDECL_EXP_EQ = "; expected '=' after ";
    public static final String ERR_XMLDECL_EXP_ATTRVAL = "; expected a quote character enclosing value for ";
    protected int _inputProcessed = 0;
    protected int _inputRow = 0;
    protected int _inputRowStart = 0;
    final ReaderConfig _config;
    int mDeclaredXmlVersion = 0;
    String mFoundEncoding;
    String mStandalone;
    final char[] mKeyword;

    protected InputBootstrapper(ReaderConfig cfg) {
        this._config = cfg;
        this.mKeyword = cfg.allocSmallCBuffer(60);
    }

    public abstract XmlScanner bootstrap() throws XMLStreamException;

    protected void readXmlDeclaration() throws IOException, XMLStreamException {
        int c = this.getNextAfterWs(false);
        if (c != 118) {
            this.reportUnexpectedChar(c, ERR_XMLDECL_KW_VERSION);
        } else {
            this.mDeclaredXmlVersion = this.readXmlVersion();
            c = this.getWsOrChar(63);
        }
        if (c == 101) {
            this.mFoundEncoding = this.readXmlEncoding();
            c = this.getWsOrChar(63);
        }
        if (c == 115) {
            this.mStandalone = this.readXmlStandalone();
            c = this.getWsOrChar(63);
        }
        if (c != 63) {
            this.reportUnexpectedChar(c, ERR_XMLDECL_END_MARKER);
        }
        if ((c = this.getNext()) != 62) {
            this.reportUnexpectedChar(c, ERR_XMLDECL_END_MARKER);
        }
    }

    private final int readXmlVersion() throws IOException, XMLStreamException {
        int len;
        int c = this.checkKeyword("version");
        if (c != 0) {
            this.reportUnexpectedChar(c, "version");
        }
        if ((len = this.readQuotedValue(this.mKeyword, c = this.handleEq("version"))) == 3 && this.mKeyword[0] == '1' && this.mKeyword[1] == '.') {
            c = this.mKeyword[2];
            if (c == 48) {
                return 256;
            }
            if (c == 49) {
                return 272;
            }
        }
        String got = len < 0 ? "'" + new String(this.mKeyword) + "[..]'" : (len == 0 ? "<empty>" : "'" + new String(this.mKeyword, 0, len) + "'");
        this.reportPseudoAttrProblem("version", got, "1.0", "1.1");
        return 0;
    }

    private final String readXmlEncoding() throws IOException, XMLStreamException {
        int len;
        int c = this.checkKeyword("encoding");
        if (c != 0) {
            this.reportUnexpectedChar(c, "encoding");
        }
        if ((len = this.readQuotedValue(this.mKeyword, c = this.handleEq("encoding"))) == 0) {
            this.reportPseudoAttrProblem("encoding", null, null, null);
        }
        if (len < 0) {
            return new String(this.mKeyword);
        }
        return new String(this.mKeyword, 0, len);
    }

    private final String readXmlStandalone() throws IOException, XMLStreamException {
        int len;
        int c = this.checkKeyword("standalone");
        if (c != 0) {
            this.reportUnexpectedChar(c, "standalone");
        }
        if ((len = this.readQuotedValue(this.mKeyword, c = this.handleEq("standalone"))) == 2) {
            if (this.mKeyword[0] == 'n' && this.mKeyword[1] == 'o') {
                return "no";
            }
        } else if (len == 3 && this.mKeyword[0] == 'y' && this.mKeyword[1] == 'e' && this.mKeyword[2] == 's') {
            return "yes";
        }
        String got = len < 0 ? "'" + new String(this.mKeyword) + "[..]'" : (len == 0 ? "<empty>" : "'" + new String(this.mKeyword, 0, len) + "'");
        this.reportPseudoAttrProblem("standalone", got, "yes", "no");
        return got;
    }

    private final int handleEq(String attr) throws IOException, XMLStreamException {
        int c = this.getNextAfterWs(false);
        if (c != 61) {
            this.reportUnexpectedChar(c, "; expected '=' after '" + attr + "'");
        }
        if ((c = this.getNextAfterWs(false)) != 34 && c != 39) {
            this.reportUnexpectedChar(c, "; expected a quote character enclosing value for '" + attr + "'");
        }
        return c;
    }

    private final int getWsOrChar(int ok) throws IOException, XMLStreamException {
        int c = this.getNext();
        if (c == ok) {
            return c;
        }
        if (c > 32) {
            this.reportUnexpectedChar(c, "; expected either '" + (char)ok + "' or white space");
        }
        if (c == 10 || c == 13) {
            this.pushback();
        }
        return this.getNextAfterWs(false);
    }

    protected abstract void pushback();

    protected abstract int getNext() throws IOException, XMLStreamException;

    protected abstract int getNextAfterWs(boolean var1) throws IOException, XMLStreamException;

    protected abstract int checkKeyword(String var1) throws IOException, XMLStreamException;

    protected abstract int readQuotedValue(char[] var1, int var2) throws IOException, XMLStreamException;

    protected abstract Location getLocation();

    protected void reportXmlProblem(String msg) throws XMLStreamException {
        throw new WFCException(msg, this.getLocation());
    }

    protected void reportNull() throws XMLStreamException {
        this.reportXmlProblem("Illegal null byte/char in input stream");
    }

    protected void reportEof() throws XMLStreamException {
        this.reportXmlProblem("Unexpected end-of-input in xml declaration");
    }

    protected void reportUnexpectedChar(int i, String msg) throws XMLStreamException {
        String excMsg = Character.isISOControl((char)i) ? "Unexpected character (CTRL-CHAR, code " + i + ")" + msg : "Unexpected character '" + (char)i + "' (code " + i + ")" + msg;
        this.reportXmlProblem(excMsg);
    }

    protected final void reportPseudoAttrProblem(String attrName, String got, String expVal1, String expVal2) throws XMLStreamException {
        String expStr;
        String string = expStr = expVal1 == null ? "" : "; expected \"" + expVal1 + "\" or \"" + expVal2 + "\"";
        if (got == null || got.length() == 0) {
            this.reportXmlProblem("Missing XML pseudo-attribute '" + attrName + "' value" + expStr);
        }
        this.reportXmlProblem("Invalid XML pseudo-attribute '" + attrName + "' value " + got + expStr);
    }
}

