/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomMetaData;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class DomNameSuggestionProvider
implements NameSuggestionProvider {
    public SuggestedNameInfo getSuggestedNames(PsiElement element, PsiElement nameSuggestionContext, Set<String> result) {
        PsiMetaData psiMetaData;
        if (element instanceof PsiMetaOwner && (psiMetaData = ((PsiMetaOwner)element).getMetaData()) instanceof DomMetaData) {
            DomMetaData domMetaData = (DomMetaData)psiMetaData;
            GenericDomValue value = domMetaData.getNameElement(domMetaData.getElement());
            ContainerUtil.addIfNotNull(result, (Object)DomNameSuggestionProvider.getNameFromNameValue(value, true));
        }
        return null;
    }

    @Nullable
    private static String getNameFromNameValue(Object o, boolean local) {
        if (o == null || o instanceof String) {
            return (String)o;
        }
        if (o instanceof GenericValue) {
            Object name;
            GenericValue value = (GenericValue)o;
            if (!local && (name = value.getValue()) != null) {
                return String.valueOf(name);
            }
            return value.getStringValue();
        }
        return String.valueOf(o);
    }
}

