/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.config;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ReferenceType;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.groovy.scripts.TextResourceScriptSource;
import org.gradle.internal.file.RelativeFilePathResolver;
import org.gradle.internal.resource.DefaultTextFileResourceLoader;
import org.gradle.internal.resource.TextResource;
import org.gradle.internal.resource.UriTextResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.config.GradleScriptType;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.extensions.debugger.ScriptPositionManagerHelper;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.runner.GroovyScriptUtil;

public class GradlePositionManager
extends ScriptPositionManagerHelper {
    private static final Key<CachedValue<Map<File, String>>> GRADLE_CLASS_NAME = Key.create((String)"GRADLE_CLASS_NAME");

    public boolean isAppropriateRuntimeName(@NotNull String runtimeName) {
        if (runtimeName == null) {
            GradlePositionManager.$$$reportNull$$$0(0);
        }
        return true;
    }

    public boolean isAppropriateScriptFile(@NotNull GroovyFile scriptFile) {
        if (scriptFile == null) {
            GradlePositionManager.$$$reportNull$$$0(1);
        }
        return GroovyScriptUtil.isSpecificScriptFile((GroovyFile)scriptFile, (GroovyScriptType)GradleScriptType.INSTANCE);
    }

    @NotNull
    public String getRuntimeScriptName(@NotNull GroovyFile groovyFile) {
        VirtualFile virtualFile;
        if (groovyFile == null) {
            GradlePositionManager.$$$reportNull$$$0(2);
        }
        if ((virtualFile = groovyFile.getVirtualFile()) == null) {
            return "";
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)groovyFile);
        if (module == null) {
            return "";
        }
        File scriptFile = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
        String className = (String)((Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, GRADLE_CLASS_NAME, (CachedValueProvider)new ScriptSourceMapCalculator(module), false)).get(scriptFile);
        String string = className == null ? "" : className;
        if (string == null) {
            GradlePositionManager.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public String customizeClassName(@NotNull PsiClass psiClass) {
        PsiFile file;
        if (psiClass == null) {
            GradlePositionManager.$$$reportNull$$$0(4);
        }
        if ((file = psiClass.getContainingFile()) instanceof GroovyFile) {
            return this.getRuntimeScriptName((GroovyFile)file);
        }
        return null;
    }

    public PsiFile getExtraScriptIfNotFound(@NotNull ReferenceType refType, @NotNull String runtimeName, @NotNull Project project, @NotNull GlobalSearchScope scope2) {
        String sourceFilePath;
        if (refType == null) {
            GradlePositionManager.$$$reportNull$$$0(5);
        }
        if (runtimeName == null) {
            GradlePositionManager.$$$reportNull$$$0(6);
        }
        if (project == null) {
            GradlePositionManager.$$$reportNull$$$0(7);
        }
        if (scope2 == null) {
            GradlePositionManager.$$$reportNull$$$0(8);
        }
        if ((sourceFilePath = GradlePositionManager.getScriptForClassName(refType)) == null) {
            return null;
        }
        sourceFilePath = GradlePositionManager.getLocalFilePath(project, sourceFilePath);
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)sourceFilePath));
        if (virtualFile == null) {
            return null;
        }
        return PsiManager.getInstance((Project)project).findFile(virtualFile);
    }

    private static String getLocalFilePath(@NotNull Project project, @NotNull String sourceFilePath) {
        String windowsPath;
        WSLDistribution wslDistribution;
        String projectBasePath;
        if (project == null) {
            GradlePositionManager.$$$reportNull$$$0(9);
        }
        if (sourceFilePath == null) {
            GradlePositionManager.$$$reportNull$$$0(10);
        }
        if ((projectBasePath = project.getBasePath()) != null && WslDistributionManager.isWslPath((String)projectBasePath) && (wslDistribution = WslPath.getDistributionByWindowsUncPath((String)projectBasePath)) != null && (windowsPath = wslDistribution.getWindowsPath(sourceFilePath)) != null) {
            sourceFilePath = windowsPath;
        }
        return sourceFilePath;
    }

    @Nullable
    private static String getScriptForClassName(@NotNull ReferenceType refType) {
        if (refType == null) {
            GradlePositionManager.$$$reportNull$$$0(11);
        }
        try {
            List<String> data = refType.sourcePaths(null);
            if (!data.isEmpty()) {
                return data.get(0);
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtimeName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groovyFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/config/GradlePositionManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refType";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/config/GradlePositionManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeScriptName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAppropriateRuntimeName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAppropriateScriptFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRuntimeScriptName";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "customizeClassName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getExtraScriptIfNotFound";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLocalFilePath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getScriptForClassName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ScriptSourceMapCalculator
    implements CachedValueProvider<Map<File, String>> {
        private final Module myModule;

        ScriptSourceMapCalculator(Module module) {
            this.myModule = module;
        }

        public CachedValueProvider.Result<Map<File, String>> compute() {
            ConcurrentMap result = ConcurrentFactoryMap.createMap(ScriptSourceMapCalculator::calcClassName);
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{ProjectRootManager.getInstance((Project)this.myModule.getProject())});
        }

        @Nullable
        private static String calcClassName(File scriptFile) {
            TextResource resource = ScriptSourceMapCalculator.getResource(scriptFile);
            return new TextResourceScriptSource(resource).getClassName();
        }

        private static TextResource getResource(File scriptFile) {
            TextResource resource = null;
            if (WslDistributionManager.isWslPath((String)scriptFile.getPath())) {
                resource = ScriptSourceMapCalculator.getWslUriResource(scriptFile);
            }
            if (resource == null) {
                resource = new DefaultTextFileResourceLoader((RelativeFilePathResolver)new IdentityFileResolver()).loadFile("script", scriptFile);
            }
            return resource;
        }

        @Nullable
        private static TextResource getWslUriResource(@NotNull File scriptFile) {
            WSLDistribution wslDistribution;
            if (scriptFile == null) {
                ScriptSourceMapCalculator.$$$reportNull$$$0(0);
            }
            if ((wslDistribution = WslPath.getDistributionByWindowsUncPath((String)scriptFile.getPath())) == null) {
                return null;
            }
            String wslPath = wslDistribution.getWslPath(scriptFile.getPath());
            if (wslPath == null) {
                return null;
            }
            return new UriTextResource("script", ScriptSourceMapCalculator.pathToUri(wslPath), (RelativeFilePathResolver)new IdentityFileResolver());
        }

        @Nullable
        private static URI pathToUri(@NotNull String path) {
            if (path == null) {
                ScriptSourceMapCalculator.$$$reportNull$$$0(1);
            }
            try {
                String p = ScriptSourceMapCalculator.slashify(path);
                return new URI("file", null, (String)(p.startsWith("//") ? "//" + p : p), null);
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }

        private static String slashify(String path) {
            String name = FileUtil.toSystemIndependentName((String)path);
            return name.startsWith("/") ? name : "/" + name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scriptFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/gradle/config/GradlePositionManager$ScriptSourceMapCalculator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getWslUriResource";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "pathToUri";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

