/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.compilers.Javac13;
import org.apache.tools.ant.taskdefs.condition.AntVersion;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ant.Kotlin2JvmTask;
import org.jetbrains.kotlin.ant.KotlinAntTaskUtil;
import org.jetbrains.kotlin.ant.KotlinAntTaskUtilKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\u0006\u0010\u0015\u001a\u00020\u0005J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0013\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aR \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/ant/KotlinCompilerAdapter;", "Lorg/apache/tools/ant/taskdefs/compilers/Javac13;", "()V", "additionalArguments", "", "Lorg/apache/tools/ant/types/Commandline$Argument;", "getAdditionalArguments", "()Ljava/util/List;", "setAdditionalArguments", "(Ljava/util/List;)V", "moduleName", "", "getModuleName", "()Ljava/lang/String;", "setModuleName", "(Ljava/lang/String;)V", "addRuntimeToJavacClasspath", "", "kotlinc", "Lorg/jetbrains/kotlin/ant/Kotlin2JvmTask;", "checkAntVersion", "createCompilerArg", "execute", "", "getSupportedFileExtensions", "", "()[Ljava/lang/String;", "Companion", "kotlin-ant"})
public final class KotlinCompilerAdapter
extends Javac13 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String moduleName;
    @NotNull
    private List<Commandline.Argument> additionalArguments = new ArrayList(0);
    @NotNull
    private static final List<String> KOTLIN_EXTENSIONS;

    @Nullable
    public final String getModuleName() {
        return this.moduleName;
    }

    public final void setModuleName(@Nullable String string) {
        this.moduleName = string;
    }

    @NotNull
    public final List<Commandline.Argument> getAdditionalArguments() {
        return this.additionalArguments;
    }

    public final void setAdditionalArguments(@NotNull List<Commandline.Argument> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.additionalArguments = list;
    }

    @NotNull
    public final Commandline.Argument createCompilerArg() {
        Commandline.Argument argument = new Commandline.Argument();
        this.additionalArguments.add(argument);
        return argument;
    }

    @NotNull
    public String[] getSupportedFileExtensions() {
        String[] stringArray = super.getSupportedFileExtensions();
        Intrinsics.checkNotNullExpressionValue(stringArray, "super.getSupportedFileExtensions()");
        return (String[])ArraysKt.plus((Object[])stringArray, (Collection)KOTLIN_EXTENSIONS);
    }

    public boolean execute() throws BuildException {
        boolean hasKotlinFilesInSources;
        if (this.getJavac().isForkedJavac()) {
            this.getJavac().log("<withKotlin> task does not yet support the fork mode", 0);
            return false;
        }
        Javac javac = this.getJavac();
        this.checkAntVersion();
        Kotlin2JvmTask kotlinc = new Kotlin2JvmTask();
        kotlinc.setFailOnError(javac.getFailonerror());
        kotlinc.setOutput(javac.getDestdir());
        Path classpath = javac.getClasspath();
        if (classpath != null) {
            kotlinc.setClasspath(classpath);
        }
        kotlinc.setSrc(javac.getSrcdir());
        if (this.moduleName == null) {
            Intrinsics.checkNotNullExpressionValue(javac, "javac");
            this.moduleName = KotlinAntTaskUtilKt.getDefaultModuleName((Task)javac);
        }
        kotlinc.setModuleName(this.moduleName);
        kotlinc.getAdditionalArguments().addAll((Collection<Commandline.Argument>)this.additionalArguments);
        File[] fileArray = this.compileList;
        Intrinsics.checkNotNullExpressionValue(fileArray, "compileList");
        File[] compileListForJavac = KotlinCompilerAdapter.Companion.filterOutKotlinSources(fileArray);
        boolean bl = hasKotlinFilesInSources = compileListForJavac.length < this.compileList.length;
        if (hasKotlinFilesInSources) {
            kotlinc.execute();
            Integer n = kotlinc.getExitCode();
            boolean bl2 = false;
            if (n == null || n != 0) {
                return false;
            }
        } else {
            kotlinc.fillArguments();
        }
        javac.log("Running javac...");
        this.compileList = compileListForJavac;
        this.addRuntimeToJavacClasspath(kotlinc);
        Object[] objectArray = this.compileList;
        Intrinsics.checkNotNullExpressionValue(objectArray, "compileList");
        objectArray = objectArray;
        boolean bl3 = false;
        return objectArray.length == 0 || super.execute();
    }

    private final void addRuntimeToJavacClasspath(Kotlin2JvmTask kotlinc) {
        boolean addReflect;
        boolean addStdlib = !kotlinc.getArgs().contains("-no-stdlib");
        boolean bl = addReflect = !kotlinc.getArgs().contains("-no-reflect");
        if (!addStdlib && !addReflect) {
            return;
        }
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        if (addStdlib) {
            this.compileClasspath.add(new Path(this.getProject(), KotlinAntTaskUtil.INSTANCE.getRuntimeJar().getAbsolutePath()));
        }
        if (addReflect && addStdlib) {
            this.compileClasspath.add(new Path(this.getProject(), KotlinAntTaskUtil.INSTANCE.getReflectJar().getAbsolutePath()));
        }
    }

    private final void checkAntVersion() {
        AntVersion checkVersion = new AntVersion();
        checkVersion.setAtLeast("1.8.2");
        if (!checkVersion.eval()) {
            this.getJavac().log(Intrinsics.stringPlus("<withKotlin> task requires Ant of version at least 1.8.2 to operate reliably. Please upgrade or, as a workaround, make sure you have at least one Java source and the output directory is clean before running this task. You have: ", this.getProject().getProperty("ant.version")), 1);
        }
    }

    static {
        String[] stringArray = new String[]{"kt", "kts"};
        KOTLIN_EXTENSIONS = CollectionsKt.listOf(stringArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a2\u0006\u0002\u0010\nR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/ant/KotlinCompilerAdapter$Companion;", "", "()V", "KOTLIN_EXTENSIONS", "", "", "filterOutKotlinSources", "", "Ljava/io/File;", "files", "([Ljava/io/File;)[Ljava/io/File;", "kotlin-ant"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final File[] filterOutKotlinSources(File[] files) {
            void $this$filterNotTo$iv$iv;
            File[] $this$filterNot$iv = files;
            boolean $i$f$filterNot = false;
            File[] fileArray = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            void var7_7 = $this$filterNotTo$iv$iv;
            int n = ((void)var7_7).length;
            for (int i = 0; i < n; ++i) {
                boolean bl;
                void element$iv$iv;
                block3: {
                    void it = element$iv$iv = var7_7[i];
                    boolean bl2 = false;
                    for (String extension : KOTLIN_EXTENSIONS) {
                        String string = it.getPath();
                        Intrinsics.checkNotNullExpressionValue(string, "it.path");
                        if (!StringsKt.endsWith$default(string, Intrinsics.stringPlus(".", extension), false, 2, null)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
                if (bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            File[] fileArray2 = thisCollection$iv.toArray(new File[0]);
            if (fileArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return fileArray2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

