/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.context;

import com.intellij.codeInsight.daemon.impl.analysis.CreateNSDeclarationIntentionFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.intellij.lang.xpath.context.NamespaceContext;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.impl.XsltChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsltNamespaceContext
implements NamespaceContext {
    public static final XsltNamespaceContext NAMESPACE_CONTEXT = new XsltNamespaceContext();

    @Override
    public String getNamespaceURI(String prefix, XmlElement context) {
        return XsltNamespaceContext.getNamespaceUriStatic(prefix, context);
    }

    @Nullable
    public static String getNamespaceUriStatic(String prefix, XmlElement context) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class);
        return tag != null ? tag.getNamespaceByPrefix(prefix) : null;
    }

    @Override
    @Nullable
    public String getPrefixForURI(String uri, XmlElement context) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class);
        return tag != null ? tag.getPrefixByNamespace(uri) : null;
    }

    @Override
    @NotNull
    public Collection<String> getKnownPrefixes(XmlElement context) {
        Collection<String> collection = XsltNamespaceContext.getPrefixes(context);
        if (collection == null) {
            XsltNamespaceContext.$$$reportNull$$$0(0);
        }
        return collection;
    }

    public static Collection<String> getPrefixes(XmlElement context) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class);
        if (tag != null) {
            String[] uris;
            HashSet<String> allPrefixes = new HashSet<String>();
            for (String uri : uris = tag.knownNamespaces()) {
                for (XmlTag p = tag; p != null; p = p.getParentTag()) {
                    Set localPrefixes = p.getLocalNamespaceDeclarations().entrySet();
                    for (Map.Entry entry : localPrefixes) {
                        String prefix = (String)entry.getKey();
                        if (prefix.isEmpty() || !((String)entry.getValue()).equals(uri)) continue;
                        allPrefixes.add(prefix);
                    }
                }
            }
            return allPrefixes;
        }
        return Collections.emptySet();
    }

    @Override
    @Nullable
    public PsiElement resolve(String prefix, XmlElement context) {
        return XsltNamespaceContext.resolvePrefix(prefix, context);
    }

    @Nullable
    public static PsiElement resolvePrefix(final String prefix, XmlElement context) {
        String name = "xmlns:" + prefix;
        XmlTag parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class);
        while (parent != null) {
            final XmlAttribute attribute = parent.getAttribute(name, null);
            if (attribute != null) {
                TextRange textRange = TextRange.from((int)"xmlns:".length(), (int)prefix.length());
                return new SchemaPrefix(attribute, textRange, prefix){

                    public boolean equals(Object obj) {
                        if (obj instanceof SchemaPrefix) {
                            SchemaPrefix p = (SchemaPrefix)obj;
                            return prefix.equals(p.getName()) && p.getParent() == attribute;
                        }
                        return super.equals(obj);
                    }
                };
            }
            parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)parent, XmlTag.class);
        }
        return null;
    }

    @Override
    public IntentionAction[] getUnresolvedNamespaceFixes(@NotNull PsiReference reference, String localName) {
        if (reference == null) {
            XsltNamespaceContext.$$$reportNull$$$0(1);
        }
        return XsltNamespaceContext.getUnresolvedNamespaceFixesStatic(reference, localName);
    }

    @Override
    public String getDefaultNamespace(XmlElement context) {
        if (context != null && XsltSupport.getXsltLanguageLevel(context.getContainingFile()) == XsltChecker.LanguageLevel.V2 && (context = (XmlElement)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class, (boolean)false)) != null) {
            do {
                XmlTag tag;
                String uri;
                if ((uri = (tag = (XmlTag)context).getAttributeValue("xpath-default-namespace", null)) == null && (uri = tag.getAttributeValue("xpath-default-namespace", "http://www.w3.org/1999/XSL/Transform")) == null) continue;
                return !uri.isEmpty() ? uri : null;
            } while ((context = (XmlElement)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class, (boolean)true)) != null);
        }
        return null;
    }

    public static IntentionAction[] getUnresolvedNamespaceFixesStatic(PsiReference reference, String localName) {
        IntentionAction[] intentionActionArray;
        PsiElement element = reference.getElement();
        XmlElementFactory factory = XmlElementFactory.getInstance((Project)element.getProject());
        XmlTag tag = factory.createTagFromText((CharSequence)("<" + reference.getCanonicalText() + ":" + localName + " />"), (Language)XMLLanguage.INSTANCE);
        XmlFile xmlFile = (XmlFile)PsiTreeUtil.getContextOfType((PsiElement)element, XmlFile.class, (boolean)true);
        if (xmlFile == null) {
            intentionActionArray = IntentionAction.EMPTY_ARRAY;
        } else {
            IntentionAction[] intentionActionArray2 = new IntentionAction[1];
            intentionActionArray = intentionActionArray2;
            intentionActionArray2[0] = new MyCreateNSDeclarationAction((XmlElement)tag, reference.getCanonicalText(), xmlFile);
        }
        return intentionActionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/context/XsltNamespaceContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKnownPrefixes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/context/XsltNamespaceContext";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUnresolvedNamespaceFixes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyCreateNSDeclarationAction
    extends CreateNSDeclarationIntentionFix {
        private final SmartPsiElementPointer<XmlFile> myXmlFile;

        MyCreateNSDeclarationAction(@NotNull XmlElement xmlElement, String prefix, @NotNull XmlFile xmlFile) {
            if (xmlElement == null) {
                MyCreateNSDeclarationAction.$$$reportNull$$$0(0);
            }
            if (xmlFile == null) {
                MyCreateNSDeclarationAction.$$$reportNull$$$0(1);
            }
            super((PsiElement)xmlElement, prefix);
            this.myXmlFile = SmartPointerManager.createPointer((PsiElement)xmlFile);
        }

        public void invoke(@NotNull Project project, Editor editor, @NotNull PsiFile psiFile) throws IncorrectOperationException {
            XmlFile xmlFile;
            if (project == null) {
                MyCreateNSDeclarationAction.$$$reportNull$$$0(2);
            }
            if (psiFile == null) {
                MyCreateNSDeclarationAction.$$$reportNull$$$0(3);
            }
            if ((xmlFile = (XmlFile)this.myXmlFile.getElement()) != null) {
                super.invoke(project, editor, (PsiFile)xmlFile);
            }
        }

        public boolean showHint(@NotNull Editor editor) {
            if (editor == null) {
                MyCreateNSDeclarationAction.$$$reportNull$$$0(4);
            }
            return false;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
            XmlFile xmlFile;
            if (project == null) {
                MyCreateNSDeclarationAction.$$$reportNull$$$0(5);
            }
            return (xmlFile = (XmlFile)this.myXmlFile.getElement()) != null && super.isAvailable(project, editor, (PsiFile)xmlFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "xmlElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "xmlFile";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "org/intellij/lang/xpath/xslt/context/XsltNamespaceContext$MyCreateNSDeclarationAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invoke";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showHint";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

