/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;

public class ConvertIfToChooseIntention
implements IntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = XPathBundle.message("intention.family.name.convert.if.to.choose", new Object[0]);
        if (string == null) {
            ConvertIfToChooseIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            ConvertIfToChooseIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            ConvertIfToChooseIntention.$$$reportNull$$$0(2);
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        assert (element != null);
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        assert (tag != null && tag.getLocalName().equals("if"));
        String test = tag.getAttributeValue("test");
        String body = tag.getValue().getText();
        XmlTag parentTag = tag.getParentTag();
        assert (parentTag != null);
        XmlTag chooseTag = parentTag.createChildTag("choose", "http://www.w3.org/1999/XSL/Transform", null, false);
        XmlTag whenTag = parentTag.createChildTag("when", "http://www.w3.org/1999/XSL/Transform", body, false);
        XmlTag otherwiseTag = parentTag.createChildTag("otherwise", "http://www.w3.org/1999/XSL/Transform", "\n\n", false);
        whenTag.setAttribute("test", test);
        chooseTag.add((PsiElement)whenTag);
        chooseTag.add((PsiElement)otherwiseTag);
        CodeStyleManager.getInstance((Project)tag.getManager().getProject()).reformat(tag.replace((PsiElement)chooseTag));
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ConvertIfToChooseIntention.$$$reportNull$$$0(3);
        }
        if (!XsltSupport.isXsltFile(file)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return false;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (tag == null || tag.getParentTag() == null) {
            return false;
        }
        if (!tag.getLocalName().equals("if") || !XsltSupport.isXsltTag(tag)) {
            return false;
        }
        if (tag.getAttributeValue("test") == null) {
            return false;
        }
        ASTNode node = tag.getNode();
        if (node == null) {
            return false;
        }
        ASTNode child = XmlChildRole.START_TAG_NAME_FINDER.findChild(node);
        return child != null && child.getTextRange().contains(offset);
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/intentions/ConvertIfToChooseIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/intentions/ConvertIfToChooseIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

