/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.run;

import com.intellij.DynamicBundle;
import com.intellij.execution.impl.CheckableRunConfigurationEditor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.ModuleFileType;
import com.intellij.ide.highlighter.ProjectFileType;
import com.intellij.ide.highlighter.WorkspaceFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.impl.FileTypeRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.SdkComboBox;
import com.intellij.openapi.roots.ui.configuration.SdkComboBoxModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.associations.FileAssociationsManager;
import org.intellij.lang.xpath.xslt.associations.impl.AnyXMLDescriptor;
import org.intellij.lang.xpath.xslt.run.XsltRunConfiguration;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XsltRunSettingsEditor
extends SettingsEditor<XsltRunConfiguration>
implements CheckableRunConfigurationEditor<XsltRunConfiguration> {
    static final boolean ALLOW_CHOOSING_SDK = !(StdFileTypes.JAVA instanceof PlainTextFileType);
    private final Project myProject;
    private Editor myEditor;

    public void checkEditorData(XsltRunConfiguration s) {
    }

    XsltRunSettingsEditor(Project project) {
        this.myProject = project;
    }

    protected void resetEditorFrom(@NotNull XsltRunConfiguration s) {
        if (s == null) {
            XsltRunSettingsEditor.$$$reportNull$$$0(0);
        }
        this.myEditor.resetFrom(s);
    }

    protected void applyEditorTo(@NotNull XsltRunConfiguration s) throws ConfigurationException {
        if (s == null) {
            XsltRunSettingsEditor.$$$reportNull$$$0(1);
        }
        this.myEditor.applyTo(s);
    }

    @NotNull
    protected JComponent createEditor() {
        this.myEditor = new Editor(this.myProject);
        JComponent jComponent = this.myEditor.getComponent();
        if (jComponent == null) {
            XsltRunSettingsEditor.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    protected void disposeEditor() {
        this.myEditor = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/run/XsltRunSettingsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/run/XsltRunSettingsEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Editor
    implements PanelWithAnchor {
        private JTabbedPane myComponent;
        private TextFieldWithBrowseButton myXsltFile;
        private ComboboxWithBrowseButton myXmlInputFile;
        private TextFieldWithBrowseButton myOutputFile;
        private JCheckBox myOpenOutputFile;
        private JCheckBox myOpenInBrowser;
        private final JBTable myParameters;
        private ButtonGroup myOutputOptions;
        private JBRadioButton myShowInConsole;
        private JCheckBox mySaveToFile;
        private JRadioButton myShowInStdout;
        private RawCommandLineEditor myVmArguments;
        private JCheckBox mySmartErrorHandling;
        private TextFieldWithBrowseButton myWorkingDirectory;
        private ButtonGroup myJdkOptions;
        private JRadioButton myJdkChoice;
        private JRadioButton myModuleChoice;
        private ComboBox<Object> myModule;
        private SdkComboBox myJDK;
        private ComboBox<FileType> myFileType;
        private JPanel myClasspathAndJDKPanel;
        private JPanel myPanelSettings;
        private JPanel myPanelAdvanced;
        private JBLabel myXSLTScriptFileLabel;
        private JPanel myParametersPanel;
        private JComponent anchor;
        private final AnyXMLDescriptor myXmlDescriptor;
        private final FileChooserDescriptor myXsltDescriptor;

        Editor(final Project project) {
            this.$$$setupUI$$$();
            final PsiManager psiManager = PsiManager.getInstance((Project)project);
            this.myXsltDescriptor = new FileChooserDescriptor(true, false, false, false, false, false){

                public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    if (!super.isFileVisible(file, showHiddenFiles)) {
                        return false;
                    }
                    return (Boolean)ReadAction.compute(() -> {
                        PsiFile psiFile = psiManager.findFile(file);
                        return psiFile != null && XsltSupport.isXsltFile(psiFile);
                    });
                }
            };
            TextComponentAccessor<JTextField> projectDefaultAccessor = new TextComponentAccessor<JTextField>(){

                public String getText(JTextField component) {
                    String text = component.getText();
                    VirtualFile baseDir = project.getBaseDir();
                    return text.length() > 0 ? text : (baseDir != null ? baseDir.getPresentableUrl() : "");
                }

                public void setText(JTextField component, @NotNull String text) {
                    if (text == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    component.setText(text);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/intellij/lang/xpath/xslt/run/XsltRunSettingsEditor$Editor$2", "setText"));
                }
            };
            this.myXsltFile.addBrowseFolderListener(XPathBundle.message("dialog.title.choose.xslt.file", new Object[0]), null, project, this.myXsltDescriptor, (TextComponentAccessor)projectDefaultAccessor);
            this.myXsltFile.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){
                final VirtualFileManager fileMgr = VirtualFileManager.getInstance();
                final FileAssociationsManager associationsManager = FileAssociationsManager.getInstance(project);

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    String text = myXsltFile.getText();
                    JComboBox comboBox = myXmlInputFile.getComboBox();
                    String oldXml = this.getXmlInputFile();
                    if (text.length() != 0) {
                        PsiFile psiFile;
                        ComboBoxModel model = comboBox.getModel();
                        boolean found = false;
                        for (int i = 0; i < model.getSize(); ++i) {
                            if (!oldXml.equals(model.getElementAt(i))) continue;
                            found = true;
                        }
                        VirtualFile virtualFile = this.fileMgr.findFileByUrl(VfsUtil.pathToUrl((String)text.replace(File.separatorChar, '/')));
                        if (virtualFile != null && (psiFile = psiManager.findFile(virtualFile)) != null) {
                            PsiFile[] files = this.associationsManager.getAssociationsFor(psiFile);
                            String[] associations = new String[files.length];
                            for (int i = 0; i < files.length; ++i) {
                                VirtualFile f = files[i].getVirtualFile();
                                assert (f != null);
                                associations[i] = f.getPath().replace('/', File.separatorChar);
                            }
                            comboBox.setModel(new DefaultComboBoxModel<String>(associations));
                        }
                        if (!found) {
                            comboBox.getEditor().setItem(oldXml);
                        }
                        comboBox.setSelectedItem(oldXml);
                    } else {
                        comboBox.setModel(new DefaultComboBoxModel<Object>(ArrayUtilRt.EMPTY_OBJECT_ARRAY));
                        comboBox.getEditor().setItem(oldXml);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/lang/xpath/xslt/run/XsltRunSettingsEditor$Editor$3", "textChanged"));
                }
            });
            this.myXmlInputFile.getComboBox().setEditable(true);
            this.myXmlDescriptor = new AnyXMLDescriptor(false);
            this.myXmlInputFile.addBrowseFolderListener(XPathBundle.message("dialog.title.choose.xml.file", new Object[0]), null, project, (FileChooserDescriptor)this.myXmlDescriptor, (TextComponentAccessor)new TextComponentAccessor<JComboBox>((TextComponentAccessor)projectDefaultAccessor){
                final /* synthetic */ TextComponentAccessor val$projectDefaultAccessor;
                {
                    this.val$projectDefaultAccessor = textComponentAccessor;
                }

                public String getText(JComboBox comboBox) {
                    Object item = comboBox.getEditor().getItem();
                    if (item.toString().length() == 0) {
                        String text = this.val$projectDefaultAccessor.getText((Component)((JTextField)myXsltFile.getChildComponent()));
                        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(VfsUtil.pathToUrl((String)text.replace(File.separatorChar, '/')));
                        if (file != null && !file.isDirectory()) {
                            VirtualFile parent = file.getParent();
                            assert (parent != null);
                            return parent.getPresentableUrl();
                        }
                    }
                    return item.toString();
                }

                public void setText(JComboBox comboBox, @NotNull String text) {
                    if (text == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    comboBox.getEditor().setItem(text);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/intellij/lang/xpath/xslt/run/XsltRunSettingsEditor$Editor$4", "setText"));
                }
            });
            this.myOutputFile.addBrowseFolderListener(XPathBundle.message("dialog.title.choose.output.file", new Object[0]), XPathBundle.message("label.selected.file.will.be.overwritten.during.execution", new Object[0]), project, FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor());
            ItemListener outputStateListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    this.updateOutputState();
                }
            };
            this.myShowInConsole.addItemListener(outputStateListener);
            this.myShowInStdout.addItemListener(outputStateListener);
            this.mySaveToFile.addItemListener(outputStateListener);
            this.updateOutputState();
            this.myFileType.setRenderer((ListCellRenderer)new FileTypeRenderer(){

                public void customize(@NotNull JList<? extends FileType> list, FileType value, int index, boolean selected, boolean hasFocus) {
                    if (list == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    if (value == null) {
                        this.setIcon(AllIcons.Actions.Cancel);
                        this.setText(XPathBundle.message("label.disabled", new Object[0]));
                    } else {
                        super.customize(list, value, index, selected, hasFocus);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/intellij/lang/xpath/xslt/run/XsltRunSettingsEditor$Editor$6", "customize"));
                }
            });
            this.myFileType.setModel(new DefaultComboBoxModel<FileType>(Editor.getFileTypes(project)));
            this.myParameters = new JBTable((TableModel)new ParamTableModel());
            this.myParameters.setDefaultRenderer(String.class, (TableCellRenderer)new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    this.setForeground(null);
                    this.setToolTipText(null);
                    if (column == 0) {
                        if (table.getModel().getValueAt(row, 1) == null) {
                            this.setForeground(PlatformColors.BLUE);
                            this.setToolTipText(XPathBundle.message("tooltip.no.value.set.for.parameter.0", value));
                        }
                    } else if (value == null) {
                        value = "<none>";
                    }
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
            });
            this.myParametersPanel.add((Component)ToolbarDecorator.createDecorator((JTable)this.myParameters).setAddAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    ((ParamTableModel)myParameters.getModel()).addParam();
                }
            }).setRemoveAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    ((ParamTableModel)myParameters.getModel()).removeParam(myParameters.getSelectedRow());
                }
            }).createPanel(), "Center");
            if (ALLOW_CHOOSING_SDK) {
                Object[] modules = ModuleManager.getInstance((Project)project).getModules();
                this.myModule.setModel(new DefaultComboBoxModel<Object>(ArrayUtil.mergeArrays((Object[])new Object[]{"<default>"}, (Object[])modules)));
                this.myModule.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> {
                    if (value instanceof Module) {
                        Module module = (Module)value;
                        String moduleName = (String)ReadAction.compute(() -> module.getName());
                        label.setText(moduleName);
                        label.setIcon(ModuleType.get((Module)module).getIcon());
                    } else if (value instanceof String) {
                        label.setText((String)value);
                    }
                }));
            } else {
                this.myModuleChoice.setEnabled(false);
                this.myModule.setEnabled(false);
                this.myJdkChoice.setSelected(true);
            }
            SdkComboBoxModel model = SdkComboBoxModel.createJdkComboBoxModel((Project)project, (ProjectSdksModel)new ProjectSdksModel());
            this.myJDK = new SdkComboBox(model);
            GridConstraints constraints = new GridConstraints();
            constraints.setColumn(2);
            constraints.setRow(1);
            constraints.setFill(3);
            this.myClasspathAndJDKPanel.add((Component)this.myJDK, constraints);
            ItemListener updateListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    this.updateJdkState();
                }
            };
            this.myModuleChoice.addItemListener(updateListener);
            this.myJdkChoice.addItemListener(updateListener);
            this.updateJdkState();
            this.myWorkingDirectory.addBrowseFolderListener(XPathBundle.message("dialog.title.working.directory", new Object[0]), null, project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
            this.myVmArguments.setDialogCaption("VM Arguments");
            this.myPanelSettings.setBorder(new EmptyBorder(UIUtil.PANEL_SMALL_INSETS));
            this.myPanelAdvanced.setBorder(new EmptyBorder(UIUtil.PANEL_SMALL_INSETS));
            this.setAnchor((JComponent)this.myShowInConsole);
        }

        public JComponent getAnchor() {
            return this.anchor;
        }

        public void setAnchor(@Nullable JComponent anchor) {
            this.anchor = anchor;
            this.myXSLTScriptFileLabel.setAnchor(anchor);
            this.myShowInConsole.setAnchor(anchor);
        }

        private static Vector<FileType> getFileTypes(Project project) {
            FileType[] fileTypes;
            Vector<FileType> v = new Vector<FileType>();
            for (FileType fileType : fileTypes = FileTypeManager.getInstance().getRegisteredFileTypes()) {
                if (fileType == StdFileTypes.CLASS || fileType == ProjectFileType.INSTANCE || fileType == WorkspaceFileType.INSTANCE || fileType == ModuleFileType.INSTANCE || fileType == StdFileTypes.GUI_DESIGNER_FORM) continue;
                try {
                    if (!(fileType instanceof LanguageFileType)) continue;
                    SyntaxHighlighter sh = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)((LanguageFileType)fileType).getLanguage(), (Project)project, null);
                    v.add(fileType);
                }
                catch (Throwable e) {
                    Logger.getInstance((String)XsltRunSettingsEditor.class.getName()).info("Encountered incompatible FileType: " + fileType.getName(), e);
                }
            }
            v.sort(Comparator.comparing(FileType::getDescription));
            v.insertElementAt(null, 0);
            return v;
        }

        public void resetFrom(XsltRunConfiguration s) {
            this.myXsltFile.setText(s.getXsltFile());
            this.myXmlInputFile.getComboBox().setSelectedItem(s.getXmlInputFile());
            VirtualFile xmlInputFile = s.findXmlInputFile();
            if (xmlInputFile != null) {
                Module contextModule = ProjectRootManager.getInstance((Project)s.getProject()).getFileIndex().getModuleForFile(xmlInputFile);
                if (contextModule != null) {
                    this.myXmlDescriptor.putUserData(LangDataKeys.MODULE_CONTEXT, contextModule);
                } else {
                    this.myXmlDescriptor.putUserData(LangDataKeys.MODULE_CONTEXT, s.getModule());
                }
            } else {
                this.myXmlDescriptor.putUserData(LangDataKeys.MODULE_CONTEXT, s.getModule());
            }
            this.myFileType.setSelectedItem((Object)s.getFileType());
            this.myOutputFile.setText(s.myOutputFile);
            this.myOpenOutputFile.setSelected(s.myOpenOutputFile);
            this.myOpenInBrowser.setSelected(s.myOpenInBrowser);
            this.myParameters.setModel((TableModel)new ParamTableModel(s.getParameters()));
            this.myVmArguments.setText(s.getVmArguments());
            this.myWorkingDirectory.setText(s.myWorkingDirectory);
            Module module = s.getModule();
            if (module != null) {
                this.myModule.setSelectedItem((Object)module);
                this.myXsltDescriptor.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)module);
            } else {
                VirtualFile xsltFile = s.findXsltFile();
                if (xsltFile != null) {
                    this.myXsltDescriptor.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)ProjectRootManager.getInstance((Project)s.getProject()).getFileIndex().getModuleForFile(xsltFile));
                }
                if (this.myModule.getItemCount() > 0) {
                    this.myModule.setSelectedIndex(0);
                }
            }
            this.myJDK.getModel().getSdksModel().reset(s.getProject());
            this.myJDK.reloadModel();
            Editor.setSelectedSdkOrNone(this.myJDK, s.getJdk());
            this.mySmartErrorHandling.setSelected(s.mySmartErrorHandling);
            Editor.setSelectedIndex(this.myOutputOptions, s.getOutputType().ordinal());
            Editor.setSelectedIndex(this.myJdkOptions, s.getJdkChoice().ordinal());
            this.mySaveToFile.setSelected(s.isSaveToFile());
        }

        public void applyTo(XsltRunConfiguration s) throws ConfigurationException {
            s.setXsltFile(this.myXsltFile.getText());
            s.setXmlInputFile(this.getXmlInputFile());
            s.setFileType((FileType)this.myFileType.getSelectedItem());
            s.myOutputFile = this.myOutputFile.getText();
            s.myOpenOutputFile = this.myOpenOutputFile.isSelected();
            s.myOpenInBrowser = this.myOpenInBrowser.isSelected();
            s.setParameters(((ParamTableModel)this.myParameters.getModel()).getParams());
            s.setVmArguments(this.myVmArguments.getText());
            s.myWorkingDirectory = this.myWorkingDirectory.getText();
            s.setModule(this.getModule());
            WriteAction.run(() -> this.myJDK.getModel().getSdksModel().apply());
            s.setJDK(this.myJDK.getSelectedSdk());
            s.setJdkChoice(XsltRunConfiguration.JdkChoice.values()[Editor.getSelectedIndex(this.myJdkOptions)]);
            s.mySmartErrorHandling = this.mySmartErrorHandling.isSelected();
            s.setOutputType(XsltRunConfiguration.OutputType.values()[Editor.getSelectedIndex(this.myOutputOptions)]);
            s.setSaveToFile(this.mySaveToFile.isSelected());
        }

        private void updateOutputState() {
            this.myOutputFile.setEnabled(this.mySaveToFile.isSelected());
            this.myOpenOutputFile.setEnabled(this.mySaveToFile.isEnabled() && this.mySaveToFile.isSelected());
            this.myOpenInBrowser.setEnabled(this.mySaveToFile.isEnabled() && this.mySaveToFile.isSelected());
            int selectedIndex = Editor.getSelectedIndex(this.myOutputOptions);
            boolean b = selectedIndex == XsltRunConfiguration.OutputType.CONSOLE.ordinal();
            this.myFileType.setEnabled(b);
        }

        private void updateJdkState() {
            this.myModule.setEnabled(Editor.getSelectedIndex(this.myJdkOptions) == XsltRunConfiguration.JdkChoice.FROM_MODULE.ordinal());
            this.myJDK.setEnabled(Editor.getSelectedIndex(this.myJdkOptions) == XsltRunConfiguration.JdkChoice.JDK.ordinal());
        }

        @Nullable
        private Module getModule() {
            Object selectedItem = this.myModule.getSelectedItem();
            return selectedItem instanceof Module ? (Module)selectedItem : null;
        }

        private String getXmlInputFile() {
            JComboBox comboBox = this.myXmlInputFile.getComboBox();
            Object currentItem = comboBox.getEditor().getItem();
            String s = (String)(currentItem != null ? currentItem : comboBox.getSelectedItem());
            return s != null ? s : "";
        }

        private static void setSelectedIndex(ButtonGroup group, int i) {
            Enumeration<AbstractButton> buttons = group.getElements();
            int j = 0;
            while (buttons.hasMoreElements()) {
                group.setSelected(buttons.nextElement().getModel(), i == j);
                ++j;
            }
        }

        private static int getSelectedIndex(ButtonGroup group) {
            ButtonModel selection = group.getSelection();
            if (selection == null) {
                return -1;
            }
            Enumeration<AbstractButton> buttons = group.getElements();
            int i = 0;
            while (buttons.hasMoreElements()) {
                AbstractButton button = buttons.nextElement();
                if (group.isSelected(button.getModel())) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private static void setSelectedSdkOrNone(@NotNull SdkComboBox comboBox, @Nullable Sdk sdk) {
            if (comboBox == null) {
                Editor.$$$reportNull$$$0(0);
            }
            if (sdk == null) {
                comboBox.setSelectedItem((Object)comboBox.showNoneSdkItem());
            } else {
                comboBox.setSelectedSdk(sdk);
            }
        }

        public JComponent getComponent() {
            return this.myComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "org/intellij/lang/xpath/xslt/run/XsltRunSettingsEditor$Editor", "setSelectedSdkOrNone"));
        }

        private /* synthetic */ void $$$setupUI$$$() {
            ButtonGroup buttonGroup;
            TextFieldWithBrowseButton textFieldWithBrowseButton;
            RawCommandLineEditor rawCommandLineEditor;
            JRadioButton jRadioButton;
            ComboBox comboBox;
            JRadioButton jRadioButton2;
            JPanel jPanel;
            JCheckBox jCheckBox;
            JPanel jPanel2;
            JPanel jPanel3;
            ComboboxWithBrowseButton comboboxWithBrowseButton;
            TextFieldWithBrowseButton textFieldWithBrowseButton2;
            JBLabel jBLabel;
            JCheckBox jCheckBox2;
            ComboBox comboBox2;
            JRadioButton jRadioButton3;
            JBRadioButton jBRadioButton;
            JCheckBox jCheckBox3;
            TextFieldWithBrowseButton textFieldWithBrowseButton3;
            JCheckBox jCheckBox4;
            JPanel jPanel4;
            JBTabbedPane jBTabbedPane = new JBTabbedPane();
            this.myComponent = jBTabbedPane;
            this.myPanelSettings = jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jBTabbedPane.addTab(DynamicBundle.getBundle((String)"messages/XPathBundle", Editor.class).getString("tab.title.settings"), null, jPanel4, null);
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel4.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/XPathBundle", Editor.class).getString("border.title.output"), (int)0, (int)0, null, null));
            this.mySaveToFile = jCheckBox4 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/XPathBundle", Editor.class).getString("checkbox.save.to.file"));
            jCheckBox4.setToolTipText(ResourceBundle.getBundle("messages/XPathBundle").getString("html.save.xslt.output.to.specified.file.br.em.warning.em.this.file.will.be.overwritten.without.confirmation.html"));
            jPanel5.add((Component)jCheckBox4, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myOutputFile = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
            jPanel5.add((Component)textFieldWithBrowseButton3, new GridConstraints(2, 1, 1, 1, 0, 1, 7, 0, null, null, null));
            this.myOpenOutputFile = jCheckBox3 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/XPathBundle", Editor.class).getString("checkbox.open.file.in.editor.after.execution"));
            jPanel5.add((Component)jCheckBox3, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null, 1));
            this.myShowInConsole = jBRadioButton = new JBRadioButton();
            this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, DynamicBundle.getBundle((String)"messages/XPathBundle", Editor.class).getString("radio.button.show.in.extra.console.tab"));
            jBRadioButton.setToolTipText(ResourceBundle.getBundle("messages/XPathBundle").getString("show.xslt.output.in.separate.tab.stdout.will.just.receive.xslt.error.messages"));
            jPanel5.add((Component)jBRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myShowInStdout = jRadioButton3 = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/XPathBundle", Editor.class).getString("radio.button.show.in.default.console"));
            jRadioButton3.setToolTipText(ResourceBundle.getBundle("messages/XPathBundle").getString("show.xslt.output.in.standard.run.console.mixed.with.other.error.messages"));
            jPanel5.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 4, 0, 0), -1, -1, false, false));
            jPanel5.add((Component)jPanel6, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 1, null, null, null));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/XPathBundle", Editor.class).getString("label.highlight.output.as"));
            jPanel6.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myFileType = comboBox2 = new ComboBox();
            comboBox2.setToolTipText(ResourceBundle.getBundle("messages/XPathBundle").getString("output.highlighting.is.experimental.please.turn.it.off.if.it.s.causing.trouble"));
            jPanel6.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 3, 3, null, null, null));
            this.myOpenInBrowser = jCheckBox2 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/XPathBundle", Editor.class).getString("checkbox.open.file.in.web.browser.after.execution"));
            jPanel5.add((Component)jCheckBox2, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null, 1));
            JPanel jPanel7 = new JPanel();
            jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel4.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel7.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/XPathBundle", Editor.class).getString("border.title.input"), (int)0, (int)0, null, null));
            JLabel jLabel2 = new JLabel();
            this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/XPathBundle", Editor.class).getString("label.choose.xml.input.file"));
            jPanel7.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myXSLTScriptFileLabel = jBLabel = new JBLabel();
            jBLabel.setEnabled(true);
            this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/XPathBundle", Editor.class).getString("label.xslt.script.file"));
            jBLabel.setVerticalAlignment(0);
            jPanel7.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myXsltFile = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
            jPanel7.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
            this.myXmlInputFile = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
            jPanel7.add((Component)comboboxWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
            this.myParametersPanel = jPanel3 = new JPanel();
            jPanel3.setLayout(new BorderLayout(0, 0));
            jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
            jPanel4.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 1, 3, 3, 7, null, new Dimension(-1, 150), null));
            jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/XPathBundle", Editor.class).getString("border.title.parameters"), (int)0, (int)0, null, null));
            this.myPanelAdvanced = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jBTabbedPane.addTab(DynamicBundle.getBundle((String)"messages/XPathBundle", Editor.class).getString("tab.title.advanced"), null, jPanel2, null);
            JLabel jLabel3 = new JLabel();
            this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/XPathBundle", Editor.class).getString("label.vm.arguments"));
            jPanel2.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.mySmartErrorHandling = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/XPathBundle", Editor.class).getString("checkbox.smart.error.handling"));
            jPanel2.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
            this.myClasspathAndJDKPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
            this.myModuleChoice = jRadioButton2 = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/XPathBundle", Editor.class).getString("radio.button.from.module"));
            jPanel.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myModule = comboBox = new ComboBox();
            jPanel.add((Component)comboBox, new GridConstraints(0, 2, 1, 1, 0, 1, 7, 0, null, null, null));
            this.myJdkChoice = jRadioButton = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/XPathBundle", Editor.class).getString("radio.button.use.jdk"));
            jPanel.add((Component)jRadioButton, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
            JLabel jLabel4 = new JLabel();
            this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/XPathBundle", Editor.class).getString("label.classpath.and.jdk"));
            jPanel.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myVmArguments = rawCommandLineEditor = new RawCommandLineEditor();
            jPanel2.add((Component)rawCommandLineEditor, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
            this.myWorkingDirectory = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
            jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 7, 0, null, null, null));
            JLabel jLabel5 = new JLabel();
            this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/XPathBundle", Editor.class).getString("label.working.directory"));
            jPanel2.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            jLabel2.setLabelFor((Component)comboboxWithBrowseButton);
            jBLabel.setLabelFor((Component)textFieldWithBrowseButton2);
            jLabel3.setLabelFor((Component)rawCommandLineEditor);
            jLabel5.setLabelFor((Component)textFieldWithBrowseButton);
            this.myOutputOptions = buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)jBRadioButton);
            buttonGroup.add(jRadioButton3);
            this.myJdkOptions = buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButton2);
            buttonGroup.add(jRadioButton);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myComponent;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }

        private static class ParamTableModel
        extends AbstractTableModel {
            private final List<Param> myParams = new ArrayList<Param>();

            ParamTableModel() {
            }

            ParamTableModel(List<? extends Pair<String, String>> params) {
                for (Pair<String, String> pair : params) {
                    this.myParams.add(new Param((String)pair.getFirst(), (String)pair.getSecond()));
                }
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public int getRowCount() {
                return this.myParams.size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public String getColumnName(int column) {
                return column == 0 ? XPathBundle.message("attribute.descriptor.name", new Object[0]) : XPathBundle.message("value", new Object[0]);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                if (rowIndex >= this.myParams.size()) {
                    return;
                }
                Param param = this.myParams.get(rowIndex);
                String value = (String)aValue;
                if (columnIndex == 0) {
                    param.name = value;
                } else {
                    param.value = value;
                }
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Param param = this.myParams.get(rowIndex);
                return columnIndex == 0 ? param.name : param.value;
            }

            public void addParam() {
                this.myParams.add(new Param("Param" + (this.myParams.size() + 1), null));
                this.fireTableRowsInserted(this.myParams.size() - 1, this.myParams.size() - 1);
            }

            public void removeParam(int selectedRow) {
                this.myParams.remove(selectedRow);
                this.fireTableRowsDeleted(selectedRow, selectedRow);
            }

            public List<Pair<String, String>> getParams() {
                ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>(this.myParams.size());
                for (Param param : this.myParams) {
                    pairs.add((Pair<String, String>)Pair.create((Object)param.name, (Object)param.value));
                }
                return pairs;
            }

            static class Param {
                public String name;
                public String value;

                Param(String name, String value) {
                    this.name = name;
                    this.value = value;
                }

                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (o == null || this.getClass() != o.getClass()) {
                        return false;
                    }
                    Param param = (Param)o;
                    return this.name.equals(param.name) && this.value.equals(param.value);
                }

                public int hashCode() {
                    int result = this.name.hashCode();
                    result = 29 * result + this.value.hashCode();
                    return result;
                }
            }
        }
    }
}

