/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.repository.Repository;
import org.jetbrains.idea.maven.server.Maven2ServerGlobals;
import org.sonatype.nexus.index.updater.ResourceFetcher;

public class Maven2ServerIndexFetcher
implements ResourceFetcher {
    private final String myOriginalRepositoryId;
    private final String myOriginalRepositoryUrl;
    private final WagonManager myWagonManager;
    private final TransferListener myListener;
    private Wagon myWagon = null;

    public Maven2ServerIndexFetcher(String originalRepositoryId, String originalRepositoryUrl, WagonManager wagonManager, TransferListener listener) {
        this.myOriginalRepositoryId = originalRepositoryId;
        this.myOriginalRepositoryUrl = originalRepositoryUrl;
        this.myWagonManager = wagonManager;
        this.myListener = listener;
    }

    public void connect(String _ignoredContextId, String _ignoredUrl) throws IOException {
        ArtifactRepository mirrorRepository = this.myWagonManager.getMirrorRepository((ArtifactRepository)new DefaultArtifactRepository(this.myOriginalRepositoryId, this.myOriginalRepositoryUrl, null));
        String mirrorUrl = mirrorRepository.getUrl();
        String indexUrl = mirrorUrl + (mirrorUrl.endsWith("/") ? "" : "/") + ".index";
        Repository repository = new Repository(this.myOriginalRepositoryId, indexUrl);
        try {
            this.myWagon = this.myWagonManager.getWagon(repository);
            this.myWagon.addTransferListener(this.myListener);
            this.myWagon.connect(repository, this.myWagonManager.getAuthenticationInfo(mirrorRepository.getId()), this.myWagonManager.getProxy(mirrorRepository.getProtocol()));
        }
        catch (AuthenticationException e) {
            throw new IOException("Authentication exception connecting to " + repository, e);
        }
        catch (WagonException e) {
            throw new IOException("Wagon exception connecting to " + repository, e);
        }
    }

    public void disconnect() throws RemoteException {
        if (this.myWagon == null) {
            return;
        }
        try {
            this.myWagon.disconnect();
        }
        catch (ConnectionException ex) {
            Maven2ServerGlobals.getLogger().warn(ex);
        }
    }

    public void retrieve(String name, File targetFile) throws IOException {
        try {
            this.myWagon.get(name, targetFile);
        }
        catch (AuthorizationException e) {
            throw new IOException("Authorization exception retrieving " + name, e);
        }
        catch (ResourceDoesNotExistException e) {
            FileNotFoundException newEx = new FileNotFoundException("Resource " + name + " does not exist");
            newEx.initCause(e);
            throw newEx;
        }
        catch (WagonException e) {
            throw new IOException("Transfer for " + name + " failed", e);
        }
    }
}

