/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.util.StopWatch;
import git4idea.GitDisposable;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchesCollection;
import git4idea.ignore.GitRepositoryIgnoredFilesHolder;
import git4idea.repo.GitBranchState;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitConfig;
import git4idea.repo.GitHooksInfo;
import git4idea.repo.GitModulesFileReader;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepoInfo;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryFiles;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitRepositoryReader;
import git4idea.repo.GitRepositoryUpdater;
import git4idea.repo.GitSubmoduleInfo;
import git4idea.repo.GitUntrackedFilesHolder;
import git4idea.status.GitStagingAreaHolder;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitRepositoryImpl
extends RepositoryImpl
implements GitRepository {
    private static final Logger LOG = Logger.getInstance(GitRepositoryImpl.class);
    @NotNull
    private final GitVcs myVcs;
    @NotNull
    private final GitRepositoryReader myReader;
    @NotNull
    private final VirtualFile myGitDir;
    @NotNull
    private final GitRepositoryFiles myRepositoryFiles;
    @NotNull
    private final GitUntrackedFilesHolder myUntrackedFilesHolder;
    @NotNull
    private final GitStagingAreaHolder myStagingAreaHolder;
    @NotNull
    private final GitRepositoryIgnoredFilesHolder myIgnoredRepositoryFilesHolder;
    @NotNull
    private volatile GitRepoInfo myInfo;

    private GitRepositoryImpl(@NotNull VirtualFile rootDir, @NotNull VirtualFile gitDir, @NotNull Project project, @NotNull Disposable parentDisposable) {
        if (rootDir == null) {
            GitRepositoryImpl.$$$reportNull$$$0(0);
        }
        if (gitDir == null) {
            GitRepositoryImpl.$$$reportNull$$$0(1);
        }
        if (project == null) {
            GitRepositoryImpl.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            GitRepositoryImpl.$$$reportNull$$$0(3);
        }
        super(project, rootDir, parentDisposable);
        this.myVcs = GitVcs.getInstance(project);
        this.myGitDir = gitDir;
        this.myRepositoryFiles = GitRepositoryFiles.getInstance(rootDir, gitDir);
        this.myReader = new GitRepositoryReader(this.myRepositoryFiles);
        this.myInfo = this.readRepoInfo();
        this.myStagingAreaHolder = new GitStagingAreaHolder(this);
        this.myUntrackedFilesHolder = new GitUntrackedFilesHolder(this);
        Disposer.register((Disposable)this, (Disposable)this.myUntrackedFilesHolder);
        this.myIgnoredRepositoryFilesHolder = new GitRepositoryIgnoredFilesHolder(this);
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static GitRepository getInstance(@NotNull VirtualFile root, @NotNull Project project, boolean listenToRepoChanges) {
        if (root == null) {
            GitRepositoryImpl.$$$reportNull$$$0(4);
        }
        if (project == null) {
            GitRepositoryImpl.$$$reportNull$$$0(5);
        }
        GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForRoot(root);
        GitRepository gitRepository = (GitRepository)ObjectUtils.notNull((Object)repository, () -> GitRepositoryImpl.createInstance(root, project, GitDisposable.getInstance(project), listenToRepoChanges));
        if (gitRepository == null) {
            GitRepositoryImpl.$$$reportNull$$$0(6);
        }
        return gitRepository;
    }

    @ApiStatus.Internal
    @NotNull
    public static GitRepository createInstance(@NotNull VirtualFile root, @NotNull Project project, @NotNull Disposable parentDisposable, boolean listenToRepoChanges) {
        if (root == null) {
            GitRepositoryImpl.$$$reportNull$$$0(7);
        }
        if (project == null) {
            GitRepositoryImpl.$$$reportNull$$$0(8);
        }
        if (parentDisposable == null) {
            GitRepositoryImpl.$$$reportNull$$$0(9);
        }
        VirtualFile gitDir = Objects.requireNonNull(GitUtil.findGitDir(root));
        return GitRepositoryImpl.createInstance(root, gitDir, project, parentDisposable, listenToRepoChanges);
    }

    @ApiStatus.Internal
    @NotNull
    static GitRepository createInstance(@NotNull VirtualFile root, @NotNull VirtualFile gitDir, @NotNull Project project, @NotNull Disposable parentDisposable, boolean listenToRepoChanges) {
        if (root == null) {
            GitRepositoryImpl.$$$reportNull$$$0(10);
        }
        if (gitDir == null) {
            GitRepositoryImpl.$$$reportNull$$$0(11);
        }
        if (project == null) {
            GitRepositoryImpl.$$$reportNull$$$0(12);
        }
        if (parentDisposable == null) {
            GitRepositoryImpl.$$$reportNull$$$0(13);
        }
        GitRepositoryImpl repository = new GitRepositoryImpl(root, gitDir, project, parentDisposable);
        repository.setupUpdater();
        GitRepositoryManager.getInstance(project).notifyListenersAsync(repository);
        GitRepositoryImpl gitRepositoryImpl = repository;
        if (gitRepositoryImpl == null) {
            GitRepositoryImpl.$$$reportNull$$$0(14);
        }
        return gitRepositoryImpl;
    }

    private void setupUpdater() {
        GitRepositoryUpdater updater = new GitRepositoryUpdater(this, this.myRepositoryFiles);
        Disposer.register((Disposable)this, (Disposable)updater);
    }

    @Override
    @Deprecated
    @NotNull
    public VirtualFile getGitDir() {
        VirtualFile virtualFile = this.myGitDir;
        if (virtualFile == null) {
            GitRepositoryImpl.$$$reportNull$$$0(15);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public GitRepositoryFiles getRepositoryFiles() {
        GitRepositoryFiles gitRepositoryFiles = this.myRepositoryFiles;
        if (gitRepositoryFiles == null) {
            GitRepositoryImpl.$$$reportNull$$$0(16);
        }
        return gitRepositoryFiles;
    }

    @Override
    @NotNull
    public GitStagingAreaHolder getStagingAreaHolder() {
        GitStagingAreaHolder gitStagingAreaHolder = this.myStagingAreaHolder;
        if (gitStagingAreaHolder == null) {
            GitRepositoryImpl.$$$reportNull$$$0(17);
        }
        return gitStagingAreaHolder;
    }

    @Override
    @NotNull
    public GitUntrackedFilesHolder getUntrackedFilesHolder() {
        GitUntrackedFilesHolder gitUntrackedFilesHolder = this.myUntrackedFilesHolder;
        if (gitUntrackedFilesHolder == null) {
            GitRepositoryImpl.$$$reportNull$$$0(18);
        }
        return gitUntrackedFilesHolder;
    }

    @Override
    @NotNull
    public GitRepositoryIgnoredFilesHolder getIgnoredFilesHolder() {
        GitRepositoryIgnoredFilesHolder gitRepositoryIgnoredFilesHolder = this.myIgnoredRepositoryFilesHolder;
        if (gitRepositoryIgnoredFilesHolder == null) {
            GitRepositoryImpl.$$$reportNull$$$0(19);
        }
        return gitRepositoryIgnoredFilesHolder;
    }

    @Override
    @NotNull
    public GitRepoInfo getInfo() {
        GitRepoInfo gitRepoInfo = this.myInfo;
        if (gitRepoInfo == null) {
            GitRepositoryImpl.$$$reportNull$$$0(20);
        }
        return gitRepoInfo;
    }

    @Override
    @Nullable
    public GitLocalBranch getCurrentBranch() {
        return this.myInfo.getCurrentBranch();
    }

    @Nullable
    public String getCurrentRevision() {
        return this.myInfo.getCurrentRevision();
    }

    @NotNull
    public Repository.State getState() {
        Repository.State state = this.myInfo.getState();
        if (state == null) {
            GitRepositoryImpl.$$$reportNull$$$0(21);
        }
        return state;
    }

    @Nullable
    public String getCurrentBranchName() {
        GitLocalBranch currentBranch = this.getCurrentBranch();
        return currentBranch == null ? null : currentBranch.getName();
    }

    @Override
    @NotNull
    public GitVcs getVcs() {
        GitVcs gitVcs = this.myVcs;
        if (gitVcs == null) {
            GitRepositoryImpl.$$$reportNull$$$0(22);
        }
        return gitVcs;
    }

    @Override
    @NotNull
    public Collection<GitSubmoduleInfo> getSubmodules() {
        Collection<GitSubmoduleInfo> collection = this.myInfo.getSubmodules();
        if (collection == null) {
            GitRepositoryImpl.$$$reportNull$$$0(23);
        }
        return collection;
    }

    @Override
    @NotNull
    public GitBranchesCollection getBranches() {
        GitRepoInfo info = this.myInfo;
        return new GitBranchesCollection(info.getLocalBranchesWithHashes(), info.getRemoteBranchesWithHashes());
    }

    @Override
    @NotNull
    public Collection<GitRemote> getRemotes() {
        Collection<GitRemote> collection = this.myInfo.getRemotes();
        if (collection == null) {
            GitRepositoryImpl.$$$reportNull$$$0(24);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<GitBranchTrackInfo> getBranchTrackInfos() {
        Collection<GitBranchTrackInfo> collection = this.myInfo.getBranchTrackInfos();
        if (collection == null) {
            GitRepositoryImpl.$$$reportNull$$$0(25);
        }
        return collection;
    }

    @Override
    @Nullable
    public GitBranchTrackInfo getBranchTrackInfo(@NotNull String localBranchName) {
        if (localBranchName == null) {
            GitRepositoryImpl.$$$reportNull$$$0(26);
        }
        return this.myInfo.getBranchTrackInfosMap().get(localBranchName);
    }

    @Override
    public boolean isRebaseInProgress() {
        return this.getState() == Repository.State.REBASING;
    }

    @Override
    public boolean isOnBranch() {
        return this.getState() != Repository.State.DETACHED && this.getState() != Repository.State.REBASING;
    }

    public void update() {
        if (ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error("Reading Git repository information should not be done on the EDT");
        }
        GitRepoInfo previousInfo = this.myInfo;
        this.myInfo = this.readRepoInfo();
        GitRepositoryImpl.notifyIfRepoChanged(this, previousInfo, this.myInfo);
    }

    @NotNull
    private GitRepoInfo readRepoInfo() {
        StopWatch sw = StopWatch.start((String)("Reading Git repo info in " + DvcsUtil.getShortRepositoryName((Repository)this)));
        File configFile = this.myRepositoryFiles.getConfigFile();
        GitConfig config = GitConfig.read(configFile);
        this.myRepositoryFiles.updateCustomPaths(config.parseCore());
        Collection<GitRemote> remotes = config.parseRemotes();
        GitBranchState state = this.myReader.readState(remotes);
        boolean isShallow = this.myReader.hasShallowCommits();
        Collection<GitBranchTrackInfo> trackInfos = config.parseTrackInfos(state.getLocalBranches().keySet(), state.getRemoteBranches().keySet());
        GitHooksInfo hooksInfo = this.myReader.readHooksInfo();
        Collection<GitSubmoduleInfo> submodules = new GitModulesFileReader().read(this.getSubmoduleFile());
        sw.report(LOG);
        return new GitRepoInfo(state.getCurrentBranch(), state.getCurrentRevision(), state.getState(), new LinkedHashSet<GitRemote>(remotes), new HashMap<GitLocalBranch, Hash>(state.getLocalBranches()), new HashMap<GitRemoteBranch, Hash>(state.getRemoteBranches()), new LinkedHashSet<GitBranchTrackInfo>(trackInfos), submodules, hooksInfo, isShallow);
    }

    @NotNull
    private File getSubmoduleFile() {
        return new File(VfsUtilCore.virtualToIoFile((VirtualFile)this.getRoot()), ".gitmodules");
    }

    private static void notifyIfRepoChanged(@NotNull GitRepository repository, @NotNull GitRepoInfo previousInfo, @NotNull GitRepoInfo info) {
        Project project;
        if (repository == null) {
            GitRepositoryImpl.$$$reportNull$$$0(27);
        }
        if (previousInfo == null) {
            GitRepositoryImpl.$$$reportNull$$$0(28);
        }
        if (info == null) {
            GitRepositoryImpl.$$$reportNull$$$0(29);
        }
        if (!(project = repository.getProject()).isDisposed() && !info.equals(previousInfo)) {
            GitRepositoryManager.getInstance(project).notifyListenersAsync(repository);
        }
    }

    @NotNull
    public String toLogString() {
        String string = "GitRepository " + this.getRoot() + " : " + this.myInfo;
        if (string == null) {
            GitRepositoryImpl.$$$reportNull$$$0(30);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDir";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitDir";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/repo/GitRepositoryImpl";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranchName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousInfo";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/repo/GitRepositoryImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getGitDir";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryFiles";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getStagingAreaHolder";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUntrackedFilesHolder";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFilesHolder";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfo";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcs";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubmodules";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemotes";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchTrackInfos";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "toLogString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getBranchTrackInfo";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "notifyIfRepoChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

