/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace;

import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.streams.StreamDebuggerBundle;
import com.intellij.debugger.streams.trace.StreamTracer;
import com.intellij.debugger.streams.trace.TraceExpressionBuilder;
import com.intellij.debugger.streams.trace.TraceResultInterpreter;
import com.intellij.debugger.streams.trace.TracingCallback;
import com.intellij.debugger.streams.trace.TracingResult;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XEvaluationCallbackBase;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvaluateExpressionTracer
implements StreamTracer {
    private final XDebugSession mySession;
    private final TraceExpressionBuilder myExpressionBuilder;
    private final TraceResultInterpreter myResultInterpreter;

    public EvaluateExpressionTracer(@NotNull XDebugSession session, @NotNull TraceExpressionBuilder expressionBuilder, @NotNull TraceResultInterpreter interpreter) {
        if (session == null) {
            EvaluateExpressionTracer.$$$reportNull$$$0(0);
        }
        if (expressionBuilder == null) {
            EvaluateExpressionTracer.$$$reportNull$$$0(1);
        }
        if (interpreter == null) {
            EvaluateExpressionTracer.$$$reportNull$$$0(2);
        }
        this.mySession = session;
        this.myExpressionBuilder = expressionBuilder;
        this.myResultInterpreter = interpreter;
    }

    @Override
    public void trace(final @NotNull StreamChain chain, final @NotNull TracingCallback callback) {
        if (chain == null) {
            EvaluateExpressionTracer.$$$reportNull$$$0(3);
        }
        if (callback == null) {
            EvaluateExpressionTracer.$$$reportNull$$$0(4);
        }
        final String streamTraceExpression = this.myExpressionBuilder.createTraceExpression(chain);
        XStackFrame stackFrame = this.mySession.getCurrentStackFrame();
        XDebuggerEvaluator evaluator = this.mySession.getDebugProcess().getEvaluator();
        if (stackFrame != null && evaluator != null) {
            evaluator.evaluate((XExpression)XExpressionImpl.fromText((String)streamTraceExpression, (EvaluationMode)EvaluationMode.CODE_FRAGMENT), (XDebuggerEvaluator.XEvaluationCallback)new XEvaluationCallbackBase(){

                public void evaluated(@NotNull XValue result) {
                    if (result == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (result instanceof JavaValue) {
                        ReferenceType type;
                        Value reference = ((JavaValue)result).getDescriptor().getValue();
                        if (reference instanceof ArrayReference) {
                            TracingResult interpretedResult;
                            try {
                                interpretedResult = EvaluateExpressionTracer.this.myResultInterpreter.interpret(chain, (ArrayReference)reference);
                            }
                            catch (Throwable t) {
                                callback.evaluationFailed(streamTraceExpression, StreamDebuggerBundle.message("evaluation.failed.cannot.interpret.result", t.getMessage()));
                                throw t;
                            }
                            EvaluationContextImpl context = ((JavaValue)result).getEvaluationContext();
                            callback.evaluated(interpretedResult, context);
                            return;
                        }
                        if (reference instanceof ObjectReference && (type = ((ObjectReference)reference).referenceType()) instanceof ClassType) {
                            ClassType classType;
                            for (classType = (ClassType)type; classType != null && !"java.lang.Throwable".equals(classType.name()); classType = classType.superclass()) {
                            }
                            if (classType != null) {
                                String exceptionMessage = EvaluateExpressionTracer.tryExtractExceptionMessage((ObjectReference)reference);
                                String description = "Evaluation failed: " + type.name() + " exception thrown";
                                String descriptionWithReason = exceptionMessage == null ? description : description + ": " + exceptionMessage;
                                callback.evaluationFailed(streamTraceExpression, descriptionWithReason);
                                return;
                            }
                        }
                    }
                    callback.evaluationFailed(streamTraceExpression, StreamDebuggerBundle.message("evaluation.failed.unknown.result.type", new Object[0]));
                }

                public void errorOccurred(@NotNull String errorMessage) {
                    if (errorMessage == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    callback.compilationFailed(streamTraceExpression, errorMessage);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "result";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorMessage";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/debugger/streams/trace/EvaluateExpressionTracer$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "evaluated";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "errorOccurred";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, stackFrame.getSourcePosition());
        }
    }

    @Nullable
    private static String tryExtractExceptionMessage(@NotNull ObjectReference exception) {
        ReferenceType type;
        Field messageField;
        if (exception == null) {
            EvaluateExpressionTracer.$$$reportNull$$$0(5);
        }
        if ((messageField = (type = exception.referenceType()).fieldByName("detailMessage")) == null) {
            return null;
        }
        Value message = exception.getValue(messageField);
        if (message instanceof StringReference) {
            return ((StringReference)message).value();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chain";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/streams/trace/EvaluateExpressionTracer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "trace";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "tryExtractExceptionMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

