/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.impl.interpret;

import com.intellij.debugger.streams.trace.CallTraceInterpreter;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.trace.impl.TraceElementImpl;
import com.intellij.debugger.streams.trace.impl.interpret.SimplePeekCallTraceInterpreter;
import com.intellij.debugger.streams.trace.impl.interpret.ValuesOrderInfo;
import com.intellij.debugger.streams.trace.impl.interpret.ex.UnexpectedArrayLengthException;
import com.intellij.debugger.streams.trace.impl.interpret.ex.UnexpectedValueTypeException;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Value;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public abstract class MatchInterpreterBase
implements CallTraceInterpreter {
    private final CallTraceInterpreter myPeekResolver = new SimplePeekCallTraceInterpreter();

    @Override
    @NotNull
    public TraceInfo resolve(@NotNull StreamCall call2, @NotNull Value value) {
        if (call2 == null) {
            MatchInterpreterBase.$$$reportNull$$$0(0);
        }
        if (value == null) {
            MatchInterpreterBase.$$$reportNull$$$0(1);
        }
        if (value instanceof ArrayReference) {
            Map<Integer, TraceElement> traceAfter;
            Collection<TraceElement> traceAfterFilter;
            ArrayReference array2 = (ArrayReference)value;
            if (array2.length() != 2) {
                throw new UnexpectedArrayLengthException("trace array for *match call should contain two items. Actual = " + array2.length());
            }
            Value peeksResult = array2.getValue(0);
            Value streamResult2 = array2.getValue(1);
            TraceElement streamResultElement = TraceElementImpl.ofResultValue(((ArrayReference)streamResult2).getValue(0));
            TraceInfo peeksInfo = this.myPeekResolver.resolve(call2, peeksResult);
            Collection<TraceElement> traceBeforeFilter = peeksInfo.getValuesOrderBefore().values();
            boolean result = this.getResult(traceBeforeFilter, traceAfterFilter = (traceAfter = peeksInfo.getValuesOrderAfter()).values());
            Action action = this.getAction(result);
            Map<Integer, TraceElement> beforeTrace = Action.CONNECT_FILTERED.equals((Object)action) ? MatchInterpreterBase.onlyFiltered(traceAfterFilter) : MatchInterpreterBase.difference(traceBeforeFilter, traceAfter.keySet());
            return new ValuesOrderInfo(call2, beforeTrace, MatchInterpreterBase.makeIndexByTime(Stream.of(streamResultElement)));
        }
        throw new UnexpectedValueTypeException("value should be array reference, but given " + value.type().toString());
    }

    protected abstract boolean getResult(@NotNull Collection<TraceElement> var1, @NotNull Collection<TraceElement> var2);

    @NotNull
    protected abstract Action getAction(boolean var1);

    @NotNull
    private static Map<Integer, TraceElement> onlyFiltered(@NotNull Collection<TraceElement> afterFilter) {
        if (afterFilter == null) {
            MatchInterpreterBase.$$$reportNull$$$0(2);
        }
        return MatchInterpreterBase.makeIndexByTime(afterFilter.stream());
    }

    @NotNull
    private static Map<Integer, TraceElement> difference(@NotNull Collection<TraceElement> before, @NotNull Set<Integer> timesAfter) {
        if (before == null) {
            MatchInterpreterBase.$$$reportNull$$$0(3);
        }
        if (timesAfter == null) {
            MatchInterpreterBase.$$$reportNull$$$0(4);
        }
        return MatchInterpreterBase.makeIndexByTime(before.stream().filter(x -> !timesAfter.contains(x.getTime())));
    }

    @NotNull
    private static Map<Integer, TraceElement> makeIndexByTime(@NotNull Stream<TraceElement> elementStream) {
        if (elementStream == null) {
            MatchInterpreterBase.$$$reportNull$$$0(5);
        }
        Map<Integer, TraceElement> map2 = elementStream.collect(Collectors.toMap(TraceElement::getTime, Function.identity()));
        if (map2 == null) {
            MatchInterpreterBase.$$$reportNull$$$0(6);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterFilter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "before";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timesAfter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/trace/impl/interpret/MatchInterpreterBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/trace/impl/interpret/MatchInterpreterBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "makeIndexByTime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onlyFiltered";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "difference";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "makeIndexByTime";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static enum Action {
        CONNECT_FILTERED,
        CONNECT_DIFFERENCE;

    }
}

