/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.UnmergedPathException;
import org.eclipse.jgit.events.WorkingTreeModifiedEvent;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

public class CheckoutCommand
extends GitCommand<Ref> {
    private String name;
    private boolean force = false;
    private boolean createBranch = false;
    private boolean orphan = false;
    private CreateBranchCommand.SetupUpstreamMode upstreamMode;
    private String startPoint = null;
    private RevCommit startCommit;
    private Stage checkoutStage = null;
    private CheckoutResult status;
    private List<String> paths;
    private boolean checkoutAllPaths;
    private Set<String> actuallyModifiedPaths;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;

    public CheckoutCommand(Repository repo) {
        super(repo);
        this.paths = new LinkedList<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref call() throws GitAPIException, RefAlreadyExistsException, RefNotFoundException, InvalidRefNameException, CheckoutConflictException {
        this.checkCallable();
        try {
            RefUpdate.Result updateResult;
            DirCacheCheckout dco;
            ObjectId branch;
            Ref headRef;
            this.processOptions();
            if (this.checkoutAllPaths || !this.paths.isEmpty()) {
                this.checkoutPaths();
                this.status = new CheckoutResult(CheckoutResult.Status.OK, this.paths);
                this.setCallable(false);
                Ref ref = null;
                return ref;
            }
            if (this.createBranch) {
                try (Git git = new Git(this.repo);){
                    CreateBranchCommand command = git.branchCreate();
                    command.setName(this.name);
                    if (this.startCommit != null) {
                        command.setStartPoint(this.startCommit);
                    } else {
                        command.setStartPoint(this.startPoint);
                    }
                    if (this.upstreamMode != null) {
                        command.setUpstreamMode(this.upstreamMode);
                    }
                    command.call();
                }
            }
            if ((headRef = this.repo.exactRef("HEAD")) == null) {
                throw new UnsupportedOperationException(JGitText.get().cannotCheckoutFromUnbornBranch);
            }
            String shortHeadRef = this.getShortBranchName(headRef);
            String refLogMessage = "checkout: moving from " + shortHeadRef;
            if (this.orphan) {
                if (this.startPoint == null && this.startCommit == null) {
                    RefUpdate.Result r = this.repo.updateRef("HEAD").link(this.getBranchName());
                    if (!EnumSet.of(RefUpdate.Result.NEW, RefUpdate.Result.FORCED).contains((Object)r)) {
                        throw new JGitInternalException(MessageFormat.format(JGitText.get().checkoutUnexpectedResult, r.name()));
                    }
                    this.status = CheckoutResult.NOT_TRIED_RESULT;
                    Ref ref = this.repo.exactRef("HEAD");
                    return ref;
                }
                branch = this.getStartPointObjectId();
            } else {
                branch = this.repo.resolve(this.name);
                if (branch == null) {
                    throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.name));
                }
            }
            RevCommit headCommit = null;
            RevCommit newCommit = null;
            try (RevWalk revWalk = new RevWalk(this.repo);){
                ObjectId headId = headRef.getObjectId();
                headCommit = headId == null ? null : revWalk.parseCommit(headId);
                newCommit = revWalk.parseCommit(branch);
            }
            RevTree headTree = headCommit == null ? null : headCommit.getTree();
            DirCache dc = this.repo.lockDirCache();
            try {
                dco = new DirCacheCheckout(this.repo, headTree, dc, newCommit.getTree());
                dco.setFailOnConflict(!this.force);
                dco.setProgressMonitor(this.monitor);
                try {
                    dco.checkout();
                }
                catch (org.eclipse.jgit.errors.CheckoutConflictException e) {
                    this.status = new CheckoutResult(CheckoutResult.Status.CONFLICTS, dco.getConflicts());
                    throw new CheckoutConflictException(dco.getConflicts(), e);
                }
            }
            finally {
                dc.unlock();
            }
            Ref ref = this.repo.findRef(this.name);
            if (ref != null && !ref.getName().startsWith("refs/heads/")) {
                ref = null;
            }
            String toName = Repository.shortenRefName(this.name);
            RefUpdate refUpdate = this.repo.updateRef("HEAD", ref == null);
            refUpdate.setForceUpdate(this.force);
            refUpdate.setRefLogMessage(refLogMessage + " to " + toName, false);
            if (ref != null) {
                updateResult = refUpdate.link(ref.getName());
            } else if (this.orphan) {
                updateResult = refUpdate.link(this.getBranchName());
                ref = this.repo.exactRef("HEAD");
            } else {
                refUpdate.setNewObjectId(newCommit);
                updateResult = refUpdate.forceUpdate();
            }
            this.setCallable(false);
            boolean ok = false;
            switch (updateResult) {
                case NEW: {
                    ok = true;
                    break;
                }
                case NO_CHANGE: 
                case FAST_FORWARD: 
                case FORCED: {
                    ok = true;
                    break;
                }
            }
            if (!ok) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().checkoutUnexpectedResult, updateResult.name()));
            }
            this.status = !dco.getToBeDeleted().isEmpty() ? new CheckoutResult(CheckoutResult.Status.NONDELETED, dco.getToBeDeleted(), new ArrayList<String>(dco.getUpdated().keySet()), dco.getRemoved()) : new CheckoutResult(new ArrayList<String>(dco.getUpdated().keySet()), dco.getRemoved());
            Ref ref2 = ref;
            return ref2;
        }
        catch (IOException ioe) {
            throw new JGitInternalException(ioe.getMessage(), ioe);
        }
        finally {
            if (this.status == null) {
                this.status = CheckoutResult.ERROR_RESULT;
            }
        }
    }

    private String getShortBranchName(Ref headRef) {
        if (headRef.isSymbolic()) {
            return Repository.shortenRefName(headRef.getTarget().getName());
        }
        ObjectId id = headRef.getObjectId();
        if (id == null) {
            throw new NullPointerException();
        }
        return id.getName();
    }

    public CheckoutCommand setProgressMonitor(ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }

    public CheckoutCommand addPath(String path) {
        this.checkCallable();
        this.paths.add(path);
        return this;
    }

    public CheckoutCommand addPaths(List<String> p) {
        this.checkCallable();
        this.paths.addAll(p);
        return this;
    }

    public CheckoutCommand setAllPaths(boolean all) {
        this.checkoutAllPaths = all;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CheckoutCommand checkoutPaths() throws IOException, RefNotFoundException {
        this.actuallyModifiedPaths = new HashSet<String>();
        DirCache dc = this.repo.lockDirCache();
        try (RevWalk revWalk = new RevWalk(this.repo);
             TreeWalk treeWalk = new TreeWalk(this.repo, revWalk.getObjectReader());){
            treeWalk.setRecursive(true);
            if (!this.checkoutAllPaths) {
                treeWalk.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            if (this.isCheckoutIndex()) {
                this.checkoutPathsFromIndex(treeWalk, dc);
            } else {
                RevCommit commit2 = revWalk.parseCommit(this.getStartPointObjectId());
                this.checkoutPathsFromCommit(treeWalk, dc, commit2);
            }
        }
        finally {
            try {
                dc.unlock();
            }
            finally {
                WorkingTreeModifiedEvent event = new WorkingTreeModifiedEvent(this.actuallyModifiedPaths, null);
                this.actuallyModifiedPaths = null;
                if (!event.isEmpty()) {
                    this.repo.fireEvent(event);
                }
            }
        }
        return this;
    }

    private void checkoutPathsFromIndex(TreeWalk treeWalk, DirCache dc) throws IOException {
        DirCacheIterator dci = new DirCacheIterator(dc);
        treeWalk.addTree(dci);
        String previousPath = null;
        final ObjectReader r = treeWalk.getObjectReader();
        DirCacheEditor editor2 = dc.editor();
        while (treeWalk.next()) {
            final String path = treeWalk.getPathString();
            if (path.equals(previousPath)) continue;
            final CoreConfig.EolStreamType eolStreamType = treeWalk.getEolStreamType(TreeWalk.OperationType.CHECKOUT_OP);
            final String filterCommand = treeWalk.getFilterCommand("smudge");
            editor2.add(new DirCacheEditor.PathEdit(path){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void apply(DirCacheEntry ent) {
                    int stage = ent.getStage();
                    if (stage <= 0) {
                        CheckoutCommand.this.checkoutPath(ent, r, new DirCacheCheckout.CheckoutMetadata(eolStreamType, filterCommand));
                        CheckoutCommand.this.actuallyModifiedPaths.add(path);
                        return;
                    }
                    if (CheckoutCommand.this.checkoutStage != null) {
                        if (stage != CheckoutCommand.this.checkoutStage.number) return;
                        CheckoutCommand.this.checkoutPath(ent, r, new DirCacheCheckout.CheckoutMetadata(eolStreamType, filterCommand));
                        CheckoutCommand.this.actuallyModifiedPaths.add(path);
                        return;
                    }
                    UnmergedPathException e = new UnmergedPathException(ent);
                    throw new JGitInternalException(e.getMessage(), e);
                }
            });
            previousPath = path;
        }
        editor2.commit();
    }

    private void checkoutPathsFromCommit(TreeWalk treeWalk, DirCache dc, RevCommit commit2) throws IOException {
        treeWalk.addTree(commit2.getTree());
        final ObjectReader r = treeWalk.getObjectReader();
        DirCacheEditor editor2 = dc.editor();
        while (treeWalk.next()) {
            final ObjectId blobId = treeWalk.getObjectId(0);
            final FileMode mode = treeWalk.getFileMode(0);
            final CoreConfig.EolStreamType eolStreamType = treeWalk.getEolStreamType(TreeWalk.OperationType.CHECKOUT_OP);
            final String filterCommand = treeWalk.getFilterCommand("smudge");
            final String path = treeWalk.getPathString();
            editor2.add(new DirCacheEditor.PathEdit(path){

                @Override
                public void apply(DirCacheEntry ent) {
                    ent.setObjectId(blobId);
                    ent.setFileMode(mode);
                    CheckoutCommand.this.checkoutPath(ent, r, new DirCacheCheckout.CheckoutMetadata(eolStreamType, filterCommand));
                    CheckoutCommand.this.actuallyModifiedPaths.add(path);
                }
            });
        }
        editor2.commit();
    }

    private void checkoutPath(DirCacheEntry entry, ObjectReader reader, DirCacheCheckout.CheckoutMetadata checkoutMetadata) {
        try {
            DirCacheCheckout.checkoutEntry(this.repo, entry, reader, true, checkoutMetadata);
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().checkoutConflictWithFile, entry.getPathString()), e);
        }
    }

    private boolean isCheckoutIndex() {
        return this.startCommit == null && this.startPoint == null;
    }

    private ObjectId getStartPointObjectId() throws AmbiguousObjectException, RefNotFoundException, IOException {
        if (this.startCommit != null) {
            return this.startCommit.getId();
        }
        String startPointOrHead = this.startPoint != null ? this.startPoint : "HEAD";
        ObjectId result = this.repo.resolve(startPointOrHead);
        if (result == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, startPointOrHead));
        }
        return result;
    }

    private void processOptions() throws InvalidRefNameException, RefAlreadyExistsException, IOException {
        Ref refToCheck;
        if ((!this.checkoutAllPaths && this.paths.isEmpty() || this.orphan) && (this.name == null || !Repository.isValidRefName("refs/heads/" + this.name))) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().branchNameInvalid, this.name == null ? "<null>" : this.name));
        }
        if (this.orphan && (refToCheck = this.repo.exactRef(this.getBranchName())) != null) {
            throw new RefAlreadyExistsException(MessageFormat.format(JGitText.get().refAlreadyExists, this.name));
        }
    }

    private String getBranchName() {
        if (this.name.startsWith("refs/")) {
            return this.name;
        }
        return "refs/heads/" + this.name;
    }

    public CheckoutCommand setName(String name) {
        this.checkCallable();
        this.name = name;
        return this;
    }

    public CheckoutCommand setCreateBranch(boolean createBranch) {
        this.checkCallable();
        this.createBranch = createBranch;
        return this;
    }

    public CheckoutCommand setOrphan(boolean orphan) {
        this.checkCallable();
        this.orphan = orphan;
        return this;
    }

    public CheckoutCommand setForce(boolean force) {
        this.checkCallable();
        this.force = force;
        return this;
    }

    public CheckoutCommand setStartPoint(String startPoint) {
        this.checkCallable();
        this.startPoint = startPoint;
        this.startCommit = null;
        this.checkOptions();
        return this;
    }

    public CheckoutCommand setStartPoint(RevCommit startCommit) {
        this.checkCallable();
        this.startCommit = startCommit;
        this.startPoint = null;
        this.checkOptions();
        return this;
    }

    public CheckoutCommand setUpstreamMode(CreateBranchCommand.SetupUpstreamMode mode) {
        this.checkCallable();
        this.upstreamMode = mode;
        return this;
    }

    public CheckoutCommand setStage(Stage stage) {
        this.checkCallable();
        this.checkoutStage = stage;
        this.checkOptions();
        return this;
    }

    public CheckoutResult getResult() {
        if (this.status == null) {
            return CheckoutResult.NOT_TRIED_RESULT;
        }
        return this.status;
    }

    private void checkOptions() {
        if (this.checkoutStage != null && !this.isCheckoutIndex()) {
            throw new IllegalStateException(JGitText.get().cannotCheckoutOursSwitchBranch);
        }
    }

    public static enum Stage {
        BASE(1),
        OURS(2),
        THEIRS(3);

        private final int number;

        private Stage(int number) {
            this.number = number;
        }
    }
}

