/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.repo;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class HgRepositoryFiles {
    @NonNls
    private static final String BRANCHHEADS = "cache/branch";
    @NonNls
    private static final String BRANCHEADSDIR = "cache";
    @NonNls
    private static final String MERGE = "merge";
    @NonNls
    private static final String REBASE = "rebase";
    @NonNls
    private static final String BRANCH = "branch";
    @NonNls
    private static final String DIRSTATE = "dirstate";
    @NonNls
    private static final String BOOKMARKS = "bookmarks";
    @NonNls
    private static final String LOCAL_TAGS = "localtags";
    @NonNls
    private static final String TAGS = ".hgtags";
    @NonNls
    private static final String CURRENT_BOOKMARK = "bookmarks.current";
    @NonNls
    private static final String MQDIR = "patches";
    @NonNls
    private static final String CONFIG_HGRC = "hgrc";
    @NonNls
    public static final String HGIGNORE = ".hgignore";
    @NotNull
    private final String myBranchHeadsPath;
    @NotNull
    private final String myBranchHeadsDirPath;
    @NotNull
    private final String myMergePath;
    @NotNull
    private final String myRebasePath;
    @NotNull
    private final String myBranchPath;
    @NotNull
    private final String myDirstatePath;
    @NotNull
    private final String myBookmarksPath;
    @NotNull
    private final String myTagsPath;
    @NotNull
    private final String myLocalTagsPath;
    @NotNull
    private final String myCurrentBookmarkPath;
    @NotNull
    private final String myMQDirPath;
    @NotNull
    private final String myConfigHgrcPath;
    @NotNull
    private final String myHgIgnorePath;

    @NotNull
    public static HgRepositoryFiles getInstance(@NotNull VirtualFile hgDir) {
        if (hgDir == null) {
            HgRepositoryFiles.$$$reportNull$$$0(0);
        }
        return new HgRepositoryFiles(hgDir);
    }

    private HgRepositoryFiles(@NotNull VirtualFile hgDir) {
        if (hgDir == null) {
            HgRepositoryFiles.$$$reportNull$$$0(1);
        }
        this.myBranchHeadsPath = hgDir.getPath() + HgRepositoryFiles.slash(BRANCHHEADS);
        this.myBranchHeadsDirPath = hgDir.getPath() + HgRepositoryFiles.slash(BRANCHEADSDIR);
        this.myBranchPath = hgDir.getPath() + HgRepositoryFiles.slash(BRANCH);
        this.myDirstatePath = hgDir.getPath() + HgRepositoryFiles.slash(DIRSTATE);
        this.myMergePath = hgDir.getPath() + HgRepositoryFiles.slash(MERGE);
        this.myRebasePath = hgDir.getPath() + HgRepositoryFiles.slash(REBASE);
        this.myBookmarksPath = hgDir.getPath() + HgRepositoryFiles.slash(BOOKMARKS);
        VirtualFile repoDir = hgDir.getParent();
        this.myTagsPath = repoDir.getPath() + HgRepositoryFiles.slash(TAGS);
        this.myLocalTagsPath = hgDir.getPath() + HgRepositoryFiles.slash(LOCAL_TAGS);
        this.myCurrentBookmarkPath = hgDir.getPath() + HgRepositoryFiles.slash(CURRENT_BOOKMARK);
        this.myMQDirPath = hgDir.getPath() + HgRepositoryFiles.slash(MQDIR);
        this.myConfigHgrcPath = hgDir.getPath() + HgRepositoryFiles.slash(CONFIG_HGRC);
        this.myHgIgnorePath = repoDir.getPath() + HgRepositoryFiles.slash(HGIGNORE);
    }

    @NotNull
    private static String slash(@NotNull String s) {
        if (s == null) {
            HgRepositoryFiles.$$$reportNull$$$0(2);
        }
        String string = "/" + s;
        if (string == null) {
            HgRepositoryFiles.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    static Collection<String> getSubDirRelativePaths() {
        List<String> list = Arrays.asList(HgRepositoryFiles.slash(BRANCHHEADS), HgRepositoryFiles.slash(MERGE));
        if (list == null) {
            HgRepositoryFiles.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public String getBranchHeadsDirPath() {
        String string = this.myBranchHeadsDirPath;
        if (string == null) {
            HgRepositoryFiles.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getMQDirPath() {
        String string = this.myMQDirPath;
        if (string == null) {
            HgRepositoryFiles.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isbranchHeadsFile(String filePath) {
        return filePath.startsWith(this.myBranchHeadsPath);
    }

    public boolean isBranchFile(String filePath) {
        return filePath.equals(this.myBranchPath);
    }

    public boolean isDirstateFile(String filePath) {
        return filePath.equals(this.myDirstatePath);
    }

    public boolean isMergeFile(String filePath) {
        return filePath.startsWith(this.myMergePath);
    }

    public boolean isRebaseFile(String filePath) {
        return filePath.startsWith(this.myRebasePath);
    }

    public boolean isBookmarksFile(String filePath) {
        return filePath.equals(this.myBookmarksPath);
    }

    public boolean isCurrentBookmarksFile(String filePath) {
        return filePath.equals(this.myCurrentBookmarkPath);
    }

    public boolean isConfigHgrcFile(String filePath) {
        return filePath.equals(this.myConfigHgrcPath);
    }

    public boolean isTagsFile(String filePath) {
        return filePath.equals(this.myTagsPath);
    }

    public boolean isLocalTagsFile(String filePath) {
        return filePath.equals(this.myLocalTagsPath);
    }

    public boolean isMqFile(String filePath) {
        return filePath.startsWith(this.myMQDirPath);
    }

    public boolean isHgIgnore(String filePath) {
        return filePath.equals(this.myHgIgnorePath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hgDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/repo/HgRepositoryFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/repo/HgRepositoryFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "slash";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubDirRelativePaths";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchHeadsDirPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMQDirPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "slash";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

