/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.config;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.roots.impl.storage.ClasspathStorageProvider;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.workspaceModel.ide.JpsFileEntitySource;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleManagerBridgeImpl;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageDiffBuilder;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.io.IOException;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.eclipse.EclipseBundle;
import org.jetbrains.idea.eclipse.config.CachedXmlDocumentSet;
import org.jetbrains.idea.eclipse.config.EclipseModuleManagerImpl;
import org.jetbrains.idea.eclipse.config.EclipseProjectFile;
import org.jetbrains.idea.eclipse.conversion.DotProjectFileHelper;
import org.jetbrains.idea.eclipse.conversion.EPathUtil;
import org.jetbrains.idea.eclipse.conversion.EclipseClasspathWriter;

public final class EclipseClasspathStorageProvider
implements ClasspathStorageProvider {
    @NotNull
    @NonNls
    public String getID() {
        return "eclipse";
    }

    @NotNull
    @Nls
    public String getDescription() {
        String string = EclipseClasspathStorageProvider.getDescr();
        if (string == null) {
            EclipseClasspathStorageProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void assertCompatible(@NotNull ModuleRootModel model) throws ConfigurationException {
        if (model == null) {
            EclipseClasspathStorageProvider.$$$reportNull$$$0(1);
        }
        String moduleName = model.getModule().getName();
        for (OrderEntry entry : model.getOrderEntries()) {
            Library library;
            LibraryOrderEntry libraryEntry;
            if (!(entry instanceof LibraryOrderEntry) || !(libraryEntry = (LibraryOrderEntry)entry).isModuleLevel() || (library = libraryEntry.getLibrary()) != null && libraryEntry.getRootUrls(OrderRootType.CLASSES).length == 1 && !library.isJarDirectory(library.getUrls(OrderRootType.CLASSES)[0])) continue;
            throw new ConfigurationException(EclipseBundle.message("incompatible.eclipse.module.format.message.library.root", entry.getPresentableName(), moduleName));
        }
        if (model.getContentRoots().length == 0) {
            throw new ConfigurationException(EclipseBundle.message("incompatible.eclipse.module.format.message.no.content.roots", moduleName));
        }
        String output = ((CompilerModuleExtension)model.getModuleExtension(CompilerModuleExtension.class)).getCompilerOutputUrl();
        String contentRoot = this.getContentRoot(model);
        if (output == null || !StringUtil.startsWith((CharSequence)VfsUtilCore.urlToPath((String)output), (CharSequence)contentRoot) && PathMacroManager.getInstance((ComponentManager)model.getModule()).collapsePath(output).equals(output)) {
            throw new ConfigurationException(EclipseBundle.message("incompatible.eclipse.module.format.message.output", moduleName));
        }
    }

    public void detach(@NotNull Module module) {
        if (module == null) {
            EclipseClasspathStorageProvider.$$$reportNull$$$0(2);
        }
        EclipseModuleManagerImpl.getInstance(module).setDocumentSet(null);
        EclipseClasspathStorageProvider.updateEntitySource(module, source -> ((EclipseProjectFile)source).getInternalSource());
    }

    private static void updateEntitySource(Module module, Function<? super EntitySource, ? extends EntitySource> updateSource) {
        ModuleBridge moduleBridge = (ModuleBridge)module;
        WorkspaceEntityStorage moduleEntityStorage = moduleBridge.getEntityStorage().getCurrent();
        ModuleEntity moduleEntity = ModuleManagerBridgeImpl.findModuleEntity((WorkspaceEntityStorage)moduleEntityStorage, (ModuleBridge)moduleBridge);
        if (moduleEntity != null) {
            EntitySource entitySource2 = moduleEntity.getEntitySource();
            ModuleManagerBridgeImpl.changeModuleEntitySource((ModuleBridge)moduleBridge, (WorkspaceEntityStorage)moduleEntityStorage, (EntitySource)updateSource.apply((EntitySource)entitySource2), (WorkspaceEntityStorageDiffBuilder)moduleBridge.getDiff());
        }
    }

    public void attach(@NotNull ModuleRootModel model) {
        if (model == null) {
            EclipseClasspathStorageProvider.$$$reportNull$$$0(3);
        }
        EclipseClasspathStorageProvider.updateEntitySource(model.getModule(), source -> {
            VirtualFileUrlManager virtualFileUrlManager = VirtualFileUrlManagerUtil.getInstance((VirtualFileUrlManager.Companion)VirtualFileUrlManager.Companion, (Project)model.getModule().getProject());
            String contentRoot = this.getContentRoot(model);
            String classpathFileUrl = VfsUtilCore.pathToUrl((String)contentRoot) + "/.classpath";
            return new EclipseProjectFile(virtualFileUrlManager.fromUrl(classpathFileUrl), (JpsFileEntitySource)source);
        });
    }

    public String getContentRoot(@NotNull ModuleRootModel model) {
        VirtualFile contentRoot;
        if (model == null) {
            EclipseClasspathStorageProvider.$$$reportNull$$$0(4);
        }
        return (contentRoot = EPathUtil.getContentRoot(model)) == null ? model.getContentRoots()[0].getPath() : contentRoot.getPath();
    }

    public void modulePathChanged(@NotNull Module module) {
        EclipseModuleManagerImpl moduleManager;
        if (module == null) {
            EclipseClasspathStorageProvider.$$$reportNull$$$0(5);
        }
        if ((moduleManager = EclipseModuleManagerImpl.getInstance(module)) != null) {
            moduleManager.setDocumentSet(null);
        }
    }

    @NotNull
    static CachedXmlDocumentSet getFileCache(@NotNull Module module) {
        EclipseModuleManagerImpl moduleManager;
        CachedXmlDocumentSet fileCache;
        if (module == null) {
            EclipseClasspathStorageProvider.$$$reportNull$$$0(6);
        }
        CachedXmlDocumentSet cachedXmlDocumentSet = fileCache = (moduleManager = EclipseModuleManagerImpl.getInstance(module)) != null ? moduleManager.getDocumentSet() : null;
        if (fileCache == null) {
            fileCache = new CachedXmlDocumentSet();
            if (moduleManager != null) {
                moduleManager.setDocumentSet(fileCache);
            }
            String storageRoot = ClasspathStorage.getStorageRootFromOptions((Module)module);
            fileCache.register(".classpath", storageRoot);
            fileCache.register(".project", storageRoot);
            fileCache.register("plugin.xml", storageRoot);
            fileCache.register(module.getName() + ".eml", ModuleUtilCore.getModuleDirPath((Module)module));
        }
        CachedXmlDocumentSet cachedXmlDocumentSet2 = fileCache;
        if (cachedXmlDocumentSet2 == null) {
            EclipseClasspathStorageProvider.$$$reportNull$$$0(7);
        }
        return cachedXmlDocumentSet2;
    }

    public void moduleRenamed(@NotNull Module module, @NotNull String oldName, @NotNull String newName) {
        if (module == null) {
            EclipseClasspathStorageProvider.$$$reportNull$$$0(8);
        }
        if (oldName == null) {
            EclipseClasspathStorageProvider.$$$reportNull$$$0(9);
        }
        if (newName == null) {
            EclipseClasspathStorageProvider.$$$reportNull$$$0(10);
        }
        try {
            VirtualFile source;
            CachedXmlDocumentSet fileSet = EclipseClasspathStorageProvider.getFileCache(module);
            VirtualFile root = LocalFileSystem.getInstance().findFileByPath(ModuleUtilCore.getModuleDirPath((Module)module));
            VirtualFile virtualFile = source = root == null ? null : root.findChild(oldName + ".eml");
            if (source != null && source.isValid()) {
                WriteAction.run(() -> source.rename((Object)this, newName + ".eml"));
            }
            DotProjectFileHelper.saveDotProjectFile(module, fileSet.getParent(".project"));
            fileSet.unregister(oldName + ".eml");
            fileSet.register(newName + ".eml", ModuleUtilCore.getModuleDirPath((Module)module));
        }
        catch (IOException e) {
            EclipseClasspathWriter.LOG.warn((Throwable)e);
        }
    }

    @Nls
    public static String getDescr() {
        return EclipseBundle.message("eclipse.classpath.storage.description", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/eclipse/config/EclipseClasspathStorageProvider";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/eclipse/config/EclipseClasspathStorageProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileCache";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "assertCompatible";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "detach";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "attach";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getContentRoot";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "modulePathChanged";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFileCache";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "moduleRenamed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

