/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.conversion;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.EclipseJDOMUtil;
import org.jetbrains.annotations.NotNull;

public final class DotProjectFileHelper {
    private static final Logger LOG = Logger.getInstance(DotProjectFileHelper.class);

    private DotProjectFileHelper() {
    }

    public static void saveDotProjectFile(@NotNull Module module, @NotNull String storageRoot) throws IOException {
        if (module == null) {
            DotProjectFileHelper.$$$reportNull$$$0(0);
        }
        if (storageRoot == null) {
            DotProjectFileHelper.$$$reportNull$$$0(1);
        }
        try {
            Element rootElement = DotProjectFileHelper.generateProjectFileContent(ModuleType.get((Module)module), module.getName());
            File projectFile = new File(storageRoot, ".project");
            if (!FileUtil.createIfDoesntExist((File)projectFile)) {
                return;
            }
            EclipseJDOMUtil.output(rootElement, projectFile, module.getProject());
            ApplicationManager.getApplication().runWriteAction(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)projectFile.getPath())));
        }
        catch (JDOMException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public static Element generateProjectFileContent(@NotNull ModuleType<?> moduleType, @NotNull String moduleName) throws JDOMException, IOException {
        if (moduleType == null) {
            DotProjectFileHelper.$$$reportNull$$$0(2);
        }
        if (moduleName == null) {
            DotProjectFileHelper.$$$reportNull$$$0(3);
        }
        Element rootElement = moduleType instanceof JavaModuleType ? JDOMUtil.load((URL)DotProjectFileHelper.class.getResource("template.project.xml")) : JDOMUtil.load((URL)DotProjectFileHelper.class.getResource("template.empty.project.xml"));
        rootElement.getChild("name").setText(moduleName);
        Element element = rootElement;
        if (element == null) {
            DotProjectFileHelper.$$$reportNull$$$0(4);
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageRoot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/eclipse/conversion/DotProjectFileHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/eclipse/conversion/DotProjectFileHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generateProjectFileContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "saveDotProjectFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generateProjectFileContent";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

