/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.core.ij.md;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import org.intellij.plugins.markdown.extensions.MarkdownConfigurableExtension;
import org.intellij.plugins.markdown.extensions.jcef.MarkdownJCEFPreviewExtension;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.server.core.ij.md.PanelDelegate;
import org.jetbrains.projector.server.core.ij.md.ProjectorMarkdownPanel;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0006\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0006\u0010\u0015\u001a\u00020\u000bJ\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J-\u0010\u0017\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u0019\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00050\u001a\"\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u0005J\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0013H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/projector/server/core/ij/md/ProjectorMarkdownPanel;", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "isAgent", "", "agentDelegateClass", "", "(ZLjava/lang/String;)V", "agentDelegate", "clientDelegate", "Lorg/jetbrains/projector/server/core/ij/md/PanelDelegate;", "addScrollListener", "", "listener", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel$ScrollListener;", "dispose", "getComponent", "Ljavax/swing/JComponent;", "reloadWithOffset", "offset", "", "removeScrollListener", "render", "scrollToMarkdownSrcOffset", "setCSS", "inlineCss", "fileUris", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "setHtml", "html", "initialScrollOffset", "Companion", "projector-server-core"})
public final class ProjectorMarkdownPanel
implements MarkdownHtmlPanel {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final boolean isAgent;
    @Nullable
    private final MarkdownHtmlPanel agentDelegate;
    @NotNull
    private final PanelDelegate clientDelegate;
    @Deprecated
    @NotNull
    private static final Logger logger;
    @Deprecated
    @NotNull
    private static final Lazy<Boolean> isRenderMethodRemoved$delegate;
    @Deprecated
    @NotNull
    private static final Lazy<Method> setHtmlMethod$delegate;
    @Deprecated
    @NotNull
    private static final Lazy<Method> setCSSMethod$delegate;
    @Deprecated
    @NotNull
    private static final Lazy<Method> renderMethod$delegate;

    public ProjectorMarkdownPanel(boolean isAgent, @NotNull String agentDelegateClass) {
        MarkdownHtmlPanel markdownHtmlPanel;
        Intrinsics.checkNotNullParameter((Object)agentDelegateClass, (String)"agentDelegateClass");
        this.isAgent = isAgent;
        MarkdownHtmlPanel markdownHtmlPanel2 = this.agentDelegate = this.isAgent ? ProjectorMarkdownPanel.Companion.createNativeMarkdownPanel(agentDelegateClass) : null;
        this.clientDelegate = new PanelDelegate(this.isAgent ? ((markdownHtmlPanel = this.agentDelegate) == null ? null : markdownHtmlPanel.getComponent()) : null);
    }

    public void dispose() {
        MarkdownHtmlPanel markdownHtmlPanel = this.agentDelegate;
        if (markdownHtmlPanel != null) {
            markdownHtmlPanel.dispose();
        }
        this.clientDelegate.dispose();
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent;
        if (this.isAgent) {
            MarkdownHtmlPanel markdownHtmlPanel = this.agentDelegate;
            Intrinsics.checkNotNull((Object)markdownHtmlPanel);
            JComponent jComponent2 = markdownHtmlPanel.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"agentDelegate!!.component");
            jComponent = jComponent2;
        } else {
            jComponent = this.clientDelegate.getComponent();
        }
        return jComponent;
    }

    public final void setHtml(@NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        MarkdownHtmlPanel markdownHtmlPanel = this.agentDelegate;
        if (markdownHtmlPanel != null) {
            ProjectorMarkdownPanel.Companion.setHtml(markdownHtmlPanel, html);
        }
        this.clientDelegate.setHtml(html);
    }

    public final void setCSS(@Nullable String inlineCss, String ... fileUris) {
        Intrinsics.checkNotNullParameter((Object)fileUris, (String)"fileUris");
        MarkdownHtmlPanel markdownHtmlPanel = this.agentDelegate;
        if (markdownHtmlPanel != null) {
            ProjectorMarkdownPanel.Companion.setCSS(markdownHtmlPanel, inlineCss, Arrays.copyOf(fileUris, fileUris.length));
        }
        this.clientDelegate.setCSS(inlineCss, Arrays.copyOf(fileUris, fileUris.length));
    }

    public final void render() {
        MarkdownHtmlPanel markdownHtmlPanel = this.agentDelegate;
        if (markdownHtmlPanel != null) {
            ProjectorMarkdownPanel.Companion.render(markdownHtmlPanel);
        }
        this.clientDelegate.render();
    }

    public void setHtml(@NotNull String html, int initialScrollOffset) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        Object object = this.agentDelegate;
        if (object != null) {
            object.setHtml(html, initialScrollOffset);
        }
        this.clientDelegate.setHtml(html, initialScrollOffset);
        if (ProjectorMarkdownPanel.Companion.isRenderMethodRemoved()) {
            Iterable iterable = ProjectorMarkdownPanel.Companion.getStyleUrls();
            object = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"lineSeparator()");
            this.clientDelegate.setCSS(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)((CharSequence)object), null, null, (int)0, null, null, (int)62, null), new String[0]);
            this.clientDelegate.render();
        }
    }

    public void reloadWithOffset(int offset) {
        MarkdownHtmlPanel markdownHtmlPanel = this.agentDelegate;
        if (markdownHtmlPanel != null) {
            markdownHtmlPanel.reloadWithOffset(offset);
        }
    }

    public void scrollToMarkdownSrcOffset(int offset) {
        MarkdownHtmlPanel markdownHtmlPanel = this.agentDelegate;
        if (markdownHtmlPanel != null) {
            markdownHtmlPanel.scrollToMarkdownSrcOffset(offset);
        }
        this.clientDelegate.scrollToMarkdownSrcOffset(offset);
    }

    public void addScrollListener(@Nullable MarkdownHtmlPanel.ScrollListener listener) {
        MarkdownHtmlPanel markdownHtmlPanel = this.agentDelegate;
        if (markdownHtmlPanel != null) {
            markdownHtmlPanel.addScrollListener(listener);
        }
    }

    public void removeScrollListener(@Nullable MarkdownHtmlPanel.ScrollListener listener) {
        MarkdownHtmlPanel markdownHtmlPanel = this.agentDelegate;
        if (markdownHtmlPanel != null) {
            markdownHtmlPanel.removeScrollListener(listener);
        }
    }

    static {
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(ProjectorMarkdownPanel.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logger = LoggerKt.Logger((String)string);
        isRenderMethodRemoved$delegate = LazyKt.lazy((Function0)Companion.isRenderMethodRemoved.2.INSTANCE);
        setHtmlMethod$delegate = LazyKt.lazy((Function0)Companion.setHtmlMethod.2.INSTANCE);
        setCSSMethod$delegate = LazyKt.lazy((Function0)Companion.setCSSMethod.2.INSTANCE);
        renderMethod$delegate = LazyKt.lazy((Function0)Companion.renderMethod.2.INSTANCE);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u001eH\u0002J\f\u0010#\u001a\u00020$*\u00020!H\u0002J3\u0010%\u001a\u00020$*\u00020!2\b\u0010&\u001a\u0004\u0018\u00010\u001e2\u0016\u0010'\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001e0(\"\u0004\u0018\u00010\u001eH\u0002\u00a2\u0006\u0002\u0010)J\u0014\u0010*\u001a\u00020$*\u00020!2\u0006\u0010+\u001a\u00020\u001eH\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0003\u0010\u0005R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R#\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0007\u001a\u0004\b\u0014\u0010\u0015R#\u0010\u0017\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0007\u001a\u0004\b\u0018\u0010\u0015R#\u0010\u001a\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0007\u001a\u0004\b\u001b\u0010\u0015R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0010\u00a8\u0006,"}, d2={"Lorg/jetbrains/projector/server/core/ij/md/ProjectorMarkdownPanel$Companion;", "", "()V", "isRenderMethodRemoved", "", "()Z", "isRenderMethodRemoved$delegate", "Lkotlin/Lazy;", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "getLogger", "()Lorg/jetbrains/projector/util/logging/Logger;", "markdownExtensions", "", "Lorg/intellij/plugins/markdown/extensions/jcef/MarkdownJCEFPreviewExtension;", "getMarkdownExtensions", "()Ljava/util/List;", "renderMethod", "Ljava/lang/reflect/Method;", "kotlin.jvm.PlatformType", "getRenderMethod", "()Ljava/lang/reflect/Method;", "renderMethod$delegate", "setCSSMethod", "getSetCSSMethod", "setCSSMethod$delegate", "setHtmlMethod", "getSetHtmlMethod", "setHtmlMethod$delegate", "styleUrls", "", "getStyleUrls", "createNativeMarkdownPanel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "className", "render", "", "setCSS", "inlineCss", "fileUris", "", "(Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;Ljava/lang/String;[Ljava/lang/String;)V", "setHtml", "html", "projector-server-core"})
    private static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        /*
         * WARNING - void declaration
         */
        private final List<MarkdownJCEFPreviewExtension> getMarkdownExtensions() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = MarkdownJCEFPreviewExtension.Companion.getAll();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MarkdownJCEFPreviewExtension it = (MarkdownJCEFPreviewExtension)element$iv$iv;
                boolean bl = false;
                if (!(it instanceof MarkdownConfigurableExtension ? ((MarkdownConfigurableExtension)it).isEnabled() : true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> getStyleUrls() {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = this.getMarkdownExtensions();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapNotNullTo$iv$iv;
                MarkdownJCEFPreviewExtension extension = (MarkdownJCEFPreviewExtension)element$iv$iv;
                boolean bl = false;
                Iterable $this$mapNotNull$iv = extension.getStyles();
                boolean $i$f$mapNotNull = false;
                Iterable iterable2 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String string;
                    Object element$iv$iv$iv;
                    Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    String style = (String)element$iv$iv2;
                    boolean bl3 = false;
                    ResourceProvider.Resource resource = extension.getResourceProvider().loadResource(style);
                    if (resource == null) {
                        string = null;
                    } else {
                        byte[] byArray = resource.getContent();
                        if (byArray == null) {
                            string = null;
                        } else {
                            byte[] byArray2 = byArray;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            byte[] it = byArray2;
                            boolean bl6 = false;
                            boolean bl7 = false;
                            string = new String(it, Charsets.UTF_8);
                        }
                    }
                    if (string == null) continue;
                    String string2 = string;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    String it$iv$iv = string2;
                    boolean bl10 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final boolean isRenderMethodRemoved() {
            Lazy lazy = isRenderMethodRemoved$delegate;
            boolean bl = false;
            return (Boolean)lazy.getValue();
        }

        private final Method getSetHtmlMethod() {
            Lazy lazy = setHtmlMethod$delegate;
            boolean bl = false;
            return (Method)lazy.getValue();
        }

        private final Method getSetCSSMethod() {
            Lazy lazy = setCSSMethod$delegate;
            boolean bl = false;
            return (Method)lazy.getValue();
        }

        private final Method getRenderMethod() {
            Lazy lazy = renderMethod$delegate;
            boolean bl = false;
            return (Method)lazy.getValue();
        }

        private final void setHtml(MarkdownHtmlPanel $this$setHtml, String html) {
            Object[] objectArray = new Object[]{html};
            this.getSetHtmlMethod().invoke((Object)$this$setHtml, objectArray);
        }

        private final void setCSS(MarkdownHtmlPanel $this$setCSS, String inlineCss, String ... fileUris) {
            Object[] objectArray = new Object[]{inlineCss, fileUris};
            this.getSetCSSMethod().invoke((Object)$this$setCSS, objectArray);
        }

        private final void render(MarkdownHtmlPanel $this$render) {
            this.getRenderMethod().invoke((Object)$this$render, new Object[0]);
        }

        private final MarkdownHtmlPanel createNativeMarkdownPanel(String className) {
            Object object;
            try {
                object = Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                object = object instanceof MarkdownHtmlPanel ? (MarkdownHtmlPanel)object : null;
            }
            catch (Exception e) {
                this.getLogger().error((Throwable)e, (Function0)new Function0<String>(className){
                    final /* synthetic */ String $className;
                    {
                        this.$className = $className;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Exception during instantiating MarkdownHtmlPanel of type " + this.$className;
                    }
                });
                object = null;
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "isRenderMethodRemoved", "isRenderMethodRemoved()Z"))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "setHtmlMethod", "getSetHtmlMethod()Ljava/lang/reflect/Method;"))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "setCSSMethod", "getSetCSSMethod()Ljava/lang/reflect/Method;"))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "renderMethod", "getRenderMethod()Ljava/lang/reflect/Method;")))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

