/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.core.websocket;

import java.net.SocketException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty0;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.handshake.ServerHandshake;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.common.protocol.toServer.ClientInControlEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientOutControlEvent;
import org.jetbrains.projector.common.protocol.toServer.KotlinxJsonClientEventSerializer;
import org.jetbrains.projector.common.protocol.toServer.RelayControlEvent;
import org.jetbrains.projector.server.core.ClientWrapper;
import org.jetbrains.projector.server.core.websocket.HttpWsClient;
import org.jetbrains.projector.server.core.websocket.HttpWsTransport;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000K\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\n\b&\u0018\u0000 !2\u00020\u0001:\u0001!B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J+\u0010\u0015\u001a\u00020\u00132!\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u00130\u0017H\u0016J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\b\u0010\u001d\u001a\u00020\u0013H\u0016J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lorg/jetbrains/projector/server/core/websocket/HttpWsClient;", "Lorg/jetbrains/projector/server/core/websocket/HttpWsTransport;", "relayUrl", "", "serverId", "(Ljava/lang/String;Ljava/lang/String;)V", "clients", "", "Lorg/java_websocket/client/WebSocketClient;", "controlWebSocket", "org/jetbrains/projector/server/core/websocket/HttpWsClient$controlWebSocket$1", "Lorg/jetbrains/projector/server/core/websocket/HttpWsClient$controlWebSocket$1;", "wasStarted", "", "getWasStarted", "()Z", "wasStarted$delegate", "Lkotlin/reflect/KProperty0;", "addClient", "", "clientId", "forEachOpenedConnection", "action", "Lkotlin/Function1;", "Lorg/jetbrains/projector/server/core/ClientWrapper;", "Lkotlin/ParameterName;", "name", "client", "removeClient", "start", "stop", "timeoutMs", "", "Companion", "projector-server-core"})
public abstract class HttpWsClient
implements HttpWsTransport {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final String relayUrl;
    @NotNull
    private final String serverId;
    @NotNull
    private final Map<String, WebSocketClient> clients;
    @NotNull
    private final controlWebSocket.1 controlWebSocket;
    @NotNull
    private final KProperty0 wasStarted$delegate;
    @Deprecated
    @NotNull
    private static final Logger logger;

    public HttpWsClient(@NotNull String relayUrl, @NotNull String serverId) {
        Intrinsics.checkNotNullParameter((Object)relayUrl, (String)"relayUrl");
        Intrinsics.checkNotNullParameter((Object)serverId, (String)"serverId");
        this.relayUrl = relayUrl;
        this.serverId = serverId;
        boolean bl = false;
        this.clients = new LinkedHashMap();
        URI uRI = new URI(this.relayUrl + "/register/" + this.serverId);
        Draft_6455 draft_6455 = new Draft_6455();
        this.controlWebSocket = new WebSocketClient(this, uRI, draft_6455){
            @Nullable
            private volatile Boolean wasInitialized;
            @NotNull
            private final ReentrantLock lock;
            private final Condition condition;
            final /* synthetic */ HttpWsClient this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, (Draft)$super_call_param$2);
                this.lock = new ReentrantLock();
                this.condition = this.lock.newCondition();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final boolean getWasStarted() {
                while (this.wasInitialized == null) {
                    Lock lock = this.lock;
                    boolean bl = false;
                    boolean bl2 = false;
                    lock.lock();
                    try {
                        boolean bl3 = false;
                        if (this.wasInitialized != null) {
                            Boolean bl4 = this.wasInitialized;
                            Intrinsics.checkNotNull((Object)bl4);
                            boolean bl5 = bl4;
                            return bl5;
                        }
                        this.condition.await();
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                Boolean bl = this.wasInitialized;
                Intrinsics.checkNotNull((Object)bl);
                return bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onOpen(@Nullable ServerHandshake handshakedata) {
                Lock lock = this.lock;
                boolean bl = false;
                boolean bl2 = false;
                lock.lock();
                try {
                    boolean bl3 = false;
                    this.wasInitialized = true;
                    this.condition.signal();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }

            public void onMessage(@Nullable String message2) {
                CharSequence charSequence = message2;
                boolean bl = false;
                boolean bl2 = false;
                if (charSequence == null || charSequence.length() == 0) {
                    return;
                }
                RelayControlEvent event = KotlinxJsonClientEventSerializer.INSTANCE.deserializeFromRelay(message2);
                if (event instanceof ClientInControlEvent) {
                    HttpWsClient.access$addClient(this.this$0, ((ClientInControlEvent)event).getId());
                } else if (event instanceof ClientOutControlEvent) {
                    HttpWsClient.access$removeClient(this.this$0, ((ClientOutControlEvent)event).getId());
                }
            }

            public void onClose(int code, @Nullable String reason, boolean remote) {
                WebSocket webSocket = this.getConnection();
                Intrinsics.checkNotNullExpressionValue((Object)webSocket, (String)"connection");
                this.this$0.onWsClose(webSocket);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(@NotNull Exception ex) {
                Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
                this.this$0.onError(this.getConnection(), ex);
                if (ex instanceof SocketException) {
                    Lock lock = this.lock;
                    boolean bl = false;
                    boolean bl2 = false;
                    lock.lock();
                    try {
                        boolean bl3 = false;
                        this.wasInitialized = false;
                        this.condition.signal();
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
        };
        this.wasStarted$delegate = (KProperty0)new PropertyReference0Impl((Object)this.controlWebSocket){

            @Nullable
            public Object get() {
                return ((Object)this.receiver).getWasStarted();
            }
        };
    }

    @Override
    public boolean getWasStarted() {
        KProperty0 kProperty0 = this.wasStarted$delegate;
        boolean bl = false;
        return (Boolean)kProperty0.get();
    }

    @Override
    public void start() {
        Logger.DefaultImpls.info$default((Logger)logger, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ HttpWsClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Control socket connected to server with URI: " + HttpWsClient.access$getControlWebSocket$p(this.this$0).getURI();
            }
        }), (int)1, null);
        this.controlWebSocket.connect();
    }

    @Override
    public void stop(int timeoutMs) {
        this.controlWebSocket.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void forEachOpenedConnection(@NotNull Function1<? super ClientWrapper, Unit> action) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Iterable $this$filter$iv = this.clients.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            WebSocket p0 = (WebSocket)element$iv$iv;
            boolean bl = false;
            if (!p0.isOpen()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WebSocketClient it = (WebSocketClient)element$iv;
            boolean bl = false;
            ClientWrapper clientWrapper = (ClientWrapper)it.getAttachment();
            if (clientWrapper == null) {
                return;
            }
            ClientWrapper wrapper = clientWrapper;
            action.invoke((Object)wrapper);
        }
    }

    private final void removeClient(String clientId) {
        this.clients.remove(clientId);
    }

    private final void addClient(String clientId) {
        Object object = new URI(this.relayUrl + "/accept/" + this.serverId + "/" + clientId);
        WebSocketClient clientWebSocket2 = new WebSocketClient(this, (URI)object){
            final /* synthetic */ HttpWsClient this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void onOpen(@Nullable ServerHandshake handshakedata) {
                WebSocket webSocket = this.getConnection();
                Intrinsics.checkNotNullExpressionValue((Object)webSocket, (String)"connection");
                this.this$0.onWsOpen(webSocket);
            }

            public void onMessage(@Nullable String message2) {
                CharSequence charSequence;
                block3: {
                    block2: {
                        if (message2 == null) break block2;
                        charSequence = message2;
                        boolean bl = false;
                        if (!(charSequence.length() == 0)) break block3;
                    }
                    return;
                }
                charSequence = this.getConnection();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"connection");
                this.this$0.onWsMessage((WebSocket)charSequence, message2);
            }

            public void onClose(int code, @Nullable String reason, boolean remote) {
                WebSocket webSocket = this.getConnection();
                Intrinsics.checkNotNullExpressionValue((Object)webSocket, (String)"connection");
                this.this$0.onWsClose(webSocket);
            }

            public void onError(@NotNull Exception ex) {
                Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
                this.this$0.onError(this.getConnection(), ex);
            }
        };
        clientWebSocket2.connect();
        object = this.clients;
        boolean bl = false;
        object.put(clientId, clientWebSocket2);
    }

    @Override
    public int getClientCount() {
        return HttpWsTransport.DefaultImpls.getClientCount(this);
    }

    public static final /* synthetic */ controlWebSocket.1 access$getControlWebSocket$p(HttpWsClient $this) {
        return $this.controlWebSocket;
    }

    public static final /* synthetic */ void access$addClient(HttpWsClient $this, String clientId) {
        $this.addClient(clientId);
    }

    public static final /* synthetic */ void access$removeClient(HttpWsClient $this, String clientId) {
        $this.removeClient(clientId);
    }

    static {
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(HttpWsClient.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logger = LoggerKt.Logger((String)string);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/projector/server/core/websocket/HttpWsClient$Companion;", "", "()V", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "projector-server-core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

