/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct;

import java.io.IOException;
import java.util.Map;
import org.jetbrains.java.decompiler.struct.StructMember;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class StructField
extends StructMember {
    private final String name;
    private final String descriptor;

    public static StructField create(DataInputFullStream in, ConstantPool pool, String clQualifiedName) throws IOException {
        int accessFlags = in.readUnsignedShort();
        int nameIndex = in.readUnsignedShort();
        int descriptorIndex = in.readUnsignedShort();
        String[] values = pool.getClassElement(1, clQualifiedName, nameIndex, descriptorIndex);
        Map<String, StructGeneralAttribute> attributes = StructField.readAttributes(in, pool);
        return new StructField(accessFlags, attributes, values[0], values[1]);
    }

    protected StructField(int accessFlags, Map<String, StructGeneralAttribute> attributes, String name, String descriptor) {
        super(accessFlags, attributes);
        this.name = name;
        this.descriptor = descriptor;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        return this.name;
    }
}

