/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import net.sf.saxon.tree.tiny.TinyElementImpl;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public abstract class SequenceWriter
extends SequenceReceiver {
    private Receiver outputter = null;
    private TreeModel treeModel = null;
    private Builder builder = null;
    private int level = 0;
    private boolean inStartTag = false;

    public SequenceWriter(PipelineConfiguration pipe) {
        super(pipe);
    }

    public abstract void write(Item var1) throws XPathException;

    @Override
    public void startDocument(int properties) throws XPathException {
        if (this.outputter == null) {
            this.createTree((properties & 0x8000) != 0);
        }
        if (this.level++ == 0) {
            this.outputter.startDocument(properties);
        }
    }

    @Override
    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
        if (this.builder != null) {
            this.builder.setUnparsedEntity(name, systemID, publicID);
        }
    }

    private void createTree(boolean mutable) throws XPathException {
        TreeModel model;
        PipelineConfiguration pipe = this.getPipelineConfiguration();
        if (this.treeModel != null) {
            this.builder = this.treeModel.makeBuilder(pipe);
        } else if (pipe.getController() != null) {
            this.builder = mutable ? ((model = pipe.getController().getModel()).isMutable() ? pipe.getController().makeBuilder() : new LinkedTreeBuilder(pipe)) : pipe.getController().makeBuilder();
        } else {
            model = this.getConfiguration().getParseOptions().getModel();
            this.builder = model.makeBuilder(pipe);
        }
        this.builder.setPipelineConfiguration(pipe);
        this.builder.setSystemId(this.systemId);
        this.builder.setBaseURI(this.systemId);
        this.builder.setTiming(false);
        this.builder.setUseEventLocation(false);
        NamespaceReducer reducer = new NamespaceReducer(this.builder);
        this.outputter = new ComplexContentOutputter(reducer);
        this.outputter.setSystemId(this.systemId);
        this.outputter.setPipelineConfiguration(pipe);
        this.outputter.open();
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    public void setTreeModel(TreeModel treeModel) {
        this.treeModel = treeModel;
    }

    @Override
    public void endDocument() throws XPathException {
        if (--this.level == 0) {
            this.outputter.endDocument();
            this.outputter = null;
            NodeInfo doc = this.builder.getCurrentRoot();
            this.append(doc, ExplicitLocation.UNKNOWN_LOCATION, 524288);
            this.systemId = null;
        }
        this.previousAtomic = false;
    }

    @Override
    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.outputter == null) {
            this.createTree((properties & 0x8000) != 0);
        }
        this.outputter.startElement(elemName, typeCode, location, properties);
        ++this.level;
        this.inStartTag = true;
        this.previousAtomic = false;
    }

    @Override
    public void endElement() throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        this.outputter.endElement();
        if (--this.level == 0) {
            this.outputter.close();
            this.outputter = null;
            NodeInfo element = this.builder.getCurrentRoot();
            this.append(element, ExplicitLocation.UNKNOWN_LOCATION, 524288);
            this.systemId = null;
        }
        this.previousAtomic = false;
    }

    @Override
    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        if (this.level == 0) {
            for (NamespaceBinding ns : namespaceBindings) {
                Orphan o = new Orphan(this.getConfiguration());
                o.setNodeKind((short)13);
                o.setNodeName(new NoNamespaceName(ns.getPrefix()));
                o.setStringValue(ns.getURI());
                this.append(o, ExplicitLocation.UNKNOWN_LOCATION, 524288);
            }
        } else {
            this.outputter.namespace(namespaceBindings, properties);
        }
        this.previousAtomic = false;
    }

    @Override
    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        if (this.level == 0) {
            Orphan o = new Orphan(this.getConfiguration());
            o.setNodeKind((short)2);
            o.setNodeName(attName);
            o.setStringValue(value);
            o.setTypeAnnotation(typeCode);
            this.append(o, locationId, 524288);
        } else {
            this.outputter.attribute(attName, typeCode, value, locationId, properties);
        }
        this.previousAtomic = false;
    }

    @Override
    public void startContent() throws XPathException {
        this.inStartTag = false;
        this.outputter.startContent();
        this.previousAtomic = false;
    }

    @Override
    public void characters(CharSequence s, Location locationId, int properties) throws XPathException {
        if (this.level == 0) {
            Orphan o = new Orphan(this.getConfiguration());
            o.setNodeKind((short)3);
            o.setStringValue(s.toString());
            this.write(o);
        } else if (s.length() > 0) {
            if (this.inStartTag) {
                this.startContent();
            }
            this.outputter.characters(s, locationId, properties);
        }
        this.previousAtomic = false;
    }

    @Override
    public void comment(CharSequence comment, Location locationId, int properties) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.level == 0) {
            Orphan o = new Orphan(this.getConfiguration());
            o.setNodeKind((short)8);
            o.setStringValue(comment);
            this.write(o);
        } else {
            this.outputter.comment(comment, locationId, properties);
        }
        this.previousAtomic = false;
    }

    @Override
    public void processingInstruction(String target, CharSequence data, Location locationId, int properties) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.level == 0) {
            Orphan o = new Orphan(this.getConfiguration());
            o.setNodeName(new NoNamespaceName(target));
            o.setNodeKind((short)7);
            o.setStringValue(data);
            this.write(o);
        } else {
            this.outputter.processingInstruction(target, data, locationId, properties);
        }
        this.previousAtomic = false;
    }

    @Override
    public void close() throws XPathException {
        this.previousAtomic = false;
        if (this.outputter != null) {
            this.outputter.close();
        }
    }

    @Override
    public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
        if (item != null) {
            if (this.level == 0) {
                this.write(item);
                this.previousAtomic = false;
            } else {
                this.decompose(item, locationId, copyNamespaces);
            }
        }
    }

    @Override
    public boolean usesTypeAnnotations() {
        return this.outputter == null || this.outputter.usesTypeAnnotations();
    }

    public boolean isReadyForBulkCopy() {
        return this.level > 0 && this.outputter instanceof ComplexContentOutputter && ((ComplexContentOutputter)this.outputter).isReadyForBulkCopy();
    }

    public void bulkCopyElementNode(TinyElementImpl node, int copyOptions) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        ((ComplexContentOutputter)this.outputter).bulkCopyElementNode(node, copyOptions);
    }

    public boolean isReadyForGrafting() {
        return this.level > 0 && this.outputter instanceof ComplexContentOutputter && ((ComplexContentOutputter)this.outputter).isReadyForGrafting();
    }

    public void graftElementNode(TinyElementImpl node, int copyOptions) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        ((ComplexContentOutputter)this.outputter).graftElementNode(node, copyOptions);
    }
}

