/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.Message;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;

public final class XSLAssert
extends StyleElement {
    private Expression test = null;
    private Expression select = null;
    private Expression errorCode = null;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public void prepareAttributes() {
        String testAtt = null;
        String selectAtt = null;
        String errorCodeAtt = null;
        AttributeCollection atts = this.getAttributeList();
        block10: for (int a = 0; a < atts.getLength(); ++a) {
            String f;
            switch (f = atts.getQName(a)) {
                case "test": {
                    testAtt = atts.getValue(a);
                    this.test = this.makeExpression(testAtt, a);
                    continue block10;
                }
                case "select": {
                    selectAtt = atts.getValue(a);
                    this.select = this.makeExpression(selectAtt, a);
                    continue block10;
                }
                case "error-code": {
                    errorCodeAtt = atts.getValue(a);
                    this.errorCode = this.makeAttributeValueTemplate(errorCodeAtt, a);
                    continue block10;
                }
                default: {
                    this.checkUnknownAttribute(atts.getNodeName(a));
                }
            }
        }
        if (testAtt == null) {
            this.reportAbsence("test");
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.select = this.typeCheck("select", this.select);
        this.test = this.typeCheck("test", this.test);
        this.errorCode = this.errorCode == null ? new StringLiteral("Q{http://www.w3.org/2005/xqt-errors}XTMM9001") : this.typeCheck("error-code", this.errorCode);
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        if (exec.getCompilerInfo().isAssertionsEnabled()) {
            String code;
            Expression b = this.compileSequenceConstructor(exec, decl, true);
            if (b != null) {
                if (this.select == null) {
                    this.select = b;
                } else {
                    this.select = Block.makeBlock(this.select, b);
                    this.select.setLocation(this.allocateLocation());
                }
            }
            if (this.select == null) {
                this.select = new StringLiteral("xsl:message (no content)");
            }
            if (this.errorCode instanceof StringLiteral && (code = ((StringLiteral)this.errorCode).getStringValue()).contains(":") && !code.startsWith("Q{")) {
                StructuredQName name = this.makeQName(code);
                this.errorCode = new StringLiteral(name.getEQName());
            }
            Message msg = new Message(this.select, new StringLiteral("yes"), this.errorCode);
            msg.setIsAssert(true);
            if (!(this.errorCode instanceof StringLiteral)) {
                msg.setRetainedStaticContext(this.makeRetainedStaticContext());
            }
            Expression condition = SystemFunction.makeCall("not", this.test.getRetainedStaticContext(), this.test);
            return new Choose(new Expression[]{condition}, new Expression[]{msg});
        }
        return Literal.makeEmptySequence();
    }
}

