/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.handler;

import com.intellij.codeInsight.CustomExceptionHandler;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SneakyThrowsExceptionHandler
extends CustomExceptionHandler {
    private static final String JAVA_LANG_THROWABLE = "java.lang.Throwable";

    public boolean isHandled(@Nullable PsiElement element, @NotNull PsiClassType exceptionType, PsiElement topElement) {
        PsiElement parent;
        if (exceptionType == null) {
            SneakyThrowsExceptionHandler.$$$reportNull$$$0(0);
        }
        if ((parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiLambdaExpression.class, PsiTryStatement.class, PsiMethod.class})) instanceof PsiLambdaExpression) {
            return false;
        }
        if (parent instanceof PsiTryStatement && this.isHandledByTryCatch(exceptionType, (PsiTryStatement)parent)) {
            return false;
        }
        if (topElement instanceof PsiTryStatement && this.isHandledByTryCatch(exceptionType, (PsiTryStatement)topElement)) {
            return false;
        }
        if (!(topElement instanceof PsiCodeBlock)) {
            PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
            return psiMethod != null && this.isExceptionHandled((PsiModifierListOwner)psiMethod, exceptionType);
        }
        return false;
    }

    private boolean isHandledByTryCatch(@NotNull PsiClassType exceptionType, PsiTryStatement topElement) {
        if (exceptionType == null) {
            SneakyThrowsExceptionHandler.$$$reportNull$$$0(1);
        }
        List caughtExceptions = ContainerUtil.map((Object[])topElement.getCatchBlockParameters(), PsiParameter::getType);
        return this.isExceptionHandled(exceptionType, caughtExceptions);
    }

    private boolean isExceptionHandled(@NotNull PsiModifierListOwner psiModifierListOwner, PsiClassType exceptionClassType) {
        PsiAnnotation psiAnnotation;
        if (psiModifierListOwner == null) {
            SneakyThrowsExceptionHandler.$$$reportNull$$$0(2);
        }
        if ((psiAnnotation = PsiAnnotationSearchUtil.findAnnotation(psiModifierListOwner, "lombok.SneakyThrows")) == null) {
            return false;
        }
        Collection<PsiType> sneakedExceptionTypes = PsiAnnotationUtil.getAnnotationValues(psiAnnotation, "value", PsiType.class);
        return sneakedExceptionTypes.isEmpty() || sneakedExceptionTypes.iterator().next().equalsToText(JAVA_LANG_THROWABLE) || this.isExceptionHandled(exceptionClassType, sneakedExceptionTypes);
    }

    private boolean isExceptionHandled(@NotNull PsiClassType exceptionClassType, @NotNull Collection<PsiType> sneakedExceptionTypes) {
        if (exceptionClassType == null) {
            SneakyThrowsExceptionHandler.$$$reportNull$$$0(3);
        }
        if (sneakedExceptionTypes == null) {
            SneakyThrowsExceptionHandler.$$$reportNull$$$0(4);
        }
        for (PsiType sneakedExceptionType : sneakedExceptionTypes) {
            if (!sneakedExceptionType.equalsToText(JAVA_LANG_THROWABLE) && !sneakedExceptionType.equals(exceptionClassType)) continue;
            return true;
        }
        PsiClass unhandledExceptionClass = exceptionClassType.resolve();
        if (null != unhandledExceptionClass) {
            for (PsiType sneakedExceptionType : sneakedExceptionTypes) {
                PsiClass sneakedExceptionClass;
                if (!(sneakedExceptionType instanceof PsiClassType) || null == (sneakedExceptionClass = ((PsiClassType)sneakedExceptionType).resolve()) || !unhandledExceptionClass.isInheritor(sneakedExceptionClass, true)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiModifierListOwner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClassType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sneakedExceptionTypes";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/handler/SneakyThrowsExceptionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isHandled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isHandledByTryCatch";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isExceptionHandled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

