/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.problem.ProblemBuilder;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.processor.field.SetterFieldProcessor;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import de.plushnikov.intellij.plugin.util.PsiMethodUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SetterProcessor
extends AbstractClassProcessor {
    public SetterProcessor() {
        super((Class<? extends PsiElement>)PsiMethod.class, "lombok.Setter");
    }

    private SetterFieldProcessor getSetterFieldProcessor() {
        return (SetterFieldProcessor)ApplicationManager.getApplication().getService(SetterFieldProcessor.class);
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        if (psiAnnotation == null) {
            SetterProcessor.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            SetterProcessor.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            SetterProcessor.$$$reportNull$$$0(2);
        }
        return this.validateAnnotationOnRightType(psiAnnotation, psiClass, builder) && this.validateVisibility(psiAnnotation);
    }

    private boolean validateAnnotationOnRightType(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        if (psiAnnotation == null) {
            SetterProcessor.$$$reportNull$$$0(3);
        }
        if (psiClass == null) {
            SetterProcessor.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            SetterProcessor.$$$reportNull$$$0(5);
        }
        boolean result = true;
        if (psiClass.isAnnotationType() || psiClass.isInterface() || psiClass.isEnum()) {
            builder.addError(LombokBundle.message("inspection.message.s.only.supported.on.class.or.field.type", new Object[0]), psiAnnotation.getQualifiedName());
            result = false;
        }
        return result;
    }

    private boolean validateVisibility(@NotNull PsiAnnotation psiAnnotation) {
        String methodVisibility;
        if (psiAnnotation == null) {
            SetterProcessor.$$$reportNull$$$0(6);
        }
        return null != (methodVisibility = LombokProcessorUtil.getMethodModifier(psiAnnotation));
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target) {
        String methodVisibility;
        if (psiClass == null) {
            SetterProcessor.$$$reportNull$$$0(7);
        }
        if (psiAnnotation == null) {
            SetterProcessor.$$$reportNull$$$0(8);
        }
        if (target == null) {
            SetterProcessor.$$$reportNull$$$0(9);
        }
        if ((methodVisibility = LombokProcessorUtil.getMethodModifier(psiAnnotation)) != null) {
            target.addAll(this.createFieldSetters(psiClass, methodVisibility));
        }
    }

    public Collection<PsiMethod> createFieldSetters(@NotNull PsiClass psiClass, @NotNull String methodModifier) {
        if (psiClass == null) {
            SetterProcessor.$$$reportNull$$$0(10);
        }
        if (methodModifier == null) {
            SetterProcessor.$$$reportNull$$$0(11);
        }
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        Collection<PsiField> setterFields = this.filterSetterFields(psiClass);
        SetterFieldProcessor fieldProcessor = this.getSetterFieldProcessor();
        for (PsiField setterField : setterFields) {
            result.add(fieldProcessor.createSetterMethod(setterField, psiClass, methodModifier));
        }
        return result;
    }

    @NotNull
    private Collection<PsiField> filterSetterFields(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SetterProcessor.$$$reportNull$$$0(12);
        }
        Collection<PsiMethod> classMethods = PsiClassUtil.collectClassMethodsIntern(psiClass);
        this.filterToleratedElements(classMethods);
        SetterFieldProcessor fieldProcessor = this.getSetterFieldProcessor();
        ArrayList<PsiField> setterFields = new ArrayList<PsiField>();
        for (PsiField psiField : psiClass.getFields()) {
            boolean createSetter = true;
            PsiModifierList modifierList = psiField.getModifierList();
            if (null != modifierList) {
                createSetter = !modifierList.hasModifierProperty("final");
                createSetter &= !modifierList.hasModifierProperty("static");
                createSetter &= PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiField, fieldProcessor.getSupportedAnnotationClasses());
                createSetter &= !psiField.getName().startsWith("$");
                Collection<String> methodNames = fieldProcessor.getAllSetterNames(psiField, PsiType.BOOLEAN.equals((Object)psiField.getType()));
                for (String methodName : methodNames) {
                    createSetter &= !PsiMethodUtil.hasSimilarMethod(classMethods, methodName, 1);
                }
            }
            if (!createSetter) continue;
            setterFields.add(psiField);
        }
        ArrayList<PsiField> arrayList = setterFields;
        if (arrayList == null) {
            SetterProcessor.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        PsiClass containingClass;
        if (psiField == null) {
            SetterProcessor.$$$reportNull$$$0(14);
        }
        if (psiAnnotation == null) {
            SetterProcessor.$$$reportNull$$$0(15);
        }
        if (null != (containingClass = psiField.getContainingClass()) && PsiClassUtil.getNames(this.filterSetterFields(containingClass)).contains(psiField.getName())) {
            return LombokPsiElementUsage.WRITE;
        }
        return LombokPsiElementUsage.NONE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodModifier";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/SetterProcessor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/SetterProcessor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSetterFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateAnnotationOnRightType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateVisibility";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createFieldSetters";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "filterSetterFields";
                break;
            }
            case 13: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

