/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.problem.ProblemBuilder;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UtilityClassProcessor
extends AbstractClassProcessor {
    public UtilityClassProcessor() {
        super((Class<? extends PsiElement>)PsiMethod.class, "lombok.experimental.UtilityClass");
    }

    @Override
    protected boolean possibleToGenerateElementNamed(@Nullable String nameHint, @NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            UtilityClassProcessor.$$$reportNull$$$0(0);
        }
        if (psiAnnotation == null) {
            UtilityClassProcessor.$$$reportNull$$$0(1);
        }
        return null == nameHint || nameHint.equals(psiClass.getName());
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        if (psiAnnotation == null) {
            UtilityClassProcessor.$$$reportNull$$$0(2);
        }
        if (psiClass == null) {
            UtilityClassProcessor.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            UtilityClassProcessor.$$$reportNull$$$0(4);
        }
        return UtilityClassProcessor.validateOnRightType(psiClass, builder) && this.validateNoConstructorsDefined(psiClass, builder);
    }

    private boolean validateNoConstructorsDefined(PsiClass psiClass, ProblemBuilder builder) {
        Collection<PsiMethod> psiMethods = PsiClassUtil.collectClassConstructorIntern(psiClass);
        if (!psiMethods.isEmpty()) {
            builder.addError(LombokBundle.message("inspection.message.utility.classes.cannot.have.declared.constructors", new Object[0]));
            return false;
        }
        return true;
    }

    public static boolean validateOnRightType(PsiClass psiClass, ProblemBuilder builder) {
        if (UtilityClassProcessor.checkWrongType(psiClass)) {
            builder.addError(LombokBundle.message("inspection.message.utility.class.only.supported.on.class", new Object[0]));
            return false;
        }
        PsiElement context = psiClass.getContext();
        if (context == null) {
            return false;
        }
        if (!(context instanceof PsiFile)) {
            PsiElement contextUp = context;
            while (contextUp instanceof PsiClass) {
                PsiClass psiClassUp = (PsiClass)contextUp;
                if (psiClassUp.getContext() instanceof PsiFile) {
                    return true;
                }
                boolean isStatic = UtilityClassProcessor.isStatic(psiClassUp.getModifierList());
                if (isStatic || UtilityClassProcessor.checkWrongType(psiClassUp)) {
                    contextUp = contextUp.getContext();
                    continue;
                }
                builder.addError(LombokBundle.message("inspection.message.utility.class.automatically.makes.class.static", new Object[0]));
                return false;
            }
            builder.addError(LombokBundle.message("inspection.message.utility.class.cannot.be.placed", new Object[0]));
            return false;
        }
        return true;
    }

    private static boolean isStatic(PsiModifierList modifierList) {
        return modifierList != null && modifierList.hasModifierProperty("static");
    }

    private static boolean checkWrongType(PsiClass psiClass) {
        return psiClass != null && (psiClass.isInterface() || psiClass.isEnum() || psiClass.isAnnotationType());
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target) {
        if (psiClass == null) {
            UtilityClassProcessor.$$$reportNull$$$0(5);
        }
        if (psiAnnotation == null) {
            UtilityClassProcessor.$$$reportNull$$$0(6);
        }
        if (target == null) {
            UtilityClassProcessor.$$$reportNull$$$0(7);
        }
        LombokLightMethodBuilder constructorBuilder = new LombokLightMethodBuilder(psiClass.getManager(), psiClass.getName()).withConstructor(true).withContainingClass(psiClass).withNavigationElement((PsiElement)psiAnnotation).withModifier("private").withBodyText(String.format("throw new %s(%s);", "java.lang.UnsupportedOperationException", "\"This is a utility class and cannot be instantiated\""));
        target.add((PsiElement)constructorBuilder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/UtilityClassProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "possibleToGenerateElementNamed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "generatePsiElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

