/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz.constructor;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import de.plushnikov.intellij.plugin.problem.ProblemBuilder;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.constructor.AbstractConstructorClassProcessor;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class AllArgsConstructorProcessor
extends AbstractConstructorClassProcessor {
    public AllArgsConstructorProcessor() {
        super("lombok.AllArgsConstructor", PsiMethod.class);
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        if (psiAnnotation == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(2);
        }
        boolean result = super.validate(psiAnnotation, psiClass, builder);
        Collection<PsiField> allNotInitializedNotStaticFields = this.getAllFields(psiClass);
        String staticConstructorName = this.getStaticConstructorName(psiAnnotation);
        return result &= this.validateIsConstructorNotDefined(psiClass, staticConstructorName, allNotInitializedNotStaticFields, builder);
    }

    @NotNull
    public Collection<PsiMethod> createAllArgsConstructor(@NotNull PsiClass psiClass, @NotNull String methodVisibility, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(3);
        }
        if (methodVisibility == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(4);
        }
        if (psiAnnotation == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(5);
        }
        Collection<PsiField> allNotInitializedNotStaticFields = this.getAllNotInitializedAndNotStaticFields(psiClass);
        Collection<PsiMethod> collection = this.createConstructorMethod(psiClass, methodVisibility, psiAnnotation, false, allNotInitializedNotStaticFields);
        if (collection == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target) {
        String methodVisibility;
        if (psiClass == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(7);
        }
        if (psiAnnotation == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(8);
        }
        if (target == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(9);
        }
        if (null != (methodVisibility = LombokProcessorUtil.getAccessVisibility(psiAnnotation))) {
            String staticConstructorName = this.getStaticConstructorName(psiAnnotation);
            target.addAll(this.createAllArgsConstructor(psiClass, methodVisibility, psiAnnotation, staticConstructorName));
        }
    }

    @NotNull
    private Collection<PsiMethod> createAllArgsConstructor(PsiClass psiClass, String methodVisibility, PsiAnnotation psiAnnotation, String staticName) {
        Collection<PsiField> allNotInitializedNotStaticFields = this.getAllFields(psiClass);
        Collection<PsiMethod> collection = this.createAllArgsConstructor(psiClass, methodVisibility, psiAnnotation, staticName, allNotInitializedNotStaticFields);
        if (collection == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiMethod> createAllArgsConstructor(@NotNull PsiClass psiClass, @PsiModifier.ModifierConstant @NotNull String methodModifier, @NotNull PsiAnnotation psiAnnotation, String staticName, Collection<PsiField> allNotInitializedNotStaticFields) {
        if (psiClass == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(11);
        }
        if (methodModifier == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(12);
        }
        if (psiAnnotation == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(13);
        }
        Collection<PsiMethod> collection = this.createAllArgsConstructor(psiClass, methodModifier, psiAnnotation, staticName, allNotInitializedNotStaticFields, false);
        if (collection == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiMethod> createAllArgsConstructor(@NotNull PsiClass psiClass, @PsiModifier.ModifierConstant @NotNull String methodModifier, @NotNull PsiAnnotation psiAnnotation, String staticName, Collection<PsiField> allNotInitializedNotStaticFields, boolean skipConstructorIfAnyConstructorExists) {
        if (psiClass == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(15);
        }
        if (methodModifier == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(16);
        }
        if (psiAnnotation == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(17);
        }
        Collection<PsiMethod> collection = this.createConstructorMethod(psiClass, methodModifier, psiAnnotation, false, allNotInitializedNotStaticFields, staticName, skipConstructorIfAnyConstructorExists);
        if (collection == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(18);
        }
        return collection;
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        PsiClass containingClass;
        if (psiField == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(19);
        }
        if (psiAnnotation == null) {
            AllArgsConstructorProcessor.$$$reportNull$$$0(20);
        }
        if (null != (containingClass = psiField.getContainingClass()) && PsiClassUtil.getNames(this.getAllNotInitializedAndNotStaticFields(containingClass)).contains(psiField.getName())) {
            return LombokPsiElementUsage.WRITE;
        }
        return LombokPsiElementUsage.NONE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodVisibility";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/constructor/AllArgsConstructorProcessor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodModifier";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/constructor/AllArgsConstructorProcessor";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createAllArgsConstructor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createAllArgsConstructor";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 18: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

