/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.personalization.session;

import com.intellij.completion.ml.personalization.session.CompletionQueryTracker;
import com.intellij.completion.ml.personalization.session.CompletionQueryTrackerImpl;
import com.intellij.completion.ml.personalization.session.QueriesDuration;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0012J\b\u0010\u0016\u001a\u00020\bH\u0016J\b\u0010\u0017\u001a\u00020\bH\u0016J\b\u0010\u0018\u001a\u00020\bH\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\u00100\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/completion/ml/personalization/session/CompletionQueryTrackerImpl;", "Lcom/intellij/completion/ml/personalization/session/CompletionQueryTracker;", "sessionStartedTimestamp", "", "(J)V", "currentQuery", "", "currentQueryFrequency", "", "durations", "Lcom/intellij/completion/ml/personalization/session/QueriesDuration;", "getDurations", "()Lcom/intellij/completion/ml/personalization/session/QueriesDuration;", "prefixShiftCount", "queriesCount", "uniqueQueries", "", "afterAppend", "", "c", "", "afterTruncate", "getCurrentQueryFrequency", "getTotalQueriesCount", "getUniqueQueriesCount", "updateQuery", "newQuery", "intellij.completionMlRanking"})
public final class CompletionQueryTrackerImpl
implements CompletionQueryTracker {
    private int prefixShiftCount;
    private String currentQuery = "";
    private Map<Integer, Map<String, Integer>> uniqueQueries;
    private int queriesCount;
    private int currentQueryFrequency;
    @NotNull
    private final QueriesDuration durations;

    @Override
    public int getCurrentQueryFrequency() {
        return this.currentQueryFrequency;
    }

    @Override
    @NotNull
    public QueriesDuration getDurations() {
        return this.durations;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getUniqueQueriesCount() {
        void var3_3;
        Iterable $this$sumBy$iv = this.uniqueQueries.values();
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            void it;
            Map map = (Map)element$iv;
            int n = sum$iv;
            boolean bl = false;
            int n2 = it.size();
            sum$iv = n + n2;
        }
        return (int)var3_3;
    }

    @Override
    public int getTotalQueriesCount() {
        return this.queriesCount;
    }

    public final void afterAppend(char c) {
        this.updateQuery(this.currentQuery + c);
    }

    public final void afterTruncate() {
        String query = this.currentQuery;
        CharSequence charSequence = this.currentQuery;
        boolean bl = false;
        if (charSequence.length() == 0) {
            ++this.prefixShiftCount;
        } else {
            query = StringsKt.dropLast((String)this.currentQuery, (int)1);
        }
        this.updateQuery(query);
    }

    private final void updateQuery(String newQuery) {
        Map<String, Integer> map = this.uniqueQueries.computeIfAbsent(this.prefixShiftCount, updateQuery.prefixMap.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(map, (String)"uniqueQueries.computeIfA\u2026Count) { mutableMapOf() }");
        Map<String, Integer> prefixMap2 = map;
        this.currentQueryFrequency = ((Number)prefixMap2.getOrDefault(newQuery, 0)).intValue() + 1;
        prefixMap2.put(newQuery, this.currentQueryFrequency);
        ++this.queriesCount;
        this.currentQuery = newQuery;
        this.getDurations().fireQueryChanged();
    }

    public CompletionQueryTrackerImpl(long sessionStartedTimestamp) {
        boolean bl = false;
        this.uniqueQueries = new LinkedHashMap();
        this.durations = new QueriesDuration(sessionStartedTimestamp);
        this.updateQuery("");
    }
}

