/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.ContentDescriptor;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class ModuleDescriptorNameConverter
extends ResolvingConverter<IdeaPlugin> {
    @NonNls
    private static final String SUB_DESCRIPTOR_DELIMITER = "/";
    @NonNls
    private static final String SUB_DESCRIPTOR_FILENAME_DELIMITER = ".";

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        String moduleName;
        String filePath;
        String value = StringUtil.notNullize((String)s);
        if (ModuleDescriptorNameConverter.isSubDescriptor(value)) {
            filePath = ModuleDescriptorNameConverter.getSubDescriptorFilePath(value);
            moduleName = ModuleDescriptorNameConverter.getSubDescriptorModuleName(value);
        } else {
            filePath = ModuleDescriptorNameConverter.getDescriptorFilePath(value);
            moduleName = value;
        }
        return DevKitBundle.message("plugin.xml.convert.module.descriptor.name", filePath, moduleName);
    }

    @Nullable
    public IdeaPlugin fromString(@Nullable String s, ConvertContext context) {
        if (StringUtil.isEmpty((String)s)) {
            return null;
        }
        Module currentModule = context.getModule();
        if (currentModule == null) {
            return null;
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)context.getProject());
        if (ModuleDescriptorNameConverter.isSubDescriptor(s)) {
            Module module = moduleManager.findModuleByName(ModuleDescriptorNameConverter.getSubDescriptorModuleName(s));
            if (module != null && (module == currentModule || ModuleDescriptorNameConverter.getDependencies(currentModule).contains(module))) {
                return ModuleDescriptorNameConverter.findDescriptorFile(module, ModuleDescriptorNameConverter.getSubDescriptorFilePath(s));
            }
            return null;
        }
        Module module = moduleManager.findModuleByName(s);
        if (module != null && ModuleDescriptorNameConverter.getDependencies(currentModule).contains(module)) {
            return ModuleDescriptorNameConverter.findDescriptorFile(module, ModuleDescriptorNameConverter.getDescriptorFilePath(module.getName()));
        }
        return null;
    }

    @Nullable
    public String toString(@Nullable IdeaPlugin plugin, ConvertContext context) {
        if (plugin == null) {
            return null;
        }
        return ModuleDescriptorNameConverter.getDisplayName(plugin);
    }

    @NotNull
    private static String getDisplayName(@NotNull IdeaPlugin plugin) {
        VirtualFile virtualFile;
        String fileName;
        Module module;
        String moduleName;
        if (plugin == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(0);
        }
        if ((moduleName = (module = Objects.requireNonNull(plugin.getModule())).getName()).equals(fileName = (virtualFile = DomUtil.getFile((DomElement)plugin).getVirtualFile()).getNameWithoutExtension())) {
            String string = fileName;
            if (string == null) {
                ModuleDescriptorNameConverter.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = moduleName + SUB_DESCRIPTOR_DELIMITER + StringUtil.substringAfterLast((String)fileName, (String)SUB_DESCRIPTOR_FILENAME_DELIMITER);
        if (string == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public LookupElement createLookupElement(IdeaPlugin plugin) {
        String displayName = ModuleDescriptorNameConverter.getDisplayName(plugin);
        return LookupElementBuilder.create((Object)Objects.requireNonNull(this.getPsiElement(plugin)), (String)displayName).withIcon(ElementPresentationManager.getIconForClass(ContentDescriptor.ModuleDescriptor.class)).withBoldness(ModuleDescriptorNameConverter.isSubDescriptor(displayName)).withTypeText(plugin.getPackage().getStringValue());
    }

    @NotNull
    public Collection<? extends IdeaPlugin> getVariants(ConvertContext context) {
        Module currentModule = context.getModule();
        if (currentModule == null) {
            List list = Collections.emptyList();
            if (list == null) {
                ModuleDescriptorNameConverter.$$$reportNull$$$0(3);
            }
            return list;
        }
        Project project = context.getProject();
        SmartList variants = new SmartList();
        Set<Module> dependencies = ModuleDescriptorNameConverter.getDependencies(currentModule);
        dependencies.add(currentModule);
        for (Module module : dependencies) {
            String moduleName = module.getName();
            ModuleDescriptorNameConverter.processModuleSourceRoots(module, (Processor<VirtualFile>)((Processor)arg_0 -> ModuleDescriptorNameConverter.lambda$getVariants$1(project, (List)variants, moduleName, arg_0)));
        }
        SmartList smartList = variants;
        if (smartList == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    @NotNull
    private static Set<Module> getDependencies(@NotNull Module currentModule) {
        if (currentModule == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(5);
        }
        LinkedHashSet<Module> dependencies = new LinkedHashSet<Module>();
        ModuleUtilCore.getDependencies((Module)currentModule, dependencies);
        dependencies.remove(currentModule);
        LinkedHashSet<Module> linkedHashSet = dependencies;
        if (linkedHashSet == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    @Nullable
    private static IdeaPlugin findDescriptorFile(@NotNull Module module, @NotNull String filePath) {
        if (module == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(7);
        }
        if (filePath == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(8);
        }
        Ref ideaPlugin = Ref.create();
        ModuleDescriptorNameConverter.processModuleSourceRoots(module, (Processor<VirtualFile>)((Processor)root -> {
            VirtualFile candidate = root.findChild(filePath);
            if (candidate == null) {
                return true;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(candidate);
            if (DescriptorUtil.isPluginXml(psiFile)) {
                ideaPlugin.set((Object)DescriptorUtil.getIdeaPlugin((XmlFile)psiFile));
                return false;
            }
            return true;
        }));
        return (IdeaPlugin)ideaPlugin.get();
    }

    private static void processModuleSourceRoots(@NotNull Module module, Processor<VirtualFile> processor) {
        if (module == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(9);
        }
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getSourceRoots(JavaModuleSourceRootTypes.PRODUCTION)) {
            if (processor.process((Object)root)) continue;
            return;
        }
    }

    @NotNull
    private static String getDescriptorFilePath(@NotNull String fileName) {
        if (fileName == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(10);
        }
        String string = fileName + ".xml";
        if (string == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static boolean isSubDescriptor(@NotNull String value) {
        if (value == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(12);
        }
        return StringUtil.contains((CharSequence)value, (CharSequence)SUB_DESCRIPTOR_DELIMITER);
    }

    @NotNull
    private static String getSubDescriptorModuleName(@NotNull String value) {
        if (value == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(13);
        }
        String moduleName = StringUtil.substringBefore((String)value, (String)SUB_DESCRIPTOR_DELIMITER);
        assert (moduleName != null) : value;
        String string = moduleName;
        if (string == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private static String getSubDescriptorFilePath(@NotNull String value) {
        if (value == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(15);
        }
        String moduleName = ModuleDescriptorNameConverter.getSubDescriptorModuleName(value);
        String fileName = StringUtil.substringAfter((String)value, (String)SUB_DESCRIPTOR_DELIMITER);
        assert (fileName != null) : value;
        return ModuleDescriptorNameConverter.getDescriptorFilePath(moduleName + SUB_DESCRIPTOR_FILENAME_DELIMITER + fileName);
    }

    private static /* synthetic */ boolean lambda$getVariants$1(Project project, List variants, String moduleName, VirtualFile root) {
        Collection<IdeaPlugin> plugins = DescriptorUtil.getPlugins(project, GlobalSearchScopes.directoryScope((Project)project, (VirtualFile)root, (boolean)false));
        variants.addAll(ContainerUtil.filter(plugins, plugin -> DomUtil.getFile((DomElement)plugin).getName().startsWith(moduleName)));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/dom/impl/ModuleDescriptorNameConverter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentModule";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/dom/impl/ModuleDescriptorNameConverter";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptorFilePath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubDescriptorModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 11: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findDescriptorFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processModuleSourceRoots";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorFilePath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSubDescriptor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSubDescriptorModuleName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSubDescriptorFilePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

