/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.internal;

import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.ApplicationComponents;
import org.jetbrains.idea.devkit.dom.Component;
import org.jetbrains.idea.devkit.dom.Dependency;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.ModuleComponents;
import org.jetbrains.idea.devkit.dom.ProjectComponents;
import org.jetbrains.idea.devkit.internal.AnalyzeUnloadablePluginsAction;
import org.jetbrains.idea.devkit.internal.PluginUnloadabilityStatus;
import org.jetbrains.idea.devkit.internal.UnloadabilityStatus;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J^\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017H\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/idea/devkit/internal/AnalyzeUnloadablePluginsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "analyzePluginFile", "ideaPlugin", "Lorg/jetbrains/idea/devkit/dom/IdeaPlugin;", "analysisErrors", "", "", "components", "nonDynamicEPs", "", "unspecifiedDynamicEPs", "serviceOverrides", "allowOwnEPs", "", "analyzeUnloadable", "Lorg/jetbrains/idea/devkit/internal/PluginUnloadabilityStatus;", "allPlugins", "", "Lcom/intellij/psi/xml/XmlFile;", "resolvePluginDependency", "dependency", "Lorg/jetbrains/idea/devkit/dom/Dependency;", "showReport", "project", "Lcom/intellij/openapi/project/Project;", "result", "intellij.devkit"})
public final class AnalyzeUnloadablePluginsAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        IdeView view;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        IdeView ideView = view = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        PsiDirectory dir = ideView != null ? ideView.getOrChooseDirectory() : null;
        boolean bl = false;
        List result = new ArrayList();
        ProgressManager progressManager = ProgressManager.getInstance();
        Runnable runnable = new Runnable(this, dir, project2, result){
            final /* synthetic */ AnalyzeUnloadablePluginsAction this$0;
            final /* synthetic */ PsiDirectory $dir;
            final /* synthetic */ Project $project;
            final /* synthetic */ List $result;

            public final void run() {
                boolean $i$f$runReadAction = false;
                ApplicationManager.getApplication().runReadAction(new Computable(this){
                    final /* synthetic */ actionPerformed.show.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final T compute() {
                        void $this$filterIsInstanceTo$iv$iv;
                        void $this$filterIsInstance$iv22;
                        PsiFile[] psiFileArray;
                        ProgressIndicator pi;
                        boolean bl = false;
                        ProgressManager progressManager = ProgressManager.getInstance();
                        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
                        ProgressIndicator progressIndicator = pi = progressManager.getProgressIndicator();
                        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"pi");
                        progressIndicator.setIndeterminate(false);
                        PsiDirectory psiDirectory = this.this$0.$dir;
                        GlobalSearchScope globalSearchScope = psiDirectory == null ? GlobalSearchScopesCore.projectProductionScope((Project)this.this$0.$project) : GlobalSearchScopesCore.directoryScope((PsiDirectory)this.this$0.$dir, (boolean)true);
                        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"when (dir) {\n           \u2026pe(dir, true)\n          }");
                        GlobalSearchScope searchScope = globalSearchScope;
                        Object[] objectArray = FilenameIndex.getFilesByName((Project)this.this$0.$project, (String)"plugin.xml", (GlobalSearchScope)searchScope);
                        boolean bl2 = false;
                        Object object = objectArray;
                        boolean bl3 = false;
                        if (((PsiFile[])object).length == 0) {
                            boolean bl4 = false;
                            psiFileArray = FilenameIndex.getFilesByName((Project)this.this$0.$project, (String)"plugin.xml", (GlobalSearchScope)GlobalSearchScopesCore.projectProductionScope((Project)this.this$0.$project));
                        } else {
                            psiFileArray = objectArray;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"FilenameIndex.getFilesBy\u2026oductionScope(project)) }");
                        objectArray = psiFileArray;
                        boolean $i$f$filterIsInstance = false;
                        object = $this$filterIsInstance$iv22;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof XmlFile)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List pluginXmlFiles = (List)destination$iv$iv;
                        boolean $this$filterIsInstance$iv22 = false;
                        for (XmlFile pluginXmlFile : (Iterable)pluginXmlFiles) {
                            void processed;
                            pi.checkCanceled();
                            pi.setFraction((double)processed / (double)pluginXmlFiles.size());
                            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.this$0.$project);
                            Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
                            if (projectRootManager.getFileIndex().isUnderSourceRootOfType(pluginXmlFile.getVirtualFile(), JavaModuleSourceRootTypes.PRODUCTION)) {
                                if (DescriptorUtil.getIdeaPlugin(pluginXmlFile) == null) {
                                } else {
                                    IdeaPlugin ideaPlugin;
                                    Intrinsics.checkNotNullExpressionValue((Object)ideaPlugin, (String)"DescriptorUtil.getIdeaPl\u2026luginXmlFile) ?: continue");
                                    GenericAttributeValue<Boolean> genericAttributeValue = ideaPlugin.getRequireRestart();
                                    Intrinsics.checkNotNullExpressionValue(genericAttributeValue, (String)"ideaPlugin.requireRestart");
                                    if (!Intrinsics.areEqual((Object)((Boolean)genericAttributeValue.getValue()), (Object)true)) {
                                        PluginUnloadabilityStatus status = AnalyzeUnloadablePluginsAction.access$analyzeUnloadable(this.this$0.this$0, ideaPlugin, pluginXmlFiles);
                                        this.this$0.$result.add(status);
                                        pi.setText(status.getPluginId());
                                    }
                                }
                            }
                            ++processed;
                        }
                        return (T)Unit.INSTANCE;
                    }
                });
            }
            {
                this.this$0 = analyzeUnloadablePluginsAction;
                this.$dir = psiDirectory;
                this.$project = project;
                this.$result = list;
            }
        };
        Object[] objectArray = new Object[1];
        Object object = dir;
        if (object == null || (object = object.getName()) == null) {
            object = "Project";
        }
        objectArray[0] = object;
        boolean show2 = progressManager.runProcessWithProgressSynchronously(runnable, DevKitBundle.message("action.AnalyzeUnloadablePlugins.progress.title", objectArray), true, e.getProject());
        if (show2) {
            this.showReport(project2, result);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void showReport(Project project, List<PluginUnloadabilityStatus> result) {
        void $this$filterTo$iv$iv;
        boolean bl;
        boolean bl2;
        void $this$filterTo$iv$iv33222;
        Object status72;
        void $this$filterTo$iv$iv52322;
        Object status222;
        boolean bl3;
        void $this$filterTo$iv$iv43222;
        Object status322;
        StringBuilder $this$sortedByDescending$iv2;
        void $this$filterTo$iv$iv422322;
        boolean bl4;
        void $this$filterTo$iv$iv322322;
        Object status522;
        void $this$filterTo$iv$iv222322;
        Object element$iv;
        boolean bl5;
        Object $this$any$iv;
        StringBuilder $this$buildString;
        StringBuilder stringBuilder;
        block35: {
            boolean bl6 = false;
            boolean bl7 = false;
            stringBuilder = new StringBuilder();
            boolean bl8 = false;
            boolean bl9 = false;
            $this$buildString = stringBuilder;
            boolean bl10 = false;
            $this$any$iv = result;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl5 = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    PluginUnloadabilityStatus it232 = (PluginUnloadabilityStatus)element$iv;
                    boolean bl11 = false;
                    Collection collection = it232.getAnalysisErrors();
                    boolean bl12 = false;
                    boolean bl13 = !collection.isEmpty();
                    if (!bl13) continue;
                    bl5 = true;
                    break block35;
                }
                bl5 = false;
            }
        }
        if (bl5) {
            void $this$filterTo$iv$iv62222;
            $this$any$iv = $this$buildString;
            String $i$f$any = "Analysis errors:";
            boolean bl14 = false;
            StringBuilder stringBuilder2 = ((StringBuilder)$this$any$iv).append($i$f$any);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            element$iv = stringBuilder2;
            boolean it232 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)element$iv).append('\n'), (String)"append('\\n')");
            Iterable iterable = result;
            boolean $i$f$filter232 = false;
            Iterable it232 = iterable;
            Collection destination$iv$iv22 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv62222) {
                PluginUnloadabilityStatus pluginUnloadabilityStatus = (PluginUnloadabilityStatus)element$iv$iv2;
                boolean bl15 = false;
                Collection collection = pluginUnloadabilityStatus.getAnalysisErrors();
                boolean bl16 = false;
                if (!(!collection.isEmpty())) continue;
                destination$iv$iv22.add(element$iv$iv2);
            }
            for (PluginUnloadabilityStatus status6 : (List)destination$iv$iv22) {
                StringBuilder stringBuilder3 = $this$buildString;
                String $i$f$filter232 = status6.getPluginId();
                boolean $this$filterTo$iv$iv62222 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append($i$f$filter232), (String)"append(value)");
                $i$f$filterTo2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)destination$iv$iv22.append('\n'), (String)"append('\\n')");
                for (String string : status6.getAnalysisErrors()) {
                    StringBuilder $this$filterTo$iv$iv62222 = $this$buildString;
                    boolean destination$iv$iv22 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)$this$filterTo$iv$iv62222.append(string), (String)"append(value)");
                    boolean bl17 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$filterTo2.append('\n'), (String)"append('\\n')");
                }
                StringBuilder stringBuilder4 = $this$buildString;
                $i$f$filter232 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
            }
        }
        Object $this$filter$iv = result;
        boolean bl18 = false;
        Iterable $i$f$filter232 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator $i$f$filterTo2 = $this$filterTo$iv$iv222322.iterator();
        while ($i$f$filterTo2.hasNext()) {
            Object element$iv$iv = $i$f$filterTo2.next();
            PluginUnloadabilityStatus it = (PluginUnloadabilityStatus)element$iv$iv;
            boolean bl19 = false;
            if (!(it.getStatus() == UnloadabilityStatus.UNLOADABLE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unloadablePlugins = (List)destination$iv$iv;
        $this$filter$iv = $this$buildString;
        String string = "Can unload " + unloadablePlugins.size() + " plugins out of " + result.size();
        boolean $this$filterTo$iv$iv222322 = false;
        StringBuilder stringBuilder5 = ((StringBuilder)$this$filter$iv).append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        destination$iv$iv = stringBuilder5;
        $i$f$filterTo = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)destination$iv$iv).append('\n'), (String)"append('\\n')");
        for (Object status522 : unloadablePlugins) {
            StringBuilder $this$filterTo$iv$iv222322 = $this$buildString;
            destination$iv$iv = ((PluginUnloadabilityStatus)status522).getPluginId();
            $i$f$filterTo = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$filterTo$iv$iv222322.append((String)destination$iv$iv), (String)"append(value)");
            boolean element$iv$iv = false;
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)((Object)$i$f$filterTo2)).append('\n'), (String)"append('\\n')");
        }
        status522 = $this$buildString;
        boolean bl20 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)status522).append('\n'), (String)"append('\\n')");
        Iterable iterable = result;
        boolean $i$f$filter = false;
        destination$iv$iv = iterable;
        Iterator<String> destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2222 = false;
        Object element$iv$iv = $this$filterTo$iv$iv322322.iterator();
        while (element$iv$iv.hasNext()) {
            Object element$iv$iv3 = element$iv$iv.next();
            PluginUnloadabilityStatus pluginUnloadabilityStatus = (PluginUnloadabilityStatus)element$iv$iv3;
            bl4 = false;
            if (!(pluginUnloadabilityStatus.getStatus() == UnloadabilityStatus.USES_COMPONENTS)) continue;
            destination$iv$iv3.add((String)element$iv$iv3);
        }
        Iterable iterable2 = (List)((Object)destination$iv$iv3);
        boolean $i$f$sortedByDescending32422 = false;
        boolean $this$filterTo$iv$iv322322 = false;
        List pluginsUsingComponents = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                PluginUnloadabilityStatus it = (PluginUnloadabilityStatus)b;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getComponents().size());
                it = (PluginUnloadabilityStatus)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = it.getComponents().size();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
        StringBuilder stringBuilder6 = $this$buildString;
        String $i$f$sortedByDescending32422 = "Plugins using components (" + pluginsUsingComponents.size() + "):";
        $this$filterTo$iv$iv322322 = false;
        StringBuilder stringBuilder7 = stringBuilder6.append($i$f$sortedByDescending32422);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
        destination$iv$iv3 = stringBuilder7;
        $i$f$filterTo2222 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)((Object)destination$iv$iv3)).append('\n'), (String)"append('\\n')");
        for (PluginUnloadabilityStatus pluginUnloadabilityStatus : pluginsUsingComponents) {
            StringBuilder $this$filterTo$iv$iv322322 = $this$buildString;
            destination$iv$iv3 = pluginUnloadabilityStatus.getPluginId() + " (" + pluginUnloadabilityStatus.getComponents().size() + ')';
            $i$f$filterTo2222 = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$filterTo$iv$iv322322.append((String)((Object)destination$iv$iv3)), (String)"append(value)");
            boolean element$iv$iv3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)element$iv$iv).append('\n'), (String)"append('\\n')");
            for (String componentName : pluginUnloadabilityStatus.getComponents()) {
                StringBuilder stringBuilder8;
                StringBuilder $i$f$filterTo2222 = $this$buildString;
                element$iv$iv = "  " + componentName;
                element$iv$iv3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)$i$f$filterTo2222.append((String)element$iv$iv), (String)"append(value)");
                bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append('\\n')");
            }
        }
        StringBuilder stringBuilder9 = $this$buildString;
        boolean $i$f$sortedByDescending32422 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9.append('\n'), (String)"append('\\n')");
        Iterable $this$filter$iv3 = result;
        boolean $i$f$filter2 = false;
        destination$iv$iv3 = $this$filter$iv3;
        Object destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        Iterator element$iv$iv3 = $this$filterTo$iv$iv422322.iterator();
        while (element$iv$iv3.hasNext()) {
            Object t = element$iv$iv3.next();
            PluginUnloadabilityStatus it = (PluginUnloadabilityStatus)t;
            boolean bl19 = false;
            if (!(it.getStatus() == UnloadabilityStatus.USES_SERVICE_OVERRIDES)) continue;
            destination$iv$iv4.add(t);
        }
        $this$filter$iv3 = (List)destination$iv$iv4;
        boolean $i$f$sortedByDescending42422 = false;
        boolean $this$filterTo$iv$iv422322 = false;
        List list = CollectionsKt.sortedWith((Iterable)((Object)$this$sortedByDescending$iv2), (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                PluginUnloadabilityStatus it = (PluginUnloadabilityStatus)b;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getServiceOverrides().size());
                it = (PluginUnloadabilityStatus)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = it.getServiceOverrides().size();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
        $this$sortedByDescending$iv2 = $this$buildString;
        String $i$f$sortedByDescending42422 = "Plugins using service overrides (" + list.size() + "):";
        $this$filterTo$iv$iv422322 = false;
        StringBuilder stringBuilder10 = $this$sortedByDescending$iv2.append($i$f$sortedByDescending42422);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(value)");
        destination$iv$iv4 = stringBuilder10;
        $i$f$filterTo3 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)destination$iv$iv4).append('\n'), (String)"append('\\n')");
        for (Object status322 : list) {
            StringBuilder $this$filterTo$iv$iv422322 = $this$buildString;
            destination$iv$iv4 = ((PluginUnloadabilityStatus)status322).getPluginId() + " (" + CollectionsKt.joinToString$default((Iterable)((PluginUnloadabilityStatus)status322).getServiceOverrides(), null, null, null, (int)0, null, null, (int)63, null) + ')';
            $i$f$filterTo3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$filterTo$iv$iv422322.append((String)destination$iv$iv4), (String)"append(value)");
            boolean bl21 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)((Object)element$iv$iv3)).append('\n'), (String)"append('\\n')");
        }
        status322 = $this$buildString;
        boolean $i$f$sortedByDescending42422 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)status322).append('\n'), (String)"append('\\n')");
        Object $this$filter$iv4 = result;
        boolean $i$f$filter52422 = false;
        destination$iv$iv4 = $this$filter$iv4;
        Iterator<Map.Entry<String, Set<String>>> destination$iv$iv5 = new ArrayList();
        boolean $i$f$filterTo422 = false;
        for (Object element$iv$iv422 : $this$filterTo$iv$iv43222) {
            PluginUnloadabilityStatus it332 = (PluginUnloadabilityStatus)element$iv$iv422;
            bl3 = false;
            if (!(it332.getStatus() == UnloadabilityStatus.NON_DYNAMIC_IN_DEPENDENCIES)) continue;
            destination$iv$iv5.add((Map.Entry<String, Set<String>>)element$iv$iv422);
        }
        List pluginsWithOptionalDependencies = (List)((Object)destination$iv$iv5);
        $this$filter$iv4 = $this$buildString;
        String $i$f$filter52422 = "Plugins not unloadable because of non-dynamic EPs in optional dependencies (" + pluginsWithOptionalDependencies.size() + "):";
        boolean $this$filterTo$iv$iv43222 = false;
        StringBuilder stringBuilder11 = ((StringBuilder)$this$filter$iv4).append($i$f$filter52422);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(value)");
        destination$iv$iv5 = stringBuilder11;
        $i$f$filterTo422 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)((Object)destination$iv$iv5)).append('\n'), (String)"append('\\n')");
        for (Object status222 : pluginsWithOptionalDependencies) {
            StringBuilder stringBuilder12;
            Object $this$filterTo$iv$iv43222 = $this$buildString;
            destination$iv$iv5 = ((PluginUnloadabilityStatus)status222).getPluginId();
            $i$f$filterTo422 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$filterTo$iv$iv43222).append((String)((Object)destination$iv$iv5)), (String)"append(value)");
            boolean element$iv$iv422 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12.append('\n'), (String)"append('\\n')");
            Object $i$f$filterTo422 = ((PluginUnloadabilityStatus)status222).getNonDynamicEPsInDependencies();
            boolean bl22 = false;
            destination$iv$iv5 = $i$f$filterTo422.entrySet().iterator();
            while (destination$iv$iv5.hasNext()) {
                StringBuilder stringBuilder13;
                void pluginId;
                Object element$iv$iv422 = $this$filterTo$iv$iv43222 = destination$iv$iv5.next();
                boolean it332 = false;
                $i$f$filterTo422 = (String)element$iv$iv422.getKey();
                element$iv$iv422 = $this$filterTo$iv$iv43222;
                it332 = false;
                Set set = (Set)element$iv$iv422.getValue();
                element$iv$iv422 = $this$buildString;
                String it332 = "  " + (String)pluginId + " - " + CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, null, (int)63, null);
                bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)element$iv$iv422).append(it332), (String)"append(value)");
                boolean bl23 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13.append('\n'), (String)"append('\\n')");
            }
        }
        status222 = $this$buildString;
        boolean $i$f$filter52422 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)status222).append('\n'), (String)"append('\\n')");
        Object $this$filter$iv5 = result;
        boolean $i$f$filter62422 = false;
        destination$iv$iv5 = $this$filter$iv5;
        Iterator<String> destination$iv$iv6 = new ArrayList();
        boolean bl24 = false;
        Object element$iv$iv422 = $this$filterTo$iv$iv52322.iterator();
        while (element$iv$iv422.hasNext()) {
            Object element$iv$iv5 = element$iv$iv422.next();
            PluginUnloadabilityStatus it = (PluginUnloadabilityStatus)element$iv$iv5;
            boolean bl21 = false;
            if (!(it.getStatus() == UnloadabilityStatus.DEPENDENCIES_WITHOUT_SEPARATE_CLASSLOADERS)) continue;
            destination$iv$iv6.add((String)element$iv$iv5);
        }
        List pluginsWithDependenciesWithoutSeparateClassloaders = (List)((Object)destination$iv$iv6);
        $this$filter$iv5 = $this$buildString;
        String $i$f$filter62422 = "Plugins not unloadable because of optional dependencies without separate classloaders (" + pluginsWithDependenciesWithoutSeparateClassloaders.size() + "):";
        boolean $this$filterTo$iv$iv52322 = false;
        StringBuilder stringBuilder14 = ((StringBuilder)$this$filter$iv5).append($i$f$filter62422);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14, (String)"append(value)");
        destination$iv$iv6 = stringBuilder14;
        boolean bl25 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)((Object)destination$iv$iv6)).append('\n'), (String)"append('\\n')");
        for (Object status72 : pluginsWithDependenciesWithoutSeparateClassloaders) {
            StringBuilder $this$filterTo$iv$iv52322 = $this$buildString;
            destination$iv$iv6 = ((PluginUnloadabilityStatus)status72).getPluginId();
            boolean bl26 = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$filterTo$iv$iv52322.append((String)((Object)destination$iv$iv6)), (String)"append(value)");
            boolean element$iv$iv5 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)element$iv$iv422).append('\n'), (String)"append('\\n')");
            for (String pluginId : ((PluginUnloadabilityStatus)status72).getDependenciesWithoutSeparateClassloaders()) {
                StringBuilder it;
                StringBuilder stringBuilder15 = $this$buildString;
                element$iv$iv422 = "  " + pluginId;
                element$iv$iv5 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15.append((String)element$iv$iv422), (String)"append(value)");
                boolean bl21 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.append('\n'), (String)"append('\\n')");
            }
        }
        status72 = $this$buildString;
        boolean $i$f$filter62422 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)status72).append('\n'), (String)"append('\\n')");
        Object $this$filter$iv6 = result;
        boolean $i$f$filter332 = false;
        destination$iv$iv6 = $this$filter$iv6;
        Collection collection = new ArrayList();
        boolean $i$f$filterTo622 = false;
        Object element$iv$iv5 = $this$filterTo$iv$iv33222.iterator();
        while (element$iv$iv5.hasNext()) {
            Object element$iv$iv6 = element$iv$iv5.next();
            PluginUnloadabilityStatus it = (PluginUnloadabilityStatus)element$iv$iv6;
            bl2 = false;
            if (!(it.getStatus() == UnloadabilityStatus.USES_NON_DYNAMIC_EPS)) continue;
            collection.add(element$iv$iv6);
        }
        List nonDynamicPlugins = (List)collection;
        $this$filter$iv6 = nonDynamicPlugins;
        $i$f$filter332 = false;
        if (!$this$filter$iv6.isEmpty()) {
            Object nonDynamicPlugin22;
            $this$filter$iv6 = $this$buildString;
            String $i$f$filter332 = "Plugins with EPs explicitly marked as dynamic=false:";
            boolean $this$filterTo$iv$iv33222 = false;
            StringBuilder stringBuilder16 = ((StringBuilder)$this$filter$iv6).append($i$f$filter332);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder16, (String)"append(value)");
            StringBuilder stringBuilder17 = stringBuilder16;
            $i$f$filterTo622 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder17.append('\n'), (String)"append('\\n')");
            for (Object nonDynamicPlugin22 : nonDynamicPlugins) {
                StringBuilder $this$filterTo$iv$iv33222 = $this$buildString;
                String string2 = ((PluginUnloadabilityStatus)nonDynamicPlugin22).getPluginId() + " (" + ((PluginUnloadabilityStatus)nonDynamicPlugin22).getNonDynamicEPs().size() + ')';
                $i$f$filterTo622 = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$filterTo$iv$iv33222.append(string2), (String)"append(value)");
                boolean element$iv$iv6 = false;
                Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)element$iv$iv5).append('\n'), (String)"append('\\n')");
                for (String ep : ((PluginUnloadabilityStatus)nonDynamicPlugin22).getNonDynamicEPs()) {
                    StringBuilder it;
                    StringBuilder $i$f$filterTo622 = $this$buildString;
                    element$iv$iv5 = "  " + ep;
                    element$iv$iv6 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$filterTo622.append((String)element$iv$iv5), (String)"append(value)");
                    bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it.append('\n'), (String)"append('\\n')");
                }
            }
            nonDynamicPlugin22 = $this$buildString;
            $i$f$filter332 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)nonDynamicPlugin22).append('\n'), (String)"append('\\n')");
        }
        Object $this$filter$iv7 = result;
        boolean $i$f$filter732 = false;
        Iterable iterable3 = $this$filter$iv7;
        Object destination$iv$iv8 = new ArrayList();
        boolean $i$f$filterTo722 = false;
        Object element$iv$iv6 = iterable3.iterator();
        while (element$iv$iv6.hasNext()) {
            boolean bl27;
            Object element$iv$iv7;
            block36: {
                element$iv$iv7 = element$iv$iv6.next();
                PluginUnloadabilityStatus it = (PluginUnloadabilityStatus)element$iv$iv7;
                bl = false;
                Iterable $this$any$iv2 = it.getUnspecifiedDynamicEPs();
                boolean $i$f$any = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    bl27 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv2) {
                        String it2 = (String)element$iv2;
                        boolean bl23 = false;
                        if (!(!StringsKt.startsWith$default((String)it2, (String)"cidr", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)it2, (String)"appcode", (boolean)false, (int)2, null))) continue;
                        bl27 = true;
                        break block36;
                    }
                    bl27 = false;
                }
            }
            if (!bl27) continue;
            destination$iv$iv8.add(element$iv$iv7);
        }
        List closePlugins = (List)destination$iv$iv8;
        $this$filter$iv7 = closePlugins;
        $i$f$filter732 = false;
        if (!$this$filter$iv7.isEmpty()) {
            Object status822;
            $this$filter$iv7 = $this$buildString;
            String $i$f$filter732 = "Plugins with non-dynamic EPs (" + closePlugins.size() + "):";
            boolean bl28 = false;
            StringBuilder stringBuilder18 = ((StringBuilder)$this$filter$iv7).append($i$f$filter732);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder18, (String)"append(value)");
            destination$iv$iv8 = stringBuilder18;
            $i$f$filterTo722 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)destination$iv$iv8).append('\n'), (String)"append('\\n')");
            Iterable iterable4 = closePlugins;
            boolean $i$f$sortedBy22 = false;
            $i$f$filterTo722 = false;
            for (Object status822 : CollectionsKt.sortedWith((Iterable)iterable4, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    PluginUnloadabilityStatus it = (PluginUnloadabilityStatus)a;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.getUnspecifiedDynamicEPs().size());
                    it = (PluginUnloadabilityStatus)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = it.getUnspecifiedDynamicEPs().size();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            })) {
                StringBuilder stringBuilder19 = $this$buildString;
                String $i$f$sortedBy22 = ((PluginUnloadabilityStatus)status822).getPluginId() + " (" + ((PluginUnloadabilityStatus)status822).getUnspecifiedDynamicEPs().size() + ')';
                $i$f$filterTo722 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder19.append($i$f$sortedBy22), (String)"append(value)");
                boolean element$iv$iv7 = false;
                Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)element$iv$iv6).append('\n'), (String)"append('\\n')");
                for (String string3 : ((PluginUnloadabilityStatus)status822).getUnspecifiedDynamicEPs()) {
                    StringBuilder stringBuilder20;
                    StringBuilder $i$f$filterTo722 = $this$buildString;
                    element$iv$iv6 = "  " + string3;
                    element$iv$iv7 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$filterTo722.append((String)element$iv$iv6), (String)"append(value)");
                    bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder20.append('\n'), (String)"append('\\n')");
                }
            }
            status822 = $this$buildString;
            $i$f$filter732 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)status822).append('\n'), (String)"append('\\n')");
        }
        $i$f$filter732 = false;
        Map epUsagesMap = new LinkedHashMap();
        for (PluginUnloadabilityStatus pluginUnloadabilityStatus : result) {
            for (String ep : pluginUnloadabilityStatus.getUnspecifiedDynamicEPs()) {
                epUsagesMap.put(ep, ((Number)epUsagesMap.getOrDefault(ep, 0)).intValue() + 1);
            }
        }
        Iterable iterable5 = MapsKt.toList((Map)epUsagesMap);
        boolean $i$f$filter8 = false;
        Iterable $i$f$filterTo722 = iterable5;
        Collection destination$iv$iv9 = new ArrayList();
        boolean $i$f$filterTo8 = false;
        for (Object element$iv$iv8 : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv8;
            boolean bl242 = false;
            if (!(!StringsKt.startsWith$default((String)((String)it.getFirst()), (String)"cidr", (boolean)false, (int)2, null))) continue;
            destination$iv$iv9.add(element$iv$iv8);
        }
        Iterable iterable6 = (List)destination$iv$iv9;
        boolean $i$f$sortedByDescending = false;
        boolean bl29 = false;
        List epUsagesList = CollectionsKt.sortedWith((Iterable)iterable6, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair it = (Pair)b;
                boolean bl2 = false;
                Comparable comparable = (Integer)it.getSecond();
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = (Integer)it.getSecond();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
        StringBuilder stringBuilder21 = $this$buildString;
        String string4 = "EP usage statistics (" + epUsagesList.size() + " non-dynamic EPs remaining):";
        bl29 = false;
        StringBuilder stringBuilder22 = stringBuilder21.append(string4);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder22, (String)"append(value)");
        StringBuilder stringBuilder23 = stringBuilder22;
        boolean bl30 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder23.append('\n'), (String)"append('\\n')");
        for (Pair pair : epUsagesList) {
            $this$buildString.append(((Number)pair.getSecond()).intValue() + ": " + (String)pair.getFirst());
            StringBuilder stringBuilder24 = $this$buildString;
            boolean bl31 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder24.append('\n'), (String)"append('\\n')");
        }
        String string5 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"StringBuilder().apply(builderAction).toString()");
        String report = string5;
        stringBuilder = StringCompanionObject.INSTANCE;
        String string3 = "AnalyzeUnloadablePlugins-Report-%s.txt";
        Object[] objectArray = new Object[]{DateFormatUtil.formatDateTime((long)System.currentTimeMillis())};
        boolean bl28 = false;
        String string6 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"java.lang.String.format(format, *args)");
        String fileName = string6;
        LightVirtualFile file = new LightVirtualFile(fileName, (CharSequence)report);
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, (VirtualFile)file);
        FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
    }

    /*
     * WARNING - void declaration
     */
    private final PluginUnloadabilityStatus analyzeUnloadable(IdeaPlugin ideaPlugin, List<? extends XmlFile> allPlugins) {
        void $this$mapNotNullTo$iv$iv;
        boolean bl = false;
        Set unspecifiedDynamicEPs = new LinkedHashSet();
        boolean bl2 = false;
        Set nonDynamicEPs = new LinkedHashSet();
        boolean bl3 = false;
        List analysisErrors = new ArrayList();
        boolean bl4 = false;
        List serviceOverrides = new ArrayList();
        boolean bl5 = false;
        List components = new ArrayList();
        this.analyzePluginFile(ideaPlugin, analysisErrors, components, nonDynamicEPs, unspecifiedDynamicEPs, serviceOverrides, true);
        Function1<IdeaPlugin, Unit> $fun$analyzeDependencies$1 = new Function1<IdeaPlugin, Unit>(this, analysisErrors, components, nonDynamicEPs, unspecifiedDynamicEPs, serviceOverrides){
            final /* synthetic */ AnalyzeUnloadablePluginsAction this$0;
            final /* synthetic */ List $analysisErrors;
            final /* synthetic */ List $components;
            final /* synthetic */ Set $nonDynamicEPs;
            final /* synthetic */ Set $unspecifiedDynamicEPs;
            final /* synthetic */ List $serviceOverrides;

            public final void invoke(@NotNull IdeaPlugin ideaPlugin) {
                Intrinsics.checkNotNullParameter((Object)ideaPlugin, (String)"ideaPlugin");
                Iterator<Dependency> iterator = ideaPlugin.getDepends().iterator();
                while (iterator.hasNext()) {
                    String configFileName;
                    Dependency dependency;
                    Dependency dependency2 = dependency = iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)dependency2, (String)"dependency");
                    GenericAttributeValue<PathReference> genericAttributeValue = dependency2.getConfigFile();
                    Intrinsics.checkNotNullExpressionValue(genericAttributeValue, (String)"dependency.configFile");
                    if (genericAttributeValue.getStringValue() == null) {
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)configFileName, (String)"dependency.configFile.stringValue ?: continue");
                    IdeaPlugin depIdeaPlugin = AnalyzeUnloadablePluginsAction.access$resolvePluginDependency(this.this$0, dependency);
                    if (depIdeaPlugin == null) {
                        this.$analysisErrors.add("Failed to resolve dependency descriptor file " + configFileName);
                        continue;
                    }
                    AnalyzeUnloadablePluginsAction.access$analyzePluginFile(this.this$0, depIdeaPlugin, this.$analysisErrors, this.$components, this.$nonDynamicEPs, this.$unspecifiedDynamicEPs, this.$serviceOverrides, true);
                    this.invoke(depIdeaPlugin);
                }
            }
            {
                this.this$0 = analyzeUnloadablePluginsAction;
                this.$analysisErrors = list;
                this.$components = list2;
                this.$nonDynamicEPs = set;
                this.$unspecifiedDynamicEPs = set2;
                this.$serviceOverrides = list3;
                super(1);
            }
        };
        $fun$analyzeDependencies$1.invoke(ideaPlugin);
        boolean bl6 = false;
        List componentsInOptionalDependencies = new ArrayList();
        boolean bl7 = false;
        Map nonDynamicEPsInOptionalDependencies = new LinkedHashMap();
        boolean bl8 = false;
        List serviceOverridesInDependencies = new ArrayList();
        boolean bl9 = false;
        List dependenciesWithoutSeparateClassloaders = new ArrayList();
        Iterable $this$mapNotNull$iv = allPlugins;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            IdeaPlugin ideaPlugin2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl10 = false;
            XmlFile it = (XmlFile)element$iv$iv;
            boolean bl11 = false;
            if (DescriptorUtil.getIdeaPlugin(it) == null) continue;
            boolean bl12 = false;
            boolean bl13 = false;
            IdeaPlugin it$iv$iv = ideaPlugin2;
            boolean bl14 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterator iterator2 = ((List)destination$iv$iv).iterator();
        while (iterator2.hasNext()) {
            IdeaPlugin descriptor;
            IdeaPlugin ideaPlugin3 = descriptor = (IdeaPlugin)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)ideaPlugin3, (String)"descriptor");
            Iterator<Dependency> iterator3 = ideaPlugin3.getDepends().iterator();
            while (iterator3.hasNext()) {
                boolean bl15;
                Dependency dependency;
                Dependency dependency2 = dependency = iterator3.next();
                Intrinsics.checkNotNullExpressionValue((Object)dependency2, (String)"dependency");
                GenericAttributeValue<Boolean> genericAttributeValue = dependency2.getOptional();
                Intrinsics.checkNotNullExpressionValue(genericAttributeValue, (String)"dependency.optional");
                if (!Intrinsics.areEqual((Object)((Boolean)genericAttributeValue.getValue()), (Object)true) || !Intrinsics.areEqual((Object)dependency.getValue(), (Object)ideaPlugin)) continue;
                IdeaPlugin depIdeaPlugin = this.resolvePluginDependency(dependency);
                if (depIdeaPlugin == null) {
                    GenericAttributeValue<PathReference> genericAttributeValue2 = dependency.getConfigFile();
                    Intrinsics.checkNotNullExpressionValue(genericAttributeValue2, (String)"dependency.configFile");
                    if (genericAttributeValue2.getStringValue() == null) continue;
                    StringBuilder stringBuilder = new StringBuilder().append("Failed to resolve dependency descriptor file ");
                    GenericAttributeValue<PathReference> genericAttributeValue3 = dependency.getConfigFile();
                    Intrinsics.checkNotNullExpressionValue(genericAttributeValue3, (String)"dependency.configFile");
                    analysisErrors.add(stringBuilder.append(genericAttributeValue3.getStringValue()).toString());
                    continue;
                }
                if (descriptor.getPluginId() != null) {
                    bl15 = false;
                    boolean bl16 = false;
                    Object pluginId = destination$iv$iv;
                    boolean bl17 = false;
                    GenericAttributeValue<PsiPackage> genericAttributeValue4 = depIdeaPlugin.getPackage();
                    Intrinsics.checkNotNullExpressionValue(genericAttributeValue4, (String)"depIdeaPlugin.`package`");
                    if (genericAttributeValue4.getRawText() == null) {
                        Object object = pluginId;
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pluginId");
                        dependenciesWithoutSeparateClassloaders.add(object);
                    }
                }
                bl15 = false;
                Set nonDynamicEPsInDependency = new LinkedHashSet();
                this.analyzePluginFile(depIdeaPlugin, analysisErrors, componentsInOptionalDependencies, nonDynamicEPsInDependency, nonDynamicEPsInDependency, serviceOverridesInDependencies, false);
                Collection collection = nonDynamicEPsInDependency;
                boolean bl18 = false;
                if (!(!collection.isEmpty())) continue;
                String string = descriptor.getPluginId();
                if (string == null) {
                    string = "<unknown>";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptor.pluginId ?: \"<unknown>\"");
                nonDynamicEPsInOptionalDependencies.put(string, nonDynamicEPsInDependency);
            }
        }
        String string = ideaPlugin.getPluginId();
        if (string == null) {
            string = "?";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ideaPlugin.pluginId ?: \"?\"");
        return new PluginUnloadabilityStatus(string, unspecifiedDynamicEPs, nonDynamicEPs, nonDynamicEPsInOptionalDependencies, dependenciesWithoutSeparateClassloaders, components, serviceOverrides, analysisErrors);
    }

    private final IdeaPlugin resolvePluginDependency(Dependency dependency) {
        IdeaPlugin ideaPlugin;
        XmlFile xmlFile = dependency.getResolvedConfigFile();
        GenericAttributeValue<PathReference> genericAttributeValue = dependency.getConfigFile();
        Intrinsics.checkNotNullExpressionValue(genericAttributeValue, (String)"dependency.configFile");
        String configFileName = genericAttributeValue.getStringValue();
        if (xmlFile == null && configFileName != null) {
            DomManager domManager = dependency.getManager();
            Intrinsics.checkNotNullExpressionValue((Object)domManager, (String)"dependency.manager");
            Project project = domManager.getProject();
            Object[] objectArray = FilenameIndex.getFilesByName((Project)project, (String)configFileName, (GlobalSearchScope)GlobalSearchScopesCore.projectProductionScope((Project)project));
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"FilenameIndex.getFilesBy\u2026ProductionScope(project))");
            Object[] matchingFiles = objectArray;
            Object object = ArraysKt.singleOrNull((Object[])matchingFiles);
            if (!(object instanceof XmlFile)) {
                object = null;
            }
            xmlFile = (XmlFile)object;
        }
        XmlFile xmlFile2 = xmlFile;
        if (xmlFile2 != null) {
            XmlFile xmlFile3 = xmlFile2;
            boolean bl = false;
            boolean bl2 = false;
            XmlFile it = xmlFile3;
            boolean bl3 = false;
            ideaPlugin = DescriptorUtil.getIdeaPlugin(it);
        } else {
            ideaPlugin = null;
        }
        return ideaPlugin;
    }

    /*
     * WARNING - void declaration
     */
    private final void analyzePluginFile(IdeaPlugin ideaPlugin, List<String> analysisErrors, List<String> components, Set<String> nonDynamicEPs, Set<String> unspecifiedDynamicEPs, List<String> serviceOverrides, boolean allowOwnEPs) {
        String string;
        Collection collection;
        void $this$mapTo$iv;
        Iterable list$iv$iv;
        Object it;
        Object $this$flatMapTo$iv$iv;
        Object ep;
        void $this$flatMapTo$iv$iv2;
        List<Extensions> list = ideaPlugin.getExtensions();
        Intrinsics.checkNotNullExpressionValue(list, (String)"ideaPlugin.extensions");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap2 = false;
        Iterable iterable = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            Extensions it2 = (Extensions)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv2 = it2.collectExtensions();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv2);
        }
        Iterator iterator = ((List)destination$iv$iv).iterator();
        while (iterator.hasNext()) {
            Extension extension;
            Extension extension2 = extension = (Extension)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)extension2, (String)"extension");
            ep = extension2.getExtensionPoint();
            if (ep == null) {
                analysisErrors.add("Cannot resolve EP " + extension.getXmlElementName());
                continue;
            }
            if (allowOwnEPs && (Intrinsics.areEqual((Object)ep.getModule(), (Object)ideaPlugin.getModule()) || Intrinsics.areEqual((Object)ep.getModule(), (Object)extension.getModule()))) continue;
            GenericAttributeValue<Boolean> genericAttributeValue = ep.getDynamic();
            Intrinsics.checkNotNullExpressionValue(genericAttributeValue, (String)"ep.dynamic");
            Boolean $i$f$flatMap2 = (Boolean)genericAttributeValue.getValue();
            if (Intrinsics.areEqual((Object)$i$f$flatMap2, (Object)false)) {
                String string2 = ep.getEffectiveQualifiedName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ep.effectiveQualifiedName");
                nonDynamicEPs.add(string2);
            } else if ($i$f$flatMap2 == null) {
                String string3 = ep.getEffectiveQualifiedName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ep.effectiveQualifiedName");
                unspecifiedDynamicEPs.add(string3);
            }
            if (!Intrinsics.areEqual((Object)ep.getEffectiveQualifiedName(), (Object)"com.intellij.applicationService") && !Intrinsics.areEqual((Object)ep.getEffectiveQualifiedName(), (Object)"com.intellij.projectService") && !Intrinsics.areEqual((Object)ep.getEffectiveQualifiedName(), (Object)"com.intellij.moduleService") || !Intrinsics.areEqual((Object)extension.getXmlTag().getAttributeValue("overrides"), (Object)"true")) continue;
            String string4 = extension.getXmlTag().getAttributeValue("serviceInterface");
            if (string4 == null) {
                string4 = "<unknown>";
            }
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"extension.xmlTag.getAttr\u2026nterface\") ?: \"<unknown>\"");
            serviceOverrides.add(string4);
        }
        List<ApplicationComponents> list2 = ideaPlugin.getApplicationComponents();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"ideaPlugin.applicationComponents");
        Iterable $this$flatMap$iv2 = list2;
        boolean $i$f$flatMap3 = false;
        ep = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo22 = false;
        destination$iv$iv = $this$flatMapTo$iv$iv.iterator();
        while (destination$iv$iv.hasNext()) {
            Object element$iv$iv = destination$iv$iv.next();
            it = (ApplicationComponents)element$iv$iv;
            boolean bl = false;
            ApplicationComponents applicationComponents = it;
            Intrinsics.checkNotNullExpressionValue((Object)applicationComponents, (String)"it");
            list$iv$iv = applicationComponents.getComponents();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv2;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it3;
            Component.Application $i$f$flatMapTo22 = (Component.Application)item$iv;
            collection = components;
            boolean bl = false;
            void v8 = it3;
            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"it");
            GenericDomValue<PsiClass> genericDomValue = v8.getImplementationClass();
            Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"it.implementationClass");
            String string5 = genericDomValue.getRawText();
            if (string5 == null) {
                string5 = "?";
            }
            string = string5;
            collection.add(string);
        }
        List<ProjectComponents> list3 = ideaPlugin.getProjectComponents();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"ideaPlugin.projectComponents");
        $this$flatMap$iv2 = list3;
        $i$f$flatMap3 = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv2;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo32 = false;
        Iterator bl = $this$flatMapTo$iv$iv.iterator();
        while (bl.hasNext()) {
            Object element$iv$iv = bl.next();
            it = (ProjectComponents)element$iv$iv;
            boolean bl2 = false;
            Object object = it;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it");
            list$iv$iv = object.getComponents();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv2;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it4;
            Component.Project $i$f$flatMapTo32 = (Component.Project)item$iv;
            collection = components;
            boolean bl3 = false;
            void v13 = it4;
            Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"it");
            GenericDomValue<PsiClass> genericDomValue = v13.getImplementationClass();
            Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"it.implementationClass");
            String string6 = genericDomValue.getRawText();
            if (string6 == null) {
                string6 = "?";
            }
            string = string6;
            collection.add(string);
        }
        List<ModuleComponents> list4 = ideaPlugin.getModuleComponents();
        Intrinsics.checkNotNullExpressionValue(list4, (String)"ideaPlugin.moduleComponents");
        $this$flatMap$iv2 = list4;
        $i$f$flatMap3 = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv2;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo42 = false;
        Iterator bl3 = $this$flatMapTo$iv$iv.iterator();
        while (bl3.hasNext()) {
            Object element$iv$iv = bl3.next();
            it = (ModuleComponents)element$iv$iv;
            boolean bl4 = false;
            Object object = it;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it");
            list$iv$iv = object.getComponents();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv2;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it5;
            Component.Module $i$f$flatMapTo42 = (Component.Module)item$iv;
            collection = components;
            boolean bl5 = false;
            void v18 = it5;
            Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"it");
            GenericDomValue<PsiClass> genericDomValue = v18.getImplementationClass();
            Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"it.implementationClass");
            String string7 = genericDomValue.getRawText();
            if (string7 == null) {
                string7 = "?";
            }
            string = string7;
            collection.add(string);
        }
    }

    public static final /* synthetic */ PluginUnloadabilityStatus access$analyzeUnloadable(AnalyzeUnloadablePluginsAction $this, IdeaPlugin ideaPlugin, List allPlugins) {
        return $this.analyzeUnloadable(ideaPlugin, allPlugins);
    }

    public static final /* synthetic */ IdeaPlugin access$resolvePluginDependency(AnalyzeUnloadablePluginsAction $this, Dependency dependency) {
        return $this.resolvePluginDependency(dependency);
    }

    public static final /* synthetic */ void access$analyzePluginFile(AnalyzeUnloadablePluginsAction $this, IdeaPlugin ideaPlugin, List analysisErrors, List components, Set nonDynamicEPs, Set unspecifiedDynamicEPs, List serviceOverrides, boolean allowOwnEPs) {
        $this.analyzePluginFile(ideaPlugin, analysisErrors, components, nonDynamicEPs, unspecifiedDynamicEPs, serviceOverrides, allowOwnEPs);
    }
}

