/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.module;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.ui.UIThemeProvider;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.impl.BundledKeymapBean;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

final class PluginModuleConvertToGradleStartupActivity
implements StartupActivity.Background {
    @NonNls
    private static final String ID = "Migrate DevKit plugin to Gradle";
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"Migrate DevKit plugin to Gradle", (String)DevKitBundle.message("convert.devkit.to.gradle.notification", new Object[0]));
    private static final String DO_NOT_SHOW_AGAIN_SETTING = "PluginModuleConvertToGradleStartupActivity.DoNotShowAgain";

    PluginModuleConvertToGradleStartupActivity() {
    }

    public void runActivity(@NotNull Project project) {
        Application application;
        if (project == null) {
            PluginModuleConvertToGradleStartupActivity.$$$reportNull$$$0(0);
        }
        if ((application = ApplicationManager.getApplication()).isUnitTestMode() || application.isHeadlessEnvironment()) {
            return;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        if (propertiesComponent.isTrueValue(DO_NOT_SHOW_AGAIN_SETTING)) {
            return;
        }
        HashSet<Module> devkitModules = new HashSet<Module>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!PluginModuleType.isOfType(module)) continue;
            devkitModules.add(module);
            if (devkitModules.size() > 1) break;
        }
        if (!PluginModuleConvertToGradleStartupActivity.isSimpleSingleModulePlugin(project, devkitModules)) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> NOTIFICATION_GROUP.createNotification(DevKitBundle.message("convert.devkit.to.gradle.notification", new Object[0]), DevKitBundle.message("convert.devkit.to.gradle.notification.content", new Object[0]), NotificationType.INFORMATION).addAction((AnAction)NotificationAction.createSimpleExpiring((String)DevKitBundle.message("convert.devkit.to.gradle.notification.link.title", new Object[0]), () -> BrowserUtil.browse((String)"https://plugins.jetbrains.com/docs/intellij/gradle-prerequisites.html?from=DevkitConvertToGradleNotification#adding-gradle-support-to-an-existing-devkit-based-intellij-platform-plugin"))).addAction((AnAction)NotificationAction.createSimpleExpiring((String)DevKitBundle.message("convert.devkit.to.gradle.notification.do.not.show.again", new Object[0]), () -> propertiesComponent.setValue(DO_NOT_SHOW_AGAIN_SETTING, true))).setIcon(AllIcons.Nodes.Plugin).notify(project));
    }

    private static boolean isSimpleSingleModulePlugin(Project project, Set<Module> devkitModules) {
        if (devkitModules.size() != 1) {
            return false;
        }
        return (Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
            XmlFile pluginXml = PluginModuleType.getPluginXml((Module)ContainerUtil.getOnlyItem((Collection)devkitModules));
            if (pluginXml == null || !DescriptorUtil.isPluginXml((PsiFile)pluginXml)) {
                return false;
            }
            IdeaPlugin ideaPlugin = DescriptorUtil.getIdeaPlugin(pluginXml);
            assert (ideaPlugin != null);
            Extensions extensions = (Extensions)ContainerUtil.getOnlyItem(ideaPlugin.getExtensions());
            if (extensions == null) {
                return false;
            }
            List<Extension> extensionList = extensions.collectExtensions();
            for (Extension extension : extensionList) {
                ExtensionPoint extensionPoint = extension.getExtensionPoint();
                if (extensionPoint == null) {
                    return false;
                }
                String extensionPointName = extensionPoint.getEffectiveQualifiedName();
                if (UIThemeProvider.EP_NAME.getName().equals(extensionPointName) || BundledKeymapBean.EP_NAME.getName().equals(extensionPointName)) continue;
                return false;
            }
            return !extensionList.isEmpty();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/devkit/module/PluginModuleConvertToGradleStartupActivity", "runActivity"));
    }
}

