/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.calendar;

import circlet.common.calendar.EventCounter;
import circlet.common.calendar.EventCountersKt;
import circlet.common.calendar.RecurrenceRuleFreq;
import circlet.common.calendar.RelativeDate;
import circlet.common.calendar.SpecIntersectsKt;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.KotlinXDate;
import circlet.platform.api.Weekday;
import circlet.platform.api.WorkingDaysKt;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\u0010\u001a\u00060\u0005j\u0002`\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J \u0010\u0014\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u0015\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u0002\u001a\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00060\u0005j\u0002`\u0006H\u0016J \u0010\u0018\u001a\u00060\u0005j\u0002`\u00062\n\u0010\b\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\b\u0010\u001a\u001a\u00020\u0003H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0014\u0010\u001d\u001a\u00020\u001e2\n\u0010\b\u001a\u00060\u0005j\u0002`\u0006H\u0002J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0014\u0010 \u001a\u00020!2\n\u0010\b\u001a\u00060\u0005j\u0002`\u0006H\u0002J\u0018\u0010\"\u001a\u00060\u0005j\u0002`\u00062\n\u0010#\u001a\u00060\u0005j\u0002`\u0006H\u0002J\f\u0010$\u001a\u00060\u0005j\u0002`\u0006H\u0002J\b\u0010%\u001a\u00020&H\u0016J\u0014\u0010'\u001a\u00020&2\n\u0010(\u001a\u00060\u0005j\u0002`\u0006H\u0016R\u001e\u0010\b\u001a\u00060\u0005j\u0002`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\n\u00a8\u0006)"}, d2={"Lcirclet/common/calendar/RegularEventCounter;", "Lcirclet/common/calendar/EventCounter;", "freq", "Lcirclet/common/calendar/RecurrenceRuleFreq;", "startDate", "Lcirclet/platform/api/KotlinXDate;", "Lcirclet/platform/api/ADate;", "(Lcirclet/common/calendar/RecurrenceRuleFreq;Lcirclet/platform/api/KotlinXDate;)V", "date", "getDate", "()Lcirclet/platform/api/KotlinXDate;", "setDate", "(Lcirclet/platform/api/KotlinXDate;)V", "getFreq", "()Lcirclet/common/calendar/RecurrenceRuleFreq;", "getStartDate", "adjustDateForWeekday", "weekdays", "", "Lcirclet/platform/api/Weekday;", "calcNextMonthlyOnWeekday", "start", "Lcirclet/common/calendar/RecurrenceRuleFreq$MonthlyOnFirstWeekday;", "getCurrentDate", "getFirstWeekdayInMonth", "weekday", "getFrequency", "getRelativity", "Lcirclet/common/calendar/RelativeDate;", "getWeekdayShift", "", "getWeekdays", "isDateCorrect", "", "leapTo", "toDate", "next", "toNextEvent", "", "toNextEventAfterDate", "targetDate", "common"})
public final class RegularEventCounter
implements EventCounter {
    @NotNull
    private final RecurrenceRuleFreq freq;
    @NotNull
    private final KotlinXDate startDate;
    @NotNull
    private KotlinXDate date;

    public RegularEventCounter(@NotNull RecurrenceRuleFreq freq, @NotNull KotlinXDate startDate) {
        Intrinsics.checkNotNullParameter((Object)freq, (String)"freq");
        Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
        this.freq = freq;
        this.date = this.startDate = startDate;
    }

    @NotNull
    public final RecurrenceRuleFreq getFreq() {
        return this.freq;
    }

    @NotNull
    public final KotlinXDate getStartDate() {
        return this.startDate;
    }

    @NotNull
    public final KotlinXDate getDate() {
        return this.date;
    }

    public final void setDate(@NotNull KotlinXDate kotlinXDate) {
        Intrinsics.checkNotNullParameter((Object)kotlinXDate, (String)"<set-?>");
        this.date = kotlinXDate;
    }

    @Override
    public void toNextEvent() {
        this.date = this.next();
    }

    @Override
    public void toNextEventAfterDate(@NotNull KotlinXDate targetDate) {
        Intrinsics.checkNotNullParameter((Object)targetDate, (String)"targetDate");
        this.date = this.leapTo(targetDate);
        if (!this.isDateCorrect(this.date)) {
            this.date = this.next();
        }
        while (this.date.compareTo(targetDate) < 0) {
            this.date = this.next();
        }
        boolean bl = this.isDateCorrect(this.date);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Event counter has switched to an incorrect date. Frequency: " + this.getFreq() + ", start date: " + this.getStartDate() + ", date: " + this.getDate();
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
    }

    private final boolean isDateCorrect(KotlinXDate date2) {
        boolean bl;
        RecurrenceRuleFreq recurrenceRuleFreq = this.freq;
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Daily) {
            int daysDiff = ADateJvmKt.daysBetween(this.startDate, date2);
            return daysDiff % ((RecurrenceRuleFreq.Daily)this.freq).getInterval() == 0;
        }
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Weekly) {
            return ((RecurrenceRuleFreq.Weekly)this.freq).getWeekdays().contains(ADateJvmKt.getWeekday(date2));
        }
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnFirstWeekday) {
            return ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)this.freq).getWeekday() == ADateJvmKt.getWeekday(date2) && this.getWeekdayShift(date2) == ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)this.freq).getShift();
        }
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnLastWeekday) {
            return ((RecurrenceRuleFreq.MonthlyOnLastWeekday)this.freq).getWeekday() == ADateJvmKt.getWeekday(date2) && ADateJvmKt.getDayOfMonth(date2) >= ADateJvmKt.getLastMonthDay(date2) - 7;
        }
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnDate) {
            bl = ((RecurrenceRuleFreq.MonthlyOnDate)this.freq).getDay() == ADateJvmKt.getDayOfMonth(date2);
        } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnStartDate) {
            bl = ADateJvmKt.getDayOfMonth(this.startDate) == ADateJvmKt.getDayOfMonth(date2);
        } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Yearly) {
            bl = ADateJvmKt.getDayOfMonth(this.startDate) == ADateJvmKt.getDayOfMonth(date2) && ADateJvmKt.getMonth(this.startDate) == ADateJvmKt.getMonth(date2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    @NotNull
    public KotlinXDate getCurrentDate() {
        return this.date;
    }

    private final KotlinXDate leapTo(KotlinXDate toDate) {
        if (toDate.compareTo(this.date) <= 0) {
            return this.date;
        }
        RecurrenceRuleFreq recurrenceRuleFreq = this.freq;
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Daily) {
            int daysDiff = ADateJvmKt.daysBetween(this.date, toDate);
            return ADateJvmKt.plusDays(this.date, ((RecurrenceRuleFreq.Daily)this.freq).getInterval() * (daysDiff / ((RecurrenceRuleFreq.Daily)this.freq).getInterval()));
        }
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Weekly) {
            KotlinXDate adjustedDate = this.adjustDateForWeekday(((RecurrenceRuleFreq.Weekly)this.freq).getWeekdays());
            int daysDiff = ADateJvmKt.daysBetween(adjustedDate, toDate);
            return ADateJvmKt.plusDays(adjustedDate, 7 * ((RecurrenceRuleFreq.Weekly)this.freq).getInterval() * (daysDiff / (((RecurrenceRuleFreq.Weekly)this.freq).getInterval() * 7)));
        }
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnFirstWeekday) {
            KotlinXDate adjustedDate = this.adjustDateForWeekday(CollectionsKt.listOf((Object)((RecurrenceRuleFreq.MonthlyOnFirstWeekday)this.freq).getWeekday()));
            int monthsDiff = ADateJvmKt.monthsBetween(adjustedDate, toDate);
            return monthsDiff == 0 ? adjustedDate : ADateJvmKt.plusMonths(ADateJvmKt.withDay(adjustedDate, 1), ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)this.freq).getInterval() * (monthsDiff / ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)this.freq).getInterval()));
        }
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnLastWeekday) {
            KotlinXDate adjustedDate = this.adjustDateForWeekday(CollectionsKt.listOf((Object)((RecurrenceRuleFreq.MonthlyOnLastWeekday)this.freq).getWeekday()));
            int monthsDiff = ADateJvmKt.monthsBetween(adjustedDate, toDate);
            return monthsDiff == 0 ? adjustedDate : ADateJvmKt.plusMonths(ADateJvmKt.withDay(adjustedDate, 1), ((RecurrenceRuleFreq.MonthlyOnLastWeekday)this.freq).getInterval() * (monthsDiff / ((RecurrenceRuleFreq.MonthlyOnLastWeekday)this.freq).getInterval()));
        }
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnDate) {
            int monthsDiff = ADateJvmKt.monthsBetween(this.date, toDate);
            return monthsDiff == 0 ? this.date : ADateJvmKt.plusMonths(ADateJvmKt.withDay(this.date, 1), ((RecurrenceRuleFreq.MonthlyOnDate)this.freq).getInterval() * (monthsDiff / ((RecurrenceRuleFreq.MonthlyOnDate)this.freq).getInterval()));
        }
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnStartDate) {
            int monthsDiff = ADateJvmKt.monthsBetween(this.date, toDate);
            return monthsDiff == 0 ? this.date : ADateJvmKt.plusMonths(ADateJvmKt.withDay(this.date, 1), ((RecurrenceRuleFreq.MonthlyOnStartDate)this.freq).getInterval() * (monthsDiff / ((RecurrenceRuleFreq.MonthlyOnStartDate)this.freq).getInterval()));
        }
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Yearly) {
            int yearsDiff = ADateJvmKt.monthsBetween(this.date, toDate) / 12;
            return yearsDiff == 0 ? this.date : ADateJvmKt.plusYears(ADateJvmKt.withDay(this.date, 1), ((RecurrenceRuleFreq.Yearly)this.freq).getInterval() * (yearsDiff / ((RecurrenceRuleFreq.Yearly)this.freq).getInterval()));
        }
        throw new NoWhenBranchMatchedException();
    }

    private final KotlinXDate adjustDateForWeekday(List<? extends Weekday> weekdays) {
        if (weekdays.isEmpty()) {
            return this.date;
        }
        KotlinXDate adjustedDate = this.date;
        while (!weekdays.contains(ADateJvmKt.getWeekday(adjustedDate))) {
            adjustedDate = ADateJvmKt.plusDays(adjustedDate, 1);
        }
        return adjustedDate;
    }

    private final KotlinXDate next() {
        KotlinXDate start2 = this.date;
        RecurrenceRuleFreq recurrenceRuleFreq = this.freq;
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Daily) {
            return ADateJvmKt.plusDays(start2, ((RecurrenceRuleFreq.Daily)this.freq).getInterval());
        }
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Weekly) {
            Iterable $this$forEach$iv = (Iterable)new IntRange(ADateJvmKt.getWeekday(start2).ordinal() + 1, 6);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                int element$iv;
                int it = element$iv = ((IntIterator)iterator2).nextInt();
                boolean bl = false;
                if (!((RecurrenceRuleFreq.Weekly)this.getFreq()).getWeekdays().contains(WorkingDaysKt.weekday(it))) continue;
                return ADateJvmKt.plusDays(EventCountersKt.access$weekStart(start2), it);
            }
            KotlinXDate next = ADateJvmKt.plusDays(EventCountersKt.access$weekStart(start2), 7 * ((RecurrenceRuleFreq.Weekly)this.freq).getInterval());
            Object $this$forEach$iv2 = (Iterable)new IntRange(0, 6);
            boolean $i$f$forEach2 = false;
            Iterator iterator3 = $this$forEach$iv2.iterator();
            while (iterator3.hasNext()) {
                int element$iv;
                int it = element$iv = ((IntIterator)iterator3).nextInt();
                boolean bl = false;
                if (!((RecurrenceRuleFreq.Weekly)this.getFreq()).getWeekdays().contains(WorkingDaysKt.weekday(it))) continue;
                return ADateJvmKt.plusDays(next, it);
            }
            $this$forEach$iv2 = Intrinsics.stringPlus((String)"unexpected next for ", (Object)this.freq);
            $i$f$forEach2 = false;
            throw (Throwable)new IllegalStateException($this$forEach$iv2.toString());
        }
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnFirstWeekday) {
            return this.calcNextMonthlyOnWeekday(start2, (RecurrenceRuleFreq.MonthlyOnFirstWeekday)this.freq);
        }
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnLastWeekday) {
            KotlinXDate ret = ADateJvmKt.plusDays(ADateJvmKt.plusMonths(SpecIntersectsKt.monthStart(start2), ((RecurrenceRuleFreq.MonthlyOnLastWeekday)this.freq).getInterval() + 1), -1);
            Iterable $this$forEach$iv = (Iterable)new IntRange(0, 6);
            boolean $i$f$forEach = false;
            Iterator iterator4 = $this$forEach$iv.iterator();
            while (iterator4.hasNext()) {
                int element$iv;
                int it = element$iv = ((IntIterator)iterator4).nextInt();
                boolean bl = false;
                KotlinXDate day = ADateJvmKt.plusDays(ret, -it);
                if (ADateJvmKt.getWeekday(day) != ((RecurrenceRuleFreq.MonthlyOnLastWeekday)this.getFreq()).getWeekday()) continue;
                return day;
            }
            String string2 = Intrinsics.stringPlus((String)"unexpected next for ", (Object)this.freq);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnDate) {
            return SpecIntersectsKt.toNextDateWithMonthDay(start2, ((RecurrenceRuleFreq.MonthlyOnDate)this.freq).getDay(), ((RecurrenceRuleFreq.MonthlyOnDate)this.freq).getInterval());
        }
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnStartDate) {
            return SpecIntersectsKt.toNextDateWithMonthDay(start2, ADateJvmKt.getDayOfMonth(this.startDate), ((RecurrenceRuleFreq.MonthlyOnStartDate)this.freq).getInterval());
        }
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Yearly) {
            return SpecIntersectsKt.toNextYearWithYearDay(start2, ADateJvmKt.getDayOfMonth(this.startDate), ADateJvmKt.getMonth(this.startDate), ((RecurrenceRuleFreq.Yearly)this.freq).getInterval());
        }
        throw new NoWhenBranchMatchedException();
    }

    private final KotlinXDate calcNextMonthlyOnWeekday(KotlinXDate start2, RecurrenceRuleFreq.MonthlyOnFirstWeekday freq) {
        KotlinXDate currentMonthStart = SpecIntersectsKt.monthStart(start2);
        KotlinXDate weekday = ADateJvmKt.plusDays(this.getFirstWeekdayInMonth(currentMonthStart, freq.getWeekday()), 7 * freq.getShift());
        if (ADateJvmKt.getMonth(weekday) == ADateJvmKt.getMonth(currentMonthStart) && weekday.compareTo(start2) > 0) {
            return weekday;
        }
        return this.calcNextMonthlyOnWeekday(ADateJvmKt.plusMonths(currentMonthStart, freq.getInterval()), freq);
    }

    private final int getWeekdayShift(KotlinXDate date2) {
        KotlinXDate firstWeekday = this.getFirstWeekdayInMonth(date2, ADateJvmKt.getWeekday(date2));
        int daysBetween = ADateJvmKt.getDayOfMonth(date2) - ADateJvmKt.getDayOfMonth(firstWeekday);
        return daysBetween / 7;
    }

    private final KotlinXDate getFirstWeekdayInMonth(KotlinXDate date2, Weekday weekday) {
        KotlinXDate monthStart = SpecIntersectsKt.monthStart(date2);
        Iterable $this$forEach$iv = (Iterable)new IntRange(0, 6);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            KotlinXDate day = ADateJvmKt.plusDays(monthStart, it);
            if (ADateJvmKt.getWeekday(day) != weekday) continue;
            return day;
        }
        String string2 = "can't get first " + weekday + " relative to " + date2;
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string2.toString());
    }

    @Override
    @NotNull
    public List<Weekday> getWeekdays() {
        RecurrenceRuleFreq recurrenceRuleFreq = this.freq;
        return recurrenceRuleFreq instanceof RecurrenceRuleFreq.Weekly ? ((RecurrenceRuleFreq.Weekly)this.freq).getWeekdays() : (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnFirstWeekday ? CollectionsKt.listOf((Object)((RecurrenceRuleFreq.MonthlyOnFirstWeekday)this.freq).getWeekday()) : (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnLastWeekday ? CollectionsKt.listOf((Object)((RecurrenceRuleFreq.MonthlyOnLastWeekday)this.freq).getWeekday()) : CollectionsKt.emptyList()));
    }

    @Override
    @NotNull
    public RecurrenceRuleFreq getFrequency() {
        return this.freq;
    }

    @Override
    @NotNull
    public RelativeDate getRelativity() {
        return RelativeDate.Same;
    }

    @Override
    public int getFrequencyOrder() {
        return EventCounter.DefaultImpls.getFrequencyOrder(this);
    }

    @Override
    public boolean haveCommonWeekdays(@NotNull EventCounter event2) {
        return EventCounter.DefaultImpls.haveCommonWeekdays(this, event2);
    }
}

