/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.api;

import circlet.platform.api.ARecord;
import circlet.platform.api.Arena;
import circlet.platform.api.ExtArena;
import circlet.platform.api.Ref;
import circlet.platform.api.RefResolver;
import circlet.platform.api.RefSelector;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.stringUtils.Common_ConvertKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001a\u0010\n\u001a\u00020\u00012\u0010\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\fH\u0002\u001a\u0012\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0001j\u0002`\u0011\u001a\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u001a\u0010\u0014\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\r\u001a2\u0010\u0014\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00152\u0010\b\u0002\u0010\u0017\u001a\n\u0018\u00010\u0001j\u0004\u0018\u0001`\u00182\u0010\b\u0002\u0010\u0019\u001a\n\u0018\u00010\u0001j\u0004\u0018\u0001`\u0011\u001a\"\u0010\u001a\u001a\u00020\u0001*\u00020\u00012\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001c\u001a\u001a\u0010\u001e\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u0001\u001a\n\u0010!\u001a\u00020\u000f*\u00020\u0005\u001a\u0016\u0010\"\u001a\u00020\u0001*\u00020\u00012\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u0015\u001a9\u0010$\u001a\b\u0012\u0004\u0012\u0002H%0\r\"\n\b\u0000\u0010%\u0018\u0001*\u00020\u0005*\u00020&2\n\u0010'\u001a\u00060\u0001j\u0002`\u00182\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H%0\u001cH\u0086\b\u001a\u000e\u0010(\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u001c\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0017\u0010\b\u001a\u0004\u0018\u00010\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007*\n\u0010)\"\u00020\u00012\u00020\u0001\u00a8\u0006*"}, d2={"ARENA_TOMBSTONES_FILE_PACKAGE", "", "ArenaRecordTombstoneId", "ArenaTombstoneIdSuffix", "selector", "Lcirclet/platform/api/ARecord;", "getSelector", "(Lcirclet/platform/api/ARecord;)Ljava/lang/String;", "temporarySelector", "getTemporarySelector", "exceptionMessage", "refs", "", "Lcirclet/platform/api/Ref;", "isTombstoneArena", "", "arenaId", "Lcirclet/platform/api/ArenaId;", "parseRefSelector", "Lcirclet/platform/api/RefSelector;", "arenaIdForExtRecord", "Lcirclet/platform/api/ExtArena;", "parentRef", "parentRefId", "Lcirclet/platform/api/TID;", "parentArenaId", "idWithDifferentArena", "sourceArena", "Lcirclet/platform/api/Arena;", "targetArena", "idWithDifferentArenaPrefix", "sourcePrefix", "targetPrefix", "isTemporary", "recordIdFromExtArenaId", "arena", "refOf", "T", "Lcirclet/platform/api/RefResolver;", "id", "tombstoneId", "ArenaId", "platform-api"})
public final class ArenasKt {
    @NotNull
    public static final String ArenaRecordTombstoneId = "__TS__";
    @NotNull
    public static final String ArenaTombstoneIdSuffix = "__TS__";
    @NotNull
    public static final String ARENA_TOMBSTONES_FILE_PACKAGE = "tombstones";

    @NotNull
    public static final String arenaIdForExtRecord(@NotNull ExtArena<?> $this$arenaIdForExtRecord, @NotNull Ref<?> parentRef) {
        Intrinsics.checkNotNullParameter($this$arenaIdForExtRecord, (String)"<this>");
        Intrinsics.checkNotNullParameter(parentRef, (String)"parentRef");
        boolean bl = StringsKt.startsWith$default((String)parentRef.getArenaId(), (String)$this$arenaIdForExtRecord.getParent().getPrefix(), (boolean)false, (int)2, null);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Reference " + parentRef.getArenaId() + " must be from parent arena " + $this$arenaIdForExtRecord.getParent().getPrefix();
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return ArenasKt.arenaIdForExtRecord($this$arenaIdForExtRecord, parentRef.getId(), parentRef.getArenaId());
    }

    @NotNull
    public static final String arenaIdForExtRecord(@NotNull ExtArena<?> $this$arenaIdForExtRecord, @Nullable String parentRefId, @Nullable String parentArenaId) {
        String string2;
        Intrinsics.checkNotNullParameter($this$arenaIdForExtRecord, (String)"<this>");
        if ($this$arenaIdForExtRecord.getParent().getSingle() && $this$arenaIdForExtRecord.getSingle()) {
            string2 = $this$arenaIdForExtRecord.getPrefix();
        } else if ($this$arenaIdForExtRecord.getParent().getSingle() && !$this$arenaIdForExtRecord.getSingle()) {
            boolean bl = parentRefId != null;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string3 = "Record id must be specified if main arena is single and extension arena is non-single";
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
            string2 = Intrinsics.stringPlus((String)$this$arenaIdForExtRecord.getPrefix(), (Object)parentRefId);
        } else if (!$this$arenaIdForExtRecord.getParent().getSingle() && !$this$arenaIdForExtRecord.getSingle()) {
            boolean bl = parentArenaId != null && !Intrinsics.areEqual((Object)parentArenaId, (Object)$this$arenaIdForExtRecord.getParent().getPrefix());
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl) {
                boolean bl7 = false;
                String string4 = "Parent arenaId must be set for non-single parent arena";
                throw (Throwable)new IllegalArgumentException(string4.toString());
            }
            string2 = ArenasKt.idWithDifferentArena(parentArenaId, $this$arenaIdForExtRecord.getParent(), (Arena)$this$arenaIdForExtRecord);
        } else {
            String string5 = "Single extension arenas for non-single main arenas are not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string5.toString());
        }
        return string2;
    }

    public static /* synthetic */ String arenaIdForExtRecord$default(ExtArena extArena, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        if ((n & 2) != 0) {
            string3 = null;
        }
        return ArenasKt.arenaIdForExtRecord(extArena, string2, string3);
    }

    @NotNull
    public static final String recordIdFromExtArenaId(@NotNull String $this$recordIdFromExtArenaId, @NotNull ExtArena<?> arena2) {
        Intrinsics.checkNotNullParameter((Object)$this$recordIdFromExtArenaId, (String)"<this>");
        Intrinsics.checkNotNullParameter(arena2, (String)"arena");
        boolean bl = !arena2.getSingle();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Record is can be obtained from arena id only if arena is not single";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return StringsKt.removePrefix((String)$this$recordIdFromExtArenaId, (CharSequence)arena2.getPrefix());
    }

    @NotNull
    public static final String getSelector(@NotNull ARecord $this$selector) {
        Intrinsics.checkNotNullParameter((Object)$this$selector, (String)"<this>");
        return $this$selector.getArenaId() + '/' + $this$selector.getId();
    }

    @Nullable
    public static final String getTemporarySelector(@NotNull ARecord $this$temporarySelector) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$temporarySelector, (String)"<this>");
        String string3 = $this$temporarySelector.getTemporaryId();
        if (string3 == null) {
            string2 = null;
        } else {
            String string4 = string3;
            boolean bl = false;
            boolean bl2 = false;
            String it = string4;
            boolean bl3 = false;
            string2 = $this$temporarySelector.getArenaId() + '/' + it;
        }
        return string2;
    }

    @NotNull
    public static final String idWithDifferentArena(@NotNull String $this$idWithDifferentArena, @NotNull Arena<?> sourceArena, @NotNull Arena<?> targetArena) {
        Intrinsics.checkNotNullParameter((Object)$this$idWithDifferentArena, (String)"<this>");
        Intrinsics.checkNotNullParameter(sourceArena, (String)"sourceArena");
        Intrinsics.checkNotNullParameter(targetArena, (String)"targetArena");
        return ArenasKt.idWithDifferentArenaPrefix($this$idWithDifferentArena, sourceArena.getPrefix(), targetArena.getPrefix());
    }

    @NotNull
    public static final String idWithDifferentArenaPrefix(@NotNull String $this$idWithDifferentArenaPrefix, @NotNull String sourcePrefix, @NotNull String targetPrefix) {
        Intrinsics.checkNotNullParameter((Object)$this$idWithDifferentArenaPrefix, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sourcePrefix, (String)"sourcePrefix");
        Intrinsics.checkNotNullParameter((Object)targetPrefix, (String)"targetPrefix");
        return Intrinsics.stringPlus((String)targetPrefix, (Object)StringsKt.removePrefix((String)$this$idWithDifferentArenaPrefix, (CharSequence)sourcePrefix));
    }

    public static final /* synthetic */ <T extends ARecord> Ref<T> refOf(RefResolver $this$refOf, String id, Arena<T> arena2) {
        Intrinsics.checkNotNullParameter((Object)$this$refOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(arena2, (String)"arena");
        boolean $i$f$refOf = false;
        return new Ref(id, arena2.getPrefix(), $this$refOf);
    }

    @NotNull
    public static final RefSelector parseRefSelector(@NotNull String selector) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Pair<String, String> pair = Common_ConvertKt.partitionAtLast(selector, "/");
        String arenaAndKind = (String)pair.component1();
        String id = (String)pair.component2();
        Pair<String, String> pair2 = Common_ConvertKt.partitionAtLast(arenaAndKind, "/");
        String first = (String)pair2.component1();
        String second = (String)pair2.component2();
        CharSequence charSequence = first;
        boolean bl = false;
        return charSequence.length() == 0 ? new RefSelector(second, id) : new RefSelector(first, id);
    }

    public static final boolean isTemporary(@NotNull ARecord $this$isTemporary) {
        Intrinsics.checkNotNullParameter((Object)$this$isTemporary, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isTemporary.getId(), (Object)$this$isTemporary.getTemporaryId());
    }

    private static final String exceptionMessage(Collection<? extends Ref<?>> refs2) {
        return refs2.size() <= 10 ? Intrinsics.stringPlus((String)"References could not be resolved, they are ", refs2) : "References could not be resolved, size " + refs2.size() + ", first 10 are " + CollectionsKt.take((Iterable)refs2, (int)10);
    }

    @NotNull
    public static final String tombstoneId(@NotNull Arena<?> $this$tombstoneId) {
        Intrinsics.checkNotNullParameter($this$tombstoneId, (String)"<this>");
        return $this$tombstoneId.getSingle() ? $this$tombstoneId.getPrefix() : Intrinsics.stringPlus((String)$this$tombstoneId.getPrefix(), (Object)"__TS__");
    }

    public static final boolean isTombstoneArena(@NotNull String arenaId) {
        Intrinsics.checkNotNullParameter((Object)arenaId, (String)"arenaId");
        return StringsKt.endsWith$default((String)arenaId, (String)"__TS__", (boolean)false, (int)2, null);
    }

    public static final /* synthetic */ String access$exceptionMessage(Collection refs2) {
        return ArenasKt.exceptionMessage(refs2);
    }
}

