/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.workspaces;

import circlet.platform.api.ClientSupportFlag;
import circlet.platform.api.oauth.CodeChallenge;
import circlet.platform.api.oauth.OAuthFlowKt;
import circlet.platform.api.oauth.OAuthTokenResponse;
import circlet.platform.api.oauth.OpenSet;
import circlet.platform.workspaces.WorkspaceConfiguration;
import circlet.platform.workspaces.WorkspaceConfigurationKt;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import kotlin.text.StringsKt;
import libraries.collections.MultiMap;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.net.Http;
import runtime.net.Uri;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0016J!\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J\u0019\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0012\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006."}, d2={"Lcirclet/platform/workspaces/WorkspaceConfigurationImpl;", "Lcirclet/platform/workspaces/WorkspaceConfiguration;", "server", "", "apiServer", "clientId", "clientSecret", "features", "Lcirclet/platform/api/oauth/OpenSet;", "Lcirclet/platform/api/ClientSupportFlag;", "http", "Lruntime/net/Http;", "codeVerifier", "Lcirclet/platform/workspaces/WorkspaceConfiguration$CodeVerifier;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcirclet/platform/api/oauth/OpenSet;Lruntime/net/Http;Lcirclet/platform/workspaces/WorkspaceConfiguration$CodeVerifier;)V", "STRING_LENGTH", "", "getApiServer", "()Ljava/lang/String;", "charPool", "", "", "getClientId", "getClientSecret", "codeChallenge", "Lcirclet/platform/api/oauth/CodeChallenge$S256;", "getCodeChallenge", "()Lcirclet/platform/api/oauth/CodeChallenge$S256;", "codeChallenge$delegate", "Lkotlin/Lazy;", "getCodeVerifier", "()Lcirclet/platform/workspaces/WorkspaceConfiguration$CodeVerifier;", "getFeatures", "()Lcirclet/platform/api/oauth/OpenSet;", "getHttp", "()Lruntime/net/Http;", "getServer", "codeFlowURL", "redirectUri", "handleCodeFlowRedirect", "Lcirclet/platform/api/oauth/OAuthTokenResponse;", "uri", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "refreshTokenFlow", "refreshToken", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "platform-app-state"})
public final class WorkspaceConfigurationImpl
implements WorkspaceConfiguration {
    @NotNull
    private final String server;
    @NotNull
    private final String apiServer;
    @NotNull
    private final String clientId;
    @NotNull
    private final String clientSecret;
    @NotNull
    private final OpenSet<ClientSupportFlag> features;
    @NotNull
    private final Http http;
    @NotNull
    private final WorkspaceConfiguration.CodeVerifier codeVerifier;
    private final int STRING_LENGTH;
    @NotNull
    private final List<Character> charPool;
    @NotNull
    private final Lazy codeChallenge$delegate;

    public WorkspaceConfigurationImpl(@NotNull String server2, @NotNull String apiServer, @NotNull String clientId, @NotNull String clientSecret, @NotNull OpenSet<ClientSupportFlag> features2, @NotNull Http http, @NotNull WorkspaceConfiguration.CodeVerifier codeVerifier) {
        Intrinsics.checkNotNullParameter((Object)server2, (String)"server");
        Intrinsics.checkNotNullParameter((Object)apiServer, (String)"apiServer");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkNotNullParameter(features2, (String)"features");
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)codeVerifier, (String)"codeVerifier");
        this.server = server2;
        this.apiServer = apiServer;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.features = features2;
        this.http = http;
        this.codeVerifier = codeVerifier;
        this.STRING_LENGTH = 64;
        this.charPool = CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('A', 'Z'))), (Iterable)((Iterable)new CharRange('0', '9')));
        KLogger this_$iv = WorkspaceConfigurationKt.access$getLog$p();
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            String string2 = "WorkspaceConfiguration.init()";
            kLogger.debug(string2);
        }
        this.codeChallenge$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CodeChallenge.S256>(this){
            final /* synthetic */ WorkspaceConfigurationImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CodeChallenge.S256 invoke() {
                return CodeChallenge.Companion.s256(this.this$0.getCodeVerifier().getValue());
            }
        }));
    }

    public /* synthetic */ WorkspaceConfigurationImpl(String string2, String string3, String string4, String string5, OpenSet openSet, Http http, WorkspaceConfiguration.CodeVerifier codeVerifier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            openSet = OpenSet.None.INSTANCE;
        }
        this(string2, string3, string4, string5, openSet, http, codeVerifier);
    }

    @Override
    @NotNull
    public String getServer() {
        return this.server;
    }

    @Override
    @NotNull
    public String getApiServer() {
        return this.apiServer;
    }

    @Override
    @NotNull
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @NotNull
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    @NotNull
    public OpenSet<ClientSupportFlag> getFeatures() {
        return this.features;
    }

    @Override
    @NotNull
    public Http getHttp() {
        return this.http;
    }

    @Override
    @NotNull
    public WorkspaceConfiguration.CodeVerifier getCodeVerifier() {
        return this.codeVerifier;
    }

    private final CodeChallenge.S256 getCodeChallenge() {
        Lazy lazy = this.codeChallenge$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (CodeChallenge.S256)lazy.getValue();
    }

    @Override
    @NotNull
    public String codeFlowURL(@NotNull String redirectUri) {
        Intrinsics.checkNotNullParameter((Object)redirectUri, (String)"redirectUri");
        return OAuthFlowKt.codeFlowURL$default(this.getServer(), this.getClientId(), redirectUri, null, null, true, this.getCodeChallenge(), 24, null);
    }

    @Override
    @Nullable
    public Object refreshTokenFlow(@NotNull String refreshToken2, @NotNull Continuation<? super OAuthTokenResponse> $completion) {
        return OAuthFlowKt.refreshTokenFlow$default(this.getHttp(), this.getServer(), this.getClientId(), this.getClientSecret(), refreshToken2, null, null, $completion, 48, null);
    }

    @Override
    @Nullable
    public Object handleCodeFlowRedirect(@NotNull String uri, @NotNull String redirectUri, @NotNull Continuation<? super OAuthTokenResponse> $completion) {
        String string2 = Uri.INSTANCE.extractQuery(uri);
        if (string2 == null) {
            return new OAuthTokenResponse.Error(uri, "500", Intrinsics.stringPlus((String)"Error parsing redirect uri: ", (Object)uri), null, 8, null);
        }
        String query2 = string2;
        MultiMap<String, String> queryParameters = Uri.INSTANCE.parseQuery(query2);
        String string3 = (String)CollectionsKt.firstOrNull((Iterable)queryParameters.get("code"));
        if (string3 == null) {
            return new OAuthTokenResponse.Error(uri, "500", Intrinsics.stringPlus((String)"Error parsing redirect uri, code is missing: ", (Object)uri), null, 8, null);
        }
        String code = string3;
        boolean qr = StringsKt.contains$default((CharSequence)uri, (CharSequence)"qr-token", (boolean)false, (int)2, null);
        if (qr) {
            return OAuthFlowKt.qrCodeFlowToken$default(this.getHttp(), this.getServer(), this.getClientId(), this.getClientSecret(), code, true, null, null, $completion, 96, null);
        }
        return OAuthFlowKt.codeFlowToken$default(this.getHttp(), this.getServer(), this.getClientId(), redirectUri, this.getClientSecret(), code, this.getCodeVerifier().getValue(), null, $completion, 64, null);
    }
}

