/*
 * Decompiled with CFR 0.152.
 */
package runtime.date;

import java.time.temporal.WeekFields;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.DateTimePeriod;
import kotlinx.datetime.Instant;
import kotlinx.datetime.InstantJvmKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import runtime.date.DateFormat;
import runtime.date.DateTimeMode;
import runtime.date.TimeOfDay;
import runtime.stringUtils.Symbols;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\r\u001a\u0016\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f\u001a\u0016\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0016\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b\u001a)\u0010\u0015\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u0018\u001a&\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u001e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u001d\u001a\u000e\u0010\u001e\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u000e\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u0011\u001a\u000e\u0010\u001f\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u000e\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001d\u001a\u0016\u0010 \u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b\u001a\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\b\u001a\u000e\u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\b\u001a\n\u0010%\u001a\u00020&*\u00020\u001d\u001a\u001e\u0010'\u001a\u00020\u001d*\u00020\u00112\u0006\u0010%\u001a\u00020&2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u0006\u001a\u0012\u0010)\u001a\u00020\u001d*\u00020\u001d2\u0006\u0010%\u001a\u00020&\"\u0019\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006*"}, d2={"DATE_LOCALE", "Ljava/util/Locale;", "kotlin.jvm.PlatformType", "getDATE_LOCALE", "()Ljava/util/Locale;", "dateTimeZoneForIdOrNull", "Lorg/joda/time/DateTimeZone;", "id", "", "formatDate", "epochMillis", "", "nowMillis", "(JLjava/lang/Long;)Ljava/lang/String;", "date", "Lkotlinx/datetime/LocalDate;", "now", "Lorg/joda/time/LocalDate;", "formatDateSpan", "from", "to", "formatDateTime", "mode", "Lruntime/date/DateTimeMode;", "(JLruntime/date/DateTimeMode;Ljava/lang/Long;)Ljava/lang/String;", "dateTime", "Lkotlinx/datetime/LocalDateTime;", "zone", "Lkotlinx/datetime/TimeZone;", "Lorg/joda/time/DateTime;", "formatFullDate", "formatFullDateTime", "formatTimeSpan", "setDefaultLocale", "", "name", "setDefaultTimeZone", "timeOfDay", "Lruntime/date/TimeOfDay;", "toDateTime", "timezone", "withTime", "platform-runtime"})
public final class DatesKt {
    private static final Locale DATE_LOCALE = Locale.ENGLISH;

    public static final Locale getDATE_LOCALE() {
        return DATE_LOCALE;
    }

    @NotNull
    public static final String formatDate(long epochMillis, @Nullable Long nowMillis) {
        DateTime dateTime2;
        Long l = nowMillis;
        if (l == null) {
            dateTime2 = null;
        } else {
            Long l2 = l;
            boolean bl = false;
            boolean bl2 = false;
            long it = ((Number)l2).longValue();
            boolean bl3 = false;
            dateTime2 = new DateTime(it);
        }
        DateTime dateTime3 = dateTime2;
        DateTime now = dateTime3 == null ? new DateTime() : dateTime3;
        DateTime dateTime4 = new DateTime(epochMillis);
        l = dateTime4.toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"dateTime.toLocalDate()");
        Long l3 = l;
        l = now.toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"now.toLocalDate()");
        return DatesKt.formatDate((LocalDate)l3, (LocalDate)l);
    }

    public static /* synthetic */ String formatDate$default(long l, Long l2, int n, Object object) {
        if ((n & 2) != 0) {
            l2 = null;
        }
        return DatesKt.formatDate(l, l2);
    }

    @NotNull
    public static final String formatDate(@NotNull LocalDate date2, @NotNull LocalDate now) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)date2, (String)"date");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        int n = date2.getYear();
        if (n == now.getYear()) {
            String string3 = DateFormat.NO_YEAR_DATE_NON_BREAKING.getJodaTimeFormatter().print((ReadablePartial)date2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"NO_YEAR_DATE_NON_BREAKIN\u2026TimeFormatter.print(date)");
            string2 = string3;
        } else {
            string2 = DatesKt.formatFullDate(date2);
        }
        return string2;
    }

    @NotNull
    public static final String formatDate(@NotNull kotlinx.datetime.LocalDate date2, @NotNull kotlinx.datetime.LocalDate now) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)date2, (String)"date");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        int n = date2.getYear();
        if (n == now.getYear()) {
            String string3 = ConvertersKt.toJavaLocalDate((kotlinx.datetime.LocalDate)date2).format(DateFormat.NO_YEAR_DATE_NON_BREAKING.getJavaFormatter());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"date.toJavaLocalDate().f\u2026N_BREAKING.javaFormatter)");
            string2 = string3;
        } else {
            string2 = DatesKt.formatFullDate(date2);
        }
        return string2;
    }

    @NotNull
    public static final String formatFullDate(@NotNull LocalDate dateTime2) {
        Intrinsics.checkNotNullParameter((Object)dateTime2, (String)"dateTime");
        String string2 = DateFormat.DATE_NON_BREAKING.getJodaTimeFormatter().print((ReadablePartial)dateTime2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DATE_NON_BREAKING.jodaTi\u2026Formatter.print(dateTime)");
        return string2;
    }

    @NotNull
    public static final String formatFullDate(@NotNull kotlinx.datetime.LocalDate date2) {
        Intrinsics.checkNotNullParameter((Object)date2, (String)"date");
        String string2 = ConvertersKt.toJavaLocalDate((kotlinx.datetime.LocalDate)date2).format(DateFormat.DATE_NON_BREAKING.getJavaFormatter());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"date.toJavaLocalDate().f\u2026N_BREAKING.javaFormatter)");
        return string2;
    }

    @NotNull
    public static final String formatDateTime(long epochMillis, @NotNull DateTimeMode mode2, @Nullable Long nowMillis) {
        DateTime dateTime2;
        Intrinsics.checkNotNullParameter((Object)((Object)mode2), (String)"mode");
        Long l = nowMillis;
        if (l == null) {
            dateTime2 = null;
        } else {
            Long l2 = l;
            boolean bl = false;
            boolean bl2 = false;
            long it = ((Number)l2).longValue();
            boolean bl3 = false;
            dateTime2 = new DateTime(it);
        }
        DateTime dateTime3 = dateTime2;
        DateTime now = dateTime3 == null ? new DateTime() : dateTime3;
        DateTime dateTime4 = new DateTime(epochMillis);
        return DatesKt.formatDateTime(dateTime4, mode2, now);
    }

    public static /* synthetic */ String formatDateTime$default(long l, DateTimeMode dateTimeMode, Long l2, int n, Object object) {
        if ((n & 2) != 0) {
            dateTimeMode = DateTimeMode.DEFAULT;
        }
        if ((n & 4) != 0) {
            l2 = null;
        }
        return DatesKt.formatDateTime(l, dateTimeMode, l2);
    }

    @NotNull
    public static final String formatDateTime(@NotNull DateTime dateTime2, @NotNull DateTimeMode mode2, @NotNull DateTime now) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)dateTime2, (String)"dateTime");
        Intrinsics.checkNotNullParameter((Object)((Object)mode2), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        if (now.isBefore((ReadableInstant)dateTime2)) {
            String string3 = DateFormat.DATE_TIME_NON_BREAKING.getJodaTimeFormatter().print((ReadableInstant)dateTime2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"DATE_TIME_NON_BREAKING.j\u2026Formatter.print(dateTime)");
            return string3;
        }
        Duration duration = new Duration((ReadableInstant)dateTime2, (ReadableInstant)now);
        if (mode2.isDefault$platform_runtime() && duration.getStandardMinutes() < 1L) {
            string2 = "just now";
        } else if (mode2.isDefault$platform_runtime() && duration.getStandardHours() < 1L) {
            string2 = "" + duration.getStandardMinutes() + 'm' + (Object)((Object)Symbols.Nbsp) + "ago";
        } else if (mode2.isDefault$platform_runtime() && Intrinsics.areEqual((Object)dateTime2.withTimeAtStartOfDay(), (Object)now.withTimeAtStartOfDay())) {
            String string4 = DateFormat.HOURS_AND_MINUTES.getJodaTimeFormatter().print((ReadableInstant)dateTime2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"HOURS_AND_MINUTES.jodaTi\u2026Formatter.print(dateTime)");
            string2 = string4;
        } else if (mode2.isDefault$platform_runtime() && dateTime2.getYear() == now.getYear()) {
            String string5 = DateFormat.NO_YEAR_DATE_TIME_NON_BREAKING.getJodaTimeFormatter().print((ReadableInstant)dateTime2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"NO_YEAR_DATE_TIME_NON_BR\u2026Formatter.print(dateTime)");
            string2 = string5;
        } else if (mode2.isAbsolute$platform_runtime() && dateTime2.getYear() == now.getYear()) {
            String string6 = DateFormat.NO_YEAR_ABSOLUTE_DATE_TIME_NON_BREAKING.getJodaTimeFormatter().print((ReadableInstant)dateTime2);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"NO_YEAR_ABSOLUTE_DATE_TI\u2026Formatter.print(dateTime)");
            string2 = string6;
        } else if (mode2.isAbsolute$platform_runtime()) {
            String string7 = DateFormat.ABSOLUTE_DATE_TIME_NON_BREAKING.getJodaTimeFormatter().print((ReadableInstant)dateTime2);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"ABSOLUTE_DATE_TIME_NON_B\u2026Formatter.print(dateTime)");
            string2 = string7;
        } else if (mode2.isCompact$platform_runtime() && Intrinsics.areEqual((Object)dateTime2.dayOfYear(), (Object)now.dayOfYear()) && Intrinsics.areEqual((Object)dateTime2.year(), (Object)now.year())) {
            String string8 = DateFormat.HOURS_AND_MINUTES.getJodaTimeFormatter().print((ReadableInstant)dateTime2);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"HOURS_AND_MINUTES.jodaTi\u2026Formatter.print(dateTime)");
            string2 = string8;
        } else if (mode2.isCompact$platform_runtime() && Intrinsics.areEqual((Object)dateTime2.weekOfWeekyear(), (Object)now.weekOfWeekyear())) {
            String string9 = DateFormat.WEEKDAY.getJodaTimeFormatter().print((ReadableInstant)dateTime2);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"WEEKDAY.jodaTimeFormatter.print(dateTime)");
            string2 = string9;
        } else if (mode2.isCompact$platform_runtime() && (Intrinsics.areEqual((Object)dateTime2.year(), (Object)now.year()) || duration.getStandardDays() < 120L)) {
            String string10 = DateFormat.MONTH_DAY.getJodaTimeFormatter().print((ReadableInstant)dateTime2);
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"MONTH_DAY.jodaTimeFormatter.print(dateTime)");
            string2 = string10;
        } else if (mode2.isCompact$platform_runtime()) {
            String string11 = DateFormat.YEAR.getJodaTimeFormatter().print((ReadableInstant)dateTime2);
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"YEAR.jodaTimeFormatter.print(dateTime)");
            string2 = string11;
        } else if (mode2 == DateTimeMode.TABLE) {
            String string12 = DateFormat.DASHED_DATE_TIME.getJodaTimeFormatter().print((ReadableInstant)dateTime2);
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"DASHED_DATE_TIME.jodaTimeFormatter.print(dateTime)");
            string2 = string12;
        } else {
            String string13 = DateFormat.DATE_TIME_NON_BREAKING.getJodaTimeFormatter().print((ReadableInstant)dateTime2);
            Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"DATE_TIME_NON_BREAKING.j\u2026Formatter.print(dateTime)");
            string2 = string13;
        }
        return string2;
    }

    @NotNull
    public static final String formatDateTime(@NotNull LocalDateTime dateTime2, @NotNull DateTimeMode mode2, @NotNull LocalDateTime now, @NotNull TimeZone zone) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)dateTime2, (String)"dateTime");
        Intrinsics.checkNotNullParameter((Object)((Object)mode2), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        if (now.compareTo(dateTime2) < 0) {
            String string3 = DateFormat.DATE_TIME_NON_BREAKING.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"DATE_TIME_NON_BREAKING.j\u2026me.toJavaLocalDateTime())");
            return string3;
        }
        DateTimePeriod period = InstantJvmKt.periodUntil((Instant)TimeZoneKt.toInstant((LocalDateTime)dateTime2, (TimeZone)zone), (Instant)TimeZoneKt.toInstant((LocalDateTime)now, (TimeZone)zone), (TimeZone)zone);
        int periodMinutes = period.getHours() * 60 + period.getMinutes();
        if (mode2.isDefault$platform_runtime() && periodMinutes < 1) {
            string2 = "just now";
        } else if (mode2.isDefault$platform_runtime() && period.getHours() < 1) {
            string2 = "" + periodMinutes + 'm' + (Object)((Object)Symbols.Nbsp) + "ago";
        } else if (mode2.isDefault$platform_runtime() && Intrinsics.areEqual((Object)dateTime2.getDate(), (Object)now.getDate())) {
            String string4 = DateFormat.HOURS_AND_MINUTES.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"HOURS_AND_MINUTES.javaFo\u2026me.toJavaLocalDateTime())");
            string2 = string4;
        } else if (mode2.isDefault$platform_runtime() && dateTime2.getYear() == now.getYear()) {
            String string5 = DateFormat.NO_YEAR_DATE_TIME_NON_BREAKING.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"NO_YEAR_DATE_TIME_NON_BR\u2026me.toJavaLocalDateTime())");
            string2 = string5;
        } else if (mode2.isAbsolute$platform_runtime() && dateTime2.getYear() == now.getYear()) {
            String string6 = DateFormat.NO_YEAR_ABSOLUTE_DATE_TIME_NON_BREAKING.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"NO_YEAR_ABSOLUTE_DATE_TI\u2026me.toJavaLocalDateTime())");
            string2 = string6;
        } else if (mode2.isAbsolute$platform_runtime()) {
            String string7 = DateFormat.ABSOLUTE_DATE_TIME_NON_BREAKING.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"ABSOLUTE_DATE_TIME_NON_B\u2026me.toJavaLocalDateTime())");
            string2 = string7;
        } else if (mode2.isCompact$platform_runtime() && dateTime2.getDayOfYear() == now.getDayOfYear() && dateTime2.getYear() == now.getYear()) {
            String string8 = DateFormat.HOURS_AND_MINUTES.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"HOURS_AND_MINUTES.javaFo\u2026me.toJavaLocalDateTime())");
            string2 = string8;
        } else if (mode2.isCompact$platform_runtime() && ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2).get(WeekFields.ISO.weekOfYear()) == ConvertersKt.toJavaLocalDateTime((LocalDateTime)now).get(WeekFields.ISO.weekOfYear())) {
            String string9 = DateFormat.WEEKDAY.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"WEEKDAY.javaFormatter.fo\u2026me.toJavaLocalDateTime())");
            string2 = string9;
        } else if (mode2.isCompact$platform_runtime() && (dateTime2.getYear() == now.getYear() || period.getDays() < 120)) {
            String string10 = DateFormat.MONTH_DAY.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"MONTH_DAY.javaFormatter.\u2026me.toJavaLocalDateTime())");
            string2 = string10;
        } else if (mode2.isCompact$platform_runtime()) {
            String string11 = DateFormat.YEAR.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"YEAR.javaFormatter.forma\u2026me.toJavaLocalDateTime())");
            string2 = string11;
        } else {
            String string12 = DateFormat.DATE_TIME_NON_BREAKING.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"DATE_TIME_NON_BREAKING.j\u2026me.toJavaLocalDateTime())");
            string2 = string12;
        }
        return string2;
    }

    @NotNull
    public static final String formatFullDateTime(long epochMillis) {
        String string2 = DateFormat.DATE_TIME_NON_BREAKING.getJodaTimeFormatter().print(epochMillis);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DATE_TIME_NON_BREAKING.j\u2026matter.print(epochMillis)");
        return string2;
    }

    @NotNull
    public static final String formatFullDateTime(@NotNull DateTime dateTime2) {
        Intrinsics.checkNotNullParameter((Object)dateTime2, (String)"dateTime");
        return DatesKt.formatFullDateTime(dateTime2.getMillis());
    }

    @NotNull
    public static final String formatFullDateTime(@NotNull LocalDateTime dateTime2) {
        Intrinsics.checkNotNullParameter((Object)dateTime2, (String)"dateTime");
        String string2 = DateFormat.DATE_TIME_NON_BREAKING.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DATE_TIME_NON_BREAKING.j\u2026me.toJavaLocalDateTime())");
        return string2;
    }

    public static final void setDefaultTimeZone(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        java.util.TimeZone.setDefault(java.util.TimeZone.getTimeZone(name2));
    }

    @NotNull
    public static final String formatTimeSpan(long from, long to) {
        String string2;
        LocalDate nowDate = new LocalDate();
        LocalDate fromDate = new LocalDate(from);
        LocalDate toDate = new LocalDate(to);
        DateTimeFormatter mainFormat = nowDate.getYear() != fromDate.getYear() ? DateFormat.DATE_NON_BREAKING.getJodaTimeFormatter() : DateFormat.NO_YEAR_DATE_NON_BREAKING.getJodaTimeFormatter();
        if (fromDate.getYear() != toDate.getYear()) {
            string2 = mainFormat.print((ReadablePartial)fromDate) + "\u2009\u2013\u2009" + mainFormat.print((ReadablePartial)toDate);
        } else if (!Intrinsics.areEqual((Object)fromDate.monthOfYear(), (Object)toDate.monthOfYear())) {
            string2 = DateFormat.NO_YEAR_DATE_NON_BREAKING.getJodaTimeFormatter().print((ReadablePartial)fromDate) + "\u2009\u2013\u2009" + mainFormat.print((ReadablePartial)toDate);
        } else if (fromDate.getDayOfMonth() != toDate.getDayOfMonth()) {
            string2 = DateFormat.DAY.getJodaTimeFormatter().print((ReadablePartial)fromDate) + '\u2013' + mainFormat.print((ReadablePartial)toDate);
        } else {
            String string3 = mainFormat.print((ReadablePartial)fromDate);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"mainFormat.print(fromDate)");
            string2 = string3;
        }
        return string2;
    }

    public static final void setDefaultLocale(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
    }

    @Nullable
    public static final DateTimeZone dateTimeZoneForIdOrNull(@NotNull String id) {
        DateTimeZone dateTimeZone;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        try {
            dateTimeZone = DateTimeZone.forID((String)id);
        }
        catch (Throwable th) {
            dateTimeZone = null;
        }
        return dateTimeZone;
    }

    @NotNull
    public static final String formatDateSpan(long from, long to) {
        String string2;
        LocalDate start2 = new LocalDate(from);
        LocalDate end = new LocalDate(to);
        if (start2.getYear() == end.getYear() && start2.getDayOfYear() == end.getDayOfYear()) {
            String string3 = DateFormat.DATE_NON_BREAKING.getJodaTimeFormatter().print((ReadablePartial)start2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"DATE_NON_BREAKING.jodaTimeFormatter.print(start)");
            string2 = string3;
        } else {
            string2 = start2.getYear() == end.getYear() && start2.getMonthOfYear() == end.getMonthOfYear() ? DateFormat.DAY.getJodaTimeFormatter().print((ReadablePartial)start2) + "\u2009\u2013\u2009" + DateFormat.DATE_NON_BREAKING.getJodaTimeFormatter().print((ReadablePartial)end) : (start2.getYear() == end.getYear() ? DateFormat.NO_YEAR_DATE_NON_BREAKING.getJodaTimeFormatter().print((ReadablePartial)start2) + "\u2009\u2013\u2009" + DateFormat.DATE_NON_BREAKING.getJodaTimeFormatter().print((ReadablePartial)end) : DateFormat.DATE_NON_BREAKING.getJodaTimeFormatter().print((ReadablePartial)start2) + "\u2009\u2013\u2009" + DateFormat.DATE_NON_BREAKING.getJodaTimeFormatter().print((ReadablePartial)end));
        }
        return string2;
    }

    @NotNull
    public static final DateTime toDateTime(@NotNull LocalDate $this$toDateTime, @NotNull TimeOfDay timeOfDay, @Nullable DateTimeZone timezone) {
        DateTime dateTime2;
        Intrinsics.checkNotNullParameter((Object)$this$toDateTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timeOfDay, (String)"timeOfDay");
        if (timeOfDay.getHours() == 24) {
            DateTime dateTime3 = $this$toDateTime.plusDays(1).toDateTimeAtStartOfDay(timezone);
            Intrinsics.checkNotNullExpressionValue((Object)dateTime3, (String)"{\n        this.plusDays(\u2026tartOfDay(timezone)\n    }");
            dateTime2 = dateTime3;
        } else {
            Integer n;
            LocalTime localTime = new LocalTime(timeOfDay.getHours(), timeOfDay.getMinutes(), (n = timeOfDay.getSeconds()) == null ? 0 : n);
            DateTime dateTime4 = $this$toDateTime.toDateTime(localTime, timezone);
            Intrinsics.checkNotNullExpressionValue((Object)dateTime4, (String)"{\n        val localTime \u2026ocalTime, timezone)\n    }");
            dateTime2 = dateTime4;
        }
        return dateTime2;
    }

    public static /* synthetic */ DateTime toDateTime$default(LocalDate localDate, TimeOfDay timeOfDay, DateTimeZone dateTimeZone, int n, Object object) {
        if ((n & 2) != 0) {
            dateTimeZone = null;
        }
        return DatesKt.toDateTime(localDate, timeOfDay, dateTimeZone);
    }

    @NotNull
    public static final DateTime withTime(@NotNull DateTime $this$withTime, @NotNull TimeOfDay timeOfDay) {
        DateTime dateTime2;
        Intrinsics.checkNotNullParameter((Object)$this$withTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timeOfDay, (String)"timeOfDay");
        if (timeOfDay.getHours() == 24) {
            DateTime dateTime3 = $this$withTime.plusDays(1).withTimeAtStartOfDay();
            Intrinsics.checkNotNullExpressionValue((Object)dateTime3, (String)"{\n        this.plusDays(\u2026hTimeAtStartOfDay()\n    }");
            dateTime2 = dateTime3;
        } else {
            Integer n;
            LocalTime localTime = new LocalTime(timeOfDay.getHours(), timeOfDay.getMinutes(), (n = timeOfDay.getSeconds()) == null ? 0 : n);
            DateTime dateTime4 = $this$withTime.withTime(localTime);
            Intrinsics.checkNotNullExpressionValue((Object)dateTime4, (String)"{\n        val localTime \u2026withTime(localTime)\n    }");
            dateTime2 = dateTime4;
        }
        return dateTime2;
    }

    @NotNull
    public static final TimeOfDay timeOfDay(@NotNull DateTime $this$timeOfDay) {
        Intrinsics.checkNotNullParameter((Object)$this$timeOfDay, (String)"<this>");
        return new TimeOfDay($this$timeOfDay.getHourOfDay(), $this$timeOfDay.getMinuteOfHour(), null, 4, null);
    }
}

