/*
 * Decompiled with CFR 0.152.
 */
package runtime.system;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import runtime.system.JStack;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a8\u0006\t"}, d2={"Lruntime/system/JStack;", "", "()V", "dumpThreads", "", "threadSelector", "Lkotlin/Function1;", "Ljava/lang/Thread;", "", "platform-runtime"})
public final class JStack {
    @NotNull
    public static final JStack INSTANCE = new JStack();

    private JStack() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String dumpThreads(@NotNull Function1<? super Thread, Boolean> threadSelector) {
        Map map2;
        Intrinsics.checkNotNullParameter(threadSelector, (String)"threadSelector");
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$dumpThreads_u24lambda_u2d2 = stringBuilder;
        boolean bl5 = false;
        try {
            void $this$associateByTo$iv$iv;
            ThreadMXBean bean = ManagementFactory.getThreadMXBean();
            ThreadInfo[] threadInfoArray = bean.dumpAllThreads(true, true);
            Intrinsics.checkNotNullExpressionValue((Object)threadInfoArray, (String)"bean.dumpAllThreads(true, true)");
            Object[] $this$associateBy$iv = threadInfoArray;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
            Object[] objectArray = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv232 : $this$associateByTo$iv$iv) {
                void it;
                ThreadInfo threadInfo = (ThreadInfo)element$iv$iv232;
                Map map3 = destination$iv$iv;
                boolean bl6 = false;
                Long l = it.getThreadId();
                map3.put(l, element$iv$iv232);
            }
            map2 = destination$iv$iv;
        }
        catch (Throwable t) {
            map2 = MapsKt.emptyMap();
        }
        Map threadsInfos = map2;
        boolean bl7 = false;
        boolean bl8 = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl9 = false;
        boolean bl10 = false;
        StringBuilder $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1 = stringBuilder2;
        boolean bl11 = false;
        Object object = $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("Full thread dump ").append(System.getProperty("java.vm.name")).append(" ").append(System.getProperty("java.vm.version")).append(" ").append(System.getProperty("java.vm.info"));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"append(\"Full thread dump\u2026Property(\"java.vm.info\"))");
        StringsKt.appendln((StringBuilder)object);
        Object object2 = Thread.getAllStackTraces();
        Intrinsics.checkNotNullExpressionValue(object2, (String)"getAllStackTraces()");
        int n = 0;
        object = object2.entrySet().iterator();
        while (object.hasNext()) {
            LockInfo[] locks;
            Object object3;
            int n2;
            Object object4;
            ThreadInfo thInfo;
            ThreadGroup group;
            Object element$iv$iv232;
            Object object5 = object2 = (Map.Entry)object.next();
            boolean element$iv$iv232 = false;
            Thread thread = (Thread)object5.getKey();
            element$iv$iv232 = object2;
            boolean it = false;
            StackTraceElement[] stackTrace = (StackTraceElement[])element$iv$iv232.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"thread");
            if (!((Boolean)threadSelector.invoke((Object)thread)).booleanValue()) continue;
            $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append('\"' + thread.getName() + "\" ");
            if (thread.isDaemon()) {
                $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("daemon ");
            }
            if ((group = thread.getThreadGroup()) != null) {
                $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("group=\"" + group.getName() + "\" ");
            }
            $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("prio=" + thread.getPriority() + ' ');
            $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("tid=" + thread.getId() + ' ');
            $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("nid=" + thread.getId() + ' ');
            Thread.State state2 = thread.getState();
            if (state2 == Thread.State.RUNNABLE) {
                $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("runnable ");
            }
            if (state2 == Thread.State.WAITING || state2 == Thread.State.TIMED_WAITING) {
                $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("waiting ");
            }
            if (state2 == Thread.State.BLOCKED) {
                $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("blocked ");
            }
            if ((thInfo = (ThreadInfo)threadsInfos.get(thread.getId())) != null) {
                if (thInfo.getLockName() != null) {
                    $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append(Intrinsics.stringPlus((String)"on ", (Object)thInfo.getLockName()));
                }
                if (thInfo.getLockOwnerName() != null) {
                    $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append(" owned by \"").append(thInfo.getLockOwnerName()).append("\" Id=").append(thInfo.getLockOwnerId());
                }
                if (thInfo.isSuspended()) {
                    $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append(" (suspended)");
                }
                if (thInfo.isInNative()) {
                    $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append(" (in native)");
                }
                StringsKt.appendln((StringBuilder)$this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1);
                StringBuilder stringBuilder3 = $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1;
                object4 = Intrinsics.stringPlus((String)"   java.lang.Thread.State: ", (Object)state2.name());
                n2 = 0;
                StringBuilder stringBuilder4 = stringBuilder3.append((String)object4);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder4);
            } else {
                StringsKt.appendln((StringBuilder)$this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1);
            }
            int i = -1;
            Intrinsics.checkNotNullExpressionValue((Object)stackTrace, (String)"stackTrace");
            object4 = stackTrace;
            n2 = 0;
            int n3 = ((StackTraceElement[])object4).length;
            while (n2 < n3) {
                StackTraceElement ste = object4[n2];
                ++n2;
                int n4 = i;
                i = n4 + 1;
                StringBuilder object6 = $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("\tat ");
                Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"append(\"\\tat \")");
                StringBuilder bl14 = object6;
                object3 = ste.toString();
                int string3 = 0;
                StringBuilder stringBuilder5 = bl14.append((String)object3);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder5);
                if (thInfo == null) continue;
                if (i == 0 && thInfo.getLockInfo() != null) {
                    Thread.State state3 = thInfo.getThreadState();
                    int n5 = state3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[state3.ordinal()];
                    switch (n5) {
                        case 1: {
                            StringBuilder stringBuilder6 = $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("\t\t-  blocked on ");
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(\"\\t\\t-  blocked on \")");
                            LockInfo lockInfo = thInfo.getLockInfo();
                            boolean bl6 = false;
                            StringBuilder stringBuilder7 = stringBuilder6.append(lockInfo);
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
                            StringsKt.appendln((StringBuilder)stringBuilder7);
                            break;
                        }
                        case 2: {
                            StringBuilder stringBuilder8 = $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("\t\t-  waiting on ");
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(\"\\t\\t-  waiting on \")");
                            LockInfo lockInfo = thInfo.getLockInfo();
                            boolean bl6 = false;
                            StringBuilder stringBuilder9 = stringBuilder8.append(lockInfo);
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(value)");
                            StringsKt.appendln((StringBuilder)stringBuilder9);
                            break;
                        }
                        case 3: {
                            StringBuilder stringBuilder10 = $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("\t\t-  waiting on ");
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(\"\\t\\t-  waiting on \")");
                            LockInfo lockInfo = thInfo.getLockInfo();
                            boolean bl6 = false;
                            StringBuilder stringBuilder11 = stringBuilder10.append(lockInfo);
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(value)");
                            StringsKt.appendln((StringBuilder)stringBuilder11);
                        }
                    }
                }
                object3 = thInfo.getLockedMonitors();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"thInfo.lockedMonitors");
                for (MonitorInfo mi : object3) {
                    if (mi.getLockedStackDepth() != i) continue;
                    StringBuilder stringBuilder12 = $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("\t-  locked ");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12, (String)"append(\"\\t-  locked \")");
                    boolean bl12 = false;
                    StringBuilder stringBuilder13 = stringBuilder12.append(mi);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder13);
                }
            }
            StringsKt.appendln((StringBuilder)$this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1);
            if (thInfo == null || (locks = thInfo.getLockedSynchronizers()) == null) continue;
            Object object7 = locks;
            n3 = 0;
            LockInfo[] lockInfoArray = object7;
            boolean bl13 = false;
            if (!(!(lockInfoArray.length == 0))) continue;
            StringsKt.appendln((StringBuilder)$this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1);
            object7 = $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1;
            String string2 = "  Locked ownable synchronizers:\n";
            int n7 = 0;
            StringBuilder stringBuilder14 = ((StringBuilder)object7).append(string2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder14);
            for (LockInfo lockInfo : locks) {
                object3 = $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1;
                String string3 = Intrinsics.stringPlus((String)"\t- ", (Object)lockInfo);
                boolean bl14 = false;
                StringBuilder stringBuilder15 = ((StringBuilder)object3).append(string3);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder15);
            }
            StringsKt.appendln((StringBuilder)$this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1);
        }
        StringsKt.appendln((StringBuilder)$this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1);
        String string4 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        return string4;
    }

    public static /* synthetic */ String dumpThreads$default(JStack jStack, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = dumpThreads.1.INSTANCE;
        }
        return jStack.dumpThreads((Function1<? super Thread, Boolean>)function1);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Thread.State.values().length];
            nArray[Thread.State.BLOCKED.ordinal()] = 1;
            nArray[Thread.State.WAITING.ordinal()] = 2;
            nArray[Thread.State.TIMED_WAITING.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

