/*
 * Decompiled with CFR 0.152.
 */
package runtime.text;

import java.nio.charset.Charset;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.text.BOM;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"detectBOM", "Lruntime/text/BOM;", "bytes", "", "fileContentToString", "", "encoding", "Ljava/nio/charset/Charset;", "defaultEncoding", "isBinaryFileContent", "", "isControlChar", "ch", "", "platform-runtime"})
public final class FileContentKt {
    public static final boolean isBinaryFileContent(@NotNull byte[] bytes) {
        int n;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (FileContentKt.detectBOM(bytes) != null) {
            return false;
        }
        int controlChars = 0;
        for (byte by : bytes) {
            if (!FileContentKt.isControlChar(by)) continue;
            ++controlChars;
        }
        int n2 = bytes.length;
        if (n2 == 0) {
            return false;
        }
        boolean bl = 1 <= n2 ? n2 <= 255 : false;
        if (bl) {
            n = 1;
        } else {
            int n3 = bytes.length / 100;
            int n4 = 100;
            boolean bl2 = false;
            n = Math.min(n3, n4);
        }
        int threshold = n;
        return controlChars >= threshold;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isControlChar(byte ch) {
        boolean bl;
        byte by = ch;
        if (0 <= by) {
            if (by <= 7) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        by = ch;
        if (14 > by) return false;
        if (by > 25) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static final BOM detectBOM(byte[] bytes) {
        block7: {
            $this$firstOrNull$iv = BOM.values();
            $i$f$firstOrNull = false;
            var3_3 = $this$firstOrNull$iv;
            var4_4 = var3_3.length;
            for (var5_5 = 0; var5_5 < var4_4; ++var5_5) {
                block6: {
                    bom = element$iv = var3_3[var5_5];
                    $i$a$-firstOrNull-FileContentKt$detectBOM$1 = false;
                    if (bytes.length < bom.getBom().length) ** GOTO lbl-1000
                    $this$all$iv = (Iterable)ArraysKt.getIndices((byte[])bom.getBom());
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        v0 = true;
                    } else {
                        var11_11 = $this$all$iv.iterator();
                        while (var11_11.hasNext()) {
                            it = element$iv = ((IntIterator)var11_11).nextInt();
                            $i$a$-all-FileContentKt$detectBOM$1$1 = false;
                            if (bom.getBom()[it] == bytes[it]) continue;
                            v0 = false;
                            break block6;
                        }
                        v0 = true;
                    }
                }
                if (v0) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                v2 = element$iv;
                break block7;
            }
            v2 = null;
        }
        return v2;
    }

    @NotNull
    public static final String fileContentToString(@NotNull byte[] bytes, @Nullable String defaultEncoding) {
        Charset charset;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        byte[] byArray = bytes;
        String string2 = defaultEncoding;
        if (string2 == null) {
            charset = null;
        } else {
            String string3;
            String it;
            String string4 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String string5 = string4;
            byte[] byArray2 = byArray;
            boolean bl3 = false;
            boolean bl4 = Charset.isSupported(it);
            byArray = byArray2;
            String string6 = string3 = bl4 ? string4 : null;
            if (string3 == null) {
                charset = null;
            } else {
                string4 = string3;
                bl = false;
                bl2 = false;
                it = string4;
                byArray2 = byArray;
                boolean bl5 = false;
                Charset charset2 = Charset.forName(it);
                byArray = byArray2;
                charset = charset2;
            }
        }
        Charset charset3 = charset;
        return FileContentKt.fileContentToString(byArray, charset3 == null ? Charsets.UTF_8 : charset3);
    }

    public static /* synthetic */ String fileContentToString$default(byte[] byArray, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return FileContentKt.fileContentToString(byArray, string2);
    }

    @NotNull
    public static final String fileContentToString(@NotNull byte[] bytes, @NotNull Charset encoding) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
        BOM bom = FileContentKt.detectBOM(bytes);
        if (bom != null) {
            int n = bom.getBom().length;
            int n2 = bytes.length - bom.getBom().length;
            Charset charset = bom.getCharset();
            boolean bl = false;
            return new String(bytes, n, n2, charset);
        }
        boolean bl = false;
        return new String(bytes, encoding);
    }
}

