/*
 * Decompiled with CFR 0.152.
 */
package runtime.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty1;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.KVisibility;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;
import runtime.utils.NotSupportedInRpc;
import runtime.utils.SHA1Hasher;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u001a\u0012\u0010\u0004\u001a\u00020\u00012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"calculateApiHash", "", "api", "Lkotlin/reflect/KClass;", "calculateDeepHashForMethod", "f", "Lkotlin/reflect/KFunction;", "calculateDeepHashForType", "ktype", "Lkotlin/reflect/KType;", "platform-runtime"})
@JvmName(name="ApiHashCalculatorKt")
public final class ApiHashCalculatorKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String calculateApiHash(@NotNull KClass<?> api2) {
        Intrinsics.checkNotNullParameter(api2, (String)"api");
        SHA1Hasher hash = new SHA1Hasher();
        Iterable $this$sortedBy$iv = KClasses.getDeclaredFunctions(api2);
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                KFunction it = (KFunction)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (KFunction)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string2 = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string2)));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void $this$filterTo$iv$iv;
            KFunction f = (KFunction)element$iv;
            boolean bl2 = false;
            hash.update(f.getName());
            hash.update(f.getParameters().size());
            Iterable $this$filter$iv = f.getParameters();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KParameter it = (KParameter)element$iv$iv;
                boolean bl3 = false;
                if (!(it.getKind() == KParameter.Kind.VALUE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KParameter p2 = (KParameter)element$iv2;
                boolean bl4 = false;
                String string2 = p2.getName();
                Intrinsics.checkNotNull((Object)string2);
                hash.update(string2);
                hash.update(p2.getType().toString());
            }
            hash.update(f.getReturnType().toString());
        }
        return hash.hashAsString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String calculateDeepHashForMethod(@NotNull KFunction<?> f) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(f, (String)"f");
        SHA1Hasher hash = new SHA1Hasher();
        hash.update(f.getName());
        Iterable $this$filter$iv = f.getParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KParameter it = (KParameter)element$iv$iv;
            boolean bl = false;
            if (!(it.getKind() == KParameter.Kind.VALUE && !it.getType().isMarkedNullable())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KParameter it = (KParameter)element$iv;
            boolean bl = false;
            KType type = it.getType();
            String string2 = it.getName();
            if (string2 != null) {
                String string3 = string2;
                boolean bl2 = false;
                boolean bl3 = false;
                String it2 = string3;
                boolean bl4 = false;
                hash.update(it2);
            }
            hash.update(ApiHashCalculatorKt.calculateDeepHashForType(type));
        }
        hash.update(ApiHashCalculatorKt.calculateDeepHashForType(f.getReturnType()));
        return hash.hashAsString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String calculateDeepHashForType(@NotNull KType ktype) {
        KTypeProjection it;
        Intrinsics.checkNotNullParameter((Object)ktype, (String)"ktype");
        SHA1Hasher hash = new SHA1Hasher();
        Iterable $this$forEach$iv = ktype.getArguments();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (KTypeProjection)element$iv;
            boolean bl = false;
            KType kType = it.getType();
            if (kType == null) continue;
            KType kType2 = kType;
            boolean bl2 = false;
            boolean bl3 = false;
            KType it2 = kType2;
            boolean bl4 = false;
            hash.update(ApiHashCalculatorKt.calculateDeepHashForType(it2));
        }
        if (ktype.getClassifier() instanceof KClass) {
            KClassifier $i$f$forEach2 = ktype.getClassifier();
            if ($i$f$forEach2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.reflect.KClass<*>");
            }
            KClass klass = (KClass)$i$f$forEach2;
            Object object = klass.getSimpleName();
            if (object == null) {
                throw new NotSupportedInRpc("Anonymous classes are not supported");
            }
            Object[] klassName = object;
            hash.update((String)klassName);
            object = new String[]{"Array", "List"};
            if (!CollectionsKt.listOf((Object[])object).contains(klassName)) {
                void $this$forEach$iv2;
                Iterable $this$sortedBy$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                object = KClasses.getDeclaredMemberProperties((KClass)klass);
                boolean $i$f$filter = false;
                it = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    KProperty1 it3 = (KProperty1)element$iv$iv;
                    boolean bl = false;
                    if (!(!it3.getReturnType().isMarkedNullable() && it3.getVisibility() == KVisibility.PUBLIC)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$sortedBy = false;
                boolean bl = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        KProperty1 it = (KProperty1)a;
                        boolean bl2 = false;
                        Comparable comparable = (Comparable)((Object)it.getName());
                        it = (KProperty1)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        String string2 = it.getName();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string2)));
                    }
                });
                boolean $i$f$forEach3 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    KProperty1 it4 = (KProperty1)element$iv;
                    boolean bl5 = false;
                    hash.update(it4.getName());
                    hash.update(ApiHashCalculatorKt.calculateDeepHashForType(it4.getReturnType()));
                }
            }
        } else {
            String string2 = ktype + " is a type parameter, skipping";
            boolean bl = false;
            System.out.println((Object)string2);
        }
        return hash.hashAsString();
    }
}

