"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var group_by_rollup_1 = require("../../layout/utils/group_by_rollup");
var pie_spec_1 = require("./pie_spec");
var tree_1 = require("./tree");
exports.getLegendItemsLabels = re_reselect_1.default([pie_spec_1.getPieSpec, get_settings_specs_1.getSettingsSpecSelector, tree_1.getTree], function (pieSpec, _a, tree) {
    var legendMaxDepth = _a.legendMaxDepth;
    if (!pieSpec) {
        return [];
    }
    if (isInvalidLegendMaxDepth(legendMaxDepth)) {
        return [];
    }
    var labels = flatSlicesNames(pieSpec.layers, 0, tree).filter(function (_a) {
        var depth = _a.depth;
        if (typeof legendMaxDepth !== 'number') {
            return true;
        }
        return depth <= legendMaxDepth;
    });
    return labels;
})(get_chart_id_1.getChartIdSelector);
function isInvalidLegendMaxDepth(legendMaxDepth) {
    return typeof legendMaxDepth === 'number' && (Number.isNaN(legendMaxDepth) || legendMaxDepth <= 0);
}
function flatSlicesNames(layers, depth, tree, keys) {
    if (keys === void 0) { keys = new Map(); }
    var _a, _b;
    if (tree.length === 0) {
        return [];
    }
    for (var i = 0; i < tree.length; i++) {
        var branch = tree[i];
        var arrayNode = branch[1];
        var key = branch[0];
        var layer = layers[depth - 1];
        var formatter = (_a = layer) === null || _a === void 0 ? void 0 : _a.nodeLabel;
        var formattedValue = '';
        if (key != null) {
            formattedValue = formatter ? formatter(key) : "" + key;
        }
        if (formattedValue != null && formattedValue !== '') {
            keys.set(formattedValue, Math.max(depth, (_b = keys.get(formattedValue), (_b !== null && _b !== void 0 ? _b : 0))));
        }
        var children = arrayNode[group_by_rollup_1.CHILDREN_KEY];
        flatSlicesNames(layers, depth + 1, children, keys);
    }
    return __spread(keys.keys()).map(function (k) {
        var _a;
        return ({
            label: k,
            depth: (_a = keys.get(k), (_a !== null && _a !== void 0 ? _a : 0)),
        });
    });
}
//# sourceMappingURL=get_legend_items_labels.js.map