"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var color_library_wrappers_1 = require("../../../../partition_chart/layout/utils/color_library_wrappers");
var line_1 = require("../primitives/line");
function renderLineAnnotations(ctx, annotations, lineStyle) {
    var lines = annotations.map(function (annotation) {
        var _a = annotation.linePathPoints, _b = _a.start, x1 = _b.x1, y1 = _b.y1, _c = _a.end, x2 = _c.x2, y2 = _c.y2;
        return {
            x1: x1,
            y1: y1,
            x2: x2,
            y2: y2,
        };
    });
    var strokeColor = color_library_wrappers_1.stringToRGB(lineStyle.line.stroke);
    strokeColor.opacity *= lineStyle.line.opacity;
    var stroke = {
        color: strokeColor,
        width: lineStyle.line.strokeWidth,
        dash: lineStyle.line.dash,
    };
    line_1.renderMultiLine(ctx, lines, stroke);
}
exports.renderLineAnnotations = renderLineAnnotations;
//# sourceMappingURL=lines.js.map