"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var __1 = require("../../..");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var picked_shapes_1 = require("./picked_shapes");
var pie_spec_1 = require("./pie_spec");
function isOverElement(prevPickedShapes, nextPickedShapes) {
    if (prevPickedShapes === void 0) { prevPickedShapes = []; }
    if (nextPickedShapes.length === 0) {
        return;
    }
    if (nextPickedShapes.length !== prevPickedShapes.length) {
        return true;
    }
    return !nextPickedShapes.every(function (nextPickedShapeValues, index) {
        var prevPickedShapeValues = prevPickedShapes[index];
        if (prevPickedShapeValues === null) {
            return false;
        }
        if (prevPickedShapeValues.length !== nextPickedShapeValues.length) {
            return false;
        }
        return nextPickedShapeValues.every(function (layerValue, i) {
            var prevPickedValue = prevPickedShapeValues[i];
            if (!prevPickedValue) {
                return false;
            }
            return layerValue.value === prevPickedValue.value && layerValue.groupByRollup === prevPickedValue.groupByRollup;
        });
    });
}
function createOnElementOverCaller() {
    var prevPickedShapes = [];
    var selector = null;
    return function (state) {
        if (selector === null && state.chartType === __1.ChartTypes.Partition) {
            selector = re_reselect_1.default([pie_spec_1.getPieSpec, picked_shapes_1.getPickedShapesLayerValues, get_settings_specs_1.getSettingsSpecSelector], function (pieSpec, nextPickedShapes, settings) {
                if (!pieSpec) {
                    return;
                }
                if (!settings.onElementOver) {
                    return;
                }
                if (isOverElement(prevPickedShapes, nextPickedShapes)) {
                    var elements = nextPickedShapes.map(function (values) { return [
                        values,
                        {
                            specId: pieSpec.id,
                            key: "spec{" + pieSpec.id + "}",
                        },
                    ]; });
                    settings.onElementOver(elements);
                }
                prevPickedShapes = nextPickedShapes;
            })({
                keySelector: get_chart_id_1.getChartIdSelector,
            });
        }
        if (selector) {
            selector(state);
        }
    };
}
exports.createOnElementOverCaller = createOnElementOverCaller;
//# sourceMappingURL=on_element_over_caller.js.map