"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var react_redux_1 = require("react-redux");
var redux_1 = require("redux");
var mouse_1 = require("../../../../../state/actions/mouse");
var get_internal_is_intialized_1 = require("../../../../../state/selectors/get_internal_is_intialized");
var compute_annotations_1 = require("../../../state/selectors/compute_annotations");
var compute_chart_dimensions_1 = require("../../../state/selectors/compute_chart_dimensions");
var get_annotation_tooltip_state_1 = require("../../../state/selectors/get_annotation_tooltip_state");
var get_specs_1 = require("../../../state/selectors/get_specs");
var is_chart_empty_1 = require("../../../state/selectors/is_chart_empty");
var spec_1 = require("../../../state/utils/spec");
var specs_1 = require("../../../utils/specs");
var annotation_tooltip_1 = require("./annotation_tooltip");
function renderAnnotationLineMarkers(chartDimensions, annotationLines, id) {
    return annotationLines.reduce(function (markers, _a, index) {
        var marker = _a.marker;
        if (!marker) {
            return markers;
        }
        var icon = marker.icon, color = marker.color, position = marker.position;
        var style = {
            color: color,
            top: chartDimensions.top + position.top,
            left: chartDimensions.left + position.left,
        };
        markers.push(react_1.default.createElement("div", { className: "echAnnotation", style: __assign({}, style), key: "annotation-" + id + "-" + index }, icon));
        return markers;
    }, []);
}
var AnnotationsComponent = function (_a) {
    var tooltipState = _a.tooltipState, isChartEmpty = _a.isChartEmpty, chartDimensions = _a.chartDimensions, annotationSpecs = _a.annotationSpecs, annotationDimensions = _a.annotationDimensions, getChartContainerRef = _a.getChartContainerRef, chartId = _a.chartId, onPointerMove = _a.onPointerMove;
    var renderAnnotationMarkers = react_1.useCallback(function () {
        var markers = [];
        annotationDimensions.forEach(function (dimensions, id) {
            var annotationSpec = spec_1.getSpecsById(annotationSpecs, id);
            if (!annotationSpec) {
                return;
            }
            if (specs_1.isLineAnnotation(annotationSpec)) {
                var annotationLines = dimensions;
                var lineMarkers = renderAnnotationLineMarkers(chartDimensions, annotationLines, id);
                markers.push.apply(markers, __spread(lineMarkers));
            }
        });
        return markers;
    }, [chartDimensions, annotationDimensions, annotationSpecs]);
    var onScroll = react_1.useCallback(function () {
        onPointerMove({ x: -1, y: -1 }, new Date().getTime());
    }, []);
    if (isChartEmpty) {
        return null;
    }
    return (react_1.default.createElement(react_1.default.Fragment, null,
        renderAnnotationMarkers(),
        react_1.default.createElement(annotation_tooltip_1.AnnotationTooltip, { chartId: chartId, state: tooltipState, chartRef: getChartContainerRef(), onScroll: onScroll })));
};
AnnotationsComponent.displayName = 'Annotations';
var mapDispatchToProps = function (dispatch) {
    return redux_1.bindActionCreators({ onPointerMove: mouse_1.onPointerMove }, dispatch);
};
var mapStateToProps = function (state) {
    if (get_internal_is_intialized_1.getInternalIsInitializedSelector(state) !== get_internal_is_intialized_1.InitStatus.Initialized) {
        return {
            isChartEmpty: true,
            chartDimensions: { top: 0, left: 0, width: 0, height: 0 },
            annotationDimensions: new Map(),
            annotationSpecs: [],
            tooltipState: null,
            chartId: '',
        };
    }
    return {
        isChartEmpty: is_chart_empty_1.isChartEmptySelector(state),
        chartDimensions: compute_chart_dimensions_1.computeChartDimensionsSelector(state).chartDimensions,
        annotationDimensions: compute_annotations_1.computeAnnotationDimensionsSelector(state),
        annotationSpecs: get_specs_1.getAnnotationSpecsSelector(state),
        tooltipState: get_annotation_tooltip_state_1.getAnnotationTooltipStateSelector(state),
        chartId: state.chartId,
    };
};
exports.Annotations = react_redux_1.connect(mapStateToProps, mapDispatchToProps)(AnnotationsComponent);
//# sourceMappingURL=annotations.js.map