#!/usr/bin/perl
#
# Copyright (c) 2006 Zmanda Inc.  All Rights Reserved.
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 2 as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# Contact information: Zmanda Inc, 505 N Mathlida Ave, Suite 120
# Sunnyvale, CA 94085, USA, or: http://www.zmanda.com
#

# This file contains a template for pre-restore plugin that can be used 
# with Zmanda Recovery Manager (ZRM) for MySQL. For more information about the
# product, please see http://mysqlbackup.zmanda.com/
#
# This plugin is executed before a restore for the backup set.
#
# Parameters passed to the plugin
# -------------------------------
# The parameters passed to the restore plugin are based on what was passed to the restore utility.
# Following are the list of parameters that could be passed
# --source-directory <directory containing the backup to be restored>
# OR
# --bin-logs <list of binary logs to be parsed>
# --backup-level <level>
# --mysql-shutdown (in case the mysql server was shutdown, this attribute
# will be passed )
# --zrm-error <error code 1|2> (This will be passed only if there is a very significant error durign the restore process).
#
# Return values
# -------------
# The plugin should return 0 on success and and non-zero value on failure
#
# How to use this plugin
# ----------------------
# 1. Make modifications to the plugin. The default plugin does no action.
# 2. Modify the mysql-zrm.conf file in the relevant backup-set directory
#    (/etc/mysql-zrm/<backup set name>/mysql-zrm.conf) and add the
#    following line to the configuration file.
#
#    pre-restore-plugin="/usr/share/mysql-zrm/plugins/pre-restore.pl"
#

#This plugin will just print all of the inputs and exit with return value 0

foreach( @ARGV ){
	print "$_\n";
}
exit(0);
